/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.WorldCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.ArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.ArrowSymbolType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.graphic.sql.GraphicPoint;
import org.applied_geodesy.jag3d.ui.graphic.sql.RelativeConfidence;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;

public class PointShiftArrowLayer
extends ArrowLayer {
    private List<RelativeConfidence> relativeConfidences = FXCollections.observableArrayList();

    PointShiftArrowLayer(LayerType layerType) {
        super(layerType);
        ArrowSymbolType arrowSymbolType;
        Color color;
        double symbolSize = -1.0;
        double lineWidth = -1.0;
        boolean visible = Boolean.TRUE;
        switch (layerType) {
            case POINT_SHIFT_HORIZONTAL: {
                try {
                    color = Color.web((String)PROPERTIES.getProperty("POINT_SHIFT_HORIZONTAL_ARROW_COLOR", "#ff8c00"));
                }
                catch (Exception e) {
                    color = Color.web((String)"#ff8c00");
                }
                try {
                    arrowSymbolType = ArrowSymbolType.valueOf(PROPERTIES.getProperty("POINT_SHIFT_HORIZONTAL_ARROW_SYMBOL_TYPE", "FILLED_TETRAGON_ARROW"));
                }
                catch (Exception e) {
                    arrowSymbolType = ArrowSymbolType.FILLED_TETRAGON_ARROW;
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("POINT_SHIFT_HORIZONTAL_ARROW_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("POINT_SHIFT_HORIZONTAL_ARROW_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("POINT_SHIFT_HORIZONTAL_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {}
                break;
            }
            case POINT_SHIFT_VERTICAL: {
                try {
                    color = Color.web((String)PROPERTIES.getProperty("POINT_SHIFT_VERTICAL_ARROW_COLOR", "#ffaf00"));
                }
                catch (Exception e) {
                    color = Color.web((String)"#ffaf00");
                }
                try {
                    arrowSymbolType = ArrowSymbolType.valueOf(PROPERTIES.getProperty("POINT_SHIFT_VERTICAL_ARROW_SYMBOL_TYPE", "FILLED_TETRAGON_ARROW"));
                }
                catch (Exception e) {
                    arrowSymbolType = ArrowSymbolType.FILLED_TETRAGON_ARROW;
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("POINT_SHIFT_VERTICAL_ARROW_SYMBOL_SIZE"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("POINT_SHIFT_VERTICAL_ARROW_LINE_WIDTH"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("POINT_SHIFT_VERTICAL_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                throw new IllegalArgumentException("Error, unsupported layer type " + String.valueOf((Object)layerType));
            }
        }
        symbolSize = symbolSize >= 0.0 ? symbolSize : 12.0;
        lineWidth = lineWidth >= 0.0 ? lineWidth : 1.0;
        this.setSymbolType(arrowSymbolType);
        this.setColor(color);
        this.setSymbolSize(symbolSize);
        this.setLineWidth(lineWidth);
        this.setVisible(visible);
    }

    @Override
    public void draw(GraphicsContext graphicsContext, GraphicExtent graphicExtent) {
        if (!this.isVisible() || this.relativeConfidences == null || this.relativeConfidences.isEmpty()) {
            return;
        }
        LayerType layerType = this.getLayerType();
        ArrowSymbolType arrowSymbolType = this.getSymbolType();
        double scale = this.getVectorScale();
        double symbolSize = this.getSymbolSize();
        double lineWidth = this.getLineWidth();
        double width = graphicExtent.getDrawingBoardWidth();
        double height = graphicExtent.getDrawingBoardHeight();
        double layerDiagonal = Math.hypot(width, height);
        graphicsContext.setStroke((Paint)this.getColor());
        graphicsContext.setFill((Paint)this.getColor());
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setLineDashes(null);
        block4: for (RelativeConfidence relativeConfidence : this.relativeConfidences) {
            GraphicPoint startPoint = relativeConfidence.getStartPoint();
            GraphicPoint endPoint = relativeConfidence.getEndPoint();
            double deltaHeight = relativeConfidence.getDeltaHeight();
            if (!startPoint.isVisible() || !endPoint.isVisible()) continue;
            PixelCoordinate pixelCoordinateStartPoint = GraphicExtent.toPixelCoordinate(startPoint.getCoordinate(), graphicExtent);
            PixelCoordinate pixelCoordinateEndPoint = GraphicExtent.toPixelCoordinate(endPoint.getCoordinate(), graphicExtent);
            if (!this.contains(graphicExtent, pixelCoordinateStartPoint) && !this.contains(graphicExtent, pixelCoordinateEndPoint)) continue;
            double xs = pixelCoordinateStartPoint.getX();
            double ys = pixelCoordinateStartPoint.getY();
            double xe = pixelCoordinateEndPoint.getX();
            double ye = pixelCoordinateEndPoint.getY();
            double pxDistance = Math.hypot(xe - xs, ye - ys);
            double avgX = 0.5 * (xs + xe);
            double avgY = 0.5 * (ys + ye);
            PixelCoordinate vectorStartCoordinate = new PixelCoordinate(avgX, avgY);
            if (!this.contains(graphicExtent, vectorStartCoordinate)) continue;
            switch (layerType) {
                case POINT_SHIFT_HORIZONTAL: {
                    if (startPoint.getDimension() == 1 || endPoint.getDimension() == 1 || !(pxDistance > 0.0) || !(pxDistance * scale >= symbolSize)) continue block4;
                    pxDistance = pxDistance > 0.0 ? pxDistance : 1.0;
                    double dx = (xe - xs) / pxDistance;
                    double dy = (ye - ys) / pxDistance;
                    double angle = Math.atan2(dy, dx);
                    if ((pxDistance *= scale) > 1.05 * layerDiagonal) {
                        pxDistance = 1.05 * layerDiagonal;
                    }
                    PixelCoordinate vectorEndCoordinate = new PixelCoordinate(avgX + pxDistance * dx, avgY + pxDistance * dy);
                    graphicsContext.strokeLine(avgX, avgY, avgX + pxDistance * dx, avgY + pxDistance * dy);
                    SymbolBuilder.drawSymbol(graphicsContext, vectorEndCoordinate, arrowSymbolType, symbolSize, angle);
                    break;
                }
                case POINT_SHIFT_VERTICAL: {
                    PixelCoordinate pixelCoordinateHeightComponent = GraphicExtent.toPixelCoordinate(new WorldCoordinate(startPoint.getCoordinate().getX(), startPoint.getCoordinate().getY() + deltaHeight), graphicExtent);
                    double pxHeightComponent = pixelCoordinateHeightComponent.getY() - pixelCoordinateStartPoint.getY();
                    if (startPoint.getDimension() == 2 || endPoint.getDimension() == 2 || !(Math.abs(pxHeightComponent) > 0.0) || !(Math.abs(pxHeightComponent) * scale >= symbolSize)) continue block4;
                    double angle = 0.5 * Math.signum(pxHeightComponent) * Math.PI;
                    if (Math.abs(pxHeightComponent *= scale) > 1.05 * layerDiagonal) {
                        pxHeightComponent = 1.05 * Math.signum(pxHeightComponent) * layerDiagonal;
                    }
                    PixelCoordinate vectorEndCoordinate = new PixelCoordinate(avgX, avgY + pxHeightComponent);
                    graphicsContext.strokeLine(avgX, avgY, avgX, avgY + pxHeightComponent);
                    SymbolBuilder.drawSymbol(graphicsContext, vectorEndCoordinate, arrowSymbolType, symbolSize, angle);
                    break;
                }
            }
        }
    }

    public void setRelativeConfidences(List<RelativeConfidence> relativeConfidences) {
        GraphicExtent graphicExtent = this.getMaximumGraphicExtent();
        graphicExtent.reset();
        this.relativeConfidences.clear();
        if (relativeConfidences != null) {
            for (RelativeConfidence relativeConfidence : relativeConfidences) {
                GraphicPoint startPoint = relativeConfidence.getStartPoint();
                GraphicPoint endPoint = relativeConfidence.getEndPoint();
                graphicExtent.merge(startPoint.getCoordinate());
                graphicExtent.merge(endPoint.getCoordinate());
            }
            this.relativeConfidences.addAll(relativeConfidences);
        }
    }

    List<RelativeConfidence> getRelativeConfidences() {
        return this.relativeConfidences;
    }

    public String toString() {
        switch (this.getLayerType()) {
            case POINT_SHIFT_HORIZONTAL: {
                return this.i18n.getString("PointShiftArrowLayer.type.horizontal", "Horizontal point shift");
            }
            case POINT_SHIFT_VERTICAL: {
                return this.i18n.getString("PointShiftArrowLayer.type.vertical", "Vertical point shift");
            }
        }
        return "";
    }

    @Override
    public void clearLayer() {
        this.relativeConfidences.clear();
    }

    @Override
    public GraphicExtent getMaximumGraphicExtent() {
        GraphicExtent graphicExtent = new GraphicExtent();
        graphicExtent.reset();
        if (this.relativeConfidences != null) {
            for (RelativeConfidence relativeConfidence : this.relativeConfidences) {
                GraphicPoint startPoint = relativeConfidence.getStartPoint();
                GraphicPoint endPoint = relativeConfidence.getEndPoint();
                if (startPoint.isVisible()) {
                    graphicExtent.merge(startPoint.getCoordinate());
                }
                if (!endPoint.isVisible()) continue;
                graphicExtent.merge(endPoint.getCoordinate());
            }
        }
        return graphicExtent;
    }

    @Override
    public void drawLegendSymbol(GraphicsContext graphicsContext, GraphicExtent graphicExtent, PixelCoordinate pixelCoordinate, double symbolHeight, double symbolWidth) {
        ArrowSymbolType arrowSymbolType = this.getSymbolType();
        double lineWidth = this.getLineWidth();
        double symbolSize = symbolHeight;
        graphicsContext.setStroke((Paint)this.getColor());
        graphicsContext.setFill((Paint)this.getColor());
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setLineDashes(null);
        graphicsContext.strokeLine(pixelCoordinate.getX(), pixelCoordinate.getY(), pixelCoordinate.getX() + symbolWidth, pixelCoordinate.getY() + 0.0);
        SymbolBuilder.drawSymbol(graphicsContext, pixelCoordinate, arrowSymbolType, symbolSize, Math.PI);
    }

    @Override
    public boolean hasContent() {
        LayerType layerType = this.getLayerType();
        for (RelativeConfidence relativeConfidence : this.relativeConfidences) {
            GraphicPoint startPoint = relativeConfidence.getStartPoint();
            GraphicPoint endPoint = relativeConfidence.getEndPoint();
            if (!startPoint.isVisible() || !endPoint.isVisible() || (layerType != LayerType.POINT_SHIFT_HORIZONTAL || startPoint.getDimension() == 1 || endPoint.getDimension() == 1) && (layerType != LayerType.POINT_SHIFT_VERTICAL || startPoint.getDimension() == 2 || endPoint.getDimension() == 2)) continue;
            return true;
        }
        return false;
    }
}

