/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.WorldCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.ArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.ArrowSymbolType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.graphic.sql.GraphicPoint;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;

public class PointResidualArrowLayer
extends ArrowLayer {
    private List<PointLayer> referenceLayers = FXCollections.observableArrayList();

    PointResidualArrowLayer(LayerType layerType) {
        super(layerType);
        ArrowSymbolType arrowSymbolType;
        Color color;
        double symbolSize = -1.0;
        double lineWidth = -1.0;
        boolean visible = Boolean.FALSE;
        switch (layerType) {
            case POINT_RESIDUAL_HORIZONTAL: {
                try {
                    color = Color.web((String)PROPERTIES.getProperty("POINT_RESIDUAL_HORIZONTAL_ARROW_COLOR", "#334db3"));
                }
                catch (Exception e) {
                    color = Color.web((String)"#334db3");
                }
                try {
                    arrowSymbolType = ArrowSymbolType.valueOf(PROPERTIES.getProperty("POINT_RESIDUAL_HORIZONTAL_ARROW_SYMBOL_TYPE", "STROKED_ARROW"));
                }
                catch (Exception e) {
                    arrowSymbolType = ArrowSymbolType.STROKED_ARROW;
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("POINT_RESIDUAL_HORIZONTAL_ARROW_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("POINT_RESIDUAL_HORIZONTAL_ARROW_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("POINT_RESIDUAL_HORIZONTAL_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {}
                break;
            }
            case POINT_RESIDUAL_VERTICAL: {
                try {
                    color = Color.web((String)PROPERTIES.getProperty("POINT_RESIDUAL_VERTICAL_ARROW_COLOR", "#6680e6"));
                }
                catch (Exception e) {
                    color = Color.web((String)"#6680e6");
                }
                try {
                    arrowSymbolType = ArrowSymbolType.valueOf(PROPERTIES.getProperty("POINT_RESIDUAL_VERTICAL_ARROW_SYMBOL_TYPE", "STROKED_ARROW"));
                }
                catch (Exception e) {
                    arrowSymbolType = ArrowSymbolType.STROKED_ARROW;
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("POINT_RESIDUAL_VERTICAL_ARROW_SYMBOL_SIZE"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("POINT_RESIDUAL_VERTICAL_ARROW_LINE_WIDTH"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("POINT_RESIDUAL_VERTICAL_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                throw new IllegalArgumentException("Error, unsupported layer type " + String.valueOf((Object)layerType));
            }
        }
        symbolSize = symbolSize >= 0.0 ? symbolSize : 12.0;
        lineWidth = lineWidth >= 0.0 ? lineWidth : 1.0;
        this.setVisible(visible);
        this.setSymbolType(arrowSymbolType);
        this.setColor(color);
        this.setSymbolSize(symbolSize);
        this.setLineWidth(lineWidth);
    }

    public void add(PointLayer layer) {
        this.referenceLayers.add(layer);
    }

    public void addAll(PointLayer ... layers) {
        PointLayer[] pointLayerArray = layers;
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            PointLayer layer = pointLayerArray[n2];
            this.add(layer);
            ++n2;
        }
    }

    List<PointLayer> getReferenceLayers() {
        return this.referenceLayers;
    }

    @Override
    public void draw(GraphicsContext graphicsContext, GraphicExtent graphicExtent) {
        if (!this.isVisible() || this.referenceLayers == null || this.referenceLayers.isEmpty()) {
            return;
        }
        LayerType layerType = this.getLayerType();
        ArrowSymbolType arrowSymbolType = this.getSymbolType();
        double scale = this.getVectorScale();
        double symbolSize = this.getSymbolSize();
        double lineWidth = this.getLineWidth();
        double width = graphicExtent.getDrawingBoardWidth();
        double height = graphicExtent.getDrawingBoardHeight();
        graphicsContext.setStroke((Paint)this.getColor());
        graphicsContext.setFill((Paint)this.getColor());
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setLineDashes(null);
        for (PointLayer layer : this.referenceLayers) {
            if (!layer.isVisible()) continue;
            block5: for (GraphicPoint startPoint : layer.getPoints()) {
                double ye;
                WorldCoordinate endPoint;
                if (!startPoint.isVisible()) continue;
                switch (layerType) {
                    case POINT_RESIDUAL_HORIZONTAL: {
                        endPoint = new WorldCoordinate(startPoint.getCoordinate().getX() + startPoint.getResidualX(), startPoint.getCoordinate().getY() + startPoint.getResidualY());
                        break;
                    }
                    case POINT_RESIDUAL_VERTICAL: {
                        endPoint = new WorldCoordinate(startPoint.getCoordinate().getX() + 0.0, startPoint.getCoordinate().getY() + startPoint.getResidualZ());
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                PixelCoordinate pixelCoordinateStartPoint = GraphicExtent.toPixelCoordinate(startPoint.getCoordinate(), graphicExtent);
                PixelCoordinate pixelCoordinateEndPoint = GraphicExtent.toPixelCoordinate(endPoint, graphicExtent);
                if (!this.contains(graphicExtent, pixelCoordinateStartPoint) && !this.contains(graphicExtent, pixelCoordinateEndPoint)) continue;
                double xs = pixelCoordinateStartPoint.getX();
                double ys = pixelCoordinateStartPoint.getY();
                double xe = pixelCoordinateEndPoint.getX();
                double distance = Math.hypot(xe - xs, (ye = pixelCoordinateEndPoint.getY()) - ys);
                if (distance == 0.0 || distance * scale < symbolSize) continue;
                distance = distance > 0.0 ? distance : 1.0;
                double dx = (xe - xs) / distance;
                double dy = (ye - ys) / distance;
                double angle = Math.atan2(dy, dx);
                if (!this.contains(graphicExtent, pixelCoordinateStartPoint)) continue;
                double layerDiagoal = Math.hypot(width, height);
                if ((distance *= scale) > 1.05 * layerDiagoal) {
                    distance = 1.05 * layerDiagoal;
                }
                PixelCoordinate vectorEndCoordinate = new PixelCoordinate(xs + distance * dx, ys + distance * dy);
                graphicsContext.strokeLine(xs, ys, xs + distance * dx, ys + distance * dy);
                SymbolBuilder.drawSymbol(graphicsContext, vectorEndCoordinate, arrowSymbolType, symbolSize, angle);
            }
        }
    }

    public String toString() {
        switch (this.getLayerType()) {
            case POINT_RESIDUAL_HORIZONTAL: {
                return this.i18n.getString("PointResidualArrowLayer.type.horizontal", "Horizontal point residuals");
            }
            case POINT_RESIDUAL_VERTICAL: {
                return this.i18n.getString("PointResidualArrowLayer.type.vertical", "Vertical point residuals");
            }
        }
        return "";
    }

    @Override
    public GraphicExtent getMaximumGraphicExtent() {
        GraphicExtent extent = new GraphicExtent();
        extent.reset();
        return extent;
    }

    @Override
    public void clearLayer() {
    }

    @Override
    public void drawLegendSymbol(GraphicsContext graphicsContext, GraphicExtent graphicExtent, PixelCoordinate pixelCoordinate, double symbolHeight, double symbolWidth) {
        ArrowSymbolType arrowSymbolType = this.getSymbolType();
        double lineWidth = this.getLineWidth();
        double symbolSize = symbolHeight;
        graphicsContext.setStroke((Paint)this.getColor());
        graphicsContext.setFill((Paint)this.getColor());
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setLineDashes(null);
        graphicsContext.strokeLine(pixelCoordinate.getX(), pixelCoordinate.getY(), pixelCoordinate.getX() + symbolWidth, pixelCoordinate.getY() + 0.0);
        SymbolBuilder.drawSymbol(graphicsContext, pixelCoordinate, arrowSymbolType, symbolSize, Math.PI);
    }

    @Override
    public boolean hasContent() {
        LayerType layerType = this.getLayerType();
        for (PointLayer layer : this.referenceLayers) {
            if (!layer.isVisible() || !layer.hasContent()) continue;
            for (GraphicPoint startPoint : layer.getPoints()) {
                if (!startPoint.isVisible() || (layerType != LayerType.POINT_RESIDUAL_HORIZONTAL || startPoint.getDimension() == 1) && (layerType != LayerType.POINT_RESIDUAL_VERTICAL || startPoint.getDimension() == 2)) continue;
                return true;
            }
        }
        return false;
    }
}

