/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.FontLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.HighlightableLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.PointSymbolType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.graphic.sql.GraphicPoint;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

public class PointLayer
extends Layer
implements HighlightableLayer,
FontLayer {
    private DoubleProperty fontSize = new SimpleDoubleProperty(10.0);
    private StringProperty fontFamily = new SimpleStringProperty(Font.getDefault().getFamily());
    private ObjectProperty<Color> fontColor = new SimpleObjectProperty((Object)Color.DIMGREY);
    private ObjectProperty<Color> fontBackgroundColor = new SimpleObjectProperty((Object)Color.rgb((int)255, (int)255, (int)255, (double)0.25));
    private ObjectProperty<PointSymbolType> pointSymbolType = new SimpleObjectProperty((Object)PointSymbolType.STROKED_CIRCLE);
    private List<GraphicPoint> points = FXCollections.observableArrayList();
    private ObjectProperty<Color> highlightColor = new SimpleObjectProperty((Object)Color.ORANGERED);
    private DoubleProperty highlightLineWidth = new SimpleDoubleProperty(2.5);
    private ObjectProperty<TableRowHighlightType> highlightType = new SimpleObjectProperty((Object)TableRowHighlightType.NONE);
    private BooleanProperty point1DVisible = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private BooleanProperty point2DVisible = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    private BooleanProperty point3DVisible = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());

    PointLayer(LayerType layerType) {
        super(layerType);
        PointSymbolType pointSymbolType;
        Color symbolColor;
        Color fontColor;
        String fontFamily = null;
        double symbolSize = -1.0;
        double lineWidth = -1.0;
        double fontSize = -1.0;
        double highlightLineWidth = -1.0;
        boolean visible = Boolean.TRUE;
        switch (layerType) {
            case REFERENCE_POINT_APRIORI: {
                fontFamily = PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_COLOR", "#90ee90"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#90ee90");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_SYMBOL_TYPE", "STROKED_SQUARE"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_FONT_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("REFERENCE_POINT_APRIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {}
                break;
            }
            case REFERENCE_POINT_APOSTERIORI: {
                Color highlightColor;
                TableRowHighlightType highlightType;
                fontFamily = PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_COLOR", "#006400"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#006400");
                }
                try {
                    highlightType = TableRowHighlightType.valueOf(PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_HIGHLIGHT_TYPE", "NONE"));
                    if (highlightType == null) {
                        highlightType = TableRowHighlightType.NONE;
                    }
                }
                catch (Exception e) {
                    highlightType = TableRowHighlightType.NONE;
                }
                try {
                    highlightColor = Color.web((String)PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_HIGHLIGHT_COLOR", "#FF4500"));
                }
                catch (Exception e) {
                    highlightColor = Color.web((String)"#FF4500");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_SYMBOL_TYPE", "STROKED_SQUARE"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_FONT_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    highlightLineWidth = Double.parseDouble(PROPERTIES.getProperty("REFERENCE_POINT_APOSTERIORI_HIGHLIGHT_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.setHighlightLineWidth(highlightLineWidth >= 0.0 ? highlightLineWidth : 2.5);
                this.setHighlightColor(highlightColor);
                this.setHighlightType(highlightType);
                break;
            }
            case STOCHASTIC_POINT_APRIORI: {
                fontFamily = PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_COLOR", "#ffd700"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#ffd700");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_SYMBOL_TYPE", "STROKED_UPRIGHT_TRIANGLE"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_FONT_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("STOCHASTIC_POINT_APRIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {}
                break;
            }
            case STOCHASTIC_POINT_APOSTERIORI: {
                Color highlightColor;
                TableRowHighlightType highlightType;
                fontFamily = PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_COLOR", "#daa520"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#daa520");
                }
                try {
                    highlightType = TableRowHighlightType.valueOf(PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_HIGHLIGHT_TYPE", "NONE"));
                    if (highlightType == null) {
                        highlightType = TableRowHighlightType.NONE;
                    }
                }
                catch (Exception e) {
                    highlightType = TableRowHighlightType.NONE;
                }
                try {
                    highlightColor = Color.web((String)PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_HIGHLIGHT_COLOR", "#FF4500"));
                }
                catch (Exception e) {
                    highlightColor = Color.web((String)"#FF4500");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_SYMBOL_TYPE", "STROKED_UPRIGHT_TRIANGLE"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_FONT_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    highlightLineWidth = Double.parseDouble(PROPERTIES.getProperty("STOCHASTIC_POINT_APOSTERIORI_HIGHLIGHT_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.setHighlightLineWidth(highlightLineWidth >= 0.0 ? highlightLineWidth : 2.5);
                this.setHighlightColor(highlightColor);
                this.setHighlightType(highlightType);
                break;
            }
            case DATUM_POINT_APRIORI: {
                fontFamily = PROPERTIES.getProperty("DATUM_POINT_APRIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("DATUM_POINT_APRIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("DATUM_POINT_APRIORI_COLOR", "#87ceeb"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#87ceeb");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("DATUM_POINT_APRIORI_SYMBOL_TYPE", "STROKED_HEXAGON"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("DATUM_POINT_APRIORI_FONT_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("DATUM_POINT_APRIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("DATUM_POINT_APRIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("DATUM_POINT_APRIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {}
                break;
            }
            case DATUM_POINT_APOSTERIORI: {
                Color highlightColor;
                TableRowHighlightType highlightType;
                fontFamily = PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_COLOR", "#1e90ff"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#1e90ff");
                }
                try {
                    highlightType = TableRowHighlightType.valueOf(PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_HIGHLIGHT_TYPE", "NONE"));
                    if (highlightType == null) {
                        highlightType = TableRowHighlightType.NONE;
                    }
                }
                catch (Exception e) {
                    highlightType = TableRowHighlightType.NONE;
                }
                try {
                    highlightColor = Color.web((String)PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_HIGHLIGHT_COLOR", "#FF4500"));
                }
                catch (Exception e) {
                    highlightColor = Color.web((String)"#FF4500");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_SYMBOL_TYPE", "STROKED_HEXAGON"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_FONT_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    highlightLineWidth = Double.parseDouble(PROPERTIES.getProperty("DATUM_POINT_APOSTERIORI_HIGHLIGHT_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.setHighlightLineWidth(highlightLineWidth >= 0.0 ? highlightLineWidth : 2.5);
                this.setHighlightColor(highlightColor);
                this.setHighlightType(highlightType);
                break;
            }
            case NEW_POINT_APRIORI: {
                fontFamily = PROPERTIES.getProperty("NEW_POINT_APRIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("NEW_POINT_APRIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("NEW_POINT_APRIORI_COLOR", "#c480c4"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#c480c4");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("NEW_POINT_APRIORI_SYMBOL_TYPE", "STROKED_CIRCLE"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("NEW_POINT_APRIORI_FONT_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("NEW_POINT_APRIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("NEW_POINT_APRIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("NEW_POINT_APRIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {}
                break;
            }
            case NEW_POINT_APOSTERIORI: {
                fontFamily = PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_FONT_FAMILY", "System");
                try {
                    fontColor = Color.web((String)PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_FONT_COLOR", "#696969"));
                }
                catch (Exception e) {
                    fontColor = Color.web((String)"#696969");
                }
                try {
                    symbolColor = Color.web((String)PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_COLOR", "#dda0dd"));
                }
                catch (Exception e) {
                    symbolColor = Color.web((String)"#dda0dd");
                }
                try {
                    pointSymbolType = PointSymbolType.valueOf(PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_SYMBOL_TYPE", "STROKED_CIRCLE"));
                }
                catch (Exception e) {
                    pointSymbolType = PointSymbolType.STROKED_SQUARE;
                }
                try {
                    fontSize = Double.parseDouble(PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_FONT_SIZE"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_SYMBOL_SIZE"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_LINE_WIDTH"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("NEW_POINT_APOSTERIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                throw new IllegalArgumentException("Error, unsupported layer type " + String.valueOf((Object)layerType));
            }
        }
        symbolSize = symbolSize >= 0.0 ? symbolSize : 12.0;
        lineWidth = lineWidth >= 0.0 ? lineWidth : 1.5;
        fontSize = fontSize >= 0.0 ? fontSize : 10.0;
        fontFamily = fontFamily != null ? fontFamily : "System";
        this.setSymbolType(pointSymbolType);
        this.setColor(symbolColor);
        this.setLineWidth(lineWidth);
        this.setSymbolSize(symbolSize);
        this.setFontSize(fontSize);
        this.setFontFamily(fontFamily);
        this.setFontColor(fontColor);
        this.setVisible(visible);
    }

    @Override
    public void draw(GraphicsContext graphicsContext, GraphicExtent graphicExtent) {
        if (!this.isVisible() || this.points.isEmpty()) {
            return;
        }
        PointSymbolType symbolType = this.getPointSymbolType();
        double symbolSize = this.getSymbolSize();
        double fontSize = this.getFontSize();
        String fontFamily = this.getFontFamily();
        Color fontBackgroundColor = this.getFontBackgroundColor();
        for (GraphicPoint point : this.points) {
            PixelCoordinate pixelCoordinate;
            if (!point.isVisible() || !this.contains(graphicExtent, pixelCoordinate = GraphicExtent.toPixelCoordinate(point.getCoordinate(), graphicExtent))) continue;
            Color symbolColor = this.getColor();
            Color fontColor = this.getFontColor();
            double lineWidth = this.getLineWidth();
            TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
            double leftBoundary = tableRowHighlight.getLeftBoundary(this.getHighlightType());
            double rightBoundary = tableRowHighlight.getRightBoundary(this.getHighlightType());
            switch (this.getHighlightType()) {
                case INFLUENCE_ON_POSITION: {
                    if (!(point.getMaxInfluenceOnPosition() > rightBoundary)) break;
                    symbolColor = this.getHighlightColor();
                    fontColor = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case P_PRIO_VALUE: {
                    if (!(point.getPprio() < Math.log(leftBoundary / 100.0))) break;
                    symbolColor = this.getHighlightColor();
                    fontColor = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case REDUNDANCY: {
                    if (!(point.getMinRedundancy() < leftBoundary)) break;
                    symbolColor = this.getHighlightColor();
                    fontColor = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case TEST_STATISTIC: {
                    if (!point.isSignificant()) break;
                    symbolColor = this.getHighlightColor();
                    fontColor = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case GROSS_ERROR: {
                    if (!point.isGrossErrorExceeded()) break;
                    symbolColor = this.getHighlightColor();
                    fontColor = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case NONE: {
                    symbolColor = this.getColor();
                    fontColor = this.getFontColor();
                    lineWidth = this.getLineWidth();
                }
            }
            this.drawPointSymbol(graphicsContext, pixelCoordinate, symbolColor, symbolType, symbolSize, lineWidth);
            this.drawPointText(graphicsContext, pixelCoordinate, point.getName().trim(), fontColor, fontBackgroundColor, fontFamily, symbolSize, lineWidth, fontSize);
        }
    }

    private void drawPointSymbol(GraphicsContext graphicsContext, PixelCoordinate pixelCoordinate, Color color, PointSymbolType symbolType, double symbolSize, double lineWidth) {
        graphicsContext.setLineCap(StrokeLineCap.BUTT);
        graphicsContext.setLineDashes(null);
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setStroke((Paint)color);
        graphicsContext.setFill((Paint)color);
        SymbolBuilder.drawSymbol(graphicsContext, pixelCoordinate, symbolType, symbolSize);
    }

    private void drawPointText(GraphicsContext graphicsContext, PixelCoordinate pixelCoordinate, String name, Color color, Color backgroundColor, String fontFamily, double symbolSize, double lineWidth, double fontSize) {
        Font font = Font.font((String)fontFamily, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        Text text = new Text(name);
        text.setFont(font);
        text.setWrappingWidth(0.0);
        text.setLineSpacing(0.0);
        double textWidth = text.getLayoutBounds().getWidth();
        double textHeight = text.getLayoutBounds().getHeight();
        double x0 = pixelCoordinate.getX() + 0.5 * (symbolSize + lineWidth);
        double y0 = pixelCoordinate.getY() + 0.5 * (symbolSize + lineWidth);
        graphicsContext.setLineCap(StrokeLineCap.BUTT);
        graphicsContext.setLineDashes(null);
        graphicsContext.setStroke((Paint)backgroundColor);
        graphicsContext.setFill((Paint)backgroundColor);
        graphicsContext.fillRoundRect(x0, y0, textWidth, textHeight, 2.0, 2.0);
        graphicsContext.setStroke((Paint)color);
        graphicsContext.setFill((Paint)color);
        graphicsContext.setFont(font);
        graphicsContext.setTextBaseline(VPos.CENTER);
        graphicsContext.setTextAlign(TextAlignment.CENTER);
        graphicsContext.fillText(name, x0 + 0.5 * textWidth, y0 + 0.5 * textHeight);
    }

    @Override
    public void clearLayer() {
        this.points.clear();
    }

    @Override
    public GraphicExtent getMaximumGraphicExtent() {
        GraphicExtent graphicExtent = new GraphicExtent();
        graphicExtent.reset();
        if (this.points != null) {
            for (GraphicPoint point : this.points) {
                if (!point.isVisible()) continue;
                graphicExtent.merge(point.getCoordinate());
            }
        }
        return graphicExtent;
    }

    public void setPoints(List<GraphicPoint> points) {
        this.points.clear();
        if (points != null) {
            block5: for (GraphicPoint point : points) {
                int dimension = point.getDimension();
                switch (dimension) {
                    case 1: {
                        point.setVisible(this.isPoint1DVisible());
                        break;
                    }
                    case 2: {
                        point.setVisible(this.isPoint2DVisible());
                        break;
                    }
                    case 3: {
                        point.setVisible(this.isPoint3DVisible());
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                this.points.add(point);
            }
        }
    }

    public List<GraphicPoint> getPoints() {
        return this.points;
    }

    private void setPointVisible(int dimension, boolean visible) {
        for (GraphicPoint point : this.points) {
            if (point.getDimension() != dimension) continue;
            point.setVisible(visible);
        }
    }

    public ObjectProperty<PointSymbolType> pointSymbolTypeProperty() {
        return this.pointSymbolType;
    }

    public PointSymbolType getPointSymbolType() {
        return (PointSymbolType)((Object)this.pointSymbolTypeProperty().get());
    }

    public void setSymbolType(PointSymbolType pointSymbolType) {
        this.pointSymbolTypeProperty().set((Object)pointSymbolType);
    }

    @Override
    public final ObjectProperty<Color> fontColorProperty() {
        return this.fontColor;
    }

    @Override
    public final Color getFontColor() {
        return (Color)this.fontColorProperty().get();
    }

    @Override
    public final void setFontColor(Color textColor) {
        this.fontColorProperty().set((Object)textColor);
    }

    @Override
    public final ObjectProperty<Color> fontBackgroundColorProperty() {
        return this.fontBackgroundColor;
    }

    @Override
    public final Color getFontBackgroundColor() {
        return (Color)this.fontBackgroundColorProperty().get();
    }

    @Override
    public final void setFontBackgroundColor(Color fontBackgroundColor) {
        this.fontBackgroundColorProperty().set((Object)fontBackgroundColor);
    }

    @Override
    public final DoubleProperty fontSizeProperty() {
        return this.fontSize;
    }

    @Override
    public final double getFontSize() {
        return this.fontSizeProperty().get();
    }

    @Override
    public final void setFontSize(double fontSize) {
        this.fontSizeProperty().set(fontSize);
    }

    @Override
    public StringProperty fontFamilyProperty() {
        return this.fontFamily;
    }

    @Override
    public String getFontFamily() {
        return (String)this.fontFamilyProperty().get();
    }

    @Override
    public void setFontFamily(String fontFamily) {
        this.fontFamilyProperty().set((Object)fontFamily);
    }

    public String toString() {
        switch (this.getLayerType()) {
            case DATUM_POINT_APOSTERIORI: {
                return this.i18n.getString("PointLayer.type.datum.aposteriori", "Datum points (a-posteriori)");
            }
            case DATUM_POINT_APRIORI: {
                return this.i18n.getString("PointLayer.type.datum.apriori", "Datum points (a-priori)");
            }
            case NEW_POINT_APOSTERIORI: {
                return this.i18n.getString("PointLayer.type.new.aposteriori", "New points (a-posteriori)");
            }
            case NEW_POINT_APRIORI: {
                return this.i18n.getString("PointLayer.type.new.apriori", "New points (a-priori)");
            }
            case REFERENCE_POINT_APOSTERIORI: {
                return this.i18n.getString("PointLayer.type.reference.aposteriori", "Reference points (a-posteriori)");
            }
            case REFERENCE_POINT_APRIORI: {
                return this.i18n.getString("PointLayer.type.reference.apriori", "Reference points (a-priori)");
            }
            case STOCHASTIC_POINT_APOSTERIORI: {
                return this.i18n.getString("PointLayer.type.stochastic.aposteriori", "Stochastic points (a-posteriori)");
            }
            case STOCHASTIC_POINT_APRIORI: {
                return this.i18n.getString("PointLayer.type.stochastic.apriori", "Stochastic points (a-priori)");
            }
        }
        return "";
    }

    public BooleanProperty point1DVisibleProperty() {
        return this.point1DVisible;
    }

    public boolean isPoint1DVisible() {
        return this.point1DVisibleProperty().get();
    }

    public void setPoint1DVisible(boolean point1DVisible) {
        this.setPointVisible(1, point1DVisible);
        this.point1DVisibleProperty().set(point1DVisible);
    }

    public BooleanProperty point2DVisibleProperty() {
        return this.point2DVisible;
    }

    public boolean isPoint2DVisible() {
        return this.point2DVisibleProperty().get();
    }

    public void setPoint2DVisible(boolean point2DVisible) {
        this.setPointVisible(2, point2DVisible);
        this.point2DVisibleProperty().set(point2DVisible);
    }

    public BooleanProperty point3DVisibleProperty() {
        return this.point3DVisible;
    }

    public boolean isPoint3DVisible() {
        return this.point3DVisibleProperty().get();
    }

    public void setPoint3DVisible(boolean point3DVisible) {
        this.setPointVisible(3, point3DVisible);
        this.point3DVisibleProperty().set(point3DVisible);
    }

    @Override
    public final ObjectProperty<Color> highlightColorProperty() {
        return this.highlightColor;
    }

    @Override
    public final Color getHighlightColor() {
        return (Color)this.highlightColorProperty().get();
    }

    @Override
    public final void setHighlightColor(Color highlightColor) {
        this.highlightColorProperty().set((Object)highlightColor);
    }

    @Override
    public final DoubleProperty highlightLineWidthProperty() {
        return this.highlightLineWidth;
    }

    @Override
    public final double getHighlightLineWidth() {
        return this.highlightLineWidthProperty().get();
    }

    @Override
    public final void setHighlightLineWidth(double highlightLineWidth) {
        this.highlightLineWidthProperty().set(highlightLineWidth);
    }

    @Override
    public ObjectProperty<TableRowHighlightType> highlightTypeProperty() {
        return this.highlightType;
    }

    @Override
    public TableRowHighlightType getHighlightType() {
        return (TableRowHighlightType)((Object)this.highlightTypeProperty().get());
    }

    @Override
    public void setHighlightType(TableRowHighlightType highlightType) {
        this.highlightTypeProperty().set((Object)highlightType);
    }

    @Override
    public void drawLegendSymbol(GraphicsContext graphicsContext, GraphicExtent graphicExtent, PixelCoordinate pixelCoordinate, double symbolHeight, double symbolWidth) {
        if (this.contains(graphicExtent, pixelCoordinate)) {
            PointSymbolType symbolType = this.getPointSymbolType();
            Color symbolColor = this.getColor();
            double lineWidth = this.getLineWidth();
            double symbolSize = symbolHeight;
            this.drawPointSymbol(graphicsContext, new PixelCoordinate(pixelCoordinate.getX() + 0.5 * symbolWidth, pixelCoordinate.getY()), symbolColor, symbolType, symbolSize, lineWidth);
        }
    }

    @Override
    public boolean hasContent() {
        return super.hasContent() && this.points != null && !this.points.isEmpty();
    }
}

