/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.HighlightableLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.ObservationSymbolProperties;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.graphic.sql.GraphicPoint;
import org.applied_geodesy.jag3d.ui.graphic.sql.ObservableMeasurement;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

public class ObservationLayer
extends Layer
implements HighlightableLayer {
    private DoubleProperty pointSymbolSize = new SimpleDoubleProperty(12.0);
    private List<ObservableMeasurement> observableMeasurements = FXCollections.observableArrayList();
    private Map<ObservationSymbolProperties.ObservationType, ObservationSymbolProperties> symbolPropertiesMap = new HashMap<ObservationSymbolProperties.ObservationType, ObservationSymbolProperties>(ObservationSymbolProperties.ObservationType.values().length);
    private ObjectProperty<Color> highlightColor = new SimpleObjectProperty((Object)Color.ORANGERED);
    private DoubleProperty highlightLineWidth = new SimpleDoubleProperty(2.5);
    private ObjectProperty<TableRowHighlightType> highlightType = new SimpleObjectProperty((Object)TableRowHighlightType.NONE);
    private Set<ObservationSymbolProperties.ObservationType> projectObservationTypes = new LinkedHashSet<ObservationSymbolProperties.ObservationType>(10);

    ObservationLayer(LayerType layerType) {
        super(layerType);
        Color color;
        double symbolSize = -1.0;
        double lineWidth = -1.0;
        double highlightLineWidth = -1.0;
        boolean visible = Boolean.TRUE;
        switch (layerType) {
            case OBSERVATION_APRIORI: {
                try {
                    color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APRIORI_COLOR", "#b0c4de"));
                }
                catch (Exception e) {
                    color = Color.web((String)"#b0c4de");
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("OBSERVATION_APRIORI_SYMBOL_SIZE"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("OBSERVATION_APRIORI_LINE_WIDTH"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("OBSERVATION_APRIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception e) {}
                break;
            }
            case OBSERVATION_APOSTERIORI: {
                Color highlightColor;
                TableRowHighlightType highlightType;
                try {
                    highlightType = TableRowHighlightType.valueOf(PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_HIGHLIGHT_TYPE", "NONE"));
                    if (highlightType == null) {
                        highlightType = TableRowHighlightType.NONE;
                    }
                }
                catch (Exception e) {
                    highlightType = TableRowHighlightType.NONE;
                }
                try {
                    highlightColor = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_HIGHLIGHT_COLOR", "#FF4500"));
                }
                catch (Exception e) {
                    highlightColor = Color.web((String)"#FF4500");
                }
                try {
                    color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_COLOR", "#778899"));
                }
                catch (Exception e) {
                    color = Color.web((String)"#778899");
                }
                try {
                    symbolSize = Double.parseDouble(PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_SYMBOL_SIZE"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    lineWidth = Double.parseDouble(PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_LINE_WIDTH"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    visible = PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_VISIBLE").equalsIgnoreCase("TRUE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    highlightLineWidth = Double.parseDouble(PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_HIGHLIGHT_LINE_WIDTH"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setHighlightLineWidth(highlightLineWidth >= 0.0 ? highlightLineWidth : 2.5);
                this.setHighlightColor(highlightColor);
                this.setHighlightType(highlightType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Error, unsupported layer type " + String.valueOf((Object)layerType));
            }
        }
        symbolSize = symbolSize >= 0.0 ? symbolSize : 12.0;
        lineWidth = lineWidth >= 0.0 ? lineWidth : 1.0;
        this.setLineWidth(lineWidth);
        this.setSymbolSize(symbolSize);
        this.setColor(color);
        this.setVisible(visible);
        this.initSymbolProperties();
    }

    private void initSymbolProperties() {
        ObservationSymbolProperties.ObservationType[] observationTypes = ObservationSymbolProperties.ObservationType.values();
        ObservationSymbolProperties properties = null;
        ObservationSymbolProperties.ObservationType[] observationTypeArray = observationTypes;
        int n = observationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ObservationSymbolProperties.ObservationType observationType = observationTypeArray[n2];
            properties = new ObservationSymbolProperties(observationType);
            properties.setVisible(Boolean.TRUE);
            Color color = Color.BLACK;
            switch (this.getLayerType()) {
                case OBSERVATION_APRIORI: {
                    switch (observationType) {
                        case LEVELING: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APRIORI_COLOR_LEVELING", "#c195c1"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#c195c1");
                            }
                            break;
                        }
                        case DIRECTION: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APRIORI_COLOR_DIRECTION", "#ffff7d"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#ffff7d");
                            }
                            break;
                        }
                        case DISTANCE: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APRIORI_COLOR_DISTANCE", "#6d93ff"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#6d93ff");
                            }
                            break;
                        }
                        case ZENITH_ANGLE: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APRIORI_COLOR_ZENITH_ANGLE", "#f28282"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#f28282");
                            }
                            break;
                        }
                        case GNSS: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APRIORI_COLOR_GNSS", "#70b770"));
                                break;
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#70b770");
                            }
                        }
                    }
                    break;
                }
                case OBSERVATION_APOSTERIORI: {
                    switch (observationType) {
                        case LEVELING: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_COLOR_LEVELING", "#875187"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#875187");
                            }
                            break;
                        }
                        case DIRECTION: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_COLOR_DIRECTION", "#d7d722"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#d7d722");
                            }
                            break;
                        }
                        case DISTANCE: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_COLOR_DISTANCE", "#4872e9"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#4872e9");
                            }
                            break;
                        }
                        case ZENITH_ANGLE: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_COLOR_ZENITH_ANGLE", "#d23737"));
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#d23737");
                            }
                            break;
                        }
                        case GNSS: {
                            try {
                                color = Color.web((String)PROPERTIES.getProperty("OBSERVATION_APOSTERIORI_COLOR_GNSS", "#32a332"));
                                break;
                            }
                            catch (Exception e) {
                                color = Color.web((String)"#32a332");
                            }
                        }
                    }
                    break;
                }
            }
            properties.setColor(color);
            this.symbolPropertiesMap.put(observationType, properties);
            ++n2;
        }
    }

    @Override
    public void draw(GraphicsContext graphicsContext, GraphicExtent graphicExtent) {
        if (!this.isVisible() || this.observableMeasurements.isEmpty()) {
            return;
        }
        double symbolSize = this.getSymbolSize();
        graphicsContext.setLineCap(StrokeLineCap.BUTT);
        graphicsContext.setLineWidth(this.getLineWidth());
        double maxLength = 125.0;
        double pointSymbolSize = this.getPointSymbolSize();
        double width = graphicExtent.getDrawingBoardWidth();
        double height = graphicExtent.getDrawingBoardHeight();
        for (ObservableMeasurement observableLink : this.observableMeasurements) {
            PixelCoordinate coordinate;
            double scale;
            double ye;
            GraphicPoint startPoint = observableLink.getStartPoint();
            GraphicPoint endPoint = observableLink.getEndPoint();
            if (!startPoint.isVisible() || !endPoint.isVisible()) continue;
            PixelCoordinate pixelCoordinateStartPoint = GraphicExtent.toPixelCoordinate(startPoint.getCoordinate(), graphicExtent);
            PixelCoordinate pixelCoordinateEndPoint = GraphicExtent.toPixelCoordinate(endPoint.getCoordinate(), graphicExtent);
            if (!this.contains(graphicExtent, pixelCoordinateStartPoint) && !this.contains(graphicExtent, pixelCoordinateEndPoint) || !this.contains(graphicExtent, pixelCoordinateStartPoint) && !this.contains(graphicExtent, pixelCoordinateEndPoint)) continue;
            double xs = pixelCoordinateStartPoint.getX();
            double ys = pixelCoordinateStartPoint.getY();
            double xe = pixelCoordinateEndPoint.getX();
            double distance = Math.hypot(xe - xs, (ye = pixelCoordinateEndPoint.getY()) - ys);
            distance = distance > 0.0 ? distance : 1.0;
            double dx = (xe - xs) / distance;
            double dy = (ye - ys) / distance;
            Color color = this.getColor();
            double lineWidth = this.getLineWidth();
            TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
            double leftBoundary = tableRowHighlight.getLeftBoundary(this.getHighlightType());
            double rightBoundary = tableRowHighlight.getRightBoundary(this.getHighlightType());
            switch (this.getHighlightType()) {
                case INFLUENCE_ON_POSITION: {
                    if (!(observableLink.getInfluenceOnPosition() > rightBoundary)) break;
                    color = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case P_PRIO_VALUE: {
                    if (!(observableLink.getPprio() < Math.log(leftBoundary / 100.0))) break;
                    color = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case REDUNDANCY: {
                    if (!(observableLink.getRedundancy() < leftBoundary)) break;
                    color = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case TEST_STATISTIC: {
                    if (!observableLink.isSignificant()) break;
                    color = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case GROSS_ERROR: {
                    if (!observableLink.isGrossErrorExceeded()) break;
                    color = this.getHighlightColor();
                    lineWidth = this.getHighlightLineWidth();
                    break;
                }
                case NONE: {
                    color = this.getColor();
                    lineWidth = this.getLineWidth();
                }
            }
            graphicsContext.setStroke((Paint)color);
            graphicsContext.setLineWidth(lineWidth);
            graphicsContext.setLineDashes(null);
            double layerDiagoal = Math.hypot(width, height);
            if (distance > 1.005 * layerDiagoal) {
                distance = 1.005 * layerDiagoal;
                if (!this.contains(graphicExtent, pixelCoordinateStartPoint)) {
                    xs = xe - distance * dx;
                    ys = ye - distance * dy;
                } else if (!this.contains(graphicExtent, pixelCoordinateEndPoint)) {
                    xe = xs + distance * dx;
                    ye = ys + distance * dy;
                }
            }
            double si = 0.0;
            double ei = 0.0;
            if (this.contains(graphicExtent, pixelCoordinateStartPoint) && !observableLink.getStartPointObservationType().isEmpty()) {
                si = 1.0;
                graphicsContext.strokeLine(xs, ys, xs + Math.min(0.35 * distance, 125.0) * dx, ys + Math.min(0.35 * distance, 125.0) * dy);
            }
            if (this.contains(graphicExtent, pixelCoordinateEndPoint) && !observableLink.getEndPointObservationType().isEmpty()) {
                ei = 1.0;
                graphicsContext.strokeLine(xe, ye, xe - Math.min(0.35 * distance, 125.0) * dx, ye - Math.min(0.35 * distance, 125.0) * dy);
            }
            graphicsContext.setLineDashes(new double[]{2.5, 3.5});
            graphicsContext.strokeLine(xs + si * (Math.min(0.35 * distance, 125.0) * dx), ys + si * (Math.min(0.35 * distance, 125.0) * dy), xe - ei * (Math.min(0.35 * distance, 125.0) * dx), ye - ei * (Math.min(0.35 * distance, 125.0) * dy));
            if (!(distance > 3.0 * symbolSize)) continue;
            double d = scale = distance > 4.0 * pointSymbolSize + symbolSize ? 1.5 * pointSymbolSize + 0.5 * symbolSize : 0.5 * (distance - symbolSize);
            if (!observableLink.getStartPointObservationType().isEmpty()) {
                coordinate = new PixelCoordinate(xs - 0.5 * symbolSize + scale * dx, ys - 0.5 * symbolSize + scale * dy);
                SymbolBuilder.drawSymbol(graphicsContext, coordinate, this.symbolPropertiesMap, observableLink.getStartPointObservationType(), symbolSize);
            }
            if (observableLink.getEndPointObservationType().isEmpty()) continue;
            coordinate = new PixelCoordinate(xe - 0.5 * symbolSize - scale * dx, ye - 0.5 * symbolSize - scale * dy);
            SymbolBuilder.drawSymbol(graphicsContext, coordinate, this.symbolPropertiesMap, observableLink.getEndPointObservationType(), symbolSize);
        }
    }

    public void setObservableMeasurements(List<ObservableMeasurement> observableMeasurements) {
        GraphicExtent graphicExtent = this.getMaximumGraphicExtent();
        graphicExtent.reset();
        this.observableMeasurements.clear();
        this.projectObservationTypes.clear();
        if (observableMeasurements != null) {
            for (ObservableMeasurement observableMeasurement : observableMeasurements) {
                GraphicPoint startPoint = observableMeasurement.getStartPoint();
                GraphicPoint endPoint = observableMeasurement.getEndPoint();
                graphicExtent.merge(startPoint.getCoordinate());
                graphicExtent.merge(endPoint.getCoordinate());
                this.projectObservationTypes.addAll(observableMeasurement.getStartPointObservationType());
                this.projectObservationTypes.addAll(observableMeasurement.getEndPointObservationType());
            }
            this.observableMeasurements.addAll(observableMeasurements);
        }
    }

    public final DoubleProperty pointSymbolSizeProperty() {
        return this.pointSymbolSize;
    }

    public final double getPointSymbolSize() {
        return this.pointSymbolSizeProperty().get();
    }

    public final void setPointSymbolSize(double pointSymbolSize) {
        this.pointSymbolSizeProperty().set(pointSymbolSize);
    }

    public ObservationSymbolProperties getObservationSymbolProperties(ObservationSymbolProperties.ObservationType observationType) {
        return this.symbolPropertiesMap.get((Object)observationType);
    }

    public String toString() {
        switch (this.getLayerType()) {
            case OBSERVATION_APOSTERIORI: {
                return this.i18n.getString("ObservationAprioriLayer.type.aposteriori", "Observations (a-posteriori)");
            }
            case OBSERVATION_APRIORI: {
                return this.i18n.getString("ObservationAprioriLayer.type.apriori", "Observations (a-priori)");
            }
        }
        return "";
    }

    @Override
    public void clearLayer() {
        this.observableMeasurements.clear();
        this.projectObservationTypes.clear();
    }

    @Override
    public GraphicExtent getMaximumGraphicExtent() {
        GraphicExtent graphicExtent = new GraphicExtent();
        graphicExtent.reset();
        if (this.observableMeasurements != null) {
            for (ObservableMeasurement observableMeasurement : this.observableMeasurements) {
                GraphicPoint startPoint = observableMeasurement.getStartPoint();
                GraphicPoint endPoint = observableMeasurement.getEndPoint();
                if (startPoint.isVisible()) {
                    graphicExtent.merge(startPoint.getCoordinate());
                }
                if (!endPoint.isVisible()) continue;
                graphicExtent.merge(endPoint.getCoordinate());
            }
        }
        return graphicExtent;
    }

    @Override
    public final ObjectProperty<Color> highlightColorProperty() {
        return this.highlightColor;
    }

    @Override
    public final Color getHighlightColor() {
        return (Color)this.highlightColorProperty().get();
    }

    @Override
    public final void setHighlightColor(Color highlightColor) {
        this.highlightColorProperty().set((Object)highlightColor);
    }

    @Override
    public final DoubleProperty highlightLineWidthProperty() {
        return this.highlightLineWidth;
    }

    @Override
    public final double getHighlightLineWidth() {
        return this.highlightLineWidthProperty().get();
    }

    @Override
    public final void setHighlightLineWidth(double highlightLineWidth) {
        this.highlightLineWidthProperty().set(highlightLineWidth);
    }

    @Override
    public ObjectProperty<TableRowHighlightType> highlightTypeProperty() {
        return this.highlightType;
    }

    @Override
    public TableRowHighlightType getHighlightType() {
        return (TableRowHighlightType)((Object)this.highlightTypeProperty().get());
    }

    @Override
    public void setHighlightType(TableRowHighlightType highlightType) {
        this.highlightTypeProperty().set((Object)highlightType);
    }

    @Override
    public void drawLegendSymbol(GraphicsContext graphicsContext, GraphicExtent graphicExtent, PixelCoordinate pixelCoordinateStartPoint, double symbolHeight, double symbolWidth) {
        PixelCoordinate pixelCoordinateEndPoint = new PixelCoordinate(pixelCoordinateStartPoint.getX() + 70.0, pixelCoordinateStartPoint.getY());
        if (!this.contains(graphicExtent, pixelCoordinateStartPoint) && !this.contains(graphicExtent, pixelCoordinateEndPoint)) {
            return;
        }
        LinkedHashSet<ObservationSymbolProperties.ObservationType> observationTypes = new LinkedHashSet<ObservationSymbolProperties.ObservationType>(10);
        for (ObservableMeasurement observableLink : this.observableMeasurements) {
            GraphicPoint startPoint = observableLink.getStartPoint();
            GraphicPoint endPoint = observableLink.getEndPoint();
            if (!startPoint.isVisible() || !endPoint.isVisible()) continue;
            observationTypes.addAll(observableLink.getStartPointObservationType());
            observationTypes.addAll(observableLink.getEndPointObservationType());
            if (observationTypes.size() != this.projectObservationTypes.size()) continue;
            boolean containsAll = true;
            for (ObservationSymbolProperties.ObservationType type : observationTypes) {
                if (this.projectObservationTypes.contains((Object)type)) continue;
                containsAll = false;
                break;
            }
            if (containsAll) break;
        }
        if (observationTypes.isEmpty()) {
            return;
        }
        graphicsContext.setLineWidth(this.getLineWidth());
        graphicsContext.setStroke((Paint)this.getColor());
        graphicsContext.setLineDashes(null);
        graphicsContext.strokeLine(pixelCoordinateStartPoint.getX(), pixelCoordinateStartPoint.getY(), pixelCoordinateStartPoint.getX() + symbolWidth, pixelCoordinateStartPoint.getY());
        PixelCoordinate coordinate = new PixelCoordinate(pixelCoordinateStartPoint.getX() + 0.5 * (symbolWidth - symbolHeight), pixelCoordinateStartPoint.getY() - 0.5 * symbolHeight);
        SymbolBuilder.drawSymbol(graphicsContext, coordinate, this.symbolPropertiesMap, observationTypes, symbolHeight);
    }

    @Override
    public boolean hasContent() {
        return super.hasContent() && this.observableMeasurements != null && !this.observableMeasurements.isEmpty();
    }
}

