/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.Locale;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.WorldCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;
import org.applied_geodesy.jag3d.ui.graphic.layer.ResizableCanvas;
import org.applied_geodesy.jag3d.ui.graphic.layer.ToolbarType;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterEventType;
import org.applied_geodesy.util.FormatterOptions;

class MouseNavigationCanvas
extends ResizableCanvas
implements FormatterChangedListener {
    private FormatterOptions options = FormatterOptions.getInstance();
    private ToolbarType toolbarType = null;
    private Label coordinatePanel;
    private RubberbandingAndPanEventHandler rubberbandingAndPanEventHandler = new RubberbandingAndPanEventHandler();
    private LayerManager layerManager;
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.DARKBLUE);
    private DoubleProperty lineWidth = new SimpleDoubleProperty(1.0);
    private ScrollEventHandler scrollEventHandler = new ScrollEventHandler();

    MouseNavigationCanvas(LayerManager layerManager) {
        super(layerManager.getCurrentGraphicExtent());
        FormatterOptions.getInstance().addFormatterChangedListener(this);
        this.layerManager = layerManager;
        this.coordinatePanel = layerManager.getCoordinateLabel();
        this.addEventHandler(MouseEvent.MOUSE_MOVED, this.rubberbandingAndPanEventHandler);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.rubberbandingAndPanEventHandler);
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.rubberbandingAndPanEventHandler);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.rubberbandingAndPanEventHandler);
        this.addEventHandler(ScrollEvent.SCROLL_STARTED, this.scrollEventHandler);
        this.addEventHandler(ScrollEvent.SCROLL, this.scrollEventHandler);
        this.addEventHandler(ScrollEvent.SCROLL_FINISHED, this.scrollEventHandler);
        this.setColor(Color.BLACK);
        this.setLineWidth(1.25);
    }

    @Override
    public void draw() {
        super.draw();
        this.drawScaleBar();
    }

    private void drawRect(double x, double y, double w, double h) {
        this.clear();
        GraphicsContext gc = this.getGraphicsContext2D();
        gc.setStroke((Paint)this.getColor());
        gc.setLineWidth(this.getLineWidth());
        gc.setLineDashes(new double[]{3.0, 5.0, 3.0, 5.0});
        gc.strokeRect(x, y, w, h);
    }

    private void drawScaleBar() {
        GraphicsContext gc = this.getGraphicsContext2D();
        gc.setStroke((Paint)Color.BLACK);
        gc.setFont(Font.font((String)"Monospaced", (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)10.0));
        gc.setLineWidth(0.5);
        gc.setLineDashes(null);
        double extentScale = this.getCurrentGraphicExtent().getScale();
        if (Double.isInfinite(extentScale) || Double.isNaN(extentScale) || extentScale <= 0.0) {
            return;
        }
        int scaleSegments = 3;
        double scaleBarWidth = 50.0;
        double scaleBarHeight = 5.0;
        double padding = 25.0;
        double x = this.getWidth() - padding;
        double y = this.getHeight() - padding;
        double worldScale = this.options.convertLengthToView(extentScale * scaleBarWidth);
        int exponent = (int)Math.log10(worldScale);
        double magnitude = Math.pow(10.0, exponent);
        double ratio = Math.ceil(worldScale / magnitude);
        if (worldScale / magnitude < 0.5) {
            magnitude = Math.pow(10.0, --exponent);
            ratio = Math.ceil(worldScale / magnitude);
        }
        scaleBarWidth = this.options.convertLengthToModel(ratio * magnitude / extentScale);
        int i = 1;
        while (i <= scaleSegments) {
            double xi = x - scaleBarWidth * (double)i;
            gc.setFill((Paint)(i % 2 == 0 ? Color.WHITE : Color.DARKGRAY));
            gc.fillRect(xi, y, scaleBarWidth, scaleBarHeight);
            gc.strokeRect(xi, y, scaleBarWidth, scaleBarHeight);
            ++i;
        }
        Object format = "%f %s";
        if (exponent <= -6 || exponent >= 6) {
            format = "%.3e %s";
        } else if (exponent >= 0) {
            format = "%.0f %s";
        } else if (exponent < 0) {
            format = "%." + Math.abs(exponent) + "f %s";
        }
        Text scaleLabel = new Text(String.format(Locale.ENGLISH, (String)format, (double)scaleSegments * ratio * magnitude, this.options.getFormatterOptions().get((Object)CellValueType.LENGTH).getUnit().getAbbreviation()));
        scaleLabel.setFont(gc.getFont());
        double scaleLabelWidth = scaleLabel.getBoundsInLocal().getWidth();
        gc.setTextBaseline(VPos.BASELINE);
        gc.setTextAlign(TextAlignment.LEFT);
        gc.setFill((Paint)Color.BLACK);
        gc.fillText("0", x - scaleBarWidth * (double)scaleSegments, y - scaleBarHeight);
        gc.fillText(scaleLabel.getText(), x - scaleLabelWidth, y - scaleBarHeight);
    }

    public void setToolbarType(ToolbarType toolbarType) {
        this.toolbarType = toolbarType;
    }

    public ToolbarType getToolbarType() {
        return this.toolbarType;
    }

    private void setCurrentCoordinate(PixelCoordinate coordinate) {
        WorldCoordinate worldCoordinate = GraphicExtent.toWorldCoordinate(coordinate, this.getCurrentGraphicExtent());
        if (Double.isNaN(worldCoordinate.getX()) || Double.isNaN(worldCoordinate.getY())) {
            this.coordinatePanel.setText(null);
        } else {
            String x = this.options.toLengthFormat(worldCoordinate.getX(), true);
            String y = this.options.toLengthFormat(worldCoordinate.getY(), true);
            this.coordinatePanel.setText(String.format("[y = %s / x = %s]", x, y));
        }
    }

    public ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public Color getColor() {
        return (Color)this.colorProperty().get();
    }

    public void setColor(Color color) {
        this.colorProperty().set((Object)color);
    }

    public DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public double getLineWidth() {
        return this.lineWidthProperty().get();
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidthProperty().set(lineWidth);
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        if (evt.getEventType() == FormatterEventType.UNIT_CHANGED && evt.getCellType() == CellValueType.LENGTH) {
            this.draw();
        }
    }

    private class RubberbandingAndPanEventHandler
    implements EventHandler<MouseEvent> {
        private double xStart = -1.0;
        private double yStart = -1.0;
        private double xEnd = 0.0;
        private double yEnd = 0.0;

        private RubberbandingAndPanEventHandler() {
        }

        public void handle(MouseEvent event) {
            MouseButton mouseButton = event.getButton();
            this.xEnd = event.getX();
            this.yEnd = event.getY();
            MouseNavigationCanvas.this.setCurrentCoordinate(new PixelCoordinate(this.xEnd, this.yEnd));
            if (MouseNavigationCanvas.this.toolbarType == null || MouseNavigationCanvas.this.toolbarType == ToolbarType.NONE) {
                return;
            }
            if (mouseButton == MouseButton.PRIMARY && event.getClickCount() >= 2) {
                MouseNavigationCanvas.this.layerManager.expand();
            } else if (MouseNavigationCanvas.this.toolbarType == ToolbarType.WINDOW_ZOOM && event.getEventType() == MouseEvent.MOUSE_DRAGGED && mouseButton == MouseButton.PRIMARY && event.isPrimaryButtonDown() && this.xStart >= 0.0 && this.yStart >= 0.0) {
                MouseNavigationCanvas.this.drawRect(Math.min(this.xStart, this.xEnd), Math.min(this.yStart, this.yEnd), Math.abs(this.xStart - this.xEnd), Math.abs(this.yStart - this.yEnd));
            } else if ((mouseButton == MouseButton.SECONDARY || MouseNavigationCanvas.this.toolbarType == ToolbarType.MOVE) && event.getEventType() == MouseEvent.MOUSE_DRAGGED && this.xStart >= 0.0 && this.yStart >= 0.0) {
                GraphicExtent currentExtent = MouseNavigationCanvas.this.getCurrentGraphicExtent();
                WorldCoordinate startWorldCoordinate = GraphicExtent.toWorldCoordinate(new PixelCoordinate(this.xStart, this.yStart), MouseNavigationCanvas.this.getCurrentGraphicExtent());
                WorldCoordinate endWorldCoordinate = GraphicExtent.toWorldCoordinate(new PixelCoordinate(this.xEnd, this.yEnd), MouseNavigationCanvas.this.getCurrentGraphicExtent());
                double startX = startWorldCoordinate.getX();
                double startY = startWorldCoordinate.getY();
                double endX = endWorldCoordinate.getX();
                double endY = endWorldCoordinate.getY();
                double minX = currentExtent.getMinX();
                double minY = currentExtent.getMinY();
                double maxX = currentExtent.getMaxX();
                double maxY = currentExtent.getMaxY();
                currentExtent.set(minX - (endX - startX), minY - (endY - startY), maxX - (endX - startX), maxY - (endY - startY));
                MouseNavigationCanvas.this.layerManager.draw();
                this.xStart = event.getX();
                this.yStart = event.getY();
            } else if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                this.xStart = event.getX();
                this.yStart = event.getY();
            } else if (mouseButton == MouseButton.PRIMARY && event.getEventType() == MouseEvent.MOUSE_RELEASED && this.xStart >= 0.0 && this.yStart >= 0.0) {
                if (MouseNavigationCanvas.this.toolbarType == ToolbarType.WINDOW_ZOOM && this.xStart != this.xEnd && this.yStart != this.yEnd) {
                    WorldCoordinate startWorldCoord = GraphicExtent.toWorldCoordinate(new PixelCoordinate(this.xStart, this.yStart), MouseNavigationCanvas.this.getCurrentGraphicExtent());
                    WorldCoordinate endWorldCoord = GraphicExtent.toWorldCoordinate(new PixelCoordinate(this.xEnd, this.yEnd), MouseNavigationCanvas.this.getCurrentGraphicExtent());
                    MouseNavigationCanvas.this.getCurrentGraphicExtent().set(startWorldCoord, endWorldCoord);
                }
                MouseNavigationCanvas.this.layerManager.draw();
                this.xStart = -1.0;
                this.yStart = -1.0;
            }
        }
    }

    private class ScrollEventHandler
    implements EventHandler<ScrollEvent> {
        private ScrollEventHandler() {
        }

        public void handle(ScrollEvent event) {
            double x = event.getX();
            double y = event.getY();
            GraphicExtent graphicExtent = MouseNavigationCanvas.this.getCurrentGraphicExtent();
            WorldCoordinate mouseWorldCoord = GraphicExtent.toWorldCoordinate(new PixelCoordinate(x, y), MouseNavigationCanvas.this.getCurrentGraphicExtent());
            double mouseX = mouseWorldCoord.getX();
            double mouseY = mouseWorldCoord.getY();
            double minX = graphicExtent.getMinX();
            double maxX = graphicExtent.getMaxX();
            double minY = graphicExtent.getMinY();
            double maxY = graphicExtent.getMaxY();
            double extentWidth = graphicExtent.getExtentWidth();
            double extentHeight = graphicExtent.getExtentHeight();
            double fxMin = Math.abs(minX - mouseX) / extentWidth;
            double fxMax = Math.abs(maxX - mouseX) / extentWidth;
            double fyMin = Math.abs(minY - mouseY) / extentHeight;
            double fyMax = Math.abs(maxY - mouseY) / extentHeight;
            if (event.getDeltaY() < 0.0) {
                extentWidth *= 1.15;
                extentHeight *= 1.15;
            } else if (event.getDeltaY() > 0.0) {
                extentWidth /= 1.15;
                extentHeight /= 1.15;
            } else {
                return;
            }
            double newMinX = mouseX - fxMin * extentWidth;
            double newMaxX = mouseX + fxMax * extentWidth;
            double newMinY = mouseY - fyMin * extentHeight;
            double newMaxY = mouseY + fyMax * extentHeight;
            MouseNavigationCanvas.this.getCurrentGraphicExtent().set(newMinX, newMinY, newMaxX, newMaxY);
            MouseNavigationCanvas.this.layerManager.draw();
        }
    }
}

