/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.ArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.FontLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.LegendPositionType;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;

public class LegendLayer
extends Layer
implements FontLayer {
    private ObservableList<Layer> layers;
    private DoubleProperty fontSize = new SimpleDoubleProperty(10.0);
    private StringProperty fontFamily = new SimpleStringProperty(Font.getDefault().getFamily());
    private ObjectProperty<Color> fontColor = new SimpleObjectProperty((Object)Color.SLATEGREY);
    private ObjectProperty<Color> fontBackgroundColor = new SimpleObjectProperty((Object)Color.rgb((int)255, (int)255, (int)255, (double)0.9));
    private ObjectProperty<LegendPositionType> legendPositionType = new SimpleObjectProperty((Object)LegendPositionType.NORTH_EAST);

    LegendLayer(LayerType layerType, ObservableList<Layer> layers) {
        super(layerType);
        LegendPositionType legendPositionType;
        Color symbolColor;
        Color fontColor;
        if (layerType != LayerType.LEGEND) {
            throw new IllegalArgumentException("Error, unsupported layer type " + String.valueOf((Object)layerType));
        }
        this.layers = layers;
        String fontFamily = null;
        double lineWidth = -1.0;
        double fontSize = -1.0;
        boolean visible = Boolean.TRUE;
        fontFamily = PROPERTIES.getProperty("LEGEND_FONT_FAMILY", "System");
        try {
            fontColor = Color.web((String)PROPERTIES.getProperty("LEGEND_FONT_COLOR", "#2F4F4F"));
        }
        catch (Exception e) {
            fontColor = Color.web((String)"#2F4F4F");
        }
        try {
            symbolColor = Color.web((String)PROPERTIES.getProperty("LEGEND_FONT_COLOR", "#778899"));
        }
        catch (Exception e) {
            symbolColor = Color.web((String)"#778899");
        }
        try {
            legendPositionType = LegendPositionType.valueOf(PROPERTIES.getProperty("LEGEND_POSITION", "NORTH_EAST"));
        }
        catch (Exception e) {
            legendPositionType = LegendPositionType.NORTH_EAST;
        }
        try {
            visible = PROPERTIES.getProperty("LEGEND_VISIBLE").equalsIgnoreCase("TRUE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fontSize = Double.parseDouble(PROPERTIES.getProperty("LEGEND_FONT_SIZE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lineWidth = Double.parseDouble(PROPERTIES.getProperty("LEGEND_LINE_WIDTH"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        lineWidth = lineWidth >= 0.0 ? lineWidth : 0.25;
        fontSize = fontSize >= 0.0 ? fontSize : 12.0;
        fontFamily = fontFamily != null ? fontFamily : "System";
        this.setColor(symbolColor);
        this.setLineWidth(lineWidth);
        this.setLegendPositionType(legendPositionType);
        this.setFontSize(fontSize);
        this.setFontFamily(fontFamily);
        this.setFontColor(fontColor);
        this.setVisible(visible);
    }

    @Override
    public void draw(GraphicsContext graphicsContext, GraphicExtent graphicExtent) {
        Color fontColor = this.getFontColor();
        String fontFamily = this.getFontFamily();
        double fontSize = this.getFontSize();
        double lineWidth = this.getLineWidth();
        Color lineColor = this.getColor();
        Color fontBackgroundColor = this.getFontBackgroundColor();
        Font font = Font.font((String)fontFamily, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        double sketchWidth = graphicExtent.getDrawingBoardWidth();
        double sketchHeight = graphicExtent.getDrawingBoardHeight();
        double xMargin = 10.0;
        double yMargin = 10.0;
        double xPadding = 5.0;
        double yPadding = 5.0;
        int cnt = 0;
        double textColumnWidth = 0.0;
        double symbolColumnWidth = 2.0999999999999996 * fontSize;
        double textHeight = 0.0;
        ArrayList<Layer> legendLayers = new ArrayList<Layer>(this.layers.size());
        for (Layer layer : this.layers) {
            if (layer == this || layer.getLayerType() == LayerType.LEGEND || !layer.isVisible() || !layer.hasContent()) continue;
            legendLayers.add(layer);
            double[] textSize = this.getTextSize(font, layer.toString());
            textColumnWidth = Math.max(textColumnWidth, textSize[0]);
            textHeight = Math.max(textHeight, textSize[1]);
            ++cnt;
        }
        double legendHeight = (double)cnt * (textHeight += 3.0) + 2.0 * yPadding;
        double legendWidth = textColumnWidth + symbolColumnWidth + 3.0 * xPadding;
        if (cnt == 0 || legendWidth + xMargin > sketchWidth || legendHeight + yMargin > sketchHeight) {
            return;
        }
        graphicsContext.setLineCap(StrokeLineCap.BUTT);
        graphicsContext.setLineDashes(null);
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setStroke((Paint)fontBackgroundColor);
        graphicsContext.setFill((Paint)fontBackgroundColor);
        PixelCoordinate leftCorner = this.getLeftUpperCorner(graphicExtent, legendWidth, legendHeight, xMargin, yMargin);
        double xLeftUpperCorner = leftCorner.getX();
        double yLeftUpperCorner = leftCorner.getY();
        graphicsContext.fillRoundRect(xLeftUpperCorner, yLeftUpperCorner, legendWidth, legendHeight, 5.0, 5.0);
        graphicsContext.setStroke((Paint)lineColor);
        graphicsContext.setFill((Paint)lineColor);
        graphicsContext.strokeRoundRect(xLeftUpperCorner, yLeftUpperCorner, legendWidth, legendHeight, 5.0, 5.0);
        double x = sketchWidth - legendWidth;
        double y = yLeftUpperCorner + textHeight;
        int length = legendLayers.size();
        int i = length - 1;
        while (i >= 0) {
            Layer layer = (Layer)legendLayers.get(i);
            x = xLeftUpperCorner + xPadding;
            layer.drawLegendSymbol(graphicsContext, graphicExtent, new PixelCoordinate(x, y - 0.3 * textHeight), 0.7 * fontSize, symbolColumnWidth);
            x += symbolColumnWidth + xPadding;
            graphicsContext.setStroke((Paint)fontColor);
            graphicsContext.setFill((Paint)fontColor);
            graphicsContext.setFont(font);
            graphicsContext.setTextBaseline(VPos.BASELINE);
            graphicsContext.setTextAlign(TextAlignment.LEFT);
            graphicsContext.fillText(layer.toString(), x, y);
            y += textHeight;
            --i;
        }
    }

    private PixelCoordinate getLeftUpperCorner(GraphicExtent graphicExtent, double legendWidth, double legendHeight, double xMargin, double yMargin) {
        double sketchWidth = graphicExtent.getDrawingBoardWidth();
        double sketchHeight = graphicExtent.getDrawingBoardHeight();
        double xLeftUpperCorner = 0.0;
        double yLeftUpperCorner = 0.0;
        switch ((LegendPositionType)((Object)this.legendPositionType.get())) {
            case NORTH: {
                xLeftUpperCorner = 0.5 * (sketchWidth - legendWidth);
                yLeftUpperCorner = yMargin;
                break;
            }
            case SOUTH: {
                xLeftUpperCorner = 0.5 * sketchWidth - 0.5 * legendWidth;
                yLeftUpperCorner = sketchHeight - (legendHeight + 5.0 * yMargin);
                break;
            }
            case EAST: {
                xLeftUpperCorner = sketchWidth - (legendWidth + xMargin);
                yLeftUpperCorner = 0.5 * (sketchHeight - legendHeight);
                break;
            }
            case WEST: {
                xLeftUpperCorner = xMargin;
                yLeftUpperCorner = 0.5 * (sketchHeight - legendHeight);
                break;
            }
            case NORTH_EAST: {
                xLeftUpperCorner = sketchWidth - (legendWidth + xMargin);
                yLeftUpperCorner = yMargin;
                break;
            }
            case NORTH_WEST: {
                xLeftUpperCorner = xMargin;
                yLeftUpperCorner = yMargin;
                break;
            }
            case SOUTH_EAST: {
                xLeftUpperCorner = sketchWidth - (legendWidth + xMargin);
                yLeftUpperCorner = sketchHeight - (legendHeight + 5.0 * yMargin);
                break;
            }
            case SOUTH_WEST: {
                xLeftUpperCorner = xMargin;
                yLeftUpperCorner = sketchHeight - (legendHeight + 5.0 * yMargin);
            }
        }
        return new PixelCoordinate(xLeftUpperCorner, yLeftUpperCorner);
    }

    @Override
    public GraphicExtent getMaximumGraphicExtent() {
        return new GraphicExtent();
    }

    @Override
    public void clearLayer() {
    }

    @Override
    public boolean hasContent() {
        for (Layer layer : this.layers) {
            if (layer == this || !layer.isVisible() || !layer.hasContent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void drawLegendSymbol(GraphicsContext graphicsContext, GraphicExtent graphicExtent, PixelCoordinate pixelCoordinate, double symbolHeight, double symbolWidth) {
    }

    private double[] getTextSize(Font font, String str) {
        Text text = new Text(str);
        text.setFont(font);
        text.setWrappingWidth(0.0);
        text.setLineSpacing(0.0);
        Bounds textBounds = text.getBoundsInLocal();
        Rectangle stencil = new Rectangle(textBounds.getMinX(), textBounds.getMinY(), textBounds.getWidth(), textBounds.getHeight());
        Shape intersection = Shape.intersect((Shape)text, (Shape)stencil);
        textBounds = intersection.getBoundsInLocal();
        return new double[]{textBounds.getWidth(), textBounds.getHeight()};
    }

    public final ObjectProperty<LegendPositionType> legendPositionTypeProperty() {
        return this.legendPositionType;
    }

    public final LegendPositionType getLegendPositionType() {
        return (LegendPositionType)((Object)this.legendPositionTypeProperty().get());
    }

    public final void setLegendPositionType(LegendPositionType legendPositionType) {
        this.legendPositionTypeProperty().set((Object)legendPositionType);
    }

    @Override
    public final ObjectProperty<Color> fontColorProperty() {
        return this.fontColor;
    }

    @Override
    public final Color getFontColor() {
        return (Color)this.fontColorProperty().get();
    }

    @Override
    public final void setFontColor(Color textColor) {
        this.fontColorProperty().set((Object)textColor);
    }

    @Override
    public final ObjectProperty<Color> fontBackgroundColorProperty() {
        return this.fontBackgroundColor;
    }

    @Override
    public final Color getFontBackgroundColor() {
        return (Color)this.fontBackgroundColorProperty().get();
    }

    @Override
    public final void setFontBackgroundColor(Color fontBackgroundColor) {
        this.fontBackgroundColorProperty().set((Object)fontBackgroundColor);
    }

    @Override
    public final DoubleProperty fontSizeProperty() {
        return this.fontSize;
    }

    @Override
    public final double getFontSize() {
        return this.fontSizeProperty().get();
    }

    @Override
    public final void setFontSize(double fontSize) {
        this.fontSizeProperty().set(fontSize);
    }

    @Override
    public StringProperty fontFamilyProperty() {
        return this.fontFamily;
    }

    @Override
    public String getFontFamily() {
        return (String)this.fontFamilyProperty().get();
    }

    @Override
    public void setFontFamily(String fontFamily) {
        this.fontFamilyProperty().set((Object)fontFamily);
    }

    public String toString() {
        return this.i18n.getString("LegendLayer.type", "Legende");
    }
}

