/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Transform;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javax.imageio.ImageIO;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateChangeListener;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateEvent;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.JAG3D;
import org.applied_geodesy.jag3d.ui.graphic.layer.AbsoluteConfidenceLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.ArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.LegendLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.MouseNavigationCanvas;
import org.applied_geodesy.jag3d.ui.graphic.layer.ObservationLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointResidualArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointShiftArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.PrincipalComponentArrowLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.RelativeConfidenceLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.ResizableCanvas;
import org.applied_geodesy.jag3d.ui.graphic.layer.ToolbarType;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.FeatureZoomDialog;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.LayerManagerDialog;
import org.applied_geodesy.jag3d.ui.graphic.sql.SQLGraphicManager;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.io.DefaultFileChooser;
import org.applied_geodesy.util.ImageUtils;

public class LayerManager {
    private Label coordinatePanel = new Label();
    private I18N i18n = I18N.getInstance();
    private ToolBar layerToolbar = new ToolBar();
    private final GraphicExtent currentGraphicExtent = new GraphicExtent();
    private final ResizableCanvas resizableGraphicCanvas = new ResizableCanvas(this.currentGraphicExtent);
    private ObservableList<Layer> layers = this.resizableGraphicCanvas.getLayers();
    private StackPane stackPane = new StackPane();
    private final MouseNavigationCanvas mouseNavigationCanvas = new MouseNavigationCanvas(this);
    private VisiblePropertyChangeListener visibleChangeListener = new VisiblePropertyChangeListener();
    private boolean ignoreChangeEvent = false;
    public static double DEFAULT_ELLIPSE_SCALE = 5000.0;
    private Spinner<Double> scaleSpinner;

    public LayerManager() {
        this.init();
    }

    private void init() {
        this.initPane();
        this.initToolBar();
        this.initCoordinateLabel();
        this.initLayers();
        this.currentGraphicExtent.drawingBoardWidthProperty().bind((ObservableValue)this.stackPane.widthProperty());
        this.currentGraphicExtent.drawingBoardHeightProperty().bind((ObservableValue)this.stackPane.heightProperty());
        GraphicExtentChangeListener graphicExtentChangeListener = new GraphicExtentChangeListener();
        this.currentGraphicExtent.extendedProperty().addListener((ChangeListener)graphicExtentChangeListener);
        SQLManager.getInstance().addProjectDatabaseStateChangeListener(new DatabaseStateChangeListener());
    }

    private void initLayers() {
        LayerType[] layerTypes;
        LayerType[] layerTypeArray = layerTypes = LayerType.values();
        int n = layerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            LayerType layerType = layerTypeArray[n2];
            Layer layer = null;
            switch (layerType) {
                case REFERENCE_POINT_APRIORI: 
                case STOCHASTIC_POINT_APRIORI: 
                case DATUM_POINT_APRIORI: 
                case NEW_POINT_APRIORI: 
                case REFERENCE_POINT_APOSTERIORI: 
                case STOCHASTIC_POINT_APOSTERIORI: 
                case DATUM_POINT_APOSTERIORI: 
                case NEW_POINT_APOSTERIORI: {
                    layer = new PointLayer(layerType);
                    break;
                }
                case OBSERVATION_APRIORI: 
                case OBSERVATION_APOSTERIORI: {
                    layer = new ObservationLayer(layerType);
                    break;
                }
                case PRINCIPAL_COMPONENT_VERTICAL: 
                case PRINCIPAL_COMPONENT_HORIZONTAL: {
                    layer = new PrincipalComponentArrowLayer(layerType);
                    break;
                }
                case POINT_RESIDUAL_VERTICAL: 
                case POINT_RESIDUAL_HORIZONTAL: {
                    layer = new PointResidualArrowLayer(layerType);
                    break;
                }
                case POINT_SHIFT_VERTICAL: 
                case POINT_SHIFT_HORIZONTAL: {
                    layer = new PointShiftArrowLayer(layerType);
                    break;
                }
                case ABSOLUTE_CONFIDENCE: {
                    layer = new AbsoluteConfidenceLayer(layerType);
                    break;
                }
                case RELATIVE_CONFIDENCE: {
                    layer = new RelativeConfidenceLayer(layerType);
                    break;
                }
                case LEGEND: {
                    layer = new LegendLayer(layerType, this.layers);
                }
            }
            if (layer != null) {
                this.add(layer);
            }
            ++n2;
        }
        AbsoluteConfidenceLayer absoluteConfidenceLayer = (AbsoluteConfidenceLayer)this.getLayer(LayerType.ABSOLUTE_CONFIDENCE);
        absoluteConfidenceLayer.addAll((PointLayer)this.getLayer(LayerType.STOCHASTIC_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.DATUM_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.NEW_POINT_APOSTERIORI));
        PrincipalComponentArrowLayer principalComponentHorizontalArrowLayer = (PrincipalComponentArrowLayer)this.getLayer(LayerType.PRINCIPAL_COMPONENT_HORIZONTAL);
        principalComponentHorizontalArrowLayer.addAll((PointLayer)this.getLayer(LayerType.STOCHASTIC_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.DATUM_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.NEW_POINT_APOSTERIORI));
        PrincipalComponentArrowLayer principalComponentVerticalArrowLayer = (PrincipalComponentArrowLayer)this.getLayer(LayerType.PRINCIPAL_COMPONENT_VERTICAL);
        principalComponentVerticalArrowLayer.addAll((PointLayer)this.getLayer(LayerType.STOCHASTIC_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.DATUM_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.NEW_POINT_APOSTERIORI));
        PointResidualArrowLayer pointResidualHorizontalArrowLayer = (PointResidualArrowLayer)this.getLayer(LayerType.POINT_RESIDUAL_HORIZONTAL);
        pointResidualHorizontalArrowLayer.addAll((PointLayer)this.getLayer(LayerType.STOCHASTIC_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.DATUM_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.NEW_POINT_APOSTERIORI));
        PointResidualArrowLayer pointResidualVerticalArrowLayer = (PointResidualArrowLayer)this.getLayer(LayerType.POINT_RESIDUAL_VERTICAL);
        pointResidualVerticalArrowLayer.addAll((PointLayer)this.getLayer(LayerType.STOCHASTIC_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.DATUM_POINT_APOSTERIORI), (PointLayer)this.getLayer(LayerType.NEW_POINT_APOSTERIORI));
        PointShiftArrowLayer pointShiftHorizontalArrowLayer = (PointShiftArrowLayer)this.getLayer(LayerType.POINT_SHIFT_HORIZONTAL);
        PointShiftArrowLayer pointShiftVerticalArrowLayer = (PointShiftArrowLayer)this.getLayer(LayerType.POINT_SHIFT_VERTICAL);
        RelativeConfidenceLayer relativeConfidenceLayer = (RelativeConfidenceLayer)this.getLayer(LayerType.RELATIVE_CONFIDENCE);
        relativeConfidenceLayer.add(pointShiftHorizontalArrowLayer);
        relativeConfidenceLayer.add(pointShiftVerticalArrowLayer);
        pointShiftHorizontalArrowLayer.setVectorScale((Double)this.scaleSpinner.getValueFactory().getValue());
        pointShiftVerticalArrowLayer.setVectorScale((Double)this.scaleSpinner.getValueFactory().getValue());
        principalComponentHorizontalArrowLayer.setVectorScale((Double)this.scaleSpinner.getValueFactory().getValue());
        principalComponentVerticalArrowLayer.setVectorScale((Double)this.scaleSpinner.getValueFactory().getValue());
        pointResidualHorizontalArrowLayer.setVectorScale((Double)this.scaleSpinner.getValueFactory().getValue());
        pointResidualVerticalArrowLayer.setVectorScale((Double)this.scaleSpinner.getValueFactory().getValue());
        absoluteConfidenceLayer.setConfidenceScale((Double)this.scaleSpinner.getValueFactory().getValue());
        this.scaleSpinner.valueProperty().addListener((ChangeListener)new ScaleChangeListener(pointShiftHorizontalArrowLayer, pointShiftVerticalArrowLayer, principalComponentHorizontalArrowLayer, principalComponentVerticalArrowLayer, pointResidualHorizontalArrowLayer, pointResidualVerticalArrowLayer, absoluteConfidenceLayer));
        ((ObservationLayer)this.getLayer(LayerType.OBSERVATION_APRIORI)).pointSymbolSizeProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)Bindings.max((ObservableNumberValue)Bindings.max((ObservableNumberValue)this.getLayer(LayerType.REFERENCE_POINT_APRIORI).symbolSizeProperty(), (ObservableNumberValue)this.getLayer(LayerType.STOCHASTIC_POINT_APRIORI).symbolSizeProperty()), (ObservableNumberValue)this.getLayer(LayerType.DATUM_POINT_APRIORI).symbolSizeProperty()), (ObservableNumberValue)this.getLayer(LayerType.NEW_POINT_APRIORI).symbolSizeProperty()));
        ((ObservationLayer)this.getLayer(LayerType.OBSERVATION_APOSTERIORI)).pointSymbolSizeProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)Bindings.max((ObservableNumberValue)Bindings.max((ObservableNumberValue)this.getLayer(LayerType.REFERENCE_POINT_APOSTERIORI).symbolSizeProperty(), (ObservableNumberValue)this.getLayer(LayerType.STOCHASTIC_POINT_APOSTERIORI).symbolSizeProperty()), (ObservableNumberValue)this.getLayer(LayerType.DATUM_POINT_APOSTERIORI).symbolSizeProperty()), (ObservableNumberValue)this.getLayer(LayerType.NEW_POINT_APOSTERIORI).symbolSizeProperty()));
    }

    private void add(Layer layer) {
        this.currentGraphicExtent.merge(layer.getMaximumGraphicExtent());
        layer.visibleProperty().addListener((ChangeListener)this.visibleChangeListener);
        this.layers.add((Object)layer);
    }

    public GraphicExtent getCurrentGraphicExtent() {
        return this.currentGraphicExtent;
    }

    public void clearAllLayers() {
        for (Layer layer : this.layers) {
            layer.clearLayer();
        }
    }

    public Layer getLayer(LayerType layerType) {
        for (Layer layer : this.layers) {
            if (layer.getLayerType() != layerType) continue;
            return layer;
        }
        return null;
    }

    public void draw() {
        this.resizableGraphicCanvas.draw();
        this.mouseNavigationCanvas.draw();
    }

    public void reorderLayer(List<Layer> layers) {
        this.layers.clear();
        for (Layer layer : layers) {
            if (layer == null || layer.getLayerType() == null) continue;
            this.layers.add((Object)layer);
        }
    }

    public Pane getPane() {
        return this.stackPane;
    }

    public ToolBar getToolBar() {
        return this.layerToolbar;
    }

    public Label getCoordinateLabel() {
        return this.coordinatePanel;
    }

    public void setEllipseScale(double scale) {
        this.scaleSpinner.getValueFactory().setValue((Object)scale);
    }

    private void initPane() {
        BackgroundFill fill = new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY);
        Background background = new Background(new BackgroundFill[]{fill});
        this.stackPane.setBackground(background);
        this.stackPane.setMinSize(0.0, 0.0);
        this.stackPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.resizableGraphicCanvas, this.mouseNavigationCanvas});
    }

    private void initCoordinateLabel() {
        this.coordinatePanel.setTextAlignment(TextAlignment.RIGHT);
    }

    private void initToolBar() {
        ToolbarActionEventHandler toolbarActionEventHandler = new ToolbarActionEventHandler();
        ToggleGroup group = new ToggleGroup();
        ToggleButton moveButton = this.createToggleButton("graphic_move_32x32.png", this.i18n.getString("LayerManager.toolbar.button.move.tooltip", "Move graphic"), ToolbarType.MOVE, toolbarActionEventHandler);
        ToggleButton windowZoomButton = this.createToggleButton("graphic_window_zoom_32x32.png", this.i18n.getString("LayerManager.toolbar.button.window_zoom.tooltip", "Window zoom"), ToolbarType.WINDOW_ZOOM, toolbarActionEventHandler);
        Button zoomInButton = this.createButton("graphic_zoom_in_32x32.png", this.i18n.getString("LayerManager.toolbar.button.zoom_in.tooltip", "Zoom in"), ToolbarType.ZOOM_IN, toolbarActionEventHandler);
        Button zoomOutButton = this.createButton("graphic_zoom_out_32x32.png", this.i18n.getString("LayerManager.toolbar.button.zoom_out.tooltip", "Zoom out"), ToolbarType.ZOOM_OUT, toolbarActionEventHandler);
        Button expandButton = this.createButton("graphic_expand_32x32.png", this.i18n.getString("LayerManager.toolbar.button.expand.tooltip", "Expand graphic"), ToolbarType.EXPAND, toolbarActionEventHandler);
        Button redrawButton = this.createButton("graphic_refresh_32x32.png", this.i18n.getString("LayerManager.toolbar.button.refresh.tooltip", "Refresh graphic from database"), ToolbarType.REDRAW, toolbarActionEventHandler);
        Button layerButton = this.createButton("graphic_layer_32x32.png", this.i18n.getString("LayerManager.toolbar.button.layers.tooltip", "Layer properties"), ToolbarType.LAYER_PROPERTIES, toolbarActionEventHandler);
        Button exportButton = this.createButton("graphic_export_32x32.png", this.i18n.getString("LayerManager.toolbar.button.export.tooltip", "Export graphic"), ToolbarType.EXPORT, toolbarActionEventHandler);
        Button featureZoomButton = this.createButton("graphic_feature_zoom_32x32.png", this.i18n.getString("LayerManager.toolbar.button.featurezoom.tooltip", "Zoom to feature"), ToolbarType.FEATURE_ZOOM, toolbarActionEventHandler);
        this.scaleSpinner = this.createDoubleSpinner(1.0, Double.MAX_VALUE, DEFAULT_ELLIPSE_SCALE, 250.0, this.i18n.getString("LayerManager.toolbar.scale.tooltip", "Scale of arrows and confidences"), 0);
        this.scaleSpinner.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label scaleLabel = new Label(" : 1");
        scaleLabel.setGraphic(this.scaleSpinner);
        scaleLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        scaleLabel.setContentDisplay(ContentDisplay.LEFT);
        group.getToggles().addAll((Object[])new Toggle[]{moveButton, windowZoomButton});
        group.selectedToggleProperty().addListener((ChangeListener)new ToggleChangeListener());
        this.layerToolbar.getItems().addAll((Object[])new Node[]{moveButton, windowZoomButton, new Separator(), zoomInButton, zoomOutButton, new Separator(), expandButton, redrawButton, featureZoomButton, exportButton, new Separator(), layerButton, new Separator(), scaleLabel});
        boolean disable = !SQLManager.getInstance().hasDatabase();
        windowZoomButton.setSelected(true);
        this.action(ToolbarType.WINDOW_ZOOM);
        this.layerToolbar.setDisable(disable);
    }

    private void action(ToolbarType type) {
        switch (type) {
            case EXPAND: {
                this.expand();
                break;
            }
            case REDRAW: {
                this.redraw();
                break;
            }
            case ZOOM_IN: {
                this.zoomIn();
                break;
            }
            case ZOOM_OUT: {
                this.zoomOut();
                break;
            }
            case EXPORT: {
                this.saveSnapshot();
                break;
            }
            case LAYER_PROPERTIES: {
                this.layerProperties();
                break;
            }
            case FEATURE_ZOOM: {
                this.featureZoom();
                break;
            }
            case WINDOW_ZOOM: 
            case MOVE: 
            case NONE: {
                this.mouseNavigationCanvas.setToolbarType(type);
            }
        }
    }

    public void redraw() {
        SQLGraphicManager sqlGraphicManager = SQLManager.getInstance().getSQLGraphicManager();
        if (sqlGraphicManager == null) {
            return;
        }
        try {
            try {
                this.ignoreChangeEvent = true;
                sqlGraphicManager.load(this);
                sqlGraphicManager.loadEllipseScale(this);
                if (!sqlGraphicManager.load(this.getCurrentGraphicExtent())) {
                    this.expand();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OptionDialog.showThrowableDialog(LayerManager.this.i18n.getString("LayerManager.message.error.load.exception.title", "Unexpected SQL-Error"), LayerManager.this.i18n.getString("LayerManager.message.error.load.exception.header", "Error, could not create plot from database."), LayerManager.this.i18n.getString("LayerManager.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                    }
                });
                this.ignoreChangeEvent = false;
                this.draw();
            }
        }
        finally {
            this.ignoreChangeEvent = false;
            this.draw();
        }
    }

    public void featureZoom() {
        FeatureZoomDialog.showAndWait(this, this.layers);
    }

    public void layerProperties() {
        LayerManagerDialog.showAndWait(this, this.layers);
    }

    public void expand() {
        GraphicExtent maxGraphicExtent = new GraphicExtent();
        for (Layer layer : this.layers) {
            if (!layer.isVisible()) continue;
            maxGraphicExtent.merge(layer.getMaximumGraphicExtent());
        }
        if (maxGraphicExtent.getMinX() != Double.MAX_VALUE || maxGraphicExtent.getMinY() != Double.MAX_VALUE || maxGraphicExtent.getMaxX() != Double.MIN_VALUE || maxGraphicExtent.getMaxY() != Double.MIN_VALUE) {
            if (maxGraphicExtent.getMinX() == maxGraphicExtent.getMaxX()) {
                maxGraphicExtent.setMinX(maxGraphicExtent.getMinX() - 1.0);
                maxGraphicExtent.setMaxX(maxGraphicExtent.getMaxX() + 1.0);
            }
            if (maxGraphicExtent.getMinY() == maxGraphicExtent.getMaxY()) {
                maxGraphicExtent.setMinY(maxGraphicExtent.getMinY() - 1.0);
                maxGraphicExtent.setMaxY(maxGraphicExtent.getMaxY() + 1.0);
            }
            this.currentGraphicExtent.set(maxGraphicExtent);
            this.zoomOut();
        }
    }

    public void zoomIn() {
        double scale = this.currentGraphicExtent.getScale();
        this.currentGraphicExtent.setScale(scale / 1.15);
        this.draw();
    }

    public void zoomOut() {
        double scale = this.currentGraphicExtent.getScale();
        this.currentGraphicExtent.setScale(scale * 1.15);
        this.draw();
    }

    public void saveSnapshot() {
        double pixelScale = 1.5;
        double width = this.stackPane.getWidth();
        double height = this.stackPane.getHeight();
        if (height > 0.0 && width > 0.0) {
            FileChooser.ExtensionFilter[] extensionFilters = new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.i18n.getString("LayerManager.extension.filled.png", "Portable Network Graphics (PNG)"), new String[]{"*.png"}), new FileChooser.ExtensionFilter(this.i18n.getString("LayerManager.extension.transparent.png", "Transparent Portable Network Graphics (PNG)"), new String[]{"*.png"})};
            File outputFile = DefaultFileChooser.showSaveDialog((Window)JAG3D.getStage(), this.i18n.getString("LayerManager.export.title", "Save current graphic"), null, extensionFilters);
            if (outputFile != null) {
                try {
                    boolean transparentImage = DefaultFileChooser.getSelectedExtensionFilter() == extensionFilters[1];
                    SnapshotParameters snapshotParameters = new SnapshotParameters();
                    snapshotParameters.setFill((Paint)(transparentImage ? Color.TRANSPARENT : null));
                    snapshotParameters.setTransform((Transform)Transform.scale((double)pixelScale, (double)pixelScale));
                    WritableImage writableImage = new WritableImage((int)Math.rint(pixelScale * width), (int)Math.rint(pixelScale * height));
                    this.stackPane.snapshot(snapshotParameters, writableImage);
                    BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)writableImage, null);
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", outputFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OptionDialog.showThrowableDialog(LayerManager.this.i18n.getString("LayerManager.message.error.save.image.exception.title", "Unexpected Error"), LayerManager.this.i18n.getString("LayerManager.message.error.save.image.exception.header", "Error, could not save plot as image."), LayerManager.this.i18n.getString("LayerManager.message.error.save.image.exception.message", "An exception has occurred during image export."), e);
                        }
                    });
                }
            }
        }
    }

    private ToggleButton createToggleButton(String iconName, String tooltip, ToolbarType type, ToolbarActionEventHandler toolbarActionEventHandler) {
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setTooltip(new Tooltip(tooltip));
        try {
            toggleButton.setGraphic((Node)new ImageView(ImageUtils.getImage(iconName)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        toggleButton.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        toggleButton.setUserData((Object)type);
        toggleButton.setOnAction((EventHandler)toolbarActionEventHandler);
        return toggleButton;
    }

    private Button createButton(String iconName, String tooltip, ToolbarType type, ToolbarActionEventHandler toolbarActionEventHandler) {
        Button button = new Button();
        button.setTooltip(new Tooltip(tooltip));
        try {
            button.setGraphic((Node)new ImageView(ImageUtils.getImage(iconName)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        button.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        button.setUserData((Object)type);
        button.setOnAction((EventHandler)toolbarActionEventHandler);
        return button;
    }

    private Spinner<Double> createDoubleSpinner(double min, double max, double initValue, double amountToStepBy, String tooltip, int digits) {
        final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(digits);
        numberFormat.setMinimumFractionDigits(digits);
        numberFormat.setGroupingUsed(false);
        StringConverter<Double> converter = new StringConverter<Double>(){

            public Double fromString(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                try {
                    return numberFormat.parse(s).doubleValue();
                }
                catch (Exception nfe) {
                    nfe.printStackTrace();
                    return null;
                }
            }

            public String toString(Double d) {
                return d == null ? "" : numberFormat.format(d);
            }
        };
        final SpinnerValueFactory.DoubleSpinnerValueFactory doubleFactory = new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max);
        Spinner doubleSpinner = new Spinner();
        doubleSpinner.setEditable(true);
        doubleSpinner.setValueFactory((SpinnerValueFactory)doubleFactory);
        doubleFactory.setConverter((StringConverter)converter);
        doubleFactory.setAmountToStepBy(amountToStepBy);
        TextFormatter formatter = new TextFormatter(doubleFactory.getConverter(), (Object)((Double)doubleFactory.getValue()));
        doubleSpinner.getEditor().setTextFormatter(formatter);
        doubleSpinner.getEditor().setAlignment(Pos.BOTTOM_RIGHT);
        doubleFactory.valueProperty().bindBidirectional((Property)formatter.valueProperty());
        doubleSpinner.setPrefWidth(100.0);
        doubleSpinner.setMaxWidth(Double.MAX_VALUE);
        doubleSpinner.setTooltip(new Tooltip(tooltip));
        doubleFactory.setValue((Object)initValue);
        doubleFactory.valueProperty().addListener((ChangeListener)new ChangeListener<Double>(){

            public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
                if (newValue == null) {
                    doubleFactory.setValue((Object)oldValue);
                }
            }
        });
        return doubleSpinner;
    }

    private void save(double newScale) {
        SQLGraphicManager sqlGraphicManager = SQLManager.getInstance().getSQLGraphicManager();
        if (sqlGraphicManager == null || Double.isNaN(newScale) || Double.isInfinite(newScale)) {
            return;
        }
        try {
            sqlGraphicManager.saveEllipseScale(newScale);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(LayerManager.this.i18n.getString("LayerManager.message.error.save.scale.exception.title", "Unexpected SQL-Error"), LayerManager.this.i18n.getString("LayerManager.message.error.save.scale.exception.header", "Error, could not save scale parameter to database."), LayerManager.this.i18n.getString("LayerManager.message.error.save.scale.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void save(GraphicExtent currentGraphicExtent) {
        SQLGraphicManager sqlGraphicManager = SQLManager.getInstance().getSQLGraphicManager();
        if (Double.isNaN(currentGraphicExtent.getMinX()) || Double.isInfinite(currentGraphicExtent.getMinX()) || Double.isNaN(currentGraphicExtent.getMinY()) || Double.isInfinite(currentGraphicExtent.getMinY()) || Double.isNaN(currentGraphicExtent.getMaxX()) || Double.isInfinite(currentGraphicExtent.getMaxX()) || Double.isNaN(currentGraphicExtent.getMaxY()) || Double.isInfinite(currentGraphicExtent.getMaxY()) || sqlGraphicManager == null) {
            return;
        }
        try {
            sqlGraphicManager.save(currentGraphicExtent);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(LayerManager.this.i18n.getString("LayerManager.message.error.save.extent.exception.title", "Unexpected SQL-Error"), LayerManager.this.i18n.getString("LayerManager.message.error.save.extent.exception.header", "Error, could not save graphic extent to database."), LayerManager.this.i18n.getString("LayerManager.message.error.save.extent.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private class DatabaseStateChangeListener
    implements ProjectDatabaseStateChangeListener {
        private DatabaseStateChangeListener() {
        }

        @Override
        public void projectDatabaseStateChanged(ProjectDatabaseStateEvent evt) {
            if (LayerManager.this.layerToolbar != null) {
                boolean disable = evt.getEventType() != ProjectDatabaseStateType.OPENED;
                LayerManager.this.layerToolbar.setDisable(disable);
                if (evt.getEventType() == ProjectDatabaseStateType.CLOSED) {
                    LayerManager.this.currentGraphicExtent.set(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
                    LayerManager.this.clearAllLayers();
                    LayerManager.this.draw();
                }
            }
        }
    }

    private class GraphicExtentChangeListener
    implements ChangeListener<Boolean> {
        private GraphicExtentChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            LayerManager.this.save(LayerManager.this.currentGraphicExtent);
        }
    }

    private class ScaleChangeListener
    implements ChangeListener<Double> {
        private Layer[] layers;

        ScaleChangeListener(Layer ... layer) {
            this.layers = layer;
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (newValue != null && !Double.isInfinite(newValue) && !Double.isNaN(newValue)) {
                Layer[] layerArray = this.layers;
                int n = this.layers.length;
                int n2 = 0;
                while (n2 < n) {
                    Layer layer = layerArray[n2];
                    if (layer.getLayerType() == LayerType.POINT_SHIFT_HORIZONTAL || layer.getLayerType() == LayerType.POINT_SHIFT_VERTICAL || layer.getLayerType() == LayerType.PRINCIPAL_COMPONENT_HORIZONTAL || layer.getLayerType() == LayerType.PRINCIPAL_COMPONENT_VERTICAL || layer.getLayerType() == LayerType.POINT_RESIDUAL_HORIZONTAL || layer.getLayerType() == LayerType.POINT_RESIDUAL_VERTICAL) {
                        ((ArrowLayer)layer).setVectorScale(newValue);
                    } else if (layer.getLayerType() == LayerType.ABSOLUTE_CONFIDENCE) {
                        ((AbsoluteConfidenceLayer)layer).setConfidenceScale(newValue);
                    }
                    ++n2;
                }
                LayerManager.this.save(newValue);
                if (!LayerManager.this.ignoreChangeEvent) {
                    LayerManager.this.draw();
                }
            }
        }
    }

    private class ToggleChangeListener
    implements ChangeListener<Toggle> {
        private ToggleChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
            if (newValue == null && oldValue != null) {
                oldValue.setSelected(true);
            }
        }
    }

    private class ToolbarActionEventHandler
    implements EventHandler<ActionEvent> {
        private ToolbarActionEventHandler() {
        }

        public void handle(ActionEvent event) {
            ToolbarType type = ToolbarType.NONE;
            if (event.getSource() instanceof Button && ((Button)event.getSource()).getUserData() instanceof ToolbarType) {
                Button button = (Button)event.getSource();
                type = (ToolbarType)((Object)button.getUserData());
            } else if (event.getSource() instanceof ToggleButton && ((ToggleButton)event.getSource()).getUserData() instanceof ToolbarType) {
                ToggleButton button = (ToggleButton)event.getSource();
                type = button.isSelected() ? (ToolbarType)((Object)button.getUserData()) : ToolbarType.NONE;
            } else {
                return;
            }
            LayerManager.this.action(type);
        }
    }

    private class VisiblePropertyChangeListener
    implements ChangeListener<Boolean> {
        private VisiblePropertyChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (!LayerManager.this.ignoreChangeEvent) {
                LayerManager.this.draw();
            }
        }
    }
}

