/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.io.BufferedInputStream;
import java.util.Properties;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.IdentifiableLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public abstract class Layer
implements IdentifiableLayer {
    static final Properties PROPERTIES = new Properties();
    private final LayerType layerType;
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.DARKBLUE);
    private DoubleProperty lineWidth = new SimpleDoubleProperty(1.0);
    private DoubleProperty symbolSize = new SimpleDoubleProperty(12.0);
    private BooleanProperty visible = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
    I18N i18n = I18N.getInstance();

    static {
        BufferedInputStream bis = null;
        String path = "properties/layers.default";
        try {
            try {
                if (Layer.class.getClassLoader().getResourceAsStream("properties/layers.default") != null) {
                    bis = new BufferedInputStream(Layer.class.getClassLoader().getResourceAsStream("properties/layers.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    Layer(LayerType layerType) {
        this.layerType = layerType;
    }

    public abstract void draw(GraphicsContext var1, GraphicExtent var2);

    public abstract GraphicExtent getMaximumGraphicExtent();

    public abstract void clearLayer();

    public abstract void drawLegendSymbol(GraphicsContext var1, GraphicExtent var2, PixelCoordinate var3, double var4, double var6);

    public boolean hasContent() {
        return this.getMaximumGraphicExtent() != null && this.getMaximumGraphicExtent().getExtentHeight() > 0.0 && this.getMaximumGraphicExtent().getExtentWidth() > 0.0 && !Double.isInfinite(this.getMaximumGraphicExtent().getExtentHeight()) && !Double.isInfinite(this.getMaximumGraphicExtent().getExtentWidth()) && !Double.isNaN(this.getMaximumGraphicExtent().getExtentHeight()) && !Double.isNaN(this.getMaximumGraphicExtent().getExtentWidth());
    }

    @Override
    public LayerType getLayerType() {
        return this.layerType;
    }

    public ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public Color getColor() {
        return (Color)this.colorProperty().get();
    }

    public void setColor(Color color) {
        this.colorProperty().set((Object)color);
    }

    public DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public double getLineWidth() {
        return this.lineWidthProperty().get();
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidthProperty().set(lineWidth);
    }

    public final DoubleProperty symbolSizeProperty() {
        return this.symbolSize;
    }

    public final double getSymbolSize() {
        return this.symbolSizeProperty().get();
    }

    public final void setSymbolSize(double symbolSize) {
        this.symbolSizeProperty().set(symbolSize);
    }

    public boolean contains(GraphicExtent graphicExtent, PixelCoordinate pixelCoordinate) {
        return pixelCoordinate.getX() >= 0.0 && pixelCoordinate.getX() <= graphicExtent.getDrawingBoardWidth() && pixelCoordinate.getY() >= 0.0 && pixelCoordinate.getY() <= graphicExtent.getDrawingBoardHeight();
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    public final boolean isVisible() {
        return this.visibleProperty().get();
    }

    public final void setVisible(boolean visible) {
        this.visibleProperty().set(visible);
    }
}

