/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.Layer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;

public abstract class ConfidenceLayer<T extends Layer>
extends Layer {
    private ObjectProperty<Color> strokeColor = new SimpleObjectProperty((Object)Color.BLACK);
    private List<T> referenceLayers = FXCollections.observableArrayList();
    private DoubleProperty confidenceLevel = null;

    ConfidenceLayer(LayerType layerType) {
        super(layerType);
        this.setSymbolSize(0.0);
        this.setLineWidth(0.5);
    }

    public void add(T layer) {
        this.referenceLayers.add(layer);
    }

    public void addAll(List<T> layers) {
        for (Layer layer : layers) {
            this.add(layer);
        }
    }

    List<T> getReferenceLayers() {
        return this.referenceLayers;
    }

    public ObjectProperty<Color> strokeColorProperty() {
        return this.strokeColor;
    }

    public Color getStrokeColor() {
        return (Color)this.strokeColorProperty().get();
    }

    public void setStrokeColor(Color borderColor) {
        this.strokeColorProperty().set((Object)borderColor);
    }

    public DoubleProperty confidenceLevelProperty() {
        if (this.confidenceLevel == null) {
            this.confidenceLevel = new SimpleDoubleProperty(DefaultValue.getConfidenceLevel());
        }
        return this.confidenceLevel;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevelProperty().get();
    }

    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevelProperty().set(confidenceLevel);
    }

    @Override
    public void clearLayer() {
    }

    @Override
    public GraphicExtent getMaximumGraphicExtent() {
        GraphicExtent extent = new GraphicExtent();
        extent.reset();
        return extent;
    }

    @Override
    public void drawLegendSymbol(GraphicsContext graphicsContext, GraphicExtent graphicExtent, PixelCoordinate pixelCoordinate, double symbolHeight, double symbolWidth) {
        if (this.contains(graphicExtent, pixelCoordinate) && Math.min(symbolHeight, symbolWidth) > 0.0) {
            double lineWidth = this.getLineWidth();
            double symbolSize = symbolHeight;
            graphicsContext.setLineWidth(lineWidth);
            graphicsContext.setStroke((Paint)this.getStrokeColor());
            graphicsContext.setFill((Paint)this.getColor());
            graphicsContext.setLineDashes(null);
            double majorAxis = 0.75 * symbolSize;
            double minorAxis = 0.7 * majorAxis;
            double angle = 0.0;
            SymbolBuilder.drawEllipse(graphicsContext, new PixelCoordinate(pixelCoordinate.getX() + 0.5 * symbolWidth, pixelCoordinate.getY()), majorAxis, minorAxis, angle);
        }
    }
}

