/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic.layer;

import java.util.List;
import java.util.Locale;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.applied_geodesy.jag3d.ui.graphic.coordinate.PixelCoordinate;
import org.applied_geodesy.jag3d.ui.graphic.layer.ConfidenceLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.graphic.layer.PointLayer;
import org.applied_geodesy.jag3d.ui.graphic.layer.symbol.SymbolBuilder;
import org.applied_geodesy.jag3d.ui.graphic.sql.GraphicPoint;
import org.applied_geodesy.jag3d.ui.graphic.util.GraphicExtent;
import org.applied_geodesy.util.FormatterOptions;

public class AbsoluteConfidenceLayer
extends ConfidenceLayer<PointLayer> {
    private DoubleProperty confidenceScale = null;
    private FormatterOptions options = FormatterOptions.getInstance();

    AbsoluteConfidenceLayer(LayerType layerType) {
        super(layerType);
        Color strokeColor;
        Color fillColor;
        double lineWidth = -1.0;
        boolean visible = Boolean.TRUE;
        try {
            fillColor = Color.web((String)PROPERTIES.getProperty("ABSOLUTE_CONFIDENCE_FILL_COLOR", "#cccccc"));
        }
        catch (Exception e) {
            fillColor = Color.web((String)"#cccccc");
        }
        try {
            strokeColor = Color.web((String)PROPERTIES.getProperty("ABSOLUTE_CONFIDENCE_STROKE_COLOR", "#000000"));
        }
        catch (Exception e) {
            strokeColor = Color.web((String)"#000000");
        }
        try {
            visible = PROPERTIES.getProperty("ABSOLUTE_CONFIDENCE_VISIBLE").equalsIgnoreCase("TRUE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            lineWidth = Double.parseDouble(PROPERTIES.getProperty("ABSOLUTE_CONFIDENCE_LINE_WIDTH"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        lineWidth = lineWidth >= 0.0 ? lineWidth : 0.5;
        this.setStrokeColor(strokeColor);
        this.setColor(fillColor);
        this.setLineWidth(lineWidth);
        this.setVisible(visible);
    }

    @Override
    public void add(PointLayer layer) {
        super.add(layer);
    }

    public void addAll(PointLayer ... layers) {
        PointLayer[] pointLayerArray = layers;
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            PointLayer layer = pointLayerArray[n2];
            this.add(layer);
            ++n2;
        }
    }

    @Override
    public void draw(GraphicsContext graphicsContext, GraphicExtent graphicExtent) {
        if (!this.isVisible() || graphicExtent.getScale() <= 0.0) {
            return;
        }
        List referenceLayers = this.getReferenceLayers();
        double scale = graphicExtent.getScale();
        double ellipseScale = this.getConfidenceScale() / scale;
        double lineWidth = this.getLineWidth();
        graphicsContext.setLineWidth(lineWidth);
        graphicsContext.setStroke((Paint)this.getStrokeColor());
        graphicsContext.setFill((Paint)this.getColor());
        graphicsContext.setLineDashes(null);
        for (PointLayer layer : referenceLayers) {
            if (!layer.isVisible()) continue;
            for (GraphicPoint point : layer.getPoints()) {
                PixelCoordinate pixelCoordinate;
                if (!point.isVisible() || !this.contains(graphicExtent, pixelCoordinate = GraphicExtent.toPixelCoordinate(point.getCoordinate(), graphicExtent)) || !(point.getMajorAxis() > 0.0)) continue;
                double majorAxis = ellipseScale * point.getMajorAxis();
                double minorAxis = ellipseScale * point.getMinorAxis();
                double angle = point.getAngle();
                SymbolBuilder.drawEllipse(graphicsContext, pixelCoordinate, majorAxis, minorAxis, angle);
            }
        }
    }

    public DoubleProperty confidenceScaleProperty() {
        if (this.confidenceScale == null) {
            this.confidenceScale = new SimpleDoubleProperty(1.0);
        }
        return this.confidenceScale;
    }

    public double getConfidenceScale() {
        return this.confidenceScaleProperty().get();
    }

    public void setConfidenceScale(double confidenceScale) {
        this.confidenceScaleProperty().set(confidenceScale);
    }

    public String toString() {
        double confidenceLevel = this.getConfidenceLevel();
        String confidenceLevelLabel = confidenceLevel > 0.0 && confidenceLevel < 1.0 ? this.options.toPercentFormat(this.getConfidenceLevel(), true) : "";
        return String.format(Locale.ENGLISH, this.i18n.getString("AbsoluteConfidenceLayer.type", "Point confidences"), confidenceLevelLabel);
    }

    @Override
    public boolean hasContent() {
        List referenceLayers = this.getReferenceLayers();
        for (PointLayer layer : referenceLayers) {
            if (!layer.isVisible() || !layer.hasContent()) continue;
            for (GraphicPoint point : layer.getPoints()) {
                if (!point.isVisible()) continue;
                return true;
            }
        }
        return false;
    }
}

