/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.graphic;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerManager;

public class UIGraphicPaneBuilder {
    private static UIGraphicPaneBuilder graphicPaneBuilder = new UIGraphicPaneBuilder();
    private BorderPane borderPane = null;
    private final LayerManager layerManager = new LayerManager();

    private UIGraphicPaneBuilder() {
    }

    public static UIGraphicPaneBuilder getInstance() {
        return graphicPaneBuilder;
    }

    public Pane getPane() {
        this.init();
        return this.borderPane;
    }

    private void init() {
        if (this.borderPane != null) {
            return;
        }
        BackgroundFill fill = new BackgroundFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)1.0), CornerRadii.EMPTY, Insets.EMPTY);
        Background background = new Background(new BackgroundFill[]{fill});
        BorderPane plotBackgroundPane = new BorderPane();
        plotBackgroundPane.setMinSize(0.0, 0.0);
        plotBackgroundPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        plotBackgroundPane.setBackground(background);
        plotBackgroundPane.setCenter((Node)this.layerManager.getPane());
        this.borderPane = new BorderPane();
        this.borderPane.setMinSize(0.0, 0.0);
        this.borderPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.borderPane.setTop((Node)this.layerManager.getToolBar());
        this.borderPane.setCenter((Node)plotBackgroundPane);
        Label coordinateLabel = this.layerManager.getCoordinateLabel();
        coordinateLabel.setFont(new Font(10.0));
        coordinateLabel.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Region spacer = new Region();
        HBox hbox = new HBox(10.0);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        hbox.getChildren().addAll((Object[])new Node[]{spacer, coordinateLabel});
        this.borderPane.setBottom((Node)hbox);
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }
}

