/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dnd;

import javafx.scene.control.TreeItem;
import org.applied_geodesy.jag3d.ui.dnd.DnD;
import org.applied_geodesy.jag3d.ui.tree.CongruenceAnalysisTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.PointTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.VerticalDeflectionTreeItemValue;

public class GroupTreeItemDnD
extends DnD {
    private static final long serialVersionUID = 8338527371608133004L;
    private int dimension;
    private int itemIndex;
    private TreeItemType itemType;
    private TreeItemType parentType;

    void setItemType(TreeItemType itemType) {
        this.itemType = itemType;
    }

    public TreeItemType getItemType() {
        return this.itemType;
    }

    void setParentType(TreeItemType parentType) {
        this.parentType = parentType;
    }

    public TreeItemType getParentType() {
        return this.parentType;
    }

    void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    void setIndex(int itemIndex) {
        this.itemIndex = itemIndex;
    }

    public int getIndex() {
        return this.itemIndex;
    }

    public static GroupTreeItemDnD fromTreeItem(TreeItem<TreeItemValue> treeItem) {
        TreeItemValue itemValue = (TreeItemValue)treeItem.getValue();
        if (treeItem.getParent() == null || treeItem.getParent().getValue() == null || itemValue == null) {
            return null;
        }
        TreeItem parent = treeItem.getParent();
        TreeItemType itemType = itemValue.getItemType();
        TreeItemType parentType = ((TreeItemValue)parent.getValue()).getItemType();
        int groupId = -1;
        int dimension = -1;
        if (itemType == null || parentType == null) {
            return null;
        }
        if (TreeItemType.isObservationTypeLeaf(itemType)) {
            groupId = ((ObservationTreeItemValue)itemValue).getGroupId();
            dimension = ((ObservationTreeItemValue)itemValue).getDimension();
        } else if (TreeItemType.isGNSSObservationTypeLeaf(itemType)) {
            groupId = ((ObservationTreeItemValue)itemValue).getGroupId();
            dimension = ((ObservationTreeItemValue)itemValue).getDimension();
        } else if (TreeItemType.isPointTypeLeaf(itemType)) {
            groupId = ((PointTreeItemValue)itemValue).getGroupId();
            dimension = ((PointTreeItemValue)itemValue).getDimension();
        } else if (TreeItemType.isCongruenceAnalysisTypeLeaf(itemType)) {
            groupId = ((CongruenceAnalysisTreeItemValue)itemValue).getGroupId();
            dimension = ((CongruenceAnalysisTreeItemValue)itemValue).getDimension();
        } else if (TreeItemType.isVerticalDeflectionTypeLeaf(itemType)) {
            groupId = ((VerticalDeflectionTreeItemValue)itemValue).getGroupId();
            dimension = ((VerticalDeflectionTreeItemValue)itemValue).getDimension();
        } else {
            return null;
        }
        int itemIndex = treeItem.getParent().getChildren().indexOf(treeItem);
        if (groupId >= 0 && dimension >= 0 && itemIndex >= 0) {
            GroupTreeItemDnD itemDnD = new GroupTreeItemDnD();
            itemDnD.setGroupId(groupId);
            itemDnD.setParentType(parentType);
            itemDnD.setItemType(itemType);
            itemDnD.setDimension(dimension);
            itemDnD.setIndex(itemIndex);
            return itemDnD;
        }
        return null;
    }
}

