/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog.chart;

import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dialog.chart.TerrestrialObservationType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public class UIResidualAnalysisChart {
    private I18N i18n = I18N.getInstance();
    private FormatterOptions options = FormatterOptions.getInstance();
    private static UIResidualAnalysisChart analysisChart = new UIResidualAnalysisChart();
    private Node analysisChartNode;
    private ComboBox<TerrestrialObservationType> terrestrialObservationTypeComboBox;
    private CheckBox gaussianProbabilityDensityFunctionCheckBox;
    private CheckBox kernelDensityEstimationCheckBox;
    private AreaChart<Number, Number> histogramChart;
    private final double X_RANGE_PDF = 3.9;

    private UIResidualAnalysisChart() {
    }

    public static UIResidualAnalysisChart getInstance() {
        analysisChart.init();
        return analysisChart;
    }

    public Node getNode() {
        return this.analysisChartNode;
    }

    private void init() {
        if (this.analysisChartNode != null) {
            return;
        }
        BorderPane borderPane = new BorderPane();
        this.gaussianProbabilityDensityFunctionCheckBox = this.createCheckBox(this.i18n.getString("UIResidualAnalysisChart.histogram.probability_density_function.label", "Gaussian probability density function"), this.i18n.getString("UIResidualAnalysisChart.histogram.probability_density_function.tooltip", "If selected, the probability density function of the standard normal distribution is estimated"));
        this.kernelDensityEstimationCheckBox = this.createCheckBox(this.i18n.getString("UIResidualAnalysisChart.histogram.kernel_density_estimation.label", "Kernel density estimation"), this.i18n.getString("UIResidualAnalysisChart.histogram.kernel_density_estimation.tooltip", "If selected, the probability density function is estimated by a kernel density estimation"));
        this.gaussianProbabilityDensityFunctionCheckBox.setSelected(true);
        this.kernelDensityEstimationCheckBox.setSelected(true);
        HBox cbNode = new HBox(10.0);
        Region regionLeft = new Region();
        Region regionRight = new Region();
        HBox.setHgrow((Node)regionLeft, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)regionRight, (Priority)Priority.ALWAYS);
        cbNode.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        cbNode.getChildren().addAll((Object[])new Node[]{regionLeft, this.gaussianProbabilityDensityFunctionCheckBox, this.kernelDensityEstimationCheckBox, regionRight});
        ProbabilityDensityFunctionChangeListener probabilityDensityFunctionChangeListener = new ProbabilityDensityFunctionChangeListener();
        this.gaussianProbabilityDensityFunctionCheckBox.selectedProperty().addListener((ChangeListener)probabilityDensityFunctionChangeListener);
        this.kernelDensityEstimationCheckBox.selectedProperty().addListener((ChangeListener)probabilityDensityFunctionChangeListener);
        this.terrestrialObservationTypeComboBox = this.createTerrestrialObservationTypeComboBox(TerrestrialObservationType.ALL, this.i18n.getString("UIResidualAnalysisChart.observationtype.terrestrial.tooltip", "Set observational type"));
        Region spacer = new Region();
        HBox hbox = new HBox(10.0);
        hbox.setPadding(new Insets(5.0, 10.0, 5.0, 15.0));
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        hbox.getChildren().addAll((Object[])new Node[]{spacer, this.terrestrialObservationTypeComboBox});
        this.histogramChart = this.createHistogramChart();
        borderPane.setTop((Node)hbox);
        borderPane.setCenter(this.histogramChart);
        borderPane.setBottom((Node)cbNode);
        borderPane.setPrefWidth(500.0);
        this.terrestrialObservationTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new TerrestrialObservationTypeChangeListener());
        this.options.addFormatterChangedListener(new TickFormatChangedListener());
        this.analysisChartNode = borderPane;
    }

    private AreaChart<Number, Number> createHistogramChart() {
        NumberAxis xAxis = new NumberAxis(-5.0, 5.0, 1.0);
        NumberAxis yAxis = new NumberAxis(0.0, 0.45, 0.1);
        xAxis.setLabel(this.i18n.getString("UIResidualAnalysisChart.chart.histogram.axis.x.label", "Normalized residuals"));
        xAxis.setForceZeroInRange(true);
        xAxis.setMinorTickVisible(false);
        xAxis.setAnimated(false);
        xAxis.setAutoRanging(false);
        yAxis.setLabel(this.i18n.getString("UIResidualAnalysisChart.chart.histogram.axis.y.label", "Probability density"));
        yAxis.setForceZeroInRange(true);
        yAxis.setMinorTickVisible(false);
        yAxis.setAnimated(false);
        yAxis.setAutoRanging(false);
        AreaChart areaChart = new AreaChart((Axis)xAxis, (Axis)yAxis);
        areaChart.setLegendVisible(false);
        areaChart.setAnimated(false);
        areaChart.setCreateSymbols(false);
        areaChart.setVerticalZeroLineVisible(false);
        areaChart.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.updateTickLabels((AreaChart<Number, Number>)areaChart);
        return areaChart;
    }

    private void updateTickLabels(AreaChart<Number, Number> areaChart) {
        NumberAxis yAxis = (NumberAxis)areaChart.getYAxis();
        yAxis.setLabel(this.i18n.getString("UIResidualAnalysisChart.chart.histogram.axis.y.label", "Probability density"));
        yAxis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number number) {
                return UIResidualAnalysisChart.this.options.toStatisticFormat(number.doubleValue());
            }

            public Number fromString(String string) {
                return null;
            }
        });
    }

    private ComboBox<TerrestrialObservationType> createTerrestrialObservationTypeComboBox(TerrestrialObservationType item, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        TerrestrialObservationType[] terrestrialObservationTypeArray = TerrestrialObservationType.values();
        typeComboBox.getItems().setAll((Object[])terrestrialObservationTypeArray);
        typeComboBox.getSelectionModel().select((Object)item);
        typeComboBox.setConverter((StringConverter)new StringConverter<TerrestrialObservationType>(){

            public String toString(TerrestrialObservationType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case ALL: {
                        return UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.observationtype.terrestrial.all.label", "All terrestrial observations");
                    }
                    case LEVELING: {
                        return UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.observationtype.terrestrial.leveling.label", "Leveling");
                    }
                    case DIRECTION: {
                        return UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.observationtype.terrestrial.direction.label", "Directions");
                    }
                    case HORIZONTAL_DISTANCE: {
                        return UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.observationtype.terrestrial.horizontal_distance.label", "Horizontal distances");
                    }
                    case SLOPE_DISTANCE: {
                        return UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.observationtype.terrestrial.slope_distance.label", "Slope distances");
                    }
                    case ZENITH_ANGLE: {
                        return UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.observationtype.terrestrial.zenith_angle.label", "Zenith angles");
                    }
                }
                return null;
            }

            public TerrestrialObservationType fromString(String string) {
                return TerrestrialObservationType.valueOf(string);
            }
        });
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinHeight(Double.NEGATIVE_INFINITY);
        checkBox.setMaxHeight(Double.MAX_VALUE);
        return checkBox;
    }

    private void updateChartData(TerrestrialObservationType terrestrialObservationType) {
        try {
            terrestrialObservationType = terrestrialObservationType == null ? TerrestrialObservationType.ALL : terrestrialObservationType;
            ObservationType[] observationTypes = this.getSelectedObservationTypes(terrestrialObservationType);
            List<Double> normalizedResiduals = SQLManager.getInstance().getNormalizedResiduals(observationTypes);
            this.histogramChart.getData().clear();
            if (normalizedResiduals == null || normalizedResiduals.isEmpty()) {
                return;
            }
            Collections.sort(normalizedResiduals);
            int length = normalizedResiduals.size();
            double sampleMean = length > 0 ? this.getMean(normalizedResiduals) : 0.0;
            double sampleVariance = length > 1 ? this.getVariance(normalizedResiduals, sampleMean) : 1.0;
            double xRange = 0.0;
            double yRange = 0.0;
            double[] range = this.plotHistogram(this.histogramChart, normalizedResiduals, sampleMean, sampleVariance);
            xRange = range[0];
            yRange = range[1];
            if (this.gaussianProbabilityDensityFunctionCheckBox.isSelected()) {
                range = this.plotGaussianProbabilityDensityFunction(this.histogramChart, normalizedResiduals, sampleMean, sampleVariance);
                xRange = Math.max(xRange, range[0]);
                yRange = Math.max(yRange, range[1]);
            }
            if (this.kernelDensityEstimationCheckBox.isSelected()) {
                range = this.plotKernelDensityEstimation(this.histogramChart, normalizedResiduals, sampleMean, sampleVariance);
                xRange = Math.max(xRange, range[0]);
                yRange = Math.max(yRange, range[1]);
            }
            xRange = Math.ceil(xRange + 0.05);
            yRange = Math.ceil((yRange + 0.005) * 10.0) / 10.0;
            NumberAxis xAxis = (NumberAxis)this.histogramChart.getXAxis();
            NumberAxis yAxis = (NumberAxis)this.histogramChart.getYAxis();
            xAxis.setLowerBound(-xRange);
            xAxis.setUpperBound(xRange);
            yAxis.setLowerBound(0.0);
            yAxis.setUpperBound(yRange);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.message.error.load.exception.title", "Unexpected SQL-Error"), UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.message.error.load.exception.header", "Error, could not load data from database."), UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private double[] plotHistogram(AreaChart<Number, Number> areaChart, List<Double> data, double sampleMean, double sampleVariance) {
        int length = data.size();
        double binWidth = 0.0;
        double iqr = this.getInterQuartileRange(data);
        double minValue = data.get(0);
        double maxValue = data.get(length - 1);
        int numberOfBins = 0;
        binWidth = iqr > 0.0 || sampleVariance > 0.0 ? (iqr > 0.0 ? 2.0 * iqr * Math.pow(length, -0.3333333333333333) : 2.0 * Math.pow(3.0, 0.3333333333333333) * Math.pow(Math.PI, 0.16666666666666666) * Math.sqrt(sampleVariance) * Math.pow(length, -0.3333333333333333)) : (maxValue - minValue) / (double)Math.round(2.0 * Math.pow(length, 0.3333333333333333));
        numberOfBins = binWidth > 0.0 ? Math.max((int)Math.ceil((maxValue - minValue) / binWidth), 1) : 1;
        int[] bins = new int[numberOfBins];
        int i = 0;
        int j = 0;
        while (i < length) {
            if (data.get(i) <= minValue + (double)(j + 1) * binWidth && j < numberOfBins) {
                int n = j;
                bins[n] = bins[n] + 1;
            } else {
                while (!(data.get(i) <= minValue + (double)(j + 1) * binWidth) || ++j >= numberOfBins) {
                }
                if (j < numberOfBins) {
                    int n = j;
                    bins[n] = bins[n] + 1;
                }
            }
            ++i;
        }
        double yRange = 0.0;
        int i2 = 0;
        while (i2 < bins.length) {
            if (bins[i2] != 0) {
                double width = minValue + (double)i2 * binWidth;
                double pdf = (double)bins[i2] / (double)length / binWidth;
                final XYChart.Series bar = new XYChart.Series();
                bar.getData().add((Object)new XYChart.Data((Object)width, (Object)0));
                bar.getData().add((Object)new XYChart.Data((Object)width, (Object)pdf));
                bar.getData().add((Object)new XYChart.Data((Object)(width + binWidth), (Object)pdf));
                bar.getData().add((Object)new XYChart.Data((Object)(width + binWidth), (Object)0));
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Node area;
                        UIResidualAnalysisChart.this.histogramChart.getData().add((Object)bar);
                        Node line = bar.getNode().lookup(".chart-series-area-line");
                        if (line != null) {
                            line.setStyle("-fx-stroke: rgba(75, 75, 75, 1); -fx-stroke-width: 1.0px;");
                        }
                        if ((area = bar.getNode().lookup(".chart-series-area-fill")) != null) {
                            area.setStyle("-fx-fill: rgba(75, 75, 75, 0.25);");
                        }
                    }
                });
                yRange = Math.max(yRange, pdf);
            }
            ++i2;
        }
        double xRange = Math.max(Math.abs(minValue), Math.abs(maxValue + binWidth));
        xRange = Math.max(xRange, 3.9);
        yRange = Math.max(yRange, this.getStandardGaussian(0.0));
        return new double[]{xRange, yRange};
    }

    private double[] plotGaussianProbabilityDensityFunction(final AreaChart<Number, Number> areaChart, List<Double> data, double sampleMean, double sampleVariance) {
        double xRange = 0.0;
        double yRange = 0.0;
        final XYChart.Series probabilityDensity = new XYChart.Series();
        double x = -3.9;
        while (x <= 3.9) {
            double pdf = this.getStandardGaussian(x);
            probabilityDensity.getData().add((Object)new XYChart.Data((Object)x, (Object)pdf));
            xRange = Math.max(xRange, Math.abs(x));
            yRange = Math.max(yRange, Math.abs(pdf));
            x += 0.01;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Node area;
                areaChart.getData().add((Object)probabilityDensity);
                Node line = probabilityDensity.getNode().lookup(".chart-series-area-line");
                if (line != null) {
                    line.setStyle("-fx-stroke: rgba(200, 0, 0, 1); -fx-stroke-width: 2.5px;");
                }
                if ((area = probabilityDensity.getNode().lookup(".chart-series-area-fill")) != null) {
                    area.setStyle("-fx-fill: rgba(200, 0, 0, 0);");
                }
            }
        });
        return new double[]{xRange, yRange};
    }

    private double[] plotKernelDensityEstimation(final AreaChart<Number, Number> areaChart, List<Double> data, double sampleMean, double sampleVariance) {
        double pdf;
        double x;
        int j;
        double iqr = this.getInterQuartileRange(data);
        int length = data.size();
        double std = sampleVariance > 0.0 ? Math.sqrt(sampleVariance) : 1.0;
        double minValue = data.get(0);
        double maxValue = data.get(length - 1);
        double xRange = 0.0;
        double yRange = 0.0;
        double bandWidth = 0.0;
        bandWidth = iqr > 0.0 && std > 0.0 ? 0.9 * Math.min(std, iqr / 1.34897950039216) * Math.pow(length, -0.2) : (length > 0 ? Math.pow(4.0 * Math.pow(std, 5.0) / 3.0 / (double)length, 0.0) : 1.0);
        final XYChart.Series kernelEstimation = new XYChart.Series();
        double t = sampleMean;
        double yt = Double.MAX_VALUE;
        double inc = 0.01;
        int cnt = 0;
        do {
            yt = 0.0;
            t = sampleMean - (double)cnt++ * inc;
            j = 0;
            while (j < length) {
                x = (t - data.get(j)) / bandWidth;
                pdf = this.getStandardGaussian(x);
                yt += pdf;
                ++j;
            }
            yt = 1.0 / (double)length / bandWidth * yt;
            kernelEstimation.getData().add((Object)new XYChart.Data((Object)t, (Object)yt));
            xRange = Math.max(xRange, Math.abs(t));
            yRange = Math.max(yRange, Math.abs(yt));
        } while (Math.abs(yt) > 5.0E-4 || t > minValue);
        t = sampleMean;
        yt = Double.MAX_VALUE;
        cnt = 0;
        do {
            yt = 0.0;
            t = sampleMean + (double)(++cnt) * inc;
            j = 0;
            while (j < length) {
                x = (t - data.get(j)) / bandWidth;
                pdf = this.getStandardGaussian(x);
                yt += pdf;
                ++j;
            }
            yt = 1.0 / (double)length / bandWidth * yt;
            kernelEstimation.getData().add((Object)new XYChart.Data((Object)t, (Object)yt));
            xRange = Math.max(xRange, Math.abs(t));
            yRange = Math.max(yRange, Math.abs(yt));
        } while (Math.abs(yt) > 5.0E-4 || t < maxValue);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                areaChart.getData().add((Object)kernelEstimation);
                if (kernelEstimation.getNode() != null) {
                    Node line = kernelEstimation.getNode().lookup(".chart-series-area-line");
                    line.setStyle("-fx-stroke: rgba(0, 0, 150, 1); -fx-stroke-width: 2.5px; -fx-stroke-dash-array: 10 7 10 7;");
                    Node area = kernelEstimation.getNode().lookup(".chart-series-area-fill");
                    area.setStyle("-fx-fill: rgba(0, 0, 0, 0);");
                }
            }
        });
        return new double[]{xRange, yRange};
    }

    private ObservationType[] getSelectedObservationTypes(TerrestrialObservationType terrestrialObservationType) {
        ObservationType[] observationTypes = terrestrialObservationType == TerrestrialObservationType.ALL ? new ObservationType[]{ObservationType.LEVELING, ObservationType.DIRECTION, ObservationType.HORIZONTAL_DISTANCE, ObservationType.SLOPE_DISTANCE, ObservationType.ZENITH_ANGLE} : new ObservationType[]{terrestrialObservationType.getObservationType()};
        return observationTypes;
    }

    private double getInterQuartileRange(List<Double> values) {
        double n = values.size();
        double q1 = values.get((int)Math.floor(0.25 * n));
        double q3 = values.get((int)Math.floor(0.75 * n));
        return q3 - q1;
    }

    private double getStandardGaussian(double x) {
        return this.getStandardGaussian(x, 0.0, 1.0);
    }

    private double getStandardGaussian(double x, double mu, double var) {
        if (var <= 0.0) {
            return 0.0;
        }
        double fac = 1.0 / Math.sqrt(Math.PI * 2 * var);
        double dx = x - mu;
        return fac * Math.exp(-0.5 * dx * dx / var);
    }

    private double getVariance(List<Double> values, double mean) {
        double var = 0.0;
        double n = values.size();
        for (Double value : values) {
            double res = value - mean;
            var += res * res;
        }
        return n > 1.0 ? var / (n - 1.0) : 1.0;
    }

    private double getMean(List<Double> values) {
        double mean = 0.0;
        double n = values.size();
        for (Double value : values) {
            mean += value.doubleValue();
        }
        return n > 0.0 ? mean / n : mean;
    }

    public void load() {
        try {
            List<ObservationType> projectObservationTypes = SQLManager.getInstance().getProjectObservationTypes();
            TerrestrialObservationType[] terrestrialObservationTypeArray = new TerrestrialObservationType[projectObservationTypes.size() == 1 ? 1 : projectObservationTypes.size() + 1];
            terrestrialObservationTypeArray[0] = TerrestrialObservationType.ALL;
            TerrestrialObservationType lastSelectedTerrestrialObservationType = (TerrestrialObservationType)((Object)this.terrestrialObservationTypeComboBox.getSelectionModel().getSelectedItem());
            boolean containsLastSelectedTerrestrialObservationType = false;
            if (projectObservationTypes.size() > 1) {
                int idx = 1;
                for (ObservationType obsType : projectObservationTypes) {
                    TerrestrialObservationType type = TerrestrialObservationType.getEnumByValue(obsType);
                    if (type == null) continue;
                    terrestrialObservationTypeArray[idx++] = type;
                    if (lastSelectedTerrestrialObservationType != type) continue;
                    containsLastSelectedTerrestrialObservationType = true;
                }
            }
            this.terrestrialObservationTypeComboBox.getSelectionModel().clearSelection();
            this.terrestrialObservationTypeComboBox.getItems().setAll((Object[])terrestrialObservationTypeArray);
            this.terrestrialObservationTypeComboBox.getSelectionModel().select((Object)(containsLastSelectedTerrestrialObservationType ? lastSelectedTerrestrialObservationType : TerrestrialObservationType.ALL));
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.message.error.load.exception.title", "Unexpected SQL-Error"), UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.message.error.load.exception.header", "Error, could not load data from database."), UIResidualAnalysisChart.this.i18n.getString("UIResidualAnalysisChart.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private class ProbabilityDensityFunctionChangeListener
    implements ChangeListener<Boolean> {
        private ProbabilityDensityFunctionChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            TerrestrialObservationType type = (TerrestrialObservationType)((Object)UIResidualAnalysisChart.this.terrestrialObservationTypeComboBox.getValue());
            UIResidualAnalysisChart.this.updateChartData(type);
        }
    }

    private class TerrestrialObservationTypeChangeListener
    implements ChangeListener<TerrestrialObservationType> {
        private TerrestrialObservationTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends TerrestrialObservationType> observable, TerrestrialObservationType oldValue, TerrestrialObservationType newValue) {
            if (newValue != null) {
                UIResidualAnalysisChart.this.updateChartData(newValue);
            }
        }
    }

    private class TickFormatChangedListener
    implements FormatterChangedListener {
        private TickFormatChangedListener() {
        }

        @Override
        public void formatterChanged(FormatterEvent evt) {
            if (evt.getCellType() == CellValueType.STATISTIC) {
                UIResidualAnalysisChart.this.updateTickLabels(UIResidualAnalysisChart.this.histogramChart);
            }
        }
    }
}

