/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog.chart;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dialog.chart.TerrestrialObservationType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.util.FormatterOptions;

public class UIRedundancyAnalysisChart {
    private I18N i18n = I18N.getInstance();
    private TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
    private FormatterOptions options = FormatterOptions.getInstance();
    private static UIRedundancyAnalysisChart analysisChart = new UIRedundancyAnalysisChart();
    private Node analysisChartNode;
    private Map<TableRowHighlightRangeType, Integer> chartData = new HashMap<TableRowHighlightRangeType, Integer>(0);
    private final String INADEQUATE = "INADEQUATE";
    private final String SATISFACTORY = "SATISFACTORY";
    private final String EXCELLENT = "EXCELLENT";
    private ComboBox<TerrestrialObservationType> terrestrialObservationTypeComboBox;
    private PieChart pieChart;

    private UIRedundancyAnalysisChart() {
    }

    public static UIRedundancyAnalysisChart getInstance() {
        analysisChart.init();
        return analysisChart;
    }

    public Node getNode() {
        return this.analysisChartNode;
    }

    private void init() {
        if (this.analysisChartNode != null) {
            return;
        }
        BorderPane borderPane = new BorderPane();
        this.terrestrialObservationTypeComboBox = this.createTerrestrialObservationTypeComboBox(TerrestrialObservationType.ALL, this.i18n.getString("UIRedundancyAnalysisChart.observationtype.terrestrial.tooltip", "Set observational type"));
        Region spacer = new Region();
        HBox hbox = new HBox(10.0);
        hbox.setPadding(new Insets(5.0, 10.0, 5.0, 15.0));
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        hbox.getChildren().addAll((Object[])new Node[]{spacer, this.terrestrialObservationTypeComboBox});
        this.pieChart = this.createPieChart();
        borderPane.setTop((Node)hbox);
        borderPane.setCenter((Node)this.pieChart);
        borderPane.setPrefWidth(500.0);
        this.terrestrialObservationTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new TerrestrialObservationTypeChangeListener());
        this.analysisChartNode = borderPane;
    }

    private PieChart createPieChart() {
        PieChart chart = new PieChart(){

            protected void layoutChartChildren(double top, double left, double contentWidth, double contentHeight) {
                if (this.getLabelsVisible()) {
                    Set items = this.lookupAll(".chart-pie-label");
                    for (Node item : items) {
                        if (!(item instanceof Text) || ((Text)item).getText() == null) continue;
                        Text text = (Text)item;
                        UIRedundancyAnalysisChart.this.setChartLabelText(text);
                    }
                }
                super.layoutChartChildren(top, left, contentWidth, contentHeight);
            }
        };
        chart.setLegendSide(Side.BOTTOM);
        chart.setLabelsVisible(Boolean.TRUE.booleanValue());
        return chart;
    }

    private void setChartLabelText(Text text) {
        String name = text.getText();
        if (name.equals("INADEQUATE") || name.equals("SATISFACTORY") || name.equals("EXCELLENT")) {
            TableRowHighlightRangeType tableRowHighlightRangeType = TableRowHighlightRangeType.valueOf(name);
            text.setText(String.format(Locale.ENGLISH, "%d", this.chartData.get((Object)tableRowHighlightRangeType)));
        }
    }

    private ObservationType[] getSelectedObservationTypes(TerrestrialObservationType terrestrialObservationType) {
        ObservationType[] observationTypes = terrestrialObservationType == TerrestrialObservationType.ALL ? new ObservationType[]{ObservationType.LEVELING, ObservationType.DIRECTION, ObservationType.HORIZONTAL_DISTANCE, ObservationType.SLOPE_DISTANCE, ObservationType.ZENITH_ANGLE} : new ObservationType[]{terrestrialObservationType.getObservationType()};
        return observationTypes;
    }

    private void updateChartData(TerrestrialObservationType terrestrialObservationType) {
        try {
            terrestrialObservationType = terrestrialObservationType == null ? TerrestrialObservationType.ALL : terrestrialObservationType;
            ObservationType[] observationTypes = this.getSelectedObservationTypes(terrestrialObservationType);
            double leftBoundary = this.tableRowHighlight.getLeftBoundary(TableRowHighlightType.REDUNDANCY);
            double rightBoundary = this.tableRowHighlight.getRightBoundary(TableRowHighlightType.REDUNDANCY);
            this.chartData = SQLManager.getInstance().getChartData(TableRowHighlightType.REDUNDANCY, observationTypes);
            this.pieChart.getData().clear();
            ObservableList dataList = FXCollections.observableArrayList();
            for (Map.Entry<TableRowHighlightRangeType, Integer> entry : this.chartData.entrySet()) {
                if (entry.getValue() <= 0) continue;
                dataList.add(new PieChart.Data(entry.getKey().name(), (double)entry.getValue().intValue()));
            }
            this.pieChart.getData().setAll((Collection)dataList);
            for (PieChart.Data data : this.pieChart.getData()) {
                try {
                    String name = data.getName();
                    switch (name) {
                        case "INADEQUATE": 
                        case "EXCELLENT": 
                        case "SATISFACTORY": {
                            TableRowHighlightRangeType tableRowHighlightRangeType = TableRowHighlightRangeType.valueOf(name);
                            Color color = this.tableRowHighlight.getColor(tableRowHighlightRangeType);
                            String rgbColor = String.format(Locale.ENGLISH, "rgb(%.0f, %.0f, %.0f, %.7f)", color.getRed() * 255.0, color.getGreen() * 255.0, color.getBlue() * 255.0, color.getOpacity());
                            data.getNode().setStyle(color != null && color != Color.TRANSPARENT ? String.format("-fx-pie-color: %s;", rgbColor) : "");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Set nodes = this.pieChart.lookupAll("Label.chart-legend-item");
            String legendAbbr = this.i18n.getString("UIRedundancyAnalysisChart.chart.legend.abbreviation", "r");
            for (Node node : nodes) {
                if (!(node instanceof Label) || !(((Label)node).getGraphic() instanceof Region)) continue;
                Label label = (Label)node;
                Region region = (Region)label.getGraphic();
                String name = label.getText();
                if (!name.equals("INADEQUATE") && !name.equals("SATISFACTORY") && !name.equals("EXCELLENT")) continue;
                TableRowHighlightRangeType tableRowHighlightRangeType = TableRowHighlightRangeType.valueOf(name);
                Color color = this.tableRowHighlight.getColor(tableRowHighlightRangeType);
                String rgbColor = String.format(Locale.ENGLISH, "rgb(%.0f, %.0f, %.0f, %.7f)", color.getRed() * 255.0, color.getGreen() * 255.0, color.getBlue() * 255.0, color.getOpacity());
                region.setStyle(color != null && color != Color.TRANSPARENT ? String.format("-fx-pie-color: %s;", rgbColor) : "");
                label.setMaxWidth(Double.MAX_VALUE);
                label.setAlignment(Pos.CENTER);
                switch (tableRowHighlightRangeType) {
                    case INADEQUATE: {
                        label.setText(String.format(Locale.ENGLISH, "%s \u2264 %s < %s", 0, legendAbbr, this.options.toPercentFormat(leftBoundary, true)));
                        break;
                    }
                    case SATISFACTORY: {
                        label.setText(String.format(Locale.ENGLISH, "%s \u2264 %s \u2264 %s", this.options.toPercentFormat(leftBoundary, false), legendAbbr, this.options.toPercentFormat(rightBoundary, true)));
                        break;
                    }
                    case EXCELLENT: {
                        label.setText(String.format(Locale.ENGLISH, "%s < %s \u2264 %s", this.options.toPercentFormat(rightBoundary, false), legendAbbr, this.options.toPercentFormat(1.0, true)));
                        break;
                    }
                    default: {
                        System.err.println(this.getClass().getSimpleName() + ": Unsupported table row highlight type" + String.valueOf((Object)tableRowHighlightRangeType));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.message.error.load.exception.title", "Unexpected SQL-Error"), UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.message.error.load.exception.header", "Error, could not load data from database."), UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private ComboBox<TerrestrialObservationType> createTerrestrialObservationTypeComboBox(TerrestrialObservationType item, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        TerrestrialObservationType[] terrestrialObservationTypeArray = TerrestrialObservationType.values();
        typeComboBox.getItems().setAll((Object[])terrestrialObservationTypeArray);
        typeComboBox.getSelectionModel().select((Object)item);
        typeComboBox.setConverter((StringConverter)new StringConverter<TerrestrialObservationType>(){

            public String toString(TerrestrialObservationType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case ALL: {
                        return UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.observationtype.terrestrial.all.label", "All terrestrial observations");
                    }
                    case LEVELING: {
                        return UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.observationtype.terrestrial.leveling.label", "Leveling");
                    }
                    case DIRECTION: {
                        return UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.observationtype.terrestrial.direction.label", "Directions");
                    }
                    case HORIZONTAL_DISTANCE: {
                        return UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.observationtype.terrestrial.horizontal_distance.label", "Horizontal distances");
                    }
                    case SLOPE_DISTANCE: {
                        return UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.observationtype.terrestrial.slope_distance.label", "Slope distances");
                    }
                    case ZENITH_ANGLE: {
                        return UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.observationtype.terrestrial.zenith_angle.label", "Zenith angles");
                    }
                }
                return null;
            }

            public TerrestrialObservationType fromString(String string) {
                return TerrestrialObservationType.valueOf(string);
            }
        });
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    public void load() {
        try {
            SQLManager.getInstance().loadTableRowHighlight();
            List<ObservationType> projectObservationTypes = SQLManager.getInstance().getProjectObservationTypes();
            TerrestrialObservationType[] terrestrialObservationTypeArray = new TerrestrialObservationType[projectObservationTypes.size() == 1 ? 1 : projectObservationTypes.size() + 1];
            terrestrialObservationTypeArray[0] = TerrestrialObservationType.ALL;
            TerrestrialObservationType lastSelectedTerrestrialObservationType = (TerrestrialObservationType)((Object)this.terrestrialObservationTypeComboBox.getSelectionModel().getSelectedItem());
            boolean containsLastSelectedTerrestrialObservationType = false;
            if (projectObservationTypes.size() > 1) {
                int idx = 1;
                for (ObservationType obsType : projectObservationTypes) {
                    TerrestrialObservationType type = TerrestrialObservationType.getEnumByValue(obsType);
                    if (type == null) continue;
                    terrestrialObservationTypeArray[idx++] = type;
                    if (lastSelectedTerrestrialObservationType != type) continue;
                    containsLastSelectedTerrestrialObservationType = true;
                }
            }
            this.terrestrialObservationTypeComboBox.getSelectionModel().clearSelection();
            this.terrestrialObservationTypeComboBox.getItems().setAll((Object[])terrestrialObservationTypeArray);
            this.terrestrialObservationTypeComboBox.getSelectionModel().select((Object)(containsLastSelectedTerrestrialObservationType ? lastSelectedTerrestrialObservationType : TerrestrialObservationType.ALL));
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.message.error.load.exception.title", "Unexpected SQL-Error"), UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.message.error.load.exception.header", "Error, could not load data from database."), UIRedundancyAnalysisChart.this.i18n.getString("UIRedundancyAnalysisChart.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private class TerrestrialObservationTypeChangeListener
    implements ChangeListener<TerrestrialObservationType> {
        private TerrestrialObservationTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends TerrestrialObservationType> observable, TerrestrialObservationType oldValue, TerrestrialObservationType newValue) {
            if (newValue != null) {
                UIRedundancyAnalysisChart.this.updateChartData(newValue);
            }
        }
    }
}

