/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog.chart;

import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.VarianceComponentType;

enum TerrestrialObservationType {
    ALL(null),
    LEVELING(ObservationType.LEVELING),
    DIRECTION(ObservationType.DIRECTION),
    HORIZONTAL_DISTANCE(ObservationType.HORIZONTAL_DISTANCE),
    SLOPE_DISTANCE(ObservationType.SLOPE_DISTANCE),
    ZENITH_ANGLE(ObservationType.ZENITH_ANGLE);

    private final ObservationType observationType;
    private final VarianceComponentType varianceComponentType;

    private TerrestrialObservationType(ObservationType observationType) {
        this.observationType = observationType;
        this.varianceComponentType = VarianceComponentType.getVarianceComponentTypeByObservationType(observationType);
    }

    public final ObservationType getObservationType() {
        return this.observationType;
    }

    public final VarianceComponentType getVarianceComponentType() {
        return this.varianceComponentType;
    }

    public static TerrestrialObservationType getEnumByValue(ObservationType observationType) {
        TerrestrialObservationType[] terrestrialObservationTypeArray = TerrestrialObservationType.values();
        int n = terrestrialObservationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerrestrialObservationType element = terrestrialObservationTypeArray[n2];
            if (element.observationType != null && element.observationType == observationType) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static TerrestrialObservationType getEnumByValue(VarianceComponentType varianceComponentType) {
        TerrestrialObservationType[] terrestrialObservationTypeArray = TerrestrialObservationType.values();
        int n = terrestrialObservationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TerrestrialObservationType element = terrestrialObservationTypeArray[n2];
            if (element.varianceComponentType != null && element.varianceComponentType == varianceComponentType) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

