/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog.chart;

import javafx.scene.control.ListCell;
import org.applied_geodesy.jag3d.ui.dialog.chart.AnalysisChartType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public class AnalysisChartTypeListCell
extends ListCell<AnalysisChartType> {
    private I18N i18n = I18N.getInstance();

    protected void updateItem(AnalysisChartType item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setGraphic(null);
        this.setText(null);
        if (item != null && !empty) {
            this.setText(this.getText(item));
        }
    }

    private String getText(AnalysisChartType type) {
        switch (type) {
            case RESIDUALS: {
                return this.i18n.getString("AnalysisChartTypeListViewCell.residual.label", "Residuals analysis");
            }
            case REDUNDANCY: {
                return this.i18n.getString("AnalysisChartTypeListViewCell.redundancy.label", "Redundancy distribution");
            }
            case INFLUENCE_ON_POSITION: {
                return this.i18n.getString("AnalysisChartTypeListViewCell.influence_on_position.label", "Influence on position distribution");
            }
            case SIGN: {
                return this.i18n.getString("AnalysisChartTypeListViewCell.sign.label", "Sign distribution");
            }
        }
        return null;
    }
}

