/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.statistic.TestStatisticDefinition;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.spinner.DoubleSpinner;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterEventType;
import org.applied_geodesy.util.FormatterOptions;

public class TestStatisticDialog
implements FormatterChangedListener {
    private I18N i18n = I18N.getInstance();
    private static TestStatisticDialog testStatisticDialog = new TestStatisticDialog();
    private FormatterOptions options = FormatterOptions.getInstance();
    private Dialog<TestStatisticDefinition> dialog = null;
    private DoubleSpinner probabilityValueSpinner;
    private DoubleSpinner testPowerSpinner;
    private ComboBox<TestStatisticType> testStatisticTypeComboBox;
    private CheckBox familywiseErrorRateCheckBox;
    private Window window;
    private Label probabilityValueLabel;
    private Label testPowerLabel;

    private TestStatisticDialog() {
    }

    public static void setOwner(Window owner) {
        TestStatisticDialog.testStatisticDialog.window = owner;
    }

    public static Optional<TestStatisticDefinition> showAndWait() {
        testStatisticDialog.init();
        testStatisticDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TestStatisticDialog.testStatisticDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)TestStatisticDialog.testStatisticDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return TestStatisticDialog.testStatisticDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("TestStatisticDialog.title", "Test statistic"));
        this.dialog.setHeaderText(this.i18n.getString("TestStatisticDialog.header", "Test statistic properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, TestStatisticDefinition>(){

            public TestStatisticDefinition call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    double probabilityValue = TestStatisticDialog.this.probabilityValueSpinner.getNumber().doubleValue();
                    double powerOfTest = TestStatisticDialog.this.testPowerSpinner.getNumber().doubleValue();
                    boolean familywiseErrorRate = TestStatisticDialog.this.familywiseErrorRateCheckBox.isSelected();
                    TestStatisticType testStatisticType = (TestStatisticType)((Object)TestStatisticDialog.this.testStatisticTypeComboBox.getSelectionModel().getSelectedItem());
                    TestStatisticDefinition testStatistic = new TestStatisticDefinition(testStatisticType, probabilityValue, powerOfTest, familywiseErrorRate);
                    TestStatisticDialog.this.save(testStatistic);
                    return testStatistic;
                }
                return null;
            }
        });
        this.options.addFormatterChangedListener(this);
    }

    private Node createPane() {
        String frmPercentUnit = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
        String labelProbabilityValue = String.format(Locale.ENGLISH, "%s%s:", this.i18n.getString("TestStatisticDialog.probability.label", "Probability value \u03b1"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
        String labelTestPower = String.format(Locale.ENGLISH, "%s%s:", this.i18n.getString("TestStatisticDialog.testpower.label", "Power of test 1 - \u03b2"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
        String tooltipProbabilityValue = this.i18n.getString("TestStatisticDialog.probability.tooltip", "Set probability value (type I error)");
        String tooltipTestPower = this.i18n.getString("TestStatisticDialog.testpower.tooltip", "Set power of test (type II error)");
        String labelFamilywiseErrorRate = this.i18n.getString("TestStatisticDialog.familywiseerror.label", "Familywise error rate");
        String tooltipFamilywiseErrorRate = this.i18n.getString("TestStatisticDialog.familywiseerror.tooltip", "If checked, probability value \u03b1 defines familywise error rate");
        this.probabilityValueLabel = new Label(labelProbabilityValue);
        this.testPowerLabel = new Label(labelTestPower);
        this.familywiseErrorRateCheckBox = this.createCheckBox(labelFamilywiseErrorRate, tooltipFamilywiseErrorRate);
        this.probabilityValueSpinner = this.createDoubleSpinner(5.0E-4, 0.3, 0.01, tooltipProbabilityValue);
        this.testPowerSpinner = this.createDoubleSpinner(0.5, 0.9995, 0.01, tooltipTestPower);
        this.testStatisticTypeComboBox = this.createTestStatisticTypeComboBox();
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setMinWidth(300.0);
        gridPane.setHgap(20.0);
        gridPane.setVgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        this.probabilityValueLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.testPowerLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.probabilityValueLabel.setMaxWidth(Double.MAX_VALUE);
        this.testPowerLabel.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.probabilityValueLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.testPowerLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.testStatisticTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.familywiseErrorRateCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.probabilityValueSpinner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.testPowerSpinner, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add(this.testStatisticTypeComboBox, 0, ++row, 2, 1);
        gridPane.add((Node)this.familywiseErrorRateCheckBox, 0, ++row, 2, 1);
        gridPane.add((Node)this.probabilityValueLabel, 0, ++row);
        gridPane.add((Node)this.probabilityValueSpinner, 1, row);
        gridPane.add((Node)this.testPowerLabel, 0, ++row);
        gridPane.add((Node)this.testPowerSpinner, 1, row);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TestStatisticDialog.this.testStatisticTypeComboBox.requestFocus();
            }
        });
        return gridPane;
    }

    private ComboBox<TestStatisticType> createTestStatisticTypeComboBox() {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])TestStatisticType.values());
        typeComboBox.setConverter((StringConverter)new StringConverter<TestStatisticType>(){

            public String toString(TestStatisticType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case BAARDA_METHOD: {
                        return TestStatisticDialog.this.i18n.getString("TestStatisticDialog.type.baarda", "Baardas B-method");
                    }
                    case SIDAK: {
                        return TestStatisticDialog.this.i18n.getString("TestStatisticDialog.type.sidak", "\u0160id\u00e1k correction");
                    }
                    case NONE: {
                        return TestStatisticDialog.this.i18n.getString("TestStatisticDialog.type.none", "None");
                    }
                }
                return "";
            }

            public TestStatisticType fromString(String string) {
                return TestStatisticType.valueOf(string);
            }
        });
        typeComboBox.setTooltip(new Tooltip(this.i18n.getString("TestStatisticDialog.type.tooltip", "Select method for type I error adaption")));
        typeComboBox.getSelectionModel().select((Object)TestStatisticType.NONE);
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setPrefWidth(200.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private DoubleSpinner createDoubleSpinner(double min, double max, double amountToStepBy, String tooltip) {
        DoubleSpinner doubleSpinner = new DoubleSpinner(CellValueType.PERCENTAGE, min, max, amountToStepBy);
        doubleSpinner.setMinWidth(75.0);
        doubleSpinner.setPrefWidth(100.0);
        doubleSpinner.setMaxWidth(Double.MAX_VALUE);
        doubleSpinner.setTooltip(new Tooltip(tooltip));
        return doubleSpinner;
    }

    private void save(TestStatisticDefinition testStatistic) {
        try {
            SQLManager.getInstance().save(testStatistic);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(TestStatisticDialog.this.i18n.getString("TestStatisticDialog.message.error.save.exception.title", "Unexpected SQL-Error"), TestStatisticDialog.this.i18n.getString("TestStatisticDialog.message.error.save.exception.header", "Error, could not save test statistics to database."), TestStatisticDialog.this.i18n.getString("TestStatisticDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void load() {
        try {
            TestStatisticDefinition testStatistic = SQLManager.getInstance().getTestStatisticDefinition();
            this.familywiseErrorRateCheckBox.setSelected(testStatistic.isFamilywiseErrorRate());
            this.testStatisticTypeComboBox.getSelectionModel().select((Object)testStatistic.getTestStatisticType());
            SpinnerValueFactory.DoubleSpinnerValueFactory probabilityValueSpinnerFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.probabilityValueSpinner.getValueFactory();
            SpinnerValueFactory.DoubleSpinnerValueFactory testPowerSpinnerFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.testPowerSpinner.getValueFactory();
            double probabilityValue = testStatistic.getProbabilityValue();
            double powerOfTest = testStatistic.getPowerOfTest();
            probabilityValue = Math.max(Math.min(this.options.convertPercentToView(probabilityValue), probabilityValueSpinnerFactory.getMax()), probabilityValueSpinnerFactory.getMin());
            powerOfTest = Math.max(Math.min(this.options.convertPercentToView(powerOfTest), testPowerSpinnerFactory.getMax()), testPowerSpinnerFactory.getMin());
            probabilityValueSpinnerFactory.setValue((Object)probabilityValue);
            testPowerSpinnerFactory.setValue((Object)powerOfTest);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(TestStatisticDialog.this.i18n.getString("TestStatisticDialog.message.error.load.exception.title", "Unexpected SQL-Error"), TestStatisticDialog.this.i18n.getString("TestStatisticDialog.message.error.load.exception.header", "Error, could not load test statistics from database."), TestStatisticDialog.this.i18n.getString("TestStatisticDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinHeight(Double.NEGATIVE_INFINITY);
        checkBox.setMaxHeight(Double.MAX_VALUE);
        return checkBox;
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        if (evt != null && evt.getCellType() == CellValueType.PERCENTAGE && evt.getEventType() == FormatterEventType.UNIT_CHANGED) {
            String frmPercentUnit = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
            String labelProbabilityValue = String.format(Locale.ENGLISH, "%s%s:", this.i18n.getString("TestStatisticDialog.probability.label", "Probability value \u03b1"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
            String labelTestPower = String.format(Locale.ENGLISH, "%s%s:", this.i18n.getString("TestStatisticDialog.testpower.label", "Power of test 1 - \u03b2"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
            this.probabilityValueLabel.setText(labelProbabilityValue);
            this.testPowerLabel.setText(labelTestPower);
        }
    }
}

