/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.DefaultTableRowHighlightValue;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.ui.textfield.MinMaxDoubleTextField;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterEventType;
import org.applied_geodesy.util.FormatterOptions;

public class TableRowHighlightDialog
implements FormatterChangedListener {
    private I18N i18n = I18N.getInstance();
    private FormatterOptions options = FormatterOptions.getInstance();
    private static TableRowHighlightDialog tableRowHighlightDialog = new TableRowHighlightDialog();
    private Dialog<TableRowHighlight> dialog = null;
    private Window window;
    private Map<TableRowHighlightType, DoubleTextField[]> highlightRangeFieldMap = new HashMap<TableRowHighlightType, DoubleTextField[]>(5);
    private boolean ignoreChangeEvent = false;
    private ToggleGroup highlightOptionGroup = new ToggleGroup();
    private ColorPicker excellentColorPicker;
    private ColorPicker satisfactoryColorPicker;
    private ColorPicker inadequateColorPicker;
    private Accordion accordion = new Accordion();
    private Label rightBoundaryRedundancy;
    private Label rightBoundaryPValue;

    private TableRowHighlightDialog() {
    }

    public static void setOwner(Window owner) {
        TableRowHighlightDialog.tableRowHighlightDialog.window = owner;
    }

    public static Optional<TableRowHighlight> showAndWait() {
        tableRowHighlightDialog.init();
        tableRowHighlightDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TableRowHighlightDialog.tableRowHighlightDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)TableRowHighlightDialog.tableRowHighlightDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return TableRowHighlightDialog.tableRowHighlightDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.ignoreChangeEvent = true;
        try {
            this.options.addFormatterChangedListener(this);
            this.dialog = new Dialog();
            this.dialog.setTitle(this.i18n.getString("TableRowHighlightDialog.title", "Highlighting table rows"));
            this.dialog.setHeaderText(this.i18n.getString("TableRowHighlightDialog.header", "Highlighting of specific table rows"));
            this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
            this.dialog.initModality(Modality.APPLICATION_MODAL);
            this.dialog.initOwner(this.window);
            this.dialog.setResizable(true);
            this.dialog.initModality(Modality.APPLICATION_MODAL);
            this.dialog.initOwner(this.window);
            this.dialog.getDialogPane().setContent(this.createPane());
            this.dialog.setResizable(true);
            this.dialog.setResultConverter((Callback)new Callback<ButtonType, TableRowHighlight>(){

                public TableRowHighlight call(ButtonType buttonType) {
                    return TableRowHighlight.getInstance();
                }
            });
            this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

                public void handle(DialogEvent event) {
                    TableRowHighlightDialog.this.accordion.setExpandedPane((TitledPane)TableRowHighlightDialog.this.accordion.getPanes().get(0));
                }
            });
        }
        finally {
            this.ignoreChangeEvent = false;
        }
    }

    private Node createPane() {
        this.accordion.getPanes().addAll((Object[])new TitledPane[]{(TitledPane)this.createRangePane(), (TitledPane)this.createColorPropertiesPane()});
        this.accordion.setExpandedPane((TitledPane)this.accordion.getPanes().get(0));
        this.accordion.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.accordion.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        if (this.highlightOptionGroup.getSelectedToggle() instanceof RadioButton) {
            ((RadioButton)this.highlightOptionGroup.getSelectedToggle()).requestFocus();
        }
        return this.accordion;
    }

    private Node createRangePane() {
        GridPane gridPane = this.createGridPane();
        int row = 0;
        this.addRow(gridPane, row++, TableRowHighlightType.NONE, this.highlightOptionGroup);
        this.addRow(gridPane, row++, TableRowHighlightType.TEST_STATISTIC, this.highlightOptionGroup);
        this.addRow(gridPane, row++, TableRowHighlightType.GROSS_ERROR, this.highlightOptionGroup);
        this.addRow(gridPane, row++, TableRowHighlightType.REDUNDANCY, this.highlightOptionGroup);
        this.addRow(gridPane, row++, TableRowHighlightType.P_PRIO_VALUE, this.highlightOptionGroup);
        this.addRow(gridPane, row++, TableRowHighlightType.INFLUENCE_ON_POSITION, this.highlightOptionGroup);
        this.highlightOptionGroup.selectedToggleProperty().addListener((ChangeListener)new HighlightTypeChangeListener());
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("TableRowHighlightDialog.range.label", "Range options"), this.i18n.getString("TableRowHighlightDialog.range.tooltip", "Specify range of table row highlighting"), (Node)gridPane);
        return titledPane;
    }

    private Node createColorPropertiesPane() {
        GridPane gridPane = this.createGridPane();
        this.excellentColorPicker = this.createColorPicker(TableRowHighlightRangeType.EXCELLENT, DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.EXCELLENT));
        this.satisfactoryColorPicker = this.createColorPicker(TableRowHighlightRangeType.SATISFACTORY, DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.SATISFACTORY));
        this.inadequateColorPicker = this.createColorPicker(TableRowHighlightRangeType.INADEQUATE, DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.INADEQUATE));
        Label excellentColorLabel = new Label(this.i18n.getString("TableRowHighlightDialog.color.excellent.label", "Excellent color:"));
        Label satisfactoryColorLabel = new Label(this.i18n.getString("TableRowHighlightDialog.color.satisfactory.label", "Satisfactory color:"));
        Label inadequateColorLabel = new Label(this.i18n.getString("TableRowHighlightDialog.color.inadequate.label", "Inadequate color:"));
        excellentColorLabel.setLabelFor((Node)this.excellentColorPicker);
        satisfactoryColorLabel.setLabelFor((Node)this.satisfactoryColorPicker);
        inadequateColorLabel.setLabelFor((Node)this.inadequateColorPicker);
        GridPane.setHgrow((Node)excellentColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)satisfactoryColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)inadequateColorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.excellentColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.satisfactoryColorPicker, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.inadequateColorPicker, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)excellentColorLabel, 0, row);
        gridPane.add((Node)this.excellentColorPicker, 1, row++);
        gridPane.add((Node)satisfactoryColorLabel, 0, row);
        gridPane.add((Node)this.satisfactoryColorPicker, 1, row++);
        gridPane.add((Node)inadequateColorLabel, 0, row);
        gridPane.add((Node)this.inadequateColorPicker, 1, row++);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("TableRowHighlightDialog.color.label", "Color options"), this.i18n.getString("TableRowHighlightDialog.color.tooltip", "Specify color properties of table row highlighting"), (Node)gridPane);
        return titledPane;
    }

    private void addRow(GridPane parent, int row, TableRowHighlightType tableRowHighlightType, ToggleGroup group) {
        String radioButtonLabelText = null;
        String radioButtonToolTipText = null;
        Label leftBoundary = null;
        Label middleBoundaray = null;
        Label rightBoundary = null;
        TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
        DoubleTextField leftRangeField = null;
        DoubleTextField rightRangeField = null;
        switch (tableRowHighlightType) {
            case NONE: {
                radioButtonLabelText = this.i18n.getString("TableRowHighlightDialog.range.none.label", "None highlighting");
                radioButtonToolTipText = this.i18n.getString("TableRowHighlightDialog.range.none.tooltip", "None specific highlighting of table rows");
                break;
            }
            case TEST_STATISTIC: {
                radioButtonLabelText = this.i18n.getString("TableRowHighlightDialog.range.test_statistic.label", "Test statistic Tprio \u2228 Tpost");
                radioButtonToolTipText = this.i18n.getString("TableRowHighlightDialog.range.test_statistic.tooltip", "Highlighting table rows depending on test statistic decisions");
                break;
            }
            case GROSS_ERROR: {
                radioButtonLabelText = this.i18n.getString("TableRowHighlightDialog.range.gross_error.label", "Gross error \u2207(1) \u2264 \u2207 \u2264 \u2207(\u03bb)");
                radioButtonToolTipText = this.i18n.getString("TableRowHighlightDialog.range.gross_error.tooltip", "Highlighting table rows depending on estimated gross error");
                break;
            }
            case REDUNDANCY: {
                radioButtonLabelText = String.format(Locale.ENGLISH, "%s %s", this.i18n.getString("TableRowHighlightDialog.range.redundancy.label", "Redundancy r"), this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation()).trim();
                radioButtonToolTipText = this.i18n.getString("TableRowHighlightDialog.range.redundancy.tooltip", "Highlighting table rows depending on redundancy");
                leftBoundary = new Label("0 \u2264 ");
                middleBoundaray = new Label(" < ");
                rightBoundary = new Label(" \u2264 " + Math.round(this.options.convertPercentToView(1.0)));
                leftRangeField = this.createMinMaxDoubleTextField(tableRowHighlightType, tableRowHighlight.getLeftBoundary(tableRowHighlightType), 0.0, 1.0, CellValueType.PERCENTAGE, false, false);
                rightRangeField = this.createMinMaxDoubleTextField(tableRowHighlightType, tableRowHighlight.getRightBoundary(tableRowHighlightType), 0.0, 1.0, CellValueType.PERCENTAGE, false, false);
                this.rightBoundaryRedundancy = rightBoundary;
                break;
            }
            case P_PRIO_VALUE: {
                radioButtonLabelText = String.format(Locale.ENGLISH, "%s %s", this.i18n.getString("TableRowHighlightDialog.range.probability_value.label", "Probability value p"), this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation()).trim();
                radioButtonToolTipText = this.i18n.getString("TableRowHighlightDialog.range.probability_value.tooltip", "Highlighting table rows depending on (a-priori) p-value");
                leftBoundary = new Label("0 < ");
                middleBoundaray = new Label(" < ");
                rightBoundary = new Label(" < " + Math.round(this.options.convertPercentToView(1.0)));
                leftRangeField = this.createMinMaxDoubleTextField(tableRowHighlightType, tableRowHighlight.getLeftBoundary(tableRowHighlightType), 0.0, 1.0, CellValueType.PERCENTAGE, true, true);
                rightRangeField = this.createMinMaxDoubleTextField(tableRowHighlightType, tableRowHighlight.getRightBoundary(tableRowHighlightType), 0.0, 1.0, CellValueType.PERCENTAGE, true, true);
                this.rightBoundaryPValue = rightBoundary;
                break;
            }
            case INFLUENCE_ON_POSITION: {
                radioButtonLabelText = String.format(Locale.ENGLISH, "%s %s", this.i18n.getString("TableRowHighlightDialog.range.influenceonposition.label", "Influence on point position EP"), this.options.getFormatterOptions().get((Object)CellValueType.LENGTH_RESIDUAL).getUnit().toFormattedAbbreviation()).trim();
                radioButtonToolTipText = this.i18n.getString("TableRowHighlightDialog.range.influenceonposition.tooltip", "Highlighting table rows depending on influence on point position due to an undetected gross-error");
                leftBoundary = new Label("0 \u2264 ");
                middleBoundaray = new Label(" < ");
                rightBoundary = new Label(" < \u221e");
                leftRangeField = this.createMinMaxDoubleTextField(tableRowHighlightType, tableRowHighlight.getLeftBoundary(tableRowHighlightType), 0.0, Double.POSITIVE_INFINITY, CellValueType.LENGTH_RESIDUAL, false, false);
                rightRangeField = this.createMinMaxDoubleTextField(tableRowHighlightType, tableRowHighlight.getRightBoundary(tableRowHighlightType), 0.0, Double.POSITIVE_INFINITY, CellValueType.LENGTH_RESIDUAL, false, false);
            }
        }
        if (tableRowHighlightType != null && radioButtonLabelText != null && radioButtonToolTipText != null) {
            int column = 0;
            RadioButton radioButton = this.createRadioButton(radioButtonLabelText, radioButtonToolTipText, tableRowHighlightType, group);
            radioButton.setSelected(tableRowHighlightType == TableRowHighlightType.NONE);
            GridPane.setMargin((Node)radioButton, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            GridPane.setHgrow((Node)radioButton, (Priority)Priority.SOMETIMES);
            parent.add((Node)radioButton, column++, row);
            if (leftRangeField != null && rightRangeField != null && leftBoundary != null && middleBoundaray != null && rightBoundary != null) {
                GridPane.setHgrow((Node)leftBoundary, (Priority)Priority.NEVER);
                GridPane.setHgrow((Node)middleBoundaray, (Priority)Priority.NEVER);
                GridPane.setHgrow((Node)rightBoundary, (Priority)Priority.NEVER);
                GridPane.setHgrow((Node)leftRangeField, (Priority)Priority.ALWAYS);
                GridPane.setHgrow(rightRangeField, (Priority)Priority.ALWAYS);
                parent.add((Node)leftBoundary, column++, row);
                parent.add((Node)leftRangeField, column++, row);
                parent.add((Node)middleBoundaray, column++, row);
                parent.add((Node)rightRangeField, column++, row);
                parent.add((Node)rightBoundary, column++, row);
                this.highlightRangeFieldMap.put(tableRowHighlightType, new DoubleTextField[]{leftRangeField, rightRangeField});
            }
        }
    }

    private void load() {
        this.ignoreChangeEvent = true;
        TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
        try {
            try {
                SQLManager.getInstance().loadTableRowHighlight();
                TableRowHighlightType selectedTableRowHighlightType = tableRowHighlight.getSelectedTableRowHighlightType();
                for (Toggle toggleButton : this.highlightOptionGroup.getToggles()) {
                    if (toggleButton.getUserData() != selectedTableRowHighlightType || !(toggleButton instanceof RadioButton)) continue;
                    RadioButton radioButton = (RadioButton)toggleButton;
                    radioButton.setSelected(true);
                    radioButton.requestFocus();
                    break;
                }
                TableRowHighlightType[] tableRowHighlightTypeArray = TableRowHighlightType.values();
                int n = tableRowHighlightTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowHighlightType tableRowHighlightType = tableRowHighlightTypeArray[n2];
                    if (tableRowHighlightType != TableRowHighlightType.NONE && this.highlightRangeFieldMap.containsKey((Object)tableRowHighlightType) && this.highlightRangeFieldMap.get((Object)tableRowHighlightType) != null) {
                        DoubleTextField[] fields = this.highlightRangeFieldMap.get((Object)tableRowHighlightType);
                        double leftBoundary = tableRowHighlight.getLeftBoundary(tableRowHighlightType);
                        double rightBoundary = tableRowHighlight.getRightBoundary(tableRowHighlightType);
                        fields[0].setNumber(leftBoundary);
                        fields[1].setNumber(rightBoundary);
                    }
                    ++n2;
                }
                this.excellentColorPicker.setValue((Object)tableRowHighlight.getColor(TableRowHighlightRangeType.EXCELLENT));
                this.satisfactoryColorPicker.setValue((Object)tableRowHighlight.getColor(TableRowHighlightRangeType.SATISFACTORY));
                this.inadequateColorPicker.setValue((Object)tableRowHighlight.getColor(TableRowHighlightRangeType.INADEQUATE));
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (TableRowHighlightDialog.this.highlightOptionGroup.getSelectedToggle() instanceof RadioButton) {
                            ((RadioButton)TableRowHighlightDialog.this.highlightOptionGroup.getSelectedToggle()).requestFocus();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OptionDialog.showThrowableDialog(TableRowHighlightDialog.this.i18n.getString("TableRowHighlightDialog.message.error.load.exception.title", "Unexpected SQL-Error"), TableRowHighlightDialog.this.i18n.getString("TableRowHighlightDialog.message.error.load.exception.header", "Error, could not load table row highlight properties from database."), TableRowHighlightDialog.this.i18n.getString("TableRowHighlightDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                    }
                });
                tableRowHighlight.refreshTables();
                this.ignoreChangeEvent = false;
            }
        }
        finally {
            tableRowHighlight.refreshTables();
            this.ignoreChangeEvent = false;
        }
    }

    private void save() {
        try {
            try {
                SQLManager.getInstance().saveTableRowHighlight();
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OptionDialog.showThrowableDialog(TableRowHighlightDialog.this.i18n.getString("TableRowHighlightDialog.message.error.save.exception.title", "Unexpected SQL-Error"), TableRowHighlightDialog.this.i18n.getString("TableRowHighlightDialog.message.error.save.exception.header", "Error, could not save table row highlight properties to database."), TableRowHighlightDialog.this.i18n.getString("TableRowHighlightDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                    }
                });
                TableRowHighlight.getInstance().refreshTables();
            }
        }
        finally {
            TableRowHighlight.getInstance().refreshTables();
        }
    }

    private RadioButton createRadioButton(String title, String tooltip, TableRowHighlightType tableRowHighlightType, ToggleGroup group) {
        Label label = new Label(title);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxWidth(Double.MAX_VALUE);
        radioButton.setUserData((Object)tableRowHighlightType);
        radioButton.setToggleGroup(group);
        return radioButton;
    }

    private DoubleTextField createMinMaxDoubleTextField(TableRowHighlightType tableRowHighlightType, double value, double min, double max, CellValueType valueType, boolean exclusiveMin, boolean exclusiveMax) {
        MinMaxDoubleTextField doubleTextField = new MinMaxDoubleTextField(value, min, max, valueType, false, exclusiveMin, exclusiveMax);
        doubleTextField.setPrefColumnCount(3);
        doubleTextField.setMaxWidth(Double.MAX_VALUE);
        doubleTextField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        doubleTextField.setUserData((Object)tableRowHighlightType);
        doubleTextField.numberProperty().addListener((ChangeListener)new HighlightRangeChangeListener(tableRowHighlightType));
        return doubleTextField;
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        gridPane.setAlignment(Pos.TOP_CENTER);
        gridPane.setHgap(5.0);
        gridPane.setVgap(7.0);
        gridPane.setPadding(new Insets(7.0, 25.0, 0.0, 25.0));
        return gridPane;
    }

    private TitledPane createTitledPane(String title, String tooltip, Node content) {
        Label label = new Label(title);
        label.setTooltip(new Tooltip(tooltip));
        TitledPane titledPane = new TitledPane();
        titledPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        titledPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        titledPane.setGraphic((Node)label);
        titledPane.setCollapsible(true);
        titledPane.setAnimated(true);
        titledPane.setContent(content);
        titledPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        return titledPane;
    }

    private ColorPicker createColorPicker(TableRowHighlightRangeType tableRowHighlightRangeType, Color color) {
        ColorPicker colorPicker = new ColorPicker(color);
        colorPicker.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        colorPicker.setMaxWidth(Double.MAX_VALUE);
        colorPicker.getStyleClass().add((Object)"split-button");
        colorPicker.valueProperty().addListener((ChangeListener)new HighlightColorChangeListener(tableRowHighlightRangeType));
        colorPicker.setUserData((Object)tableRowHighlightRangeType);
        return colorPicker;
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        if (evt.getEventType() == FormatterEventType.UNIT_CHANGED) {
            if (evt.getCellType() == CellValueType.PERCENTAGE) {
                this.rightBoundaryRedundancy.setText(" \u2264 " + Math.round(this.options.convertPercentToView(1.0)));
                this.rightBoundaryPValue.setText(" < " + Math.round(this.options.convertPercentToView(1.0)));
            }
            for (Toggle toggleButton : this.highlightOptionGroup.getToggles()) {
                if (evt.getCellType() != CellValueType.LENGTH_RESIDUAL && evt.getCellType() != CellValueType.PERCENTAGE || toggleButton.getUserData() != TableRowHighlightType.INFLUENCE_ON_POSITION && toggleButton.getUserData() != TableRowHighlightType.P_PRIO_VALUE && toggleButton.getUserData() != TableRowHighlightType.REDUNDANCY || !(toggleButton instanceof RadioButton)) continue;
                RadioButton radioButton = (RadioButton)toggleButton;
                String labelText = null;
                String unitAbbr = null;
                if (evt.getCellType() == CellValueType.LENGTH_RESIDUAL && toggleButton.getUserData() == TableRowHighlightType.INFLUENCE_ON_POSITION) {
                    labelText = this.i18n.getString("TableRowHighlightDialog.range.influenceonposition.label", "Influence on point position");
                    unitAbbr = this.options.getFormatterOptions().get((Object)CellValueType.LENGTH_RESIDUAL).getUnit().toFormattedAbbreviation();
                } else if (evt.getCellType() == CellValueType.PERCENTAGE && toggleButton.getUserData() == TableRowHighlightType.P_PRIO_VALUE) {
                    labelText = this.i18n.getString("TableRowHighlightDialog.range.probability_value.label", "Probability value p");
                    unitAbbr = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
                } else {
                    if (evt.getCellType() != CellValueType.PERCENTAGE || toggleButton.getUserData() != TableRowHighlightType.REDUNDANCY) continue;
                    labelText = this.i18n.getString("TableRowHighlightDialog.range.redundancy.label", "Redundancy r");
                    unitAbbr = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
                }
                if (radioButton.getGraphic() instanceof Label) {
                    ((Label)radioButton.getGraphic()).setText(String.format(Locale.ENGLISH, "%s %s", labelText, unitAbbr).trim());
                    continue;
                }
                radioButton.setText(String.format(Locale.ENGLISH, "%s %s", labelText, unitAbbr).trim());
            }
        }
    }

    private class HighlightColorChangeListener
    implements ChangeListener<Color> {
        private final TableRowHighlightRangeType tableRowHighlightRangeType;

        public HighlightColorChangeListener(TableRowHighlightRangeType tableRowHighlightRangeType) {
            this.tableRowHighlightRangeType = tableRowHighlightRangeType;
        }

        public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
            if (!TableRowHighlightDialog.this.ignoreChangeEvent && newValue != null) {
                TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
                tableRowHighlight.setColor(this.tableRowHighlightRangeType, newValue);
                TableRowHighlightDialog.this.save();
            }
        }
    }

    private class HighlightRangeChangeListener
    implements ChangeListener<Double> {
        private final TableRowHighlightType tableRowHighlightType;

        public HighlightRangeChangeListener(TableRowHighlightType tableRowHighlightType) {
            this.tableRowHighlightType = tableRowHighlightType;
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (!TableRowHighlightDialog.this.ignoreChangeEvent && newValue != null && TableRowHighlightDialog.this.highlightRangeFieldMap.containsKey((Object)this.tableRowHighlightType)) {
                TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
                if (TableRowHighlightDialog.this.highlightRangeFieldMap.get((Object)this.tableRowHighlightType) != null) {
                    DoubleTextField[] fields = TableRowHighlightDialog.this.highlightRangeFieldMap.get((Object)this.tableRowHighlightType);
                    double leftBoundary = fields[0].getNumber();
                    double rightBoundary = fields[1].getNumber();
                    tableRowHighlight.setSelectedTableRowHighlightType(this.tableRowHighlightType);
                    tableRowHighlight.setRange(this.tableRowHighlightType, leftBoundary, rightBoundary);
                }
                TableRowHighlightDialog.this.ignoreChangeEvent = true;
                try {
                    for (Toggle toggleButton : TableRowHighlightDialog.this.highlightOptionGroup.getToggles()) {
                        if (toggleButton.getUserData() != this.tableRowHighlightType || !(toggleButton instanceof RadioButton)) continue;
                        RadioButton radioButton = (RadioButton)toggleButton;
                        radioButton.setSelected(true);
                        break;
                    }
                }
                finally {
                    TableRowHighlightDialog.this.ignoreChangeEvent = false;
                }
                TableRowHighlightDialog.this.save();
            }
        }
    }

    private class HighlightTypeChangeListener
    implements ChangeListener<Toggle> {
        private HighlightTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
            if (!TableRowHighlightDialog.this.ignoreChangeEvent && newValue != null && newValue.isSelected() && newValue.getUserData() != null && newValue.getUserData() instanceof TableRowHighlightType && newValue instanceof RadioButton) {
                TableRowHighlight tableRowHighlight = TableRowHighlight.getInstance();
                TableRowHighlightType tableRowHighlightType = (TableRowHighlightType)((Object)newValue.getUserData());
                tableRowHighlight.setSelectedTableRowHighlightType(tableRowHighlightType);
                if (TableRowHighlightDialog.this.highlightRangeFieldMap.containsKey((Object)tableRowHighlightType) && TableRowHighlightDialog.this.highlightRangeFieldMap.get((Object)tableRowHighlightType) != null) {
                    DoubleTextField[] fields = TableRowHighlightDialog.this.highlightRangeFieldMap.get((Object)tableRowHighlightType);
                    double leftBoundary = fields[0].getNumber();
                    double rightBoundary = fields[1].getNumber();
                    tableRowHighlight.setRange(tableRowHighlightType, leftBoundary, rightBoundary);
                }
                TableRowHighlightDialog.this.save();
            }
        }
    }
}

