/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dialog.ScopeType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.util.ObservableLimitedList;

public class SearchAndReplaceDialog {
    private I18N i18n = I18N.getInstance();
    private static SearchAndReplaceDialog searchAndReplaceDialog = new SearchAndReplaceDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private ComboBox<String> searchComboBox = new ComboBox();
    private ComboBox<String> replaceComboBox = new ComboBox();
    private Label statusLabel = new Label();
    private RadioButton normalModeRadioButton;
    private RadioButton regularExpressionRadioButton;
    private CheckBox keepDialogOpenCheckBox;
    private CheckBox deleteCollisionsCheckBox;
    private ComboBox<ScopeType> scopeTypeComboBox;
    private TreeItemValue itemValue;
    private TreeItemValue[] selectedTreeItemValues;

    private SearchAndReplaceDialog() {
    }

    public static void setOwner(Window owner) {
        SearchAndReplaceDialog.searchAndReplaceDialog.window = owner;
    }

    public static Optional<Void> showAndWait(TreeItemValue itemValue, TreeItemValue ... selectedTreeItemValues) {
        SearchAndReplaceDialog.searchAndReplaceDialog.itemValue = itemValue;
        SearchAndReplaceDialog.searchAndReplaceDialog.selectedTreeItemValues = selectedTreeItemValues;
        searchAndReplaceDialog.init();
        SearchAndReplaceDialog.searchAndReplaceDialog.statusLabel.setText(null);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    SearchAndReplaceDialog.searchAndReplaceDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)SearchAndReplaceDialog.searchAndReplaceDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return SearchAndReplaceDialog.searchAndReplaceDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("SearchAndReplaceDialog.title", "Search and replace"));
        this.dialog.setHeaderText(this.i18n.getString("SearchAndReplaceDialog.header", "Search and replace point names"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        Button applyButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK);
        applyButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SearchAndReplaceDialog.this.save();
                if (SearchAndReplaceDialog.this.keepDialogOpenCheckBox.isSelected()) {
                    event.consume();
                }
            }
        });
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                return null;
            }
        });
    }

    private Node createPane() {
        this.searchComboBox = this.createComboBox(this.i18n.getString("SearchAndReplaceDialog.search.prompt", "Old point name"), this.i18n.getString("SearchAndReplaceDialog.search.tooltip", "Enter old point name"));
        this.replaceComboBox = this.createComboBox(this.i18n.getString("SearchAndReplaceDialog.replace.prompt", "New point name"), this.i18n.getString("SearchAndReplaceDialog.replace.tooltip", "Enter new point name"));
        this.normalModeRadioButton = this.createRadioButton(this.i18n.getString("SearchAndReplaceDialog.mode.normal.label", "Normal"), this.i18n.getString("SearchAndReplaceDialog.mode.normal.tooltip", "If selected, normal search and replace mode will be applied"));
        this.regularExpressionRadioButton = this.createRadioButton(this.i18n.getString("SearchAndReplaceDialog.mode.regex.label", "Regular expression"), this.i18n.getString("SearchAndReplaceDialog.mode.regex.tooltip", "If selected, regular expression mode will be applied"));
        this.keepDialogOpenCheckBox = this.createCheckBox(this.i18n.getString("SearchAndReplaceDialog.keep_open.label", "Keep dialog open after modification"), this.i18n.getString("SearchAndReplaceDialog.keep_open.tooltip", "If selected, dialog will be kept open after data modification"));
        this.keepDialogOpenCheckBox.setSelected(false);
        this.deleteCollisionsCheckBox = this.createCheckBox(this.i18n.getString("SearchAndReplaceDialog.remove_collisions.label", "Remove collisions arising from replacement"), this.i18n.getString("SearchAndReplaceDialog.remove_collisions.tooltip", "If selected, occurring database collisions such as duplicate point names will be removed"));
        this.deleteCollisionsCheckBox.setSelected(false);
        this.scopeTypeComboBox = this.createScopeTypeComboBox(ScopeType.SELECTION, this.i18n.getString("SearchAndReplaceDialog.scope.tooltip", "Select scope of application"));
        Button switchInputButton = new Button(this.i18n.getString("SearchAndReplaceDialog.switch.label", "\u21c5"));
        switchInputButton.setTooltip(new Tooltip(this.i18n.getString("SearchAndReplaceDialog.switch.tooltip", "Switch values")));
        switchInputButton.setStyle("-fx-font-size:2em");
        switchInputButton.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        switchInputButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String search = (String)SearchAndReplaceDialog.this.searchComboBox.getValue();
                String replace = (String)SearchAndReplaceDialog.this.replaceComboBox.getValue();
                SearchAndReplaceDialog.this.searchComboBox.setValue((Object)replace);
                SearchAndReplaceDialog.this.replaceComboBox.setValue((Object)search);
            }
        });
        Label scopeLabel = new Label(this.i18n.getString("SearchAndReplaceDialog.scope.label", "Scope:"));
        Label searchLabel = new Label(this.i18n.getString("SearchAndReplaceDialog.search.label", "Find what:"));
        Label replaceLabel = new Label(this.i18n.getString("SearchAndReplaceDialog.replace.label", "Replace with:"));
        Label modeLabel = new Label(this.i18n.getString("SearchAndReplaceDialog.mode.label", "Mode:"));
        scopeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        searchLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        replaceLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        switchInputButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        scopeLabel.setLabelFor(this.scopeTypeComboBox);
        searchLabel.setLabelFor(this.searchComboBox);
        replaceLabel.setLabelFor(this.replaceComboBox);
        ToggleGroup group = new ToggleGroup();
        group.getToggles().addAll((Object[])new Toggle[]{this.normalModeRadioButton, this.regularExpressionRadioButton});
        this.normalModeRadioButton.setSelected(true);
        HBox hbox = new HBox(10.0, new Node[]{this.normalModeRadioButton, this.regularExpressionRadioButton});
        hbox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        GridPane.setHgrow((Node)scopeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)searchLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)replaceLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)modeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)switchInputButton, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.searchComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.replaceComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)hbox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.scopeTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.keepDialogOpenCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.deleteCollisionsCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.statusLabel, (Priority)Priority.ALWAYS);
        int row = 1;
        gridPane.add((Node)scopeLabel, 0, row);
        gridPane.add(this.scopeTypeComboBox, 1, row++, 2, 1);
        gridPane.add((Node)switchInputButton, 3, row, 1, 2);
        gridPane.add((Node)searchLabel, 0, row);
        gridPane.add(this.searchComboBox, 1, row++, 2, 1);
        gridPane.add((Node)replaceLabel, 0, row);
        gridPane.add(this.replaceComboBox, 1, row++, 2, 1);
        gridPane.add((Node)modeLabel, 0, row);
        gridPane.add((Node)hbox, 1, row++, 2, 1);
        gridPane.add((Node)this.deleteCollisionsCheckBox, 1, row++, 2, 1);
        gridPane.add((Node)this.keepDialogOpenCheckBox, 1, row++, 2, 1);
        gridPane.add((Node)this.statusLabel, 1, row++, 2, 1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SearchAndReplaceDialog.this.searchComboBox.requestFocus();
            }
        });
        return gridPane;
    }

    private ComboBox<String> createComboBox(String promtText, String tooltip) {
        ComboBox comboBox = new ComboBox(new ObservableLimitedList(150));
        comboBox.setEditable(true);
        comboBox.setPromptText(promtText);
        comboBox.setTooltip(new Tooltip(tooltip));
        comboBox.setMinSize(250.0, Double.NEGATIVE_INFINITY);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        return comboBox;
    }

    private RadioButton createRadioButton(String text, String tooltip) {
        Label label = new Label(text);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxWidth(Double.MAX_VALUE);
        return radioButton;
    }

    private CheckBox createCheckBox(String text, String tooltip) {
        Label label = new Label(text);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxWidth(Double.MAX_VALUE);
        return checkBox;
    }

    private ComboBox<ScopeType> createScopeTypeComboBox(ScopeType item, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])ScopeType.values());
        typeComboBox.getSelectionModel().select((Object)item);
        typeComboBox.setConverter((StringConverter)new StringConverter<ScopeType>(){

            public String toString(ScopeType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case SELECTION: {
                        return SearchAndReplaceDialog.this.i18n.getString("SearchAndReplaceDialog.scope.selection.label", "Selected items");
                    }
                    case PROJECT: {
                        return SearchAndReplaceDialog.this.i18n.getString("SearchAndReplaceDialog.scope.project.label", "Whole project");
                    }
                    case REFERENCE_EPOCH: {
                        return SearchAndReplaceDialog.this.i18n.getString("SearchAndReplaceDialog.scope.reference_epoch.label", "Observations of reference epoch");
                    }
                    case CONTROL_EPOCH: {
                        return SearchAndReplaceDialog.this.i18n.getString("SearchAndReplaceDialog.scope.control_epoch.label", "Observations of control epoch");
                    }
                }
                return null;
            }

            public ScopeType fromString(String string) {
                return ScopeType.valueOf(string);
            }
        });
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private void save() {
        try {
            this.statusLabel.setText(null);
            this.searchComboBox.commitValue();
            this.replaceComboBox.commitValue();
            Object search = (String)this.searchComboBox.getValue();
            String replace = (String)this.replaceComboBox.getValue();
            search = search == null ? "" : search;
            String string = replace = replace == null ? "" : replace;
            if (!((String)search).isEmpty() && !this.searchComboBox.getItems().contains(search)) {
                this.searchComboBox.getItems().add(search);
            }
            this.searchComboBox.setValue(search);
            if (!replace.isEmpty() && !this.replaceComboBox.getItems().contains((Object)replace)) {
                this.replaceComboBox.getItems().add((Object)replace);
            }
            this.replaceComboBox.setValue((Object)replace);
            ScopeType scopeType = (ScopeType)((Object)this.scopeTypeComboBox.getValue());
            boolean regExp = this.regularExpressionRadioButton.isSelected();
            if (!regExp) {
                search = "^\\Q" + (String)search + "\\E";
            }
            boolean deleteCollisions = this.deleteCollisionsCheckBox.isSelected();
            int rows = SQLManager.getInstance().searchAndReplacePointNames((String)search, replace, scopeType, deleteCollisions, this.itemValue, this.selectedTreeItemValues);
            if (this.keepDialogOpenCheckBox.isSelected()) {
                this.statusLabel.setText(String.format(Locale.ENGLISH, this.i18n.getString("SearchAndReplaceDialog.result.label", "%d row(s) edited\u2026"), rows));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(SearchAndReplaceDialog.this.i18n.getString("SearchAndReplaceDialog.message.error.save.exception.title", "Unexpected SQL-Error"), SearchAndReplaceDialog.this.i18n.getString("SearchAndReplaceDialog.message.error.save.exception.header", "Error, could not save renamed points to database."), SearchAndReplaceDialog.this.i18n.getString("SearchAndReplaceDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }
}

