/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.network.DefectType;
import org.applied_geodesy.adjustment.network.RankDefect;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.ui.dialog.OptionDialog;

public class RankDefectDialog {
    private I18N i18n = I18N.getInstance();
    private static RankDefectDialog rankDefectDialog = new RankDefectDialog();
    private Dialog<RankDefect> dialog = null;
    private Window window;
    private CheckBox userDefinedCheckBox;
    private CheckBox translationXCheckBox;
    private CheckBox translationYCheckBox;
    private CheckBox translationZCheckBox;
    private CheckBox rotationXCheckBox;
    private CheckBox rotationYCheckBox;
    private CheckBox rotationZCheckBox;
    private CheckBox shearXCheckBox;
    private CheckBox shearYCheckBox;
    private CheckBox shearZCheckBox;
    private CheckBox scaleXCheckBox;
    private CheckBox scaleYCheckBox;
    private CheckBox scaleZCheckBox;
    private CheckBox scaleXYCheckBox;
    private CheckBox scaleXYZCheckBox;
    private Accordion accordion;

    private RankDefectDialog() {
    }

    public static void setOwner(Window owner) {
        RankDefectDialog.rankDefectDialog.window = owner;
    }

    public static Optional<RankDefect> showAndWait() {
        rankDefectDialog.init();
        rankDefectDialog.load();
        RankDefectDialog.rankDefectDialog.accordion.setExpandedPane((TitledPane)RankDefectDialog.rankDefectDialog.accordion.getPanes().get(0));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RankDefectDialog.rankDefectDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)RankDefectDialog.rankDefectDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return RankDefectDialog.rankDefectDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("RankDefectDialog.title", "Rank defect"));
        this.dialog.setHeaderText(this.i18n.getString("RankDefectDialog.header", "User defined rank defect properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, RankDefect>(){

            public RankDefect call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    RankDefect rankDefect = new RankDefect();
                    if (RankDefectDialog.this.userDefinedCheckBox.isSelected()) {
                        if (RankDefectDialog.this.translationYCheckBox.isSelected()) {
                            rankDefect.setTranslationYDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.translationXCheckBox.isSelected()) {
                            rankDefect.setTranslationXDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.translationZCheckBox.isSelected()) {
                            rankDefect.setTranslationZDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.rotationYCheckBox.isSelected()) {
                            rankDefect.setRotationYDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.rotationXCheckBox.isSelected()) {
                            rankDefect.setRotationXDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.rotationZCheckBox.isSelected()) {
                            rankDefect.setRotationZDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.shearYCheckBox.isSelected()) {
                            rankDefect.setShearYDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.shearXCheckBox.isSelected()) {
                            rankDefect.setShearXDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.shearZCheckBox.isSelected()) {
                            rankDefect.setShearZDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.scaleYCheckBox.isSelected()) {
                            rankDefect.setScaleYDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.scaleXCheckBox.isSelected()) {
                            rankDefect.setScaleXDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.scaleZCheckBox.isSelected()) {
                            rankDefect.setScaleZDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.scaleXYCheckBox.isSelected()) {
                            rankDefect.setScaleXYDefectType(DefectType.FREE);
                        }
                        if (RankDefectDialog.this.scaleXYZCheckBox.isSelected()) {
                            rankDefect.setScaleXYZDefectType(DefectType.FREE);
                        }
                    }
                    RankDefectDialog.this.save(rankDefect);
                }
                return null;
            }
        });
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                RankDefectDialog.this.accordion.setExpandedPane((TitledPane)RankDefectDialog.this.accordion.getPanes().get(0));
            }
        });
    }

    private Node createPane() {
        VBox box = this.createVbox();
        String labelUserDefined = this.i18n.getString("RankDefectDialog.userdefined.title", "User defined defect analysis");
        String tooltipUserDefined = this.i18n.getString("RankDefectDialog.userdefined.tooltip", "If checked, user defined condition equations will be applied (without examination) to free network adjustment");
        this.userDefinedCheckBox = this.createCheckBox(labelUserDefined, tooltipUserDefined);
        this.userDefinedCheckBox.selectedProperty().addListener((ChangeListener)new ScaleSelectionChangeListener(this.userDefinedCheckBox));
        this.accordion = new Accordion();
        this.accordion.getPanes().addAll((Object[])new TitledPane[]{this.createTranslationPane(), this.createRotationPane(), this.createScalePane(), this.createShearPane()});
        this.accordion.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RankDefectDialog.this.userDefinedCheckBox.requestFocus();
            }
        });
        box.getChildren().addAll((Object[])new Node[]{this.userDefinedCheckBox, this.accordion});
        return box;
    }

    private TitledPane createTranslationPane() {
        String title = this.i18n.getString("RankDefectDialog.translation.title", "Translations");
        String tooltip = this.i18n.getString("RankDefectDialog.translation.tooltip", "Condition equation for network translations");
        String labelY = this.i18n.getString("RankDefectDialog.translation.y.label", "Translation y");
        String tooltipY = this.i18n.getString("RankDefectDialog.translation.y.tooltip", "If checked, condition equation for y-translation will be applied to free network adjustment");
        String labelX = this.i18n.getString("RankDefectDialog.translation.x.label", "Translation x");
        String tooltipX = this.i18n.getString("RankDefectDialog.translation.x.tooltip", "If checked, condition equation for x-translation will be applied to free network adjustment");
        String labelZ = this.i18n.getString("RankDefectDialog.translation.z.label", "Translation z");
        String tooltipZ = this.i18n.getString("RankDefectDialog.translation.z.tooltip", "If checked, condition equation for z-translation will be applied to free network adjustment");
        this.translationYCheckBox = this.createCheckBox(labelY, tooltipY);
        this.translationXCheckBox = this.createCheckBox(labelX, tooltipX);
        this.translationZCheckBox = this.createCheckBox(labelZ, tooltipZ);
        VBox box = this.createVbox();
        box.getChildren().addAll((Object[])new Node[]{this.translationYCheckBox, this.translationXCheckBox, this.translationZCheckBox});
        return this.createTitledPane(title, tooltip, (Node)box);
    }

    private TitledPane createRotationPane() {
        String title = this.i18n.getString("RankDefectDialog.rotation.title", "Rotations");
        String tooltip = this.i18n.getString("RankDefectDialog.rotation.tooltip", "Condition equation for network rotations");
        String labelY = this.i18n.getString("RankDefectDialog.rotation.y.label", "Rotation y");
        String tooltipY = this.i18n.getString("RankDefectDialog.rotation.y.tooltip", "If checked, condition equation for y-rotation will be applied to free network adjustment");
        String labelX = this.i18n.getString("RankDefectDialog.rotation.x.label", "Rotation x");
        String tooltipX = this.i18n.getString("RankDefectDialog.rotation.x.tooltip", "If checked, condition equation for x-rotation will be applied to free network adjustment");
        String labelZ = this.i18n.getString("RankDefectDialog.rotation.z.label", "Rotation z");
        String tooltipZ = this.i18n.getString("RankDefectDialog.rotation.z.tooltip", "If checked, condition equation for z-rotation will be applied to free network adjustment");
        this.rotationYCheckBox = this.createCheckBox(labelY, tooltipY);
        this.rotationXCheckBox = this.createCheckBox(labelX, tooltipX);
        this.rotationZCheckBox = this.createCheckBox(labelZ, tooltipZ);
        VBox box = this.createVbox();
        box.getChildren().addAll((Object[])new Node[]{this.rotationYCheckBox, this.rotationXCheckBox, this.rotationZCheckBox});
        return this.createTitledPane(title, tooltip, (Node)box);
    }

    private TitledPane createShearPane() {
        String title = this.i18n.getString("RankDefectDialog.shear.title", "Shears");
        String tooltip = this.i18n.getString("RankDefectDialog.shear.tooltip", "Condition equation for network shears (unusual conditions)");
        String labelY = this.i18n.getString("RankDefectDialog.shear.y.label", "Shear y");
        String tooltipY = this.i18n.getString("RankDefectDialog.shear.y.tooltip", "If checked, condition equation for y-shear will be applied to free network adjustment");
        String labelX = this.i18n.getString("RankDefectDialog.shear.x.label", "Shear x");
        String tooltipX = this.i18n.getString("RankDefectDialog.shear.x.tooltip", "If checked, condition equation for x-shear will be applied to free network adjustment");
        String labelZ = this.i18n.getString("RankDefectDialog.shear.z.label", "Shear z");
        String tooltipZ = this.i18n.getString("RankDefectDialog.shear.z.tooltip", "If checked, condition equation for z-shear will be applied to free network adjustment");
        this.shearYCheckBox = this.createCheckBox(labelY, tooltipY);
        this.shearXCheckBox = this.createCheckBox(labelX, tooltipX);
        this.shearZCheckBox = this.createCheckBox(labelZ, tooltipZ);
        VBox box = this.createVbox();
        box.getChildren().addAll((Object[])new Node[]{this.shearYCheckBox, this.shearXCheckBox, this.shearZCheckBox});
        return this.createTitledPane(title, tooltip, (Node)box);
    }

    private TitledPane createScalePane() {
        String title = this.i18n.getString("RankDefectDialog.scale.title", "Scales");
        String tooltip = this.i18n.getString("RankDefectDialog.scale.tooltip", "Condition equation for network scales");
        String labelY = this.i18n.getString("RankDefectDialog.scale.y.label", "Scale y");
        String tooltipY = this.i18n.getString("RankDefectDialog.scale.y.tooltip", "If checked, condition equation for y-scale will be applied to free network adjustment");
        String labelX = this.i18n.getString("RankDefectDialog.scale.x.label", "Scale x");
        String tooltipX = this.i18n.getString("RankDefectDialog.scale.x.tooltip", "If checked, condition equation for x-scale will be applied to free network adjustment");
        String labelZ = this.i18n.getString("RankDefectDialog.scale.z.label", "Scale z");
        String tooltipZ = this.i18n.getString("RankDefectDialog.scale.z.tooltip", "If checked, condition equation for z-scale will be applied to free network adjustment");
        String labelXY = this.i18n.getString("RankDefectDialog.scale.xy.label", "Scale y, x");
        String tooltipXY = this.i18n.getString("RankDefectDialog.scale.xy.tooltip", "If checked, condition equation for horizontal scale will be applied to free network adjustment");
        String labelXYZ = this.i18n.getString("RankDefectDialog.scale.xyz.label", "Scale y, x, z");
        String tooltipXYZ = this.i18n.getString("RankDefectDialog.scale.xyz.tooltip", "If checked, condition equation for spatial scale will be applied to free network adjustment");
        this.scaleYCheckBox = this.createCheckBox(labelY, tooltipY);
        this.scaleYCheckBox.selectedProperty().addListener((ChangeListener)new ScaleSelectionChangeListener(this.scaleYCheckBox));
        this.scaleXCheckBox = this.createCheckBox(labelX, tooltipX);
        this.scaleXCheckBox.selectedProperty().addListener((ChangeListener)new ScaleSelectionChangeListener(this.scaleXCheckBox));
        this.scaleZCheckBox = this.createCheckBox(labelZ, tooltipZ);
        this.scaleZCheckBox.selectedProperty().addListener((ChangeListener)new ScaleSelectionChangeListener(this.scaleZCheckBox));
        this.scaleXYCheckBox = this.createCheckBox(labelXY, tooltipXY);
        this.scaleXYCheckBox.selectedProperty().addListener((ChangeListener)new ScaleSelectionChangeListener(this.scaleXYCheckBox));
        this.scaleXYZCheckBox = this.createCheckBox(labelXYZ, tooltipXYZ);
        this.scaleXYZCheckBox.selectedProperty().addListener((ChangeListener)new ScaleSelectionChangeListener(this.scaleXYZCheckBox));
        VBox leftBox = this.createVbox();
        leftBox.getChildren().addAll((Object[])new Node[]{this.scaleYCheckBox, this.scaleXCheckBox, this.scaleZCheckBox});
        VBox rightBox = this.createVbox();
        rightBox.getChildren().addAll((Object[])new Node[]{this.scaleXYCheckBox, this.scaleXYZCheckBox});
        HBox hbox = new HBox(0.0);
        hbox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        hbox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        hbox.getChildren().addAll((Object[])new Node[]{leftBox, rightBox});
        return this.createTitledPane(title, tooltip, (Node)hbox);
    }

    private TitledPane createTitledPane(String title, String tooltip, Node content) {
        TitledPane titledPane = new TitledPane();
        titledPane.setCollapsible(true);
        titledPane.setAnimated(true);
        titledPane.setContent(content);
        titledPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        titledPane.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        Label label = new Label(title);
        label.setTooltip(new Tooltip(tooltip));
        titledPane.setGraphic((Node)label);
        return titledPane;
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxWidth(Double.MAX_VALUE);
        return checkBox;
    }

    private VBox createVbox() {
        VBox vBox = new VBox();
        vBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        vBox.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        vBox.setSpacing(10.0);
        return vBox;
    }

    private void disableCheckBoxes(boolean disable) {
        this.translationYCheckBox.setDisable(disable);
        this.translationXCheckBox.setDisable(disable);
        this.translationZCheckBox.setDisable(disable);
        this.rotationYCheckBox.setDisable(disable);
        this.rotationXCheckBox.setDisable(disable);
        this.rotationZCheckBox.setDisable(disable);
        this.scaleYCheckBox.setDisable(disable);
        this.scaleXCheckBox.setDisable(disable);
        this.scaleZCheckBox.setDisable(disable);
        this.shearYCheckBox.setDisable(disable);
        this.shearXCheckBox.setDisable(disable);
        this.shearZCheckBox.setDisable(disable);
        this.scaleXYCheckBox.setDisable(disable);
        this.scaleXYZCheckBox.setDisable(disable);
    }

    private void save(RankDefect rankDefect) {
        try {
            boolean userDefined = this.userDefinedCheckBox.isSelected();
            if (userDefined && rankDefect.getDefect() == 0) {
                userDefined = false;
            }
            SQLManager.getInstance().save(userDefined, rankDefect);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(RankDefectDialog.this.i18n.getString("RankDefectDialog.message.error.save.exception.title", "Unexpected SQL-Error"), RankDefectDialog.this.i18n.getString("RankDefectDialog.message.error.save.exception.header", "Error, could not save user-defined rank defect properties to database."), RankDefectDialog.this.i18n.getString("RankDefectDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void load() {
        try {
            RankDefect rankDefect = SQLManager.getInstance().getRankDefectDefinition();
            this.userDefinedCheckBox.setSelected(rankDefect.isUserDefinedRankDefect());
            this.disableCheckBoxes(!rankDefect.isUserDefinedRankDefect());
            if (rankDefect.isUserDefinedRankDefect()) {
                this.translationYCheckBox.setSelected(rankDefect.estimateTranslationY());
                this.translationXCheckBox.setSelected(rankDefect.estimateTranslationX());
                this.translationZCheckBox.setSelected(rankDefect.estimateTranslationZ());
                this.rotationYCheckBox.setSelected(rankDefect.estimateRotationY());
                this.rotationXCheckBox.setSelected(rankDefect.estimateRotationX());
                this.rotationZCheckBox.setSelected(rankDefect.estimateRotationZ());
                this.shearYCheckBox.setSelected(rankDefect.estimateShearY());
                this.shearXCheckBox.setSelected(rankDefect.estimateShearX());
                this.shearZCheckBox.setSelected(rankDefect.estimateShearZ());
                this.scaleYCheckBox.setSelected(rankDefect.estimateScaleY());
                this.scaleXCheckBox.setSelected(rankDefect.estimateScaleX());
                this.scaleZCheckBox.setSelected(rankDefect.estimateScaleZ());
                this.scaleXYCheckBox.setSelected(rankDefect.estimateScaleXY());
                this.scaleXYZCheckBox.setSelected(rankDefect.estimateScaleXYZ());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(RankDefectDialog.this.i18n.getString("RankDefectDialog.message.error.load.exception.title", "Unexpected SQL-Error"), RankDefectDialog.this.i18n.getString("RankDefectDialog.message.error.load.exception.header", "Error, could not load user-defined rank defect properties from database."), RankDefectDialog.this.i18n.getString("RankDefectDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private class ScaleSelectionChangeListener
    implements ChangeListener<Boolean> {
        private CheckBox checkBox;

        private ScaleSelectionChangeListener(CheckBox checkBox) {
            this.checkBox = checkBox;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (this.checkBox == RankDefectDialog.this.userDefinedCheckBox) {
                RankDefectDialog.this.disableCheckBoxes(!RankDefectDialog.this.userDefinedCheckBox.isSelected());
            } else {
                if ((this.checkBox == RankDefectDialog.this.scaleXYCheckBox || this.checkBox == RankDefectDialog.this.scaleXYZCheckBox) && this.checkBox.isSelected()) {
                    RankDefectDialog.this.scaleXCheckBox.setSelected(false);
                    RankDefectDialog.this.scaleYCheckBox.setSelected(false);
                    if (RankDefectDialog.this.scaleXYZCheckBox == this.checkBox) {
                        RankDefectDialog.this.scaleZCheckBox.setSelected(false);
                        RankDefectDialog.this.scaleXYCheckBox.setSelected(false);
                    } else {
                        RankDefectDialog.this.scaleXYZCheckBox.setSelected(false);
                    }
                }
                if ((this.checkBox == RankDefectDialog.this.scaleXCheckBox || this.checkBox == RankDefectDialog.this.scaleYCheckBox || this.checkBox == RankDefectDialog.this.scaleZCheckBox) && this.checkBox.isSelected()) {
                    RankDefectDialog.this.scaleXYZCheckBox.setSelected(false);
                    if (RankDefectDialog.this.scaleZCheckBox != this.checkBox) {
                        RankDefectDialog.this.scaleXYCheckBox.setSelected(false);
                    }
                }
            }
        }
    }
}

