/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.network.observation.reduction.ProjectionType;
import org.applied_geodesy.adjustment.network.observation.reduction.Reduction;
import org.applied_geodesy.adjustment.network.observation.reduction.ReductionTaskType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.transformation.datum.Ellipsoid;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class ProjectionAndReductionDialog {
    private I18N i18n = I18N.getInstance();
    private static ProjectionAndReductionDialog projectionAndReductionDialog = new ProjectionAndReductionDialog();
    private Dialog<Reduction> dialog = null;
    private Window window;
    private DoubleTextField referenceHeightTextField;
    private DoubleTextField referenceLatitudeTextField;
    private DoubleTextField referenceLongitudeTextField;
    private DoubleTextField principalPointX0TextField;
    private DoubleTextField principalPointY0TextField;
    private DoubleTextField principalPointZ0TextField;
    private DoubleTextField majorAxisTextField;
    private DoubleTextField minorAxisTextField;
    private CheckBox directionReductionCheckBox;
    private CheckBox heightReductionCheckBox;
    private CheckBox distanceReductionCheckBox;
    private CheckBox earthCurvatureReductionCheckBox;
    private RadioButton localCartesianProjectionRadioButton;
    private RadioButton gaussKruegerProjectionRadioButton;
    private RadioButton utmProjectionRadioButton;
    private RadioButton ellipsoidalProjectionRadioButton;
    private static final double EQUATORIAL_RADIUS = 6385000.0;
    private static final double POLAR_RADIUS = 6300000.0;

    private ProjectionAndReductionDialog() {
    }

    public static void setOwner(Window owner) {
        ProjectionAndReductionDialog.projectionAndReductionDialog.window = owner;
    }

    public static Optional<Reduction> showAndWait() {
        projectionAndReductionDialog.init();
        projectionAndReductionDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectionAndReductionDialog.projectionAndReductionDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)ProjectionAndReductionDialog.projectionAndReductionDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ProjectionAndReductionDialog.projectionAndReductionDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("ProjectionAndReductionDialog.title", "Projection and reductions"));
        this.dialog.setHeaderText(this.i18n.getString("ProjectionAndReductionDialog.header", "Projection and reduction properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Reduction>(){

            public Reduction call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    Reduction reductions = new Reduction();
                    double majorAxis = ProjectionAndReductionDialog.this.majorAxisTextField.getNumber();
                    double minorAxis = ProjectionAndReductionDialog.this.minorAxisTextField.getNumber();
                    double referenceLatitude = ProjectionAndReductionDialog.this.referenceLatitudeTextField.getNumber();
                    double referenceLongitude = ProjectionAndReductionDialog.this.referenceLongitudeTextField.getNumber();
                    double referenceHeight = ProjectionAndReductionDialog.this.referenceHeightTextField.getNumber();
                    double x0 = ProjectionAndReductionDialog.this.principalPointX0TextField.getNumber();
                    double y0 = ProjectionAndReductionDialog.this.principalPointY0TextField.getNumber();
                    double z0 = ProjectionAndReductionDialog.this.principalPointZ0TextField.getNumber();
                    ProjectionType projectionType = ProjectionType.LOCAL_CARTESIAN;
                    if (ProjectionAndReductionDialog.this.utmProjectionRadioButton.isSelected()) {
                        projectionType = ProjectionType.UTM;
                    } else if (ProjectionAndReductionDialog.this.gaussKruegerProjectionRadioButton.isSelected()) {
                        projectionType = ProjectionType.GAUSS_KRUEGER;
                    } else if (ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected()) {
                        projectionType = ProjectionType.LOCAL_ELLIPSOIDAL;
                    }
                    reductions.setEllipsoid(Ellipsoid.createEllipsoidFromMinorAxis(Math.max(majorAxis, minorAxis), Math.min(majorAxis, minorAxis)));
                    reductions.getPrincipalPoint().setCoordinates(x0, y0, z0, referenceLatitude, referenceLongitude, referenceHeight);
                    reductions.setProjectionType(projectionType);
                    if (ProjectionAndReductionDialog.this.directionReductionCheckBox.isSelected()) {
                        reductions.addReductionTaskType(ReductionTaskType.DIRECTION);
                    }
                    if (ProjectionAndReductionDialog.this.distanceReductionCheckBox.isSelected()) {
                        reductions.addReductionTaskType(ReductionTaskType.DISTANCE);
                    }
                    if (ProjectionAndReductionDialog.this.heightReductionCheckBox.isSelected()) {
                        reductions.addReductionTaskType(ReductionTaskType.HEIGHT);
                    }
                    if (ProjectionAndReductionDialog.this.earthCurvatureReductionCheckBox.isSelected()) {
                        reductions.addReductionTaskType(ReductionTaskType.EARTH_CURVATURE);
                    }
                    ProjectionAndReductionDialog.this.save(reductions);
                    return reductions;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        VBox propertiesBox = this.createVbox();
        propertiesBox.getChildren().addAll((Object[])new Node[]{this.createProjectionPane(), this.createReductionOptionsPane()});
        VBox parameterBox = this.createVbox();
        parameterBox.getChildren().addAll((Object[])new Node[]{this.createParameterPane()});
        HBox.setHgrow((Node)propertiesBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)parameterBox, (Priority)Priority.ALWAYS);
        HBox hbox = this.createHbox();
        hbox.getChildren().addAll((Object[])new Node[]{propertiesBox, parameterBox});
        return hbox;
    }

    private TitledPane createProjectionPane() {
        String title = this.i18n.getString("ProjectionAndReductionDialog.properties.title", "Properties");
        String tooltip = this.i18n.getString("ProjectionAndReductionDialog.properties.tooltip", "Projection properties");
        String labelProjLocalCartesian = this.i18n.getString("ProjectionAndReductionDialog.properties.local_cartesian.label", "Local Cartesian system");
        String tooltipProjLocalCartesian = this.i18n.getString("ProjectionAndReductionDialog.properties.local_cartesian.tooltip", "If selected, a local Cartesian system will be used");
        String labelProjGK = this.i18n.getString("ProjectionAndReductionDialog.properties.gauss_krueger.label", "Gau\u00df-Kr\u00fcger");
        String tooltipProjGK = this.i18n.getString("ProjectionAndReductionDialog.properties.gauss_krueger.tooltip", "If selected, Gau\u00df-Kr\u00fcger projection will be applied");
        String labelProjUTM = this.i18n.getString("ProjectionAndReductionDialog.properties.utm.label", "Universale Transverse Mercator");
        String tooltipProjUTM = this.i18n.getString("ProjectionAndReductionDialog.properties.utm.tooltip", "If selected, UTM projection will be applied");
        String labelProjEllipsoidal = this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoidal.label", "Local ellipsoidal system");
        String tooltipProjEllipsoidal = this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoidal.tooltip", "If selected, a local ellipsoidal Earth model will be used");
        ProjectionSelectionChangeListener projectionSelectionChangeListener = new ProjectionSelectionChangeListener();
        this.localCartesianProjectionRadioButton = this.createRadioButton(labelProjLocalCartesian, tooltipProjLocalCartesian);
        this.gaussKruegerProjectionRadioButton = this.createRadioButton(labelProjGK, tooltipProjGK);
        this.utmProjectionRadioButton = this.createRadioButton(labelProjUTM, tooltipProjUTM);
        this.ellipsoidalProjectionRadioButton = this.createRadioButton(labelProjEllipsoidal, tooltipProjEllipsoidal);
        ToggleGroup group = new ToggleGroup();
        group.getToggles().addAll((Object[])new Toggle[]{this.localCartesianProjectionRadioButton, this.utmProjectionRadioButton, this.gaussKruegerProjectionRadioButton, this.ellipsoidalProjectionRadioButton});
        group.selectedToggleProperty().addListener((ChangeListener)projectionSelectionChangeListener);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(7.0);
        gridPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        GridPane.setHgrow((Node)this.localCartesianProjectionRadioButton, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.gaussKruegerProjectionRadioButton, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.utmProjectionRadioButton, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.ellipsoidalProjectionRadioButton, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)this.localCartesianProjectionRadioButton, 0, ++row, 1, 1);
        gridPane.add((Node)this.ellipsoidalProjectionRadioButton, 0, ++row, 1, 1);
        gridPane.add((Node)this.gaussKruegerProjectionRadioButton, 0, ++row, 1, 1);
        gridPane.add((Node)this.utmProjectionRadioButton, 0, ++row, 1, 1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectionAndReductionDialog.this.localCartesianProjectionRadioButton.requestFocus();
            }
        });
        return this.createTitledPane(title, tooltip, (Node)gridPane);
    }

    private TitledPane createReductionOptionsPane() {
        String title = this.i18n.getString("ProjectionAndReductionDialog.reduction.title", "Reduction options");
        String tooltip = this.i18n.getString("ProjectionAndReductionDialog.reduction.tooltip", "Observation reductions");
        String distanceLabel = this.i18n.getString("ProjectionAndReductionDialog.reduction.distance.label", "Horizontal distance reduction");
        String distanceTooltip = this.i18n.getString("ProjectionAndReductionDialog.reduction.distance.tooltip", "If checked, horizontal distance reduction will be applied during network adjustment");
        String directionLabel = this.i18n.getString("ProjectionAndReductionDialog.reduction.direction.label", "Direction reduction");
        String directionTooltip = this.i18n.getString("ProjectionAndReductionDialog.reduction.direction.tooltip", "If checked, direction reduction will be applied during network adjustment");
        String earthCurvatureLabel = this.i18n.getString("ProjectionAndReductionDialog.reduction.earth_curvature.label", "Earth's curvature reduction");
        String earthCurvatureTooltip = this.i18n.getString("ProjectionAndReductionDialog.reduction.earth_curvature.tooltip", "If checked, Earth's curvature reduction will be applied to horizontal distances and zenith angles during network adjustment");
        String heightLabel = this.i18n.getString("ProjectionAndReductionDialog.reduction.height.label", "Height reduction");
        String heightTooltip = this.i18n.getString("ProjectionAndReductionDialog.reduction.height.tooltip", "If checked, height reduction will be applied to horizontal distances during network adjustment");
        this.distanceReductionCheckBox = this.createCheckBox(distanceLabel, distanceTooltip);
        this.directionReductionCheckBox = this.createCheckBox(directionLabel, directionTooltip);
        this.heightReductionCheckBox = this.createCheckBox(heightLabel, heightTooltip);
        this.earthCurvatureReductionCheckBox = this.createCheckBox(earthCurvatureLabel, earthCurvatureTooltip);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(7.0);
        gridPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        GridPane.setHgrow((Node)this.distanceReductionCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.heightReductionCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.directionReductionCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.earthCurvatureReductionCheckBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)this.distanceReductionCheckBox, 0, ++row, 1, 1);
        gridPane.add((Node)this.directionReductionCheckBox, 0, ++row, 1, 1);
        gridPane.add((Node)this.heightReductionCheckBox, 0, ++row, 1, 1);
        gridPane.add((Node)this.earthCurvatureReductionCheckBox, 0, ++row, 1, 1);
        return this.createTitledPane(title, tooltip, (Node)gridPane);
    }

    private TitledPane createParameterPane() {
        String title = this.i18n.getString("ProjectionAndReductionDialog.parameter.title", "Parameter");
        String tooltip = this.i18n.getString("ProjectionAndReductionDialog.parameter.tooltip", "Parameters of projection model");
        this.majorAxisTextField = new DoubleTextField(6371007.0, CellValueType.LENGTH, true, DoubleTextField.ValueSupport.INCLUDING_INCLUDING_INTERVAL, 6300000.0, 6385000.0);
        this.majorAxisTextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.ellipsoid.major_axis.tooltip", "Major axis length of reference ellipsoid")));
        this.majorAxisTextField.setMinWidth(100.0);
        this.majorAxisTextField.setPrefWidth(150.0);
        this.majorAxisTextField.setMaxWidth(Double.MAX_VALUE);
        this.minorAxisTextField = new DoubleTextField(6371007.0, CellValueType.LENGTH, true, DoubleTextField.ValueSupport.INCLUDING_INCLUDING_INTERVAL, 6300000.0, 6385000.0);
        this.minorAxisTextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.ellipsoid.minor_axis.tooltip", "Minor axis length of reference ellipsoid")));
        this.minorAxisTextField.setMinWidth(100.0);
        this.minorAxisTextField.setPrefWidth(150.0);
        this.minorAxisTextField.setMaxWidth(Double.MAX_VALUE);
        this.referenceLatitudeTextField = new DoubleTextField(0.0, CellValueType.ANGLE, true, DoubleTextField.ValueSupport.INCLUDING_INCLUDING_INTERVAL, -1.5707963267948966 - Math.sqrt(Constant.EPS), 1.5707963267948966 + Math.sqrt(Constant.EPS));
        this.referenceLatitudeTextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.latitude.tooltip", "Latitude of principal point")));
        this.referenceLatitudeTextField.setMinWidth(100.0);
        this.referenceLatitudeTextField.setPrefWidth(150.0);
        this.referenceLatitudeTextField.setMaxWidth(Double.MAX_VALUE);
        this.referenceLongitudeTextField = new DoubleTextField(0.0, CellValueType.ANGLE, true, DoubleTextField.ValueSupport.INCLUDING_INCLUDING_INTERVAL, -Math.PI - Math.sqrt(Constant.EPS), Math.PI + Math.sqrt(Constant.EPS));
        this.referenceLongitudeTextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.longitude.tooltip", "Longitude of principal point")));
        this.referenceLongitudeTextField.setMinWidth(100.0);
        this.referenceLongitudeTextField.setPrefWidth(150.0);
        this.referenceLongitudeTextField.setMaxWidth(Double.MAX_VALUE);
        this.referenceHeightTextField = new DoubleTextField(0.0, CellValueType.LENGTH, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT);
        this.referenceHeightTextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.height.tooltip", "Height w.r.t. survey datum")));
        this.referenceHeightTextField.setMinWidth(100.0);
        this.referenceHeightTextField.setPrefWidth(150.0);
        this.referenceHeightTextField.setMaxWidth(Double.MAX_VALUE);
        this.principalPointX0TextField = new DoubleTextField(0.0, CellValueType.LENGTH, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT);
        this.principalPointX0TextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.x0.tooltip", "x-component of (local) principal point")));
        this.principalPointX0TextField.setMinWidth(30.0);
        this.principalPointX0TextField.setPrefWidth(50.0);
        this.principalPointX0TextField.setMaxWidth(Double.MAX_VALUE);
        this.principalPointY0TextField = new DoubleTextField(0.0, CellValueType.LENGTH, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT);
        this.principalPointY0TextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.y0.tooltip", "y-component of (local) principal point")));
        this.principalPointY0TextField.setMinWidth(30.0);
        this.principalPointY0TextField.setPrefWidth(50.0);
        this.principalPointY0TextField.setMaxWidth(Double.MAX_VALUE);
        this.principalPointZ0TextField = new DoubleTextField(0.0, CellValueType.LENGTH, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT);
        this.principalPointZ0TextField.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.z0.tooltip", "z-component of (local) principal point")));
        this.principalPointZ0TextField.setMinWidth(30.0);
        this.principalPointZ0TextField.setPrefWidth(50.0);
        this.principalPointZ0TextField.setMaxWidth(Double.MAX_VALUE);
        Label majorAxisLabel = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.ellipsoid.major_axis.label", "Major axis a:"));
        majorAxisLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        majorAxisLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        majorAxisLabel.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        majorAxisLabel.setLabelFor((Node)this.majorAxisTextField);
        Label minorAxisLabel = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.ellipsoid.minor_axis.label", "Minor axis b:"));
        minorAxisLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        minorAxisLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        minorAxisLabel.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        minorAxisLabel.setLabelFor((Node)this.minorAxisTextField);
        Label referenceLatitudeLabel = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.latitude.label", "Reference latitude \u03c60:"));
        referenceLatitudeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        referenceLatitudeLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        referenceLatitudeLabel.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        referenceLatitudeLabel.setLabelFor((Node)this.referenceLatitudeTextField);
        Label referenceLongitudeLabel = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.longitude.label", "Reference longitude \u03bb0:"));
        referenceLongitudeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        referenceLongitudeLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        referenceLongitudeLabel.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        referenceLongitudeLabel.setLabelFor((Node)this.referenceLongitudeTextField);
        Label referenceHeightLabel = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.height.label", "Reference height h0:"));
        referenceHeightLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        referenceHeightLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        referenceHeightLabel.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        referenceHeightLabel.setLabelFor((Node)this.referenceHeightTextField);
        Label principalPointPointX0Label = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.x0.label", "Principal point x0:"));
        principalPointPointX0Label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        principalPointPointX0Label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        principalPointPointX0Label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        principalPointPointX0Label.setLabelFor((Node)this.principalPointX0TextField);
        Label principalPointPointY0Label = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.y0.label", "Principal point y0:"));
        principalPointPointY0Label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        principalPointPointY0Label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        principalPointPointY0Label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        principalPointPointY0Label.setLabelFor((Node)this.principalPointY0TextField);
        Label principalPointPointZ0Label = new Label(this.i18n.getString("ProjectionAndReductionDialog.parameter.principal_point.z0.label", "Principal point z0:"));
        principalPointPointZ0Label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        principalPointPointZ0Label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        principalPointPointZ0Label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        principalPointPointZ0Label.setLabelFor((Node)this.principalPointZ0TextField);
        HBox ellipsoidHbox = new HBox();
        ellipsoidHbox.setSpacing(0.0);
        ellipsoidHbox.getChildren().addAll((Object[])new Node[]{this.majorAxisTextField, this.getEllipsoidMenuBar()});
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(7.0);
        gridPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        GridPane.setHgrow((Node)majorAxisLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.majorAxisTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)minorAxisLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.minorAxisTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)referenceLatitudeLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.referenceLatitudeTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)referenceLongitudeLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.referenceLongitudeTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)referenceHeightLabel, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.referenceHeightTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)principalPointPointY0Label, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.principalPointY0TextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)principalPointPointX0Label, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.principalPointX0TextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)principalPointPointZ0Label, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)this.principalPointZ0TextField, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)majorAxisLabel, 0, ++row, 1, 1);
        gridPane.add((Node)ellipsoidHbox, 1, row, 1, 1);
        gridPane.add((Node)minorAxisLabel, 0, ++row, 1, 1);
        gridPane.add((Node)this.minorAxisTextField, 1, row, 1, 1);
        gridPane.add((Node)principalPointPointY0Label, 0, ++row, 1, 1);
        gridPane.add((Node)this.principalPointY0TextField, 1, row, 1, 1);
        gridPane.add((Node)principalPointPointX0Label, 0, ++row, 1, 1);
        gridPane.add((Node)this.principalPointX0TextField, 1, row, 1, 1);
        gridPane.add((Node)principalPointPointZ0Label, 0, ++row, 1, 1);
        gridPane.add((Node)this.principalPointZ0TextField, 1, row, 1, 1);
        gridPane.add((Node)referenceLatitudeLabel, 0, ++row, 1, 1);
        gridPane.add((Node)this.referenceLatitudeTextField, 1, row, 1, 1);
        gridPane.add((Node)referenceLongitudeLabel, 0, ++row, 1, 1);
        gridPane.add((Node)this.referenceLongitudeTextField, 1, row, 1, 1);
        gridPane.add((Node)referenceHeightLabel, 0, ++row, 1, 1);
        gridPane.add((Node)this.referenceHeightTextField, 1, row, 1, 1);
        return this.createTitledPane(title, tooltip, (Node)gridPane);
    }

    private void load() {
        try {
            Reduction reductions = new Reduction();
            SQLManager.getInstance().load(reductions);
            this.majorAxisTextField.setValue(reductions.getEllipsoid().getMajorAxis());
            this.minorAxisTextField.setValue(reductions.getEllipsoid().getMinorAxis());
            this.referenceLatitudeTextField.setValue(reductions.getPrincipalPoint().getLatitude());
            this.referenceLongitudeTextField.setValue(reductions.getPrincipalPoint().getLongitude());
            this.referenceHeightTextField.setValue(reductions.getPrincipalPoint().getHeight());
            this.principalPointX0TextField.setValue(reductions.getPrincipalPoint().getX());
            this.principalPointY0TextField.setValue(reductions.getPrincipalPoint().getY());
            this.principalPointZ0TextField.setValue(reductions.getPrincipalPoint().getZ());
            this.directionReductionCheckBox.setSelected(reductions.applyReductionTask(ReductionTaskType.DIRECTION));
            this.distanceReductionCheckBox.setSelected(reductions.applyReductionTask(ReductionTaskType.DISTANCE));
            this.heightReductionCheckBox.setSelected(reductions.applyReductionTask(ReductionTaskType.HEIGHT));
            this.earthCurvatureReductionCheckBox.setSelected(reductions.applyReductionTask(ReductionTaskType.EARTH_CURVATURE));
            ProjectionType projection = reductions.getProjectionType();
            this.localCartesianProjectionRadioButton.setSelected(true);
            this.gaussKruegerProjectionRadioButton.setSelected(projection == ProjectionType.GAUSS_KRUEGER);
            this.utmProjectionRadioButton.setSelected(projection == ProjectionType.UTM);
            this.ellipsoidalProjectionRadioButton.setSelected(projection == ProjectionType.LOCAL_ELLIPSOIDAL);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(ProjectionAndReductionDialog.this.i18n.getString("ProjectionAndReductionDialog.message.error.load.exception.title", "Unexpected SQL-Error"), ProjectionAndReductionDialog.this.i18n.getString("ProjectionAndReductionDialog.message.error.load.exception.header", "Error, could not load projection and reduction properties from database."), ProjectionAndReductionDialog.this.i18n.getString("ProjectionAndReductionDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void save(Reduction reductions) {
        try {
            SQLManager.getInstance().save(reductions);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(ProjectionAndReductionDialog.this.i18n.getString("ProjectionAndReductionDialog.message.error.save.exception.title", "Unexpected SQL-Error"), ProjectionAndReductionDialog.this.i18n.getString("ProjectionAndReductionDialog.message.error.save.exception.header", "Error, could not save projection and reduction properties to database"), ProjectionAndReductionDialog.this.i18n.getString("ProjectionAndReductionDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private RadioButton createRadioButton(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxHeight(Double.MAX_VALUE);
        return radioButton;
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxWidth(Double.MAX_VALUE);
        return checkBox;
    }

    private TitledPane createTitledPane(String title, String tooltip, Node content) {
        TitledPane titledPane = new TitledPane();
        titledPane.setCollapsible(false);
        titledPane.setAnimated(false);
        titledPane.setContent(content);
        titledPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        titledPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        titledPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Label label = new Label(title);
        label.setTooltip(new Tooltip(tooltip));
        titledPane.setGraphic((Node)label);
        return titledPane;
    }

    private VBox createVbox() {
        VBox vBox = new VBox();
        vBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        vBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        vBox.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        vBox.setSpacing(20.0);
        return vBox;
    }

    private HBox createHbox() {
        HBox hBox = new HBox();
        hBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        hBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        hBox.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        hBox.setSpacing(5.0);
        return hBox;
    }

    private MenuBar getEllipsoidMenuBar() {
        EllipsoidMenuEventHandler handler = new EllipsoidMenuEventHandler();
        MenuBar menuBar = new MenuBar();
        Label menuLabel = new Label(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.type.label", "\u25bc"));
        menuLabel.setTooltip(new Tooltip(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.type.tooltip", "Potential reference ellipsoids")));
        menuLabel.setPadding(new Insets(0.0));
        Menu menu = new Menu();
        menu.setGraphic((Node)menuLabel);
        menu.getItems().addAll((Object[])new MenuItem[]{this.getMenuItem(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.sphere.label", "Sphere"), EllipsoidType.SPHERE, handler), this.getMenuItem(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.grs80.label", "GRS80"), EllipsoidType.GRS80, handler), this.getMenuItem(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.wgs84.label", "WGS84"), EllipsoidType.WGS84, handler), this.getMenuItem(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.bessel.label", "Bessel 1941"), EllipsoidType.BESSEL_1941, handler), this.getMenuItem(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.krassowski.label", "Krassowski"), EllipsoidType.KRASSOWSKI, handler), this.getMenuItem(this.i18n.getString("ProjectionAndReductionDialog.properties.ellipsoid.hayford.label", "Hayford"), EllipsoidType.HAYFORD, handler)});
        menuBar.setPadding(new Insets(0.0));
        menuBar.getMenus().add((Object)menu);
        return menuBar;
    }

    private MenuItem getMenuItem(String name, EllipsoidType ellipsoidType, EllipsoidMenuEventHandler handler) {
        MenuItem item = new MenuItem(name);
        item.setOnAction((EventHandler)handler);
        item.setUserData((Object)ellipsoidType);
        return item;
    }

    private class EllipsoidMenuEventHandler
    implements EventHandler<ActionEvent> {
        private EllipsoidMenuEventHandler() {
        }

        public void handle(ActionEvent event) {
            MenuItem menuItem;
            if (event.getSource() instanceof MenuItem && (menuItem = (MenuItem)event.getSource()).getUserData() instanceof EllipsoidType) {
                EllipsoidType ellipsoidType = (EllipsoidType)((Object)menuItem.getUserData());
                Ellipsoid ellipsoid = Ellipsoid.SPHERE;
                switch (ellipsoidType) {
                    case BESSEL_1941: {
                        ellipsoid = Ellipsoid.BESSEL1941;
                        break;
                    }
                    case GRS80: {
                        ellipsoid = Ellipsoid.GRS80;
                        break;
                    }
                    case HAYFORD: {
                        ellipsoid = Ellipsoid.HAYFORD;
                        break;
                    }
                    case KRASSOWSKI: {
                        ellipsoid = Ellipsoid.KRASSOWSKI;
                        break;
                    }
                    case WGS84: {
                        ellipsoid = Ellipsoid.WGS84;
                        break;
                    }
                    default: {
                        ellipsoid = Ellipsoid.SPHERE;
                    }
                }
                ProjectionAndReductionDialog.this.majorAxisTextField.setValue(ellipsoid.getMajorAxis());
                ProjectionAndReductionDialog.this.minorAxisTextField.setValue(ellipsoid.getMinorAxis());
            }
        }
    }

    private static enum EllipsoidType {
        SPHERE,
        GRS80,
        WGS84,
        BESSEL_1941,
        KRASSOWSKI,
        HAYFORD;

    }

    private class ProjectionSelectionChangeListener
    implements ChangeListener<Toggle> {
        private ProjectionSelectionChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
            ProjectionAndReductionDialog.this.distanceReductionCheckBox.setDisable(ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected() || ProjectionAndReductionDialog.this.localCartesianProjectionRadioButton.isSelected());
            ProjectionAndReductionDialog.this.directionReductionCheckBox.setDisable(ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected() || ProjectionAndReductionDialog.this.localCartesianProjectionRadioButton.isSelected());
            ProjectionAndReductionDialog.this.heightReductionCheckBox.setDisable(ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected());
            ProjectionAndReductionDialog.this.earthCurvatureReductionCheckBox.setDisable(ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected());
            ProjectionAndReductionDialog.this.principalPointX0TextField.setDisable(!ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected());
            ProjectionAndReductionDialog.this.principalPointY0TextField.setDisable(!ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected());
            ProjectionAndReductionDialog.this.principalPointZ0TextField.setDisable(!ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected());
            ProjectionAndReductionDialog.this.referenceLongitudeTextField.setDisable(!ProjectionAndReductionDialog.this.ellipsoidalProjectionRadioButton.isSelected());
            if (ProjectionAndReductionDialog.this.utmProjectionRadioButton.isSelected() || ProjectionAndReductionDialog.this.gaussKruegerProjectionRadioButton.isSelected()) {
                ProjectionAndReductionDialog.this.distanceReductionCheckBox.setDisable(Boolean.FALSE.booleanValue());
                ProjectionAndReductionDialog.this.directionReductionCheckBox.setDisable(Boolean.FALSE.booleanValue());
            }
        }
    }
}

