/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.network.NetworkAdjustment;
import org.applied_geodesy.adjustment.network.sql.IllegalProjectionPropertyException;
import org.applied_geodesy.adjustment.network.sql.SQLAdjustmentManager;
import org.applied_geodesy.jag3d.sql.PointTypeMismatchException;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.sql.UnderDeterminedPointException;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.version.jag3d.DatabaseVersionMismatchException;

public class NetworkAdjustmentDialog {
    private static NetworkAdjustmentDialog adjustmentDialog = new NetworkAdjustmentDialog();
    private Window window;
    private AdjustmentTask adjustmentTask;
    private boolean preventClosing = false;
    private I18N i18n = I18N.getInstance();
    private Dialog<Void> dialog = null;
    private ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
    private Label iterationLabel = new Label();
    private Label progressLabel = new Label();

    private NetworkAdjustmentDialog() {
    }

    public static void show() {
        adjustmentDialog.init();
        adjustmentDialog.reset();
        NetworkAdjustmentDialog.adjustmentDialog.dialog.show();
        adjustmentDialog.process();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    NetworkAdjustmentDialog.adjustmentDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)NetworkAdjustmentDialog.adjustmentDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void setOwner(Window owner) {
        NetworkAdjustmentDialog.adjustmentDialog.window = owner;
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.initOwner(this.window);
        this.dialog.setTitle(this.i18n.getString("NetworkAdjustmentDialog.title", "Network adjustment"));
        this.dialog.setHeaderText(this.i18n.getString("NetworkAdjustmentDialog.header", "Network adjustment is processing\u2026"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{this.createProgressPane()});
        this.dialog.getDialogPane().getScene().getWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (NetworkAdjustmentDialog.this.preventClosing) {
                    event.consume();
                    if (NetworkAdjustmentDialog.this.adjustmentTask != null) {
                        NetworkAdjustmentDialog.this.adjustmentTask.cancelled();
                    }
                }
            }
        });
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                if (NetworkAdjustmentDialog.this.preventClosing) {
                    event.consume();
                    if (NetworkAdjustmentDialog.this.adjustmentTask != null) {
                        NetworkAdjustmentDialog.this.adjustmentTask.cancelled();
                    }
                }
            }
        });
        this.dialog.getDialogPane().setContent((Node)vbox);
    }

    private void reset() {
        this.progressIndicator.setProgress(-1.0);
        this.iterationLabel.setText(null);
        this.progressLabel.setText(null);
        this.preventClosing = false;
    }

    private Node createProgressPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMinWidth(400.0);
        gridPane.setHgap(20.0);
        gridPane.setVgap(15.0);
        gridPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.progressIndicator.setMinWidth(50.0);
        this.progressIndicator.setMinHeight(50.0);
        gridPane.add((Node)this.progressIndicator, 0, 0, 1, 3);
        gridPane.add((Node)this.iterationLabel, 1, 0);
        gridPane.add((Node)this.progressLabel, 1, 1);
        return gridPane;
    }

    private void process() {
        this.reset();
        this.adjustmentTask = new AdjustmentTask(SQLManager.getInstance().getAdjustmentManager());
        this.adjustmentTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                EstimationStateType result = (EstimationStateType)((Object)NetworkAdjustmentDialog.this.adjustmentTask.getValue());
                if (result != null) {
                    switch (result) {
                        case ROBUST_ESTIMATION_FAILED: 
                        case NO_CONVERGENCE: {
                            OptionDialog.showErrorDialog(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.noconvergence.title", "Network adjustment failed"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.noconvergence.header", "Iteration process diverges"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.noconvergence.message", "Error, iteration limit of adjustment process reached but without satisfactory convergence."));
                            break;
                        }
                        case SINGULAR_MATRIX: 
                        case NOT_INITIALISED: {
                            OptionDialog.showErrorDialog(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.singularmatrix.title", "Network adjustment failed"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.singularmatrix.header", "Singular normal euqation matrix"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.singularmatrix.message", "Error, could not invert normal equation matrix."));
                            break;
                        }
                        case EXPORT_ADJUSTMENT_RESULTS_FAILED: {
                            OptionDialog.showErrorDialog(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.export.title", "I/O error"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.export.header", "Export adjustment result failed"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.export.message", "Error, could not export network adjustment result."));
                            break;
                        }
                        case OUT_OF_MEMORY: {
                            OptionDialog.showErrorDialog(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.outofmemory.title", "Network adjustment failed"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.outofmemory.header", "Out of memory"), NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.outofmemory.message", "Error, not enough memory to adjust network. Please allocate more memory."));
                            break;
                        }
                    }
                }
                UITreeBuilder.getInstance().handleTreeSelections();
            }
        });
        this.adjustmentTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                NetworkAdjustmentDialog.this.preventClosing = false;
                NetworkAdjustmentDialog.this.dialog.hide();
                final Throwable throwable = NetworkAdjustmentDialog.this.adjustmentTask.getException();
                if (throwable != null) {
                    if (throwable instanceof PointTypeMismatchException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.pointtypemismatch.exception.title", "Initialization error"), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.pointtypemismatch.exception.header", "Error, the project contains uncombinable point typs, i.e. datum points as well as reference or stochastic points."), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.pointtypemismatch.exception.message", "An exception has occurred during network adjustment."), throwable);
                            }
                        });
                    } else if (throwable instanceof UnderDeterminedPointException) {
                        final UnderDeterminedPointException e = (UnderDeterminedPointException)throwable;
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.underdeterminded.exception.title", "Initialization error"), String.format((this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.underdeterminded.exception.header", "Error, the point %s of dimension %d has only %d observations and is indeterminable."), e.getPointName(), e.getDimension(), e.getNumberOfObservations()), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.underdeterminded.exception.message", "An exception has occurred during network adjustment."), throwable);
                            }
                        });
                    } else if (throwable instanceof IllegalProjectionPropertyException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.projection.exception.title", "Initialization error"), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.projection.exception.header", "Error, the project contains unsupported projection properties."), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.projection.exception.message", "An exception has occurred during network adjustment."), throwable);
                            }
                        });
                    } else if (throwable instanceof DatabaseVersionMismatchException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.databaseversion.exception.title", "Version error"), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.databaseversion.exception.header", "Error, the database version is unsupported."), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.databaseversion.exception.message", "An exception has occurred during network adjustment."), throwable);
                            }
                        });
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.exception.title", "Network adjustment failed"), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.exception.header", "Error, could not adjust network."), (this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.message.error.failed.exception.message", "An exception has occurred during network adjustment."), throwable);
                            }
                        });
                    }
                    throwable.printStackTrace();
                }
                UITreeBuilder.getInstance().getTree().getSelectionModel().select(0);
            }
        });
        Thread th = new Thread((Runnable)((Object)this.adjustmentTask));
        th.setDaemon(true);
        th.start();
    }

    private class AdjustmentTask
    extends Task<EstimationStateType>
    implements PropertyChangeListener {
        private final String iterationTextTemplate;
        private final String convergenceTextTemplate;
        private final String unscentedTransformationTextTemplate;
        private NetworkAdjustment adjustment;
        private double processState = 0.0;
        private double finalStepProcesses = 0.0;
        private SQLAdjustmentManager dataBaseManager;
        private boolean updateProgressOnIterate = true;

        private AdjustmentTask(SQLAdjustmentManager dataBaseManager) {
            this.dataBaseManager = dataBaseManager;
            this.unscentedTransformationTextTemplate = NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.unscentedtransformation.label", "%d. unscented transformation step of %d \u2026");
            this.iterationTextTemplate = NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.iteration.label", "%d. iteration step of maximal %d \u2026");
            this.convergenceTextTemplate = NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.convergence.label", "Convergence max|dx| = %.2e");
        }

        protected EstimationStateType call() throws Exception {
            try {
                NetworkAdjustmentDialog.this.preventClosing = true;
                this.updateProgress(-1.0, -1.0);
                this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.initialize.label", "Initialize process\u2026"));
                this.updateIterationProgressMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.pleasewait.label", "Please wait\u2026"));
                this.updateConvergenceProgressMessage(null);
                SQLManager.getInstance().checkNumberOfObersvationsPerUnknownParameter();
                this.adjustment = this.dataBaseManager.getNetworkAdjustment();
                this.updateProgressOnIterate = this.adjustment.getEstimationType() != EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION && this.adjustment.getEstimationType() != EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION;
                this.finalStepProcesses = 0.25 / (this.adjustment.hasAdjustmentResultWriter() ? 5.0 : 4.0);
                this.adjustment.addPropertyChangeListener(this);
                this.processState = 0.0;
                this.updateProgress(this.processState, 1.0);
                if (this.isCancelled()) {
                    EstimationStateType estimationStateType = EstimationStateType.INTERRUPT;
                    return estimationStateType;
                }
                EstimationStateType returnType = this.adjustment.estimateModel();
                if (this.isCancelled()) {
                    EstimationStateType estimationStateType = EstimationStateType.INTERRUPT;
                    return estimationStateType;
                }
                this.updateProgress(-1.0, -1.0);
                this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.save.label", "Save results\u2026"));
                this.updateIterationProgressMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.pleasewait.label", "Please wait\u2026"));
                this.updateConvergenceProgressMessage(null);
                this.dataBaseManager.saveResults();
                this.dataBaseManager.clear();
                EstimationStateType estimationStateType = returnType;
                return estimationStateType;
            }
            finally {
                this.destroyNetworkAdjustment();
                this.updateIterationProgressMessage(null);
                this.updateConvergenceProgressMessage(null);
                NetworkAdjustmentDialog.this.preventClosing = false;
            }
        }

        protected void succeeded() {
            NetworkAdjustmentDialog.this.preventClosing = false;
            super.succeeded();
            this.hideDialog();
        }

        protected void failed() {
            NetworkAdjustmentDialog.this.preventClosing = false;
            super.failed();
            this.hideDialog();
        }

        protected void cancelled() {
            super.cancelled();
            if (this.adjustment != null) {
                this.adjustment.interrupt();
            }
        }

        private void hideDialog() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.preventClosing) {
                        ((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.dialog.hide();
                    }
                }
            });
        }

        private void updateIterationProgressMessage(final String message) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.iterationLabel.setText(message);
                }
            });
        }

        private void updateConvergenceProgressMessage(final String message) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.progressLabel.setText(message);
                }
            });
        }

        protected void updateMessage(final String message) {
            super.updateMessage(message);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.dialog.setHeaderText(message);
                }
            });
        }

        protected void updateProgress(final double workDone, double max) {
            super.updateProgress(workDone, max);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Node node;
                    ((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.progressIndicator.setProgress(workDone);
                    if (workDone >= 1.0 && (node = ((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.progressIndicator.lookup(".percentage")) != null && node instanceof Text) {
                        Text text = (Text)node;
                        text.setText(((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.done.label", "Done"));
                        ((AdjustmentTask)AdjustmentTask.this).NetworkAdjustmentDialog.this.progressIndicator.setPrefWidth(text.getLayoutBounds().getWidth());
                    }
                }
            });
        }

        private void destroyNetworkAdjustment() {
            if (this.adjustment != null) {
                this.adjustment.removePropertyChangeListener(this);
                this.adjustment.clearMatrices();
                this.adjustment = null;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            EstimationStateType state = EstimationStateType.valueOf(name);
            if (state == null) {
                return;
            }
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            switch (state) {
                case BUSY: {
                    this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.busy.label", "Network adjustment in process\u2026"));
                    this.updateIterationProgressMessage(null);
                    this.updateConvergenceProgressMessage(null);
                    break;
                }
                case CONVERGENCE: {
                    if (oldValue == null || newValue == null || !(oldValue instanceof Double) || !(newValue instanceof Double)) break;
                    double current = (Double)newValue;
                    double minimal = (Double)oldValue;
                    if (this.updateProgressOnIterate) {
                        double frac = 0.75 * Math.min(minimal / current, 1.0);
                        this.processState = Math.max(this.processState, frac);
                        this.updateProgress(this.processState, 1.0);
                    }
                    this.updateConvergenceProgressMessage(String.format(Locale.ENGLISH, this.convergenceTextTemplate, current, minimal));
                    break;
                }
                case ITERATE: {
                    if (oldValue == null || newValue == null || !(oldValue instanceof Integer) || !(newValue instanceof Integer)) break;
                    int current = (Integer)newValue;
                    int maximal = (Integer)oldValue;
                    if (this.updateProgressOnIterate) {
                        double frac = 0.75 * Math.min((double)current / (double)maximal, 1.0);
                        this.processState = Math.max(this.processState, frac);
                        this.updateProgress(this.processState, 1.0);
                    }
                    this.updateIterationProgressMessage(String.format(Locale.ENGLISH, this.iterationTextTemplate, current, maximal));
                    break;
                }
                case UNSCENTED_TRANSFORMATION_STEP: {
                    if (oldValue == null || newValue == null || !(oldValue instanceof Integer) || !(newValue instanceof Integer)) break;
                    int current = (Integer)newValue;
                    int maximal = (Integer)oldValue;
                    double frac = 0.75 * Math.min((double)current / (double)maximal, 1.0);
                    this.processState = Math.max(this.processState, frac);
                    this.updateMessage(String.format(Locale.ENGLISH, this.unscentedTransformationTextTemplate, current, maximal));
                    this.updateProgress(this.processState, 1.0);
                    break;
                }
                case INVERT_NORMAL_EQUATION_MATRIX: {
                    this.processState += this.finalStepProcesses;
                    this.updateProgress(this.processState, 1.0);
                    this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.invert_normal_equation_matrix.label", "Invert normal equation matrix\u2026"));
                    break;
                }
                case ESTIAMTE_STOCHASTIC_PARAMETERS: {
                    this.processState += this.finalStepProcesses;
                    this.updateProgress(this.processState, 1.0);
                    this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.estimate_stochastic_parameters.label", "Estimate stochastic parameters\u2026"));
                    break;
                }
                case PRINCIPAL_COMPONENT_ANALYSIS: {
                    this.processState += this.finalStepProcesses;
                    this.updateProgress(this.processState, 1.0);
                    this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.principal_component_analysis.label", "Principal component analysis\u2026"));
                    break;
                }
                case EXPORT_ADJUSTMENT_RESULTS: {
                    this.processState += this.finalStepProcesses;
                    this.updateProgress(this.processState, 1.0);
                    this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.export_adjustment_results.label", "Export adjustment results\u2026"));
                    if (newValue == null) break;
                    this.updateIterationProgressMessage(newValue.toString());
                    this.updateConvergenceProgressMessage(null);
                    break;
                }
                case ERROR_FREE_ESTIMATION: {
                    this.updateProgress(1.0, 1.0);
                    this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.error_free_estimation.label", "Network adjustment finished\u2026"));
                    break;
                }
                case INTERRUPT: {
                    this.updateMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.interrupt.label", "Terminate adjustment process\u2026"));
                    this.updateIterationProgressMessage(NetworkAdjustmentDialog.this.i18n.getString("NetworkAdjustmentDialog.pleasewait.label", "Please wait\u2026"));
                    this.updateConvergenceProgressMessage(null);
                    break;
                }
                case LEVENBERG_MARQUARDT_STEP: {
                    break;
                }
            }
        }
    }
}

