/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.UnscentedTransformationParameter;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.spinner.DoubleSpinner;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterEventType;
import org.applied_geodesy.util.FormatterOptions;

public class LeastSquaresSettingDialog
implements FormatterChangedListener {
    private boolean enableUnscentedTransformation = false;
    private I18N i18n = I18N.getInstance();
    private FormatterOptions options = FormatterOptions.getInstance();
    private static LeastSquaresSettingDialog leastSquaresSettingDialog = new LeastSquaresSettingDialog();
    private Dialog<LeastSquaresSettings> dialog = null;
    private Window window;
    private ComboBox<EstimationType> estimationTypeComboBox;
    private LeastSquaresSettings settings = new LeastSquaresSettings();
    private Spinner<Integer> iterationSpinner;
    private Spinner<Integer> principalComponentSpinner;
    private DoubleSpinner robustSpinner;
    private DoubleSpinner confidenceLevelSpinner;
    private DoubleTextField alphaTextField;
    private DoubleTextField betaTextField;
    private DoubleTextField weight0TextField;
    private CheckBox orientationApproximationCheckBox;
    private CheckBox congruenceAnalysisCheckBox;
    private CheckBox applyVarianceOfUnitWeightCheckBox;
    private Label confidenceLevelLabel;

    private LeastSquaresSettingDialog() {
    }

    public static void setOwner(Window owner) {
        LeastSquaresSettingDialog.leastSquaresSettingDialog.window = owner;
    }

    public static Optional<LeastSquaresSettings> showAndWait() {
        leastSquaresSettingDialog.init();
        leastSquaresSettingDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("LeastSquaresSettingDialog.title", "Least-squares"));
        this.dialog.setHeaderText(this.i18n.getString("LeastSquaresSettingDialog.header", "Least-squares properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, LeastSquaresSettings>(){

            public LeastSquaresSettings call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    LeastSquaresSettingDialog.this.save();
                    return LeastSquaresSettingDialog.this.settings;
                }
                return null;
            }
        });
        this.options.addFormatterChangedListener(this);
    }

    private Node createPane() {
        VBox contentPane = new VBox();
        this.estimationTypeComboBox = this.createEstimationTypeComboBox(DefaultValue.getEstimationType(), this.i18n.getString("LeastSquaresSettingDialog.estimationtype.tooltip", "Set estimation method"));
        this.settings.estimationTypeProperty().addListener((ChangeListener)new EstimationTypeChangeListener());
        this.estimationTypeComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new EstimationTypeChangeListener());
        VBox.setMargin(this.estimationTypeComboBox, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        contentPane.getChildren().add(this.estimationTypeComboBox);
        if (this.enableUnscentedTransformation) {
            TabPane tabPane = new TabPane();
            Tab tabGen = new Tab(this.i18n.getString("LeastSquaresSettingDialog.tab.leastsquares.label", "Least-squares"), this.createGeneralSettingPane());
            tabGen.setTooltip(new Tooltip(this.i18n.getString("LeastSquaresSettingDialog.tab.leastsquares.tooltip", "Least-squares options")));
            tabGen.setClosable(false);
            tabPane.getTabs().add((Object)tabGen);
            Tab tabUT = new Tab(this.i18n.getString("LeastSquaresSettingDialog.tab.unscented_transformation.label", "Unscented transformation"), this.createUnscentedTransformationSettingPane());
            tabUT.setTooltip(new Tooltip(this.i18n.getString("LeastSquaresSettingDialog.tab.unscented_transformation.tooltip", "Unscented transformation parameters")));
            tabUT.setClosable(false);
            tabPane.getTabs().add((Object)tabUT);
            tabPane.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            tabPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            tabPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            contentPane.getChildren().add((Object)tabPane);
        } else {
            contentPane.getChildren().add((Object)this.createGeneralSettingPane());
        }
        contentPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        contentPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LeastSquaresSettingDialog.this.estimationTypeComboBox.requestFocus();
            }
        });
        return contentPane;
    }

    private Node createUnscentedTransformationSettingPane() {
        Label alphaLabel = new Label(this.i18n.getString("LeastSquaresSettingDialog.ut.scaling.label", "Scaling \u03b1:"));
        Label betaLabel = new Label(this.i18n.getString("LeastSquaresSettingDialog.ut.damping.label", "Damping \u03b2:"));
        Label utWeight0Label = new Label(this.i18n.getString("LeastSquaresSettingDialog.ut.weight0.label", "Weight w0:"));
        this.alphaTextField = this.createDoubleTextField(UnscentedTransformationParameter.getAlpha(), DoubleTextField.ValueSupport.EXCLUDING_INCLUDING_INTERVAL, 0.0, 1.0, this.i18n.getString("LeastSquaresSettingDialog.ut.scaling.tooltip", "Defines spread of sigma points around the mean value, if \u03b1 \u2260 1"));
        this.betaTextField = this.createDoubleTextField(UnscentedTransformationParameter.getBeta(), DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.i18n.getString("LeastSquaresSettingDialog.ut.damping.tooltip", "Considers prior knowledge of the distribution, if \u03b2 \u2260 0"));
        this.weight0TextField = this.createDoubleTextField(UnscentedTransformationParameter.getWeightZero(), DoubleTextField.ValueSupport.INCLUDING_EXCLUDING_INTERVAL, Double.NEGATIVE_INFINITY, 1.0, this.i18n.getString("LeastSquaresSettingDialog.ut.weight0.tooltip", "Set the weight related to the zero sigma point (MUT: w0 < 1, SUT: 0 \u2264 w0 < 1)"));
        this.alphaTextField.numberProperty().bindBidirectional(this.settings.scalingParameterAlphaUTProperty());
        this.betaTextField.numberProperty().bindBidirectional(this.settings.dampingParameterBetaUTProperty());
        this.weight0TextField.numberProperty().bindBidirectional(this.settings.weightZeroProperty());
        alphaLabel.setLabelFor((Node)this.alphaTextField);
        betaLabel.setLabelFor((Node)this.betaTextField);
        utWeight0Label.setLabelFor((Node)this.weight0TextField);
        GridPane gridPane = new GridPane();
        gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        gridPane.setAlignment(Pos.TOP_CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        GridPane.setHgrow((Node)alphaLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)betaLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)utWeight0Label, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.alphaTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.betaTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.weight0TextField, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 2.0);
        Insets insetsRight = new Insets(5.0, 2.0, 5.0, 7.0);
        GridPane.setMargin((Node)alphaLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.alphaTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)betaLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.betaTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)utWeight0Label, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.weight0TextField, (Insets)insetsRight);
        int row = 0;
        gridPane.add((Node)utWeight0Label, 0, ++row);
        gridPane.add((Node)this.weight0TextField, 1, row);
        gridPane.add((Node)alphaLabel, 0, ++row);
        gridPane.add((Node)this.alphaTextField, 1, row, 2, 1);
        gridPane.add((Node)betaLabel, 0, ++row);
        gridPane.add((Node)this.betaTextField, 1, row, 2, 1);
        return gridPane;
    }

    private Node createGeneralSettingPane() {
        String frmPercentUnit = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
        Label iterationLabel = new Label(this.i18n.getString("LeastSquaresSettingDialog.iterations.label", "Maximum number of iterations:"));
        this.iterationSpinner = this.createIntegerSpinner(0, DefaultValue.getMaximumNumberOfIterations(), 10, this.i18n.getString("LeastSquaresSettingDialog.iterations.tooltip", "Set maximum permissible iteration value"));
        iterationLabel.setLabelFor(this.iterationSpinner);
        iterationLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label principalComponentLabel = new Label(this.i18n.getString("LeastSquaresSettingDialog.principal_components.label", "Number of principal components:"));
        this.principalComponentSpinner = this.createIntegerSpinner(0, Integer.MAX_VALUE, 1, this.i18n.getString("LeastSquaresSettingDialog.principal_components.tooltip", "Set number of principal components to be estimated"));
        principalComponentLabel.setLabelFor(this.principalComponentSpinner);
        principalComponentLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label robustLabel = new Label(this.i18n.getString("LeastSquaresSettingDialog.robust.label", "Robust estimation limit:"));
        this.robustSpinner = this.createDoubleSpinner(CellValueType.STATISTIC, 1.5, Math.max(DefaultValue.getRobustEstimationLimit(), 6.0), 0.5, this.i18n.getString("LeastSquaresSettingDialog.robust.tooltip", "Set robust estimation limit of BIBER estimator"));
        robustLabel.setLabelFor((Node)this.robustSpinner);
        robustLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.confidenceLevelLabel = new Label(String.format(Locale.ENGLISH, "%s%s:", this.i18n.getString("LeastSquaresSettingDialog.confidence.label", "Confidence level 1 - \u03b1"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit));
        this.confidenceLevelSpinner = this.createDoubleSpinner(CellValueType.PERCENTAGE, 5.0E-4, 0.9995, 0.01, this.i18n.getString("LeastSquaresSettingDialog.confidence.tooltip", "Set confidence level of parameters"));
        this.confidenceLevelLabel.setLabelFor((Node)this.confidenceLevelSpinner);
        this.confidenceLevelLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.orientationApproximationCheckBox = this.createCheckBox(this.i18n.getString("LeastSquaresSettingDialog.orientation.label", "Orientation approximation"), this.i18n.getString("LeastSquaresSettingDialog.orientation.tooltip", "If checked, orientation approximations of direction sets will be estimated before network adjustment starts"));
        this.congruenceAnalysisCheckBox = this.createCheckBox(this.i18n.getString("LeastSquaresSettingDialog.congruenceanalysis.label", "Congruence analysis"), this.i18n.getString("LeastSquaresSettingDialog.congruenceanalysis.tooltip", "If checked, a congruence analysis will be carry out in case of a free network adjustment"));
        this.applyVarianceOfUnitWeightCheckBox = this.createCheckBox(this.i18n.getString("LeastSquaresSettingDialog.applyvarianceofunitweight.label", "Variance of the unit weight"), this.i18n.getString("LeastSquaresSettingDialog.applyvarianceofunitweight.tooltip", "If checked, the estimated variance of the unit weight will be applied to scale the variance-covariance matrix"));
        this.orientationApproximationCheckBox.selectedProperty().bindBidirectional((Property)this.settings.orientationProperty());
        this.congruenceAnalysisCheckBox.selectedProperty().bindBidirectional((Property)this.settings.congruenceAnalysisProperty());
        this.applyVarianceOfUnitWeightCheckBox.selectedProperty().bindBidirectional((Property)this.settings.applyVarianceOfUnitWeightProperty());
        this.iterationSpinner.getValueFactory().valueProperty().bindBidirectional(this.settings.iterationProperty());
        this.principalComponentSpinner.getValueFactory().valueProperty().bindBidirectional(this.settings.principalComponentsProperty());
        this.robustSpinner.getValueFactory().valueProperty().bindBidirectional(this.settings.robustEstimationLimitProperty());
        GridPane gridPane = new GridPane();
        gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        gridPane.setAlignment(Pos.TOP_CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        GridPane.setHgrow((Node)iterationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)principalComponentLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)robustLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.confidenceLevelLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.orientationApproximationCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.applyVarianceOfUnitWeightCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.congruenceAnalysisCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.robustSpinner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.confidenceLevelSpinner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.principalComponentSpinner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.iterationSpinner, (Priority)Priority.ALWAYS);
        Insets insetsCenter = new Insets(5.0, 2.0, 5.0, 2.0);
        Insets insetsTop = new Insets(10.0, 2.0, 5.0, 2.0);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 2.0);
        Insets insetsRight = new Insets(5.0, 2.0, 5.0, 7.0);
        GridPane.setMargin((Node)this.applyVarianceOfUnitWeightCheckBox, (Insets)insetsTop);
        GridPane.setMargin((Node)this.orientationApproximationCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.congruenceAnalysisCheckBox, (Insets)insetsTop);
        GridPane.setMargin((Node)this.confidenceLevelLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.confidenceLevelSpinner, (Insets)insetsRight);
        GridPane.setMargin((Node)iterationLabel, (Insets)insetsLeft);
        GridPane.setMargin(this.iterationSpinner, (Insets)insetsRight);
        GridPane.setMargin((Node)robustLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.robustSpinner, (Insets)insetsRight);
        GridPane.setMargin((Node)principalComponentLabel, (Insets)insetsLeft);
        GridPane.setMargin(this.principalComponentSpinner, (Insets)insetsRight);
        int row = 0;
        gridPane.add((Node)this.applyVarianceOfUnitWeightCheckBox, 0, ++row, 2, 1);
        gridPane.add((Node)this.orientationApproximationCheckBox, 0, ++row, 2, 1);
        gridPane.add((Node)this.confidenceLevelLabel, 0, ++row);
        gridPane.add((Node)this.confidenceLevelSpinner, 1, row);
        gridPane.add((Node)iterationLabel, 0, ++row);
        gridPane.add(this.iterationSpinner, 1, row);
        gridPane.add((Node)robustLabel, 0, ++row);
        gridPane.add((Node)this.robustSpinner, 1, row);
        gridPane.add((Node)principalComponentLabel, 0, ++row);
        gridPane.add(this.principalComponentSpinner, 1, row);
        gridPane.add((Node)this.congruenceAnalysisCheckBox, 0, ++row, 2, 1);
        return gridPane;
    }

    private ComboBox<EstimationType> createEstimationTypeComboBox(EstimationType item, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        EstimationType[] estimationTypeArray = EstimationType.values();
        if (!this.enableUnscentedTransformation) {
            ArrayList<EstimationType> estimationTypeList = new ArrayList<EstimationType>(Arrays.asList(estimationTypeArray));
            estimationTypeList.remove((Object)EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION);
            estimationTypeList.remove((Object)EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION);
            estimationTypeArray = estimationTypeList.toArray(new EstimationType[estimationTypeList.size()]);
            if (item == EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION || item == EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION) {
                item = EstimationType.L2NORM;
            }
        }
        typeComboBox.getItems().setAll((Object[])estimationTypeArray);
        typeComboBox.getSelectionModel().select((Object)item);
        typeComboBox.setConverter((StringConverter)new StringConverter<EstimationType>(){

            public String toString(EstimationType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case L1NORM: {
                        return LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.estimationtype.l1norm.label", "Robust estimation (L1-Norm)");
                    }
                    case L2NORM: {
                        return LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.estimationtype.l2norm.label", "Least-squares adjustment (L2-Norm)");
                    }
                    case SIMULATION: {
                        return LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.estimationtype.simulation.label", "Simulation (Pre-analysis)");
                    }
                    case MODIFIED_UNSCENTED_TRANSFORMATION: {
                        return LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.estimationtype.mut.label", "Modified unscented transformation (MUT)");
                    }
                    case SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION: {
                        return LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.estimationtype.sut.label", "Spherical simplex unscented transformation (SUT)");
                    }
                }
                return null;
            }

            public EstimationType fromString(String string) {
                return EstimationType.valueOf(string);
            }
        });
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinHeight(Double.NEGATIVE_INFINITY);
        checkBox.setMaxHeight(Double.MAX_VALUE);
        return checkBox;
    }

    private DoubleTextField createDoubleTextField(double value, DoubleTextField.ValueSupport valueSupport, double lowerBoundary, double upperBoundary, String tooltip) {
        DoubleTextField field = new DoubleTextField(value, CellValueType.STATISTIC, Boolean.FALSE, valueSupport, lowerBoundary, upperBoundary);
        field.setTooltip(new Tooltip(tooltip));
        field.setAlignment(Pos.CENTER_RIGHT);
        field.setMinHeight(Double.NEGATIVE_INFINITY);
        field.setMaxHeight(Double.MAX_VALUE);
        return field;
    }

    private Spinner<Integer> createIntegerSpinner(int min, int max, int amountToStepBy, String tooltip) {
        final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        StringConverter<Integer> converter = new StringConverter<Integer>(){

            public Integer fromString(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                try {
                    return numberFormat.parse(s).intValue();
                }
                catch (Exception nfe) {
                    nfe.printStackTrace();
                    return null;
                }
            }

            public String toString(Integer d) {
                return d == null ? "" : numberFormat.format(d);
            }
        };
        final SpinnerValueFactory.IntegerSpinnerValueFactory integerFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max);
        Spinner integerSpinner = new Spinner();
        integerSpinner.setEditable(true);
        integerSpinner.setValueFactory((SpinnerValueFactory)integerFactory);
        integerFactory.setConverter((StringConverter)converter);
        integerFactory.setAmountToStepBy(amountToStepBy);
        TextFormatter formatter = new TextFormatter(integerFactory.getConverter(), (Object)((Integer)integerFactory.getValue()));
        integerSpinner.getEditor().setTextFormatter(formatter);
        integerSpinner.getEditor().setAlignment(Pos.BOTTOM_RIGHT);
        integerFactory.valueProperty().bindBidirectional((Property)formatter.valueProperty());
        integerSpinner.setMinWidth(75.0);
        integerSpinner.setPrefWidth(100.0);
        integerSpinner.setMaxWidth(Double.MAX_VALUE);
        integerSpinner.setTooltip(new Tooltip(tooltip));
        integerFactory.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                if (newValue == null) {
                    integerFactory.setValue((Object)oldValue);
                }
            }
        });
        return integerSpinner;
    }

    private DoubleSpinner createDoubleSpinner(CellValueType cellValueType, double min, double max, double amountToStepBy, String tooltip) {
        DoubleSpinner doubleSpinner = new DoubleSpinner(cellValueType, min, max, amountToStepBy);
        doubleSpinner.setMinWidth(75.0);
        doubleSpinner.setPrefWidth(100.0);
        doubleSpinner.setMaxWidth(Double.MAX_VALUE);
        doubleSpinner.setTooltip(new Tooltip(tooltip));
        return doubleSpinner;
    }

    private void save() {
        try {
            this.settings.setConfidenceLevel(this.confidenceLevelSpinner.getNumber().doubleValue());
            SQLManager.getInstance().save(this.settings);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.message.error.save.exception.title", "Unexpected SQL-Error"), LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.message.error.save.exception.header", "Error, could not save least-squares settings to database."), LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void load() {
        try {
            SQLManager.getInstance().load(this.settings);
            SpinnerValueFactory.DoubleSpinnerValueFactory confidenceLevelSpinnerFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.confidenceLevelSpinner.getValueFactory();
            double confidenceLevel = this.settings.getConfidenceLevel();
            confidenceLevel = Math.max(Math.min(this.options.convertPercentToView(confidenceLevel), confidenceLevelSpinnerFactory.getMax()), confidenceLevelSpinnerFactory.getMin());
            confidenceLevelSpinnerFactory.setValue((Object)confidenceLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.message.error.load.exception.title", "Unexpected SQL-Error"), LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.message.error.load.exception.header", "Error, could not load least-squares settings from database."), LeastSquaresSettingDialog.this.i18n.getString("LeastSquaresSettingDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    public static void setEnableUnscentedTransformation(boolean enable) {
        LeastSquaresSettingDialog.leastSquaresSettingDialog.enableUnscentedTransformation = enable;
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        if (evt != null && evt.getCellType() == CellValueType.PERCENTAGE && evt.getEventType() == FormatterEventType.UNIT_CHANGED) {
            String frmPercentUnit = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
            String labelConfidenceLevel = String.format(Locale.ENGLISH, "%s%s:", this.i18n.getString("LeastSquaresSettingDialog.confidence.label", "Confidence level 1 - \u03b1"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
            this.confidenceLevelLabel.setText(labelConfidenceLevel);
        }
    }

    private class EstimationTypeChangeListener
    implements ChangeListener<EstimationType> {
        private EstimationTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends EstimationType> observable, EstimationType oldValue, EstimationType newValue) {
            LeastSquaresSettingDialog.this.settings.setEstimationType(newValue);
            LeastSquaresSettingDialog.this.estimationTypeComboBox.setValue((Object)newValue);
        }
    }

    public class LeastSquaresSettings {
        private ObjectProperty<Integer> iteration = new SimpleObjectProperty((Object)50);
        private ObjectProperty<Integer> principalComponents = new SimpleObjectProperty((Object)1);
        private ObjectProperty<Double> robustEstimationLimit = new SimpleObjectProperty((Object)DefaultValue.getRobustEstimationLimit());
        private BooleanProperty orientation = new SimpleBooleanProperty(Boolean.TRUE.booleanValue());
        private BooleanProperty congruenceAnalysis = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
        private BooleanProperty applyVarianceOfUnitWeight = new SimpleBooleanProperty(DefaultValue.applyVarianceOfUnitWeight());
        private ObjectProperty<EstimationType> estimationType = new SimpleObjectProperty((Object)DefaultValue.getEstimationType());
        private ObjectProperty<Double> scalingParameterAlphaUT = new SimpleObjectProperty((Object)UnscentedTransformationParameter.getAlpha());
        private ObjectProperty<Double> dampingParameterBetaUT = new SimpleObjectProperty((Object)UnscentedTransformationParameter.getBeta());
        private ObjectProperty<Double> weightZero = new SimpleObjectProperty((Object)UnscentedTransformationParameter.getWeightZero());
        private double confidenceLevel = DefaultValue.getConfidenceLevel();

        public ObjectProperty<Integer> iterationProperty() {
            return this.iteration;
        }

        public int getIteration() {
            return (Integer)this.iterationProperty().get();
        }

        public void setIteration(int iteration) {
            this.iterationProperty().set((Object)iteration);
        }

        public ObjectProperty<Integer> principalComponentsProperty() {
            return this.principalComponents;
        }

        public int getPrincipalComponents() {
            return (Integer)this.principalComponentsProperty().get();
        }

        public void setPrincipalComponents(int principalComponents) {
            this.principalComponentsProperty().set((Object)principalComponents);
        }

        public ObjectProperty<Double> robustEstimationLimitProperty() {
            return this.robustEstimationLimit;
        }

        public double getRobustEstimationLimit() {
            return (Double)this.robustEstimationLimitProperty().get();
        }

        public void setRobustEstimationLimit(double robustEstimationLimit) {
            this.robustEstimationLimitProperty().set((Object)robustEstimationLimit);
        }

        public double getConfidenceLevel() {
            return this.confidenceLevel;
        }

        public void setConfidenceLevel(double confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
        }

        public BooleanProperty orientationProperty() {
            return this.orientation;
        }

        public boolean isOrientation() {
            return this.orientationProperty().get();
        }

        public void setOrientation(boolean orientation) {
            this.orientationProperty().set(orientation);
        }

        public BooleanProperty congruenceAnalysisProperty() {
            return this.congruenceAnalysis;
        }

        public boolean isCongruenceAnalysis() {
            return this.congruenceAnalysisProperty().get();
        }

        public void setCongruenceAnalysis(boolean congruenceAnalysis) {
            this.congruenceAnalysisProperty().set(congruenceAnalysis);
        }

        public BooleanProperty applyVarianceOfUnitWeightProperty() {
            return this.applyVarianceOfUnitWeight;
        }

        public boolean isApplyVarianceOfUnitWeight() {
            return this.applyVarianceOfUnitWeightProperty().get();
        }

        public void setApplyVarianceOfUnitWeight(boolean applyVarianceOfUnitWeight) {
            this.applyVarianceOfUnitWeightProperty().set(applyVarianceOfUnitWeight);
        }

        public ObjectProperty<EstimationType> estimationTypeProperty() {
            return this.estimationType;
        }

        public EstimationType getEstimationType() {
            return (EstimationType)((Object)this.estimationTypeProperty().get());
        }

        public void setEstimationType(EstimationType estimationType) {
            this.estimationTypeProperty().set((Object)estimationType);
        }

        public ObjectProperty<Double> scalingParameterAlphaUTProperty() {
            return this.scalingParameterAlphaUT;
        }

        public double getScalingParameterAlphaUT() {
            return (Double)this.scalingParameterAlphaUTProperty().get();
        }

        public void setScalingParameterAlphaUT(double alpha) {
            this.scalingParameterAlphaUTProperty().set((Object)alpha);
        }

        public ObjectProperty<Double> dampingParameterBetaUTProperty() {
            return this.dampingParameterBetaUT;
        }

        public double getDampingParameterBetaUT() {
            return (Double)this.dampingParameterBetaUTProperty().get();
        }

        public void setDampingParameterBetaUT(double beta) {
            this.dampingParameterBetaUTProperty().set((Object)beta);
        }

        public ObjectProperty<Double> weightZeroProperty() {
            return this.weightZero;
        }

        public double getWeightZero() {
            return (Double)this.weightZeroProperty().get();
        }

        public void setWeightZero(double weight0) {
            this.weightZeroProperty().set((Object)weight0);
        }
    }
}

