/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dialog.ScopeType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.ObservableLimitedList;

public class InstrumentAndReflectorHeightAdaptionDialog {
    private I18N i18n = I18N.getInstance();
    private static InstrumentAndReflectorHeightAdaptionDialog instrumentAndReflectorHeightAdaptionDialog = new InstrumentAndReflectorHeightAdaptionDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private ComboBox<String> stationNameComboBox = new ComboBox();
    private ComboBox<String> targetNameComboBox = new ComboBox();
    private Label statusLabel = new Label();
    private RadioButton normalModeRadioButton;
    private RadioButton regularExpressionRadioButton;
    private CheckBox keepDialogOpenCheckBox;
    private ComboBox<ScopeType> scopeTypeComboBox;
    private DoubleTextField instrumentHeightField;
    private DoubleTextField reflectorHeightField;
    private TreeItemValue itemValue;
    private TreeItemValue[] selectedTreeItemValues;

    private InstrumentAndReflectorHeightAdaptionDialog() {
    }

    public static void setOwner(Window owner) {
        InstrumentAndReflectorHeightAdaptionDialog.instrumentAndReflectorHeightAdaptionDialog.window = owner;
    }

    public static Optional<Void> showAndWait(TreeItemValue itemValue, TreeItemValue ... selectedTreeItemValues) {
        InstrumentAndReflectorHeightAdaptionDialog.instrumentAndReflectorHeightAdaptionDialog.itemValue = itemValue;
        InstrumentAndReflectorHeightAdaptionDialog.instrumentAndReflectorHeightAdaptionDialog.selectedTreeItemValues = selectedTreeItemValues;
        instrumentAndReflectorHeightAdaptionDialog.init();
        InstrumentAndReflectorHeightAdaptionDialog.instrumentAndReflectorHeightAdaptionDialog.statusLabel.setText(null);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    InstrumentAndReflectorHeightAdaptionDialog.instrumentAndReflectorHeightAdaptionDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)InstrumentAndReflectorHeightAdaptionDialog.instrumentAndReflectorHeightAdaptionDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return InstrumentAndReflectorHeightAdaptionDialog.instrumentAndReflectorHeightAdaptionDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.title", "Heights of instrument and reflector"));
        this.dialog.setHeaderText(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.header", "Adaption of heights of instrument and reflector"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        Button applyButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK);
        applyButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                InstrumentAndReflectorHeightAdaptionDialog.this.save();
                if (InstrumentAndReflectorHeightAdaptionDialog.this.keepDialogOpenCheckBox.isSelected()) {
                    event.consume();
                }
            }
        });
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                return null;
            }
        });
    }

    private Node createPane() {
        this.stationNameComboBox = this.createComboBox(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.station.prompt", "Id of station point (optional)"), this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.station.tooltip", "Enter station name (leave blank, if not required)"));
        this.targetNameComboBox = this.createComboBox(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.target.prompt", "Id of target point (optional)"), this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.target.tooltip", "Enter target name (leave blank, if not required)"));
        this.normalModeRadioButton = this.createRadioButton(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.mode.normal.label", "Normal"), this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.mode.normal.tooltip", "If selected, normal search mode will be applied"));
        this.regularExpressionRadioButton = this.createRadioButton(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.mode.regex.label", "Regular expression"), this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.mode.regex.tooltip", "If selected, regular expression mode will be applied"));
        this.keepDialogOpenCheckBox = this.createCheckBox(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.keep_open.label", "Keep dialog open after modification"), this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.keep_open.tooltip", "If selected, dialog will be kept open after data modification"));
        this.keepDialogOpenCheckBox.setSelected(false);
        this.scopeTypeComboBox = this.createScopeTypeComboBox(ScopeType.SELECTION, this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.scope.tooltip", "Select scope of application"));
        this.instrumentHeightField = this.createDoubleTextField(CellValueType.LENGTH, true, DoubleTextField.ValueSupport.NULL_VALUE_SUPPORT, this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.instrument.height.tooltip", "Set new instrument height (leave blank, if not required)"), this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.instrument.height.prompt", "New instrument height (optional)"));
        this.reflectorHeightField = this.createDoubleTextField(CellValueType.LENGTH, true, DoubleTextField.ValueSupport.NULL_VALUE_SUPPORT, this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.reflector.height.tooltip", "Set new reflector height (leave blank, if not required)"), this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.reflector.height.prompt", "New reflector height (optional)"));
        Label scopeLabel = new Label(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.scope.label", "Scope:"));
        Label stationNameLabel = new Label(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.station.label", "Station name:"));
        Label targetNameLabel = new Label(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.target.label", "Target name:"));
        Label modeLabel = new Label(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.mode.label", "Mode:"));
        Label instrumentHeightLabel = new Label(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.instrument.height.label", "Instrument height:"));
        Label reflectorHeightLabel = new Label(this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.reflector.height.label", "Reflector height:"));
        scopeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        stationNameLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        targetNameLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        instrumentHeightLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        reflectorHeightLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        scopeLabel.setLabelFor(this.scopeTypeComboBox);
        stationNameLabel.setLabelFor(this.stationNameComboBox);
        targetNameLabel.setLabelFor(this.targetNameComboBox);
        instrumentHeightLabel.setLabelFor((Node)this.instrumentHeightField);
        reflectorHeightLabel.setLabelFor((Node)this.reflectorHeightField);
        ToggleGroup group = new ToggleGroup();
        group.getToggles().addAll((Object[])new Toggle[]{this.normalModeRadioButton, this.regularExpressionRadioButton});
        this.normalModeRadioButton.setSelected(true);
        HBox hbox = new HBox(10.0, new Node[]{this.normalModeRadioButton, this.regularExpressionRadioButton});
        hbox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        GridPane.setHgrow((Node)scopeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)stationNameLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)targetNameLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)modeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.stationNameComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.targetNameComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)hbox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.scopeTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.keepDialogOpenCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.statusLabel, (Priority)Priority.ALWAYS);
        int row = 1;
        gridPane.add((Node)scopeLabel, 0, row);
        gridPane.add(this.scopeTypeComboBox, 1, row++, 1, 1);
        gridPane.add((Node)stationNameLabel, 0, row);
        gridPane.add(this.stationNameComboBox, 1, row++, 1, 1);
        gridPane.add((Node)targetNameLabel, 0, row);
        gridPane.add(this.targetNameComboBox, 1, row++, 1, 1);
        gridPane.add((Node)instrumentHeightLabel, 0, row);
        gridPane.add((Node)this.instrumentHeightField, 1, row++, 1, 1);
        gridPane.add((Node)reflectorHeightLabel, 0, row);
        gridPane.add((Node)this.reflectorHeightField, 1, row++, 1, 1);
        gridPane.add((Node)modeLabel, 0, row);
        gridPane.add((Node)hbox, 1, row++, 1, 1);
        gridPane.add((Node)this.keepDialogOpenCheckBox, 1, row++, 1, 1);
        gridPane.add((Node)this.statusLabel, 1, row++, 1, 1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                InstrumentAndReflectorHeightAdaptionDialog.this.stationNameComboBox.requestFocus();
            }
        });
        return gridPane;
    }

    private DoubleTextField createDoubleTextField(CellValueType type, boolean displayUnit, DoubleTextField.ValueSupport valueSupport, String tooltipText, String promptText) {
        DoubleTextField field = new DoubleTextField(null, type, displayUnit, valueSupport);
        field.setTooltip(new Tooltip(tooltipText));
        field.setPromptText(promptText);
        field.setMinWidth(200.0);
        field.setMaxWidth(350.0);
        return field;
    }

    private RadioButton createRadioButton(String text, String tooltip) {
        Label label = new Label(text);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxWidth(Double.MAX_VALUE);
        return radioButton;
    }

    private CheckBox createCheckBox(String text, String tooltip) {
        Label label = new Label(text);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxWidth(Double.MAX_VALUE);
        return checkBox;
    }

    private ComboBox<ScopeType> createScopeTypeComboBox(ScopeType item, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])ScopeType.values());
        typeComboBox.getSelectionModel().select((Object)item);
        typeComboBox.setConverter((StringConverter)new StringConverter<ScopeType>(){

            public String toString(ScopeType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case SELECTION: {
                        return InstrumentAndReflectorHeightAdaptionDialog.this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.scope.selection.label", "Selected items");
                    }
                    case PROJECT: {
                        return InstrumentAndReflectorHeightAdaptionDialog.this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.scope.project.label", "Whole project");
                    }
                    case REFERENCE_EPOCH: {
                        return InstrumentAndReflectorHeightAdaptionDialog.this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.scope.reference_epoch.label", "Observations of reference epoch");
                    }
                    case CONTROL_EPOCH: {
                        return InstrumentAndReflectorHeightAdaptionDialog.this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.scope.control_epoch.label", "Observations of control epoch");
                    }
                }
                return null;
            }

            public ScopeType fromString(String string) {
                return ScopeType.valueOf(string);
            }
        });
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    private ComboBox<String> createComboBox(String promtText, String tooltip) {
        ComboBox comboBox = new ComboBox(new ObservableLimitedList(150));
        comboBox.setEditable(true);
        comboBox.setPromptText(promtText);
        comboBox.setTooltip(new Tooltip(tooltip));
        comboBox.setMinSize(250.0, Double.NEGATIVE_INFINITY);
        comboBox.setMaxWidth(Double.MAX_VALUE);
        return comboBox;
    }

    private void save() {
        try {
            this.statusLabel.setText(null);
            this.stationNameComboBox.commitValue();
            this.targetNameComboBox.commitValue();
            this.instrumentHeightField.commitValue();
            this.reflectorHeightField.commitValue();
            Object stationName = (String)this.stationNameComboBox.getValue();
            Object targetName = (String)this.targetNameComboBox.getValue();
            Double instrumentHeight = this.instrumentHeightField.getNumber();
            Double reflectorHeight = this.reflectorHeightField.getNumber();
            if (instrumentHeight == null && reflectorHeight == null) {
                return;
            }
            stationName = stationName == null || ((String)stationName).trim().isEmpty() ? null : stationName;
            targetName = targetName == null || ((String)targetName).trim().isEmpty() ? null : targetName;
            if (!this.stationNameComboBox.getItems().contains(stationName == null ? "" : stationName)) {
                this.stationNameComboBox.getItems().add(stationName == null ? "" : stationName);
            }
            this.stationNameComboBox.setValue(stationName == null ? "" : stationName);
            if (!this.targetNameComboBox.getItems().contains(targetName == null ? "" : targetName)) {
                this.targetNameComboBox.getItems().add(targetName == null ? "" : targetName);
            }
            this.targetNameComboBox.setValue(targetName == null ? "" : targetName);
            ScopeType scopeType = (ScopeType)((Object)this.scopeTypeComboBox.getValue());
            boolean regExp = this.regularExpressionRadioButton.isSelected();
            if (!regExp && stationName != null) {
                stationName = "^\\Q" + (String)stationName + "\\E";
            } else if (stationName == null) {
                stationName = ".*";
            }
            if (!regExp && targetName != null) {
                targetName = "^\\Q" + (String)targetName + "\\E";
            } else if (targetName == null) {
                targetName = ".*";
            }
            int rows = SQLManager.getInstance().adaptInstrumentAndReflectorHeights((String)stationName, (String)targetName, instrumentHeight, reflectorHeight, scopeType, this.itemValue, this.selectedTreeItemValues);
            if (this.keepDialogOpenCheckBox.isSelected()) {
                this.statusLabel.setText(String.format(Locale.ENGLISH, this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.result.label", "%d row(s) edited\u2026"), rows));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(InstrumentAndReflectorHeightAdaptionDialog.this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.message.error.save.exception.title", "Unexpected SQL-Error"), InstrumentAndReflectorHeightAdaptionDialog.this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.message.error.save.exception.header", "Error, could not save renamed points to database."), InstrumentAndReflectorHeightAdaptionDialog.this.i18n.getString("InstrumentAndReflectorHeightAdaptionDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }
}

