/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.reader.ImportOption;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlight;
import org.applied_geodesy.ui.dialog.OptionDialog;

public class ImportOptionDialog {
    private I18N i18n = I18N.getInstance();
    private static ImportOptionDialog importOptionDialog = new ImportOptionDialog();
    private Dialog<ImportOption> dialog = null;
    private Window window;
    private CheckBox levelingCheckBox;
    private CheckBox directionCheckBox;
    private CheckBox horizontalDistanceCheckBox;
    private CheckBox slopeDistanceCheckBox;
    private CheckBox zenithAngleCheckBox;
    private CheckBox gnss1DCheckBox;
    private CheckBox gnss2DCheckBox;
    private CheckBox gnss3DCheckBox;

    private ImportOptionDialog() {
    }

    public static void setOwner(Window owner) {
        ImportOptionDialog.importOptionDialog.window = owner;
    }

    public static Optional<ImportOption> showAndWait() {
        importOptionDialog.init();
        importOptionDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ImportOptionDialog.importOptionDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)ImportOptionDialog.importOptionDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ImportOptionDialog.importOptionDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("ImportOptionDialog.title", "Import preferences"));
        this.dialog.setHeaderText(this.i18n.getString("ImportOptionDialog.header", "Grouping observations by station-ids"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, ImportOption>(){

            public ImportOption call(ButtonType buttonType) {
                ImportOption importOption = ImportOption.getInstance();
                if (buttonType == ButtonType.OK) {
                    ImportOptionDialog.this.save();
                }
                return importOption;
            }
        });
    }

    private Node createPane() {
        String labelLevelingSeparation = this.i18n.getString("ImportOptionDialog.separation.leveling.label", "Height differences");
        String tooltipLevelingSeparation = this.i18n.getString("ImportOptionDialog.separation.leveling.tooltip", "If checked, height differences are grouped by station-ids");
        String labelDirectionSeparation = this.i18n.getString("ImportOptionDialog.separation.direction.label", "Directions");
        String tooltipDirectionSeparation = this.i18n.getString("ImportOptionDialog.separation.direction.tooltip", "If checked, set of directions are grouped by station-ids");
        String labelHorizontalDistanceSeparation = this.i18n.getString("ImportOptionDialog.separation.horizontal_distance.label", "Horizontal distances");
        String tooltipHorizontalDistanceSeparation = this.i18n.getString("ImportOptionDialog.separation.horizontal_distance.tooltip", "If checked, horizontal distances are grouped by station-ids");
        String labelSlopeDistanceSeparation = this.i18n.getString("ImportOptionDialog.separation.slope_distance.label", "Slope distances");
        String tooltipSlopeDistanceSeparation = this.i18n.getString("ImportOptionDialog.separation.slope_distance.tooltip", "If checked, slope distances are grouped by station-ids");
        String labelZenithAngleSeparation = this.i18n.getString("ImportOptionDialog.separation.zenith_angle.label", "Zenith angles");
        String tooltipZenithAngleSeparation = this.i18n.getString("ImportOptionDialog.separation.zenith_angle.tooltip", "If checked, zenith angles are grouped by station-ids");
        String labelGNSS1DSeparation = this.i18n.getString("ImportOptionDialog.separation.gnss.1d.label", "GNSS baselines 1D");
        String tooltipGNSS1DSeparation = this.i18n.getString("ImportOptionDialog.separation.gnss.1d.tooltip", "If checked, vertical GNSS baselines are grouped by station-ids");
        String labelGNSS2DSeparation = this.i18n.getString("ImportOptionDialog.separation.gnss.2d.label", "GNSS baselines 2D");
        String tooltipGNSS2DSeparation = this.i18n.getString("ImportOptionDialog.separation.gnss.2d.tooltip", "If checked, horizontal GNSS baselines are grouped by station-ids");
        String labelGNSS3DSeparation = this.i18n.getString("ImportOptionDialog.separation.gnss.3d.label", "GNSS baselines 3D");
        String tooltipGNSS3DSeparation = this.i18n.getString("ImportOptionDialog.separation.gnss.3d.tooltip", "If checked, spatial GNSS baselines are grouped by station-ids");
        this.levelingCheckBox = this.createCheckBox(labelLevelingSeparation, tooltipLevelingSeparation);
        this.levelingCheckBox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.directionCheckBox = this.createCheckBox(labelDirectionSeparation, tooltipDirectionSeparation);
        this.horizontalDistanceCheckBox = this.createCheckBox(labelHorizontalDistanceSeparation, tooltipHorizontalDistanceSeparation);
        this.horizontalDistanceCheckBox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.slopeDistanceCheckBox = this.createCheckBox(labelSlopeDistanceSeparation, tooltipSlopeDistanceSeparation);
        this.zenithAngleCheckBox = this.createCheckBox(labelZenithAngleSeparation, tooltipZenithAngleSeparation);
        this.zenithAngleCheckBox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.gnss1DCheckBox = this.createCheckBox(labelGNSS1DSeparation, tooltipGNSS1DSeparation);
        this.gnss2DCheckBox = this.createCheckBox(labelGNSS2DSeparation, tooltipGNSS2DSeparation);
        this.gnss3DCheckBox = this.createCheckBox(labelGNSS3DSeparation, tooltipGNSS3DSeparation);
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(7.0);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        GridPane.setHgrow((Node)this.levelingCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.directionCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.horizontalDistanceCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.slopeDistanceCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.zenithAngleCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.gnss1DCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.gnss2DCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.gnss3DCheckBox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)this.levelingCheckBox, 0, ++row);
        gridPane.add((Node)this.directionCheckBox, 0, ++row);
        gridPane.add((Node)this.horizontalDistanceCheckBox, 0, ++row);
        gridPane.add((Node)this.slopeDistanceCheckBox, 0, ++row);
        gridPane.add((Node)this.zenithAngleCheckBox, 0, ++row);
        gridPane.add((Node)this.gnss1DCheckBox, 0, ++row);
        gridPane.add((Node)this.gnss2DCheckBox, 0, ++row);
        gridPane.add((Node)this.gnss3DCheckBox, 0, ++row);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ImportOptionDialog.this.levelingCheckBox.requestFocus();
            }
        });
        return gridPane;
    }

    private void load() {
        try {
            ImportOption importOption = ImportOption.getInstance();
            SQLManager.getInstance().loadImportPreferences();
            this.levelingCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.LEVELING));
            this.directionCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.DIRECTION));
            this.horizontalDistanceCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.HORIZONTAL_DISTANCE));
            this.slopeDistanceCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.SLOPE_DISTANCE));
            this.zenithAngleCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.ZENITH_ANGLE));
            this.gnss1DCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.GNSS1D));
            this.gnss2DCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.GNSS2D));
            this.gnss3DCheckBox.setSelected(importOption.isGroupSeparation(ObservationType.GNSS3D));
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ImportOptionDialog.this.levelingCheckBox.requestFocus();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(ImportOptionDialog.this.i18n.getString("ImportOptionDialog.message.error.load.exception.title", "Unexpected SQL-Error"), ImportOptionDialog.this.i18n.getString("ImportOptionDialog.message.error.load.exception.header", "Error, could not load import preferences from database."), ImportOptionDialog.this.i18n.getString("ImportOptionDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void save() {
        try {
            try {
                ImportOption importOption = ImportOption.getInstance();
                importOption.setGroupSeparation(ObservationType.LEVELING, this.levelingCheckBox.isSelected());
                importOption.setGroupSeparation(ObservationType.DIRECTION, this.directionCheckBox.isSelected());
                importOption.setGroupSeparation(ObservationType.HORIZONTAL_DISTANCE, this.horizontalDistanceCheckBox.isSelected());
                importOption.setGroupSeparation(ObservationType.SLOPE_DISTANCE, this.slopeDistanceCheckBox.isSelected());
                importOption.setGroupSeparation(ObservationType.ZENITH_ANGLE, this.zenithAngleCheckBox.isSelected());
                importOption.setGroupSeparation(ObservationType.GNSS1D, this.gnss1DCheckBox.isSelected());
                importOption.setGroupSeparation(ObservationType.GNSS2D, this.gnss2DCheckBox.isSelected());
                importOption.setGroupSeparation(ObservationType.GNSS3D, this.gnss3DCheckBox.isSelected());
                SQLManager.getInstance().saveImportPreferences();
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OptionDialog.showThrowableDialog(ImportOptionDialog.this.i18n.getString("ImportOptionDialog.message.error.save.exception.title", "Unexpected SQL-Error"), ImportOptionDialog.this.i18n.getString("ImportOptionDialog.message.error.save.exception.header", "Error, could not save import preferences to database."), ImportOptionDialog.this.i18n.getString("ImportOptionDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                    }
                });
                TableRowHighlight.getInstance().refreshTables();
            }
        }
        finally {
            TableRowHighlight.getInstance().refreshTables();
        }
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinHeight(Double.NEGATIVE_INFINITY);
        checkBox.setMaxHeight(Double.MAX_VALUE);
        return checkBox;
    }
}

