/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.writer.ExportOption;
import org.applied_geodesy.ui.dialog.OptionDialog;

public class ExportOptionDialog {
    private I18N i18n = I18N.getInstance();
    private static ExportOptionDialog exportOptionDialog = new ExportOptionDialog();
    private Dialog<ExportOption> dialog = null;
    private Window window;
    private RadioButton noneRadioButton;
    private RadioButton asciiRadioButton;
    private RadioButton matlabRadioButton;

    public static void setOwner(Window owner) {
        ExportOptionDialog.exportOptionDialog.window = owner;
    }

    public static Optional<ExportOption> showAndWait() {
        exportOptionDialog.init();
        exportOptionDialog.load();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ExportOptionDialog.exportOptionDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)ExportOptionDialog.exportOptionDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ExportOptionDialog.exportOptionDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("ExportOptionDialog.title", "Export preferences"));
        this.dialog.setHeaderText(this.i18n.getString("ExportOptionDialog.header", "Export format of adjustment results"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, ExportOption>(){

            public ExportOption call(ButtonType buttonType) {
                ExportOption exportOption = ExportOption.getInstance();
                if (buttonType == ButtonType.OK) {
                    ExportOptionDialog.this.save();
                }
                return exportOption;
            }
        });
    }

    private Node createPane() {
        String labelNone = this.i18n.getString("ExportOptionDialog.export.none.label", "No data export");
        String tooltipNone = this.i18n.getString("ExportOptionDialog.export.none.tooltip", "If selected, no adjustment results are exported");
        String labelASCII = this.i18n.getString("ExportOptionDialog.export.ascii.label", "ASCII text files (*.info, *.cxx)");
        String tooltipASCII = this.i18n.getString("ExportOptionDialog.export.ascii.tooltip", "If selected, adjustment results are exported as simple text files in ASCII format");
        String labelMatlab = this.i18n.getString("ExportOptionDialog.export.matlab.label", "Binary Matlab file (*.mat)");
        String tooltipMatlab = this.i18n.getString("ExportOptionDialog.export.matlab.tooltip", "If selected, adjustment results are exported in Matlab specific binary format");
        this.noneRadioButton = this.createRadioButton(labelNone, tooltipNone);
        this.asciiRadioButton = this.createRadioButton(labelASCII, tooltipASCII);
        this.matlabRadioButton = this.createRadioButton(labelMatlab, tooltipMatlab);
        ToggleGroup group = new ToggleGroup();
        group.getToggles().addAll((Object[])new Toggle[]{this.noneRadioButton, this.asciiRadioButton, this.matlabRadioButton});
        this.noneRadioButton.setSelected(Boolean.TRUE.booleanValue());
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(7.0);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        GridPane.setHgrow((Node)this.noneRadioButton, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.asciiRadioButton, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.matlabRadioButton, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)this.noneRadioButton, 0, ++row);
        gridPane.add((Node)this.asciiRadioButton, 0, ++row);
        gridPane.add((Node)this.matlabRadioButton, 0, ++row);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ExportOptionDialog.this.noneRadioButton.requestFocus();
            }
        });
        return gridPane;
    }

    private void load() {
        try {
            ExportOption exportOption = ExportOption.getInstance();
            SQLManager.getInstance().loadExportPreferences();
            ExportOption.ExportResultType exportResultType = exportOption.getExportResultType();
            this.noneRadioButton.setSelected(exportResultType == ExportOption.ExportResultType.NONE);
            this.asciiRadioButton.setSelected(exportResultType == ExportOption.ExportResultType.ASCII);
            this.matlabRadioButton.setSelected(exportResultType == ExportOption.ExportResultType.MATLAB);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(ExportOptionDialog.this.i18n.getString("ExportOptionDialog.message.error.load.exception.title", "Unexpected SQL-Error"), ExportOptionDialog.this.i18n.getString("ExportOptionDialog.message.error.load.exception.header", "Error, could not load export preferences from database."), ExportOptionDialog.this.i18n.getString("ExportOptionDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void save() {
        try {
            ExportOption exportOption = ExportOption.getInstance();
            ExportOption.ExportResultType exportResultType = ExportOption.ExportResultType.NONE;
            exportResultType = this.asciiRadioButton.isSelected() ? ExportOption.ExportResultType.ASCII : (this.matlabRadioButton.isSelected() ? ExportOption.ExportResultType.MATLAB : ExportOption.ExportResultType.NONE);
            exportOption.setExportResultType(exportResultType);
            SQLManager.getInstance().saveExportPreferences();
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(ExportOptionDialog.this.i18n.getString("ExportOptionDialog.message.error.save.exception.title", "Unexpected SQL-Error"), ExportOptionDialog.this.i18n.getString("ExportOptionDialog.message.error.save.exception.header", "Error, could not save export options to database."), ExportOptionDialog.this.i18n.getString("ExportOptionDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private RadioButton createRadioButton(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxHeight(Double.MAX_VALUE);
        return radioButton;
    }
}

