/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.UICongruentPointTableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class CongruentPointDialog {
    private I18N i18n = I18N.getInstance();
    private static UICongruentPointTableBuilder tableBuilder = UICongruentPointTableBuilder.getInstance();
    private static CongruentPointDialog congruentPointDialog = new CongruentPointDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private DoubleTextField snapDistanceTextField;
    private ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
    private boolean preventClosing = false;
    private ProcessSQLTask processSQLTask = null;
    private CheckBox dimensionOneCheckBox;
    private CheckBox dimensionTwoCheckBox;
    private CheckBox dimensionThreeCheckBox;
    private Button okButton;
    private Node progressIndicatorPane;
    private Node settingPane;

    private CongruentPointDialog() {
    }

    public static void setOwner(Window owner) {
        CongruentPointDialog.congruentPointDialog.window = owner;
    }

    public static Optional<Void> showAndWait() {
        congruentPointDialog.init();
        congruentPointDialog.reset();
        TableView table = tableBuilder.getTable();
        ObservableList tableModel = tableBuilder.getTableModel(table);
        tableModel.clear();
        tableModel.setAll((Object[])new TerrestrialObservationRow[]{tableBuilder.getEmptyRow()});
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    congruentPointDialog.reset();
                    TableView table = tableBuilder.getTable();
                    ObservableList tableModel = tableBuilder.getTableModel(table);
                    tableModel.clear();
                    tableModel.setAll((Object[])new TerrestrialObservationRow[]{tableBuilder.getEmptyRow()});
                    CongruentPointDialog.congruentPointDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)CongruentPointDialog.congruentPointDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return CongruentPointDialog.congruentPointDialog.dialog.showAndWait();
    }

    private void reset() {
        this.progressIndicatorPane.setVisible(false);
        this.settingPane.setDisable(false);
        this.okButton.setDisable(false);
        this.preventClosing = false;
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("CongruentPointDialog.title", "Congruent points"));
        this.dialog.setHeaderText(this.i18n.getString("CongruentPointDialog.header", "Find congruent points in project"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().getScene().getWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (CongruentPointDialog.this.preventClosing) {
                    event.consume();
                }
            }
        });
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                if (CongruentPointDialog.this.preventClosing) {
                    event.consume();
                }
            }
        });
        this.okButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK);
        this.okButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new CongruentPointEvent());
        this.settingPane = this.createSettingPane();
        this.progressIndicatorPane = this.createProgressIndicatorPane();
        this.progressIndicatorPane.setVisible(false);
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        stackPane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        stackPane.getChildren().addAll((Object[])new Node[]{this.settingPane, this.progressIndicatorPane});
        this.dialog.getDialogPane().setContent((Node)stackPane);
    }

    private Node createSettingPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        String labelSnap = this.i18n.getString("CongruentPointDialog.snap.label", "Snap distance:");
        String tooltipSnap = this.i18n.getString("CongruentPointDialog.snap.tooltip", "Set snap distance to find congruent points");
        String labelDimension = this.i18n.getString("CongruentPointDialog.dimension.label", "Point dimension:");
        String label1D = this.i18n.getString("CongruentPointDialog.dimension.1d.label", "1D");
        String label2D = this.i18n.getString("CongruentPointDialog.dimension.2d.label", "2D");
        String label3D = this.i18n.getString("CongruentPointDialog.dimension.3d.label", "3D");
        String tooltip1D = this.i18n.getString("CongruentPointDialog.dimension.1d.tooltip", "If checked, 1D points will be included into search");
        String tooltip2D = this.i18n.getString("CongruentPointDialog.dimension.2d.tooltip", "If checked, 2D points will be included into search");
        String tooltip3D = this.i18n.getString("CongruentPointDialog.dimension.3d.tooltip", "If checked, 3D points will be included into search");
        this.snapDistanceTextField = new DoubleTextField(0.15, CellValueType.LENGTH_RESIDUAL, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT);
        this.snapDistanceTextField.setTooltip(new Tooltip(tooltipSnap));
        this.snapDistanceTextField.setMinWidth(100.0);
        this.snapDistanceTextField.setMaxWidth(500.0);
        this.dimensionOneCheckBox = this.createCheckBox(label1D, tooltip1D);
        this.dimensionTwoCheckBox = this.createCheckBox(label2D, tooltip2D);
        this.dimensionThreeCheckBox = this.createCheckBox(label3D, tooltip3D);
        DimensionChangeListener dimensionChangeListener = new DimensionChangeListener();
        this.dimensionOneCheckBox.selectedProperty().addListener((ChangeListener)dimensionChangeListener);
        this.dimensionTwoCheckBox.selectedProperty().addListener((ChangeListener)dimensionChangeListener);
        this.dimensionThreeCheckBox.selectedProperty().addListener((ChangeListener)dimensionChangeListener);
        this.dimensionTwoCheckBox.setSelected(true);
        this.dimensionThreeCheckBox.setSelected(true);
        TableView table = tableBuilder.getTable();
        table.setMaxWidth(Double.MAX_VALUE);
        Label snapLabel = new Label(labelSnap);
        snapLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Label dimensionLabel = new Label(labelDimension);
        dimensionLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.add((Node)snapLabel, 0, 0);
        gridPane.add((Node)this.snapDistanceTextField, 1, 0, 4, 1);
        gridPane.add((Node)dimensionLabel, 0, 1);
        gridPane.add((Node)this.dimensionOneCheckBox, 1, 1);
        gridPane.add((Node)this.dimensionTwoCheckBox, 2, 1);
        gridPane.add((Node)this.dimensionThreeCheckBox, 3, 1);
        VBox vbox = new VBox();
        vbox.setSpacing(10.0);
        vbox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        vbox.getChildren().setAll((Object[])new Node[]{gridPane, table});
        vbox.setPrefHeight(300.0);
        return vbox;
    }

    private Node createProgressIndicatorPane() {
        VBox box = new VBox();
        box.setAlignment(Pos.CENTER);
        box.getChildren().setAll((Object[])new Node[]{this.progressIndicator});
        return box;
    }

    private void process() {
        this.reset();
        this.processSQLTask = new ProcessSQLTask();
        this.processSQLTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                CongruentPointDialog.this.preventClosing = false;
                List rows = (List)CongruentPointDialog.this.processSQLTask.getValue();
                TableView table = tableBuilder.getTable();
                if (rows != null && !rows.isEmpty()) {
                    tableBuilder.getTableModel(table).setAll((Collection)rows);
                    table.sort();
                } else {
                    tableBuilder.getTableModel(table).setAll((Object[])new TerrestrialObservationRow[]{tableBuilder.getEmptyRow()});
                }
            }
        });
        this.processSQLTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                CongruentPointDialog.this.preventClosing = false;
                CongruentPointDialog.this.dialog.hide();
                final Throwable throwable = CongruentPointDialog.this.processSQLTask.getException();
                if (throwable != null) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OptionDialog.showThrowableDialog((this).CongruentPointDialog.this.i18n.getString("CongruentPointDialog.message.error.request.exception.title", "Unexpected SQL-Error"), (this).CongruentPointDialog.this.i18n.getString("CongruentPointDialog.message.error.request.exception.header", "Error, database request is failed."), (this).CongruentPointDialog.this.i18n.getString("CongruentPointDialog.message.error.request.exception.message", "An exception has occurred during database transaction."), throwable);
                        }
                    });
                    throwable.printStackTrace();
                }
                UITreeBuilder.getInstance().getTree().getSelectionModel().select(0);
            }
        });
        Thread th = new Thread((Runnable)((Object)this.processSQLTask));
        th.setDaemon(true);
        th.start();
    }

    private CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxWidth(Double.MAX_VALUE);
        return checkBox;
    }

    private class CongruentPointEvent
    implements EventHandler<ActionEvent> {
        private CongruentPointEvent() {
        }

        public void handle(ActionEvent event) {
            CongruentPointDialog.this.okButton.setDisable(true);
            CongruentPointDialog.this.process();
            event.consume();
        }
    }

    private class DimensionChangeListener
    implements ChangeListener<Boolean> {
        private DimensionChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            CongruentPointDialog.this.okButton.setDisable(!CongruentPointDialog.this.dimensionOneCheckBox.isSelected() && !CongruentPointDialog.this.dimensionTwoCheckBox.isSelected() && !CongruentPointDialog.this.dimensionThreeCheckBox.isSelected());
        }
    }

    private class ProcessSQLTask
    extends Task<List<TerrestrialObservationRow>> {
        private ProcessSQLTask() {
        }

        protected List<TerrestrialObservationRow> call() throws Exception {
            try {
                List<TerrestrialObservationRow> rows;
                CongruentPointDialog.this.preventClosing = true;
                CongruentPointDialog.this.progressIndicatorPane.setVisible(true);
                CongruentPointDialog.this.settingPane.setDisable(true);
                CongruentPointDialog.this.okButton.setDisable(true);
                double distance = CongruentPointDialog.this.snapDistanceTextField.getNumber();
                boolean dimension1D = CongruentPointDialog.this.dimensionOneCheckBox.isSelected();
                boolean dimension2D = CongruentPointDialog.this.dimensionTwoCheckBox.isSelected();
                boolean dimension3D = CongruentPointDialog.this.dimensionThreeCheckBox.isSelected();
                List<TerrestrialObservationRow> list = rows = SQLManager.getInstance().getCongruentPoints(distance, dimension1D, dimension2D, dimension3D);
                return list;
            }
            finally {
                CongruentPointDialog.this.reset();
            }
        }

        protected void succeeded() {
            CongruentPointDialog.this.preventClosing = false;
            super.succeeded();
        }

        protected void failed() {
            CongruentPointDialog.this.preventClosing = false;
            super.failed();
        }
    }
}

