/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.PointType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.io.reader.CSVObservationFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.CSVPointFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.CSVVerticalDeflectionFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.ColumnDefinedObservationFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.ColumnDefinedPointFileReader;
import org.applied_geodesy.jag3d.ui.io.reader.ColumnDefinedVerticalDeflectionFileReader;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.ui.textfield.LimitedTextField;
import org.applied_geodesy.util.io.PreviewFileReader;
import org.applied_geodesy.util.io.SourceFileReader;
import org.applied_geodesy.util.io.csv.CSVColumnType;
import org.applied_geodesy.util.io.csv.CSVOptionType;
import org.applied_geodesy.util.io.csv.CSVParser;
import org.applied_geodesy.util.io.csv.ColumnRange;

public class ColumnImportDialog {
    private I18N i18n = I18N.getInstance();
    private static ColumnImportDialog columnImportDialog = new ColumnImportDialog();
    private Dialog<SourceFileReader<TreeItem<TreeItemValue>>> dialog = null;
    private Window window;
    private int[] maxCharactersPerColumn = null;
    private List<String> linesOfFile = new ArrayList<String>(20);
    private List<TextField> textFieldList = new ArrayList<TextField>(20);
    private ComboBox<Enum<?>> importTypes;
    private HBox editor;
    private List<VBox> columns = new ArrayList<VBox>();
    private Node csvOptionPane;
    private Node pointColumnPickerPane;
    private Node deflectionColumnPickerPane;
    private Node terrestrialObservationColumnPickerPane;
    private Node gnssObservationColumnPickerPane;
    private CheckBox importCSVFileCheckBox;
    private int startColumn = -1;
    private int endColumn = -1;
    private static final int MAX_LINES = 10;
    private final String TABULATOR = "     ";
    private char separator = (char)44;
    private char quotechar = (char)34;
    private char escape = (char)92;
    private Locale fileLocale = Locale.ENGLISH;

    private ColumnImportDialog() {
    }

    public static void setOwner(Window owner) {
        ColumnImportDialog.columnImportDialog.window = owner;
    }

    public static Optional<SourceFileReader<TreeItem<TreeItemValue>>> showAndWait(File selectedFile) {
        if (selectedFile == null) {
            return null;
        }
        columnImportDialog.init();
        try {
            columnImportDialog.readPreview(selectedFile);
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnImportDialog.columnImportDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)ColumnImportDialog.columnImportDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ColumnImportDialog.columnImportDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("ColumnImportDialog.title", "Column based file import"));
        this.dialog.setHeaderText(this.i18n.getString("ColumnImportDialog.header", "User-defined import of column-based files"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent(this.createMainPane());
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, SourceFileReader<TreeItem<TreeItemValue>>>(){

            public SourceFileReader<TreeItem<TreeItemValue>> call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return ColumnImportDialog.this.getSourceFileReader();
                }
                return null;
            }
        });
    }

    private Node createMainPane() {
        VBox vBox = new VBox();
        vBox.setSpacing(10.0);
        vBox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        Node editorPane = this.initEditor();
        this.importCSVFileCheckBox = this.createCSVCheckbox();
        this.pointColumnPickerPane = this.createPointColumnPickerPane();
        this.deflectionColumnPickerPane = this.createVerticalDeflectionColumnPickerPane();
        this.terrestrialObservationColumnPickerPane = this.createTerrestrialObservationColumnPickerPane();
        this.gnssObservationColumnPickerPane = this.createGNSSObservationColumnPickerPane();
        this.importTypes = this.createImportTypeComboBox();
        this.csvOptionPane = this.createCSVOptionPane();
        Node globalImportOptions = this.createImportOptionPane();
        vBox.getChildren().addAll((Object[])new Node[]{globalImportOptions, this.csvOptionPane, this.pointColumnPickerPane, this.deflectionColumnPickerPane, this.terrestrialObservationColumnPickerPane, this.gnssObservationColumnPickerPane, editorPane});
        ScrollPane scrollPane = new ScrollPane((Node)vBox);
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ColumnImportDialog.this.importTypes.requestFocus();
            }
        });
        return scrollPane;
    }

    private Node createImportOptionPane() {
        GridPane gridPane = this.createGridPane();
        ToggleGroup localeGroup = new ToggleGroup();
        LocaleOptionChangeListener localeChangeListener = new LocaleOptionChangeListener(localeGroup);
        RadioButton englishLocaleRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.decimal.separator.point.label", "Point"), this.i18n.getString("ColumnImportDialog.decimal.separator.point.tooltip", "If selected, decimal separator is set to point"), true, Locale.ENGLISH, localeGroup, localeChangeListener);
        RadioButton germanLocaleRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.decimal.separator.comma.label", "Comma"), this.i18n.getString("ColumnImportDialog.decimal.separator.comma.tooltip", "If selected, decimal separator is set to comma"), false, Locale.GERMAN, localeGroup, localeChangeListener);
        int columnIndex = 0;
        int rowIndex = 0;
        gridPane.add(this.importTypes, columnIndex++, rowIndex);
        gridPane.add((Node)this.importCSVFileCheckBox, columnIndex++, rowIndex);
        columnIndex = 0;
        gridPane.add((Node)new Label(this.i18n.getString("ColumnImportDialog.decimal.separator.label", "Decimal separator:")), columnIndex++, ++rowIndex);
        gridPane.add((Node)englishLocaleRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)germanLocaleRadioButton, columnIndex++, rowIndex);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("ColumnImportDialog.import.label", "Import options"), this.i18n.getString("ColumnImportDialog.import.tooltip", "Specify global import options"), (Node)gridPane);
        return titledPane;
    }

    private Node createCSVOptionPane() {
        GridPane gridPane = this.createGridPane();
        char separator = ',';
        int quotechar = 34;
        char escape = '\\';
        ToggleGroup separatorGroup = new ToggleGroup();
        separatorGroup.setUserData((Object)CSVOptionType.SEPARATOR);
        final LimitedTextField separatorTextField = new LimitedTextField(1, "|");
        separatorTextField.setPrefColumnCount(1);
        separatorTextField.setTooltip(new Tooltip(this.i18n.getString("ColumnImportDialog.csv.separator.user.field.tooltip", "User-defined column separator")));
        separatorTextField.setUserData((Object)CSVOptionType.SEPARATOR);
        separatorTextField.setMaxWidth(Double.NEGATIVE_INFINITY);
        separatorTextField.setDisable(true);
        separatorTextField.textProperty().addListener((ChangeListener)new CSVUserDefinedOptionChangeListener(separatorTextField));
        CSVOptionChangeListener separatorChangeListener = new CSVOptionChangeListener(separatorGroup);
        RadioButton commaSeparatorRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.separator.comma.label", "Comma"), this.i18n.getString("ColumnImportDialog.csv.separator.comma.tooltip", "If selected, column separator is set to comma"), separator == ',', Character.valueOf(','), separatorGroup, separatorChangeListener);
        RadioButton semicolonSeparatorRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.separator.semicolon.label", "Semicolon"), this.i18n.getString("ColumnImportDialog.csv.separator.semicolon.tooltip", "If selected, column separator is set to semicolon"), separator == ';', Character.valueOf(';'), separatorGroup, separatorChangeListener);
        RadioButton blankSeparatorRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.separator.blank.label", "Blank"), this.i18n.getString("ColumnImportDialog.csv.separator.blank.tooltip", "If selected, column separator is set to blank"), separator == ' ', Character.valueOf(' '), separatorGroup, separatorChangeListener);
        RadioButton tabulatorSeparatorRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.separator.tabulator.label", "Tabulator"), this.i18n.getString("ColumnImportDialog.csv.separator.tabulator.tooltip", "If selected, column separator is set to tabulator"), separator == '\t', Character.valueOf('\t'), separatorGroup, separatorChangeListener);
        RadioButton userdefinedSeparatorRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.separator.user.label", "User-defined"), this.i18n.getString("ColumnImportDialog.csv.separator.user.tooltip", "If selected, column separator is user-defined"), separatorTextField.getText().length() > 0 && separator == separatorTextField.getText().charAt(0), (Object)separatorTextField, separatorGroup, separatorChangeListener);
        HBox separatorBox = new HBox();
        separatorBox.setSpacing(3.0);
        separatorBox.setAlignment(Pos.CENTER_LEFT);
        separatorBox.getChildren().addAll((Object[])new Node[]{userdefinedSeparatorRadioButton, separatorTextField});
        userdefinedSeparatorRadioButton.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                separatorTextField.setDisable(newValue == false);
            }
        });
        ToggleGroup quoteGroup = new ToggleGroup();
        quoteGroup.setUserData((Object)CSVOptionType.QUOTE);
        CSVOptionChangeListener quoteChangeListener = new CSVOptionChangeListener(quoteGroup);
        RadioButton noneQuoteCharRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.quote.none.label", "None"), this.i18n.getString("ColumnImportDialog.csv.quote.none.tooltip", "If selected, quote character is undefined"), quotechar == 0, Character.valueOf('\u0000'), quoteGroup, quoteChangeListener);
        RadioButton singleQuoteCharRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.quote.single.label", "Single quote"), this.i18n.getString("ColumnImportDialog.csv.quote.single.tooltip", "If selected, single quote character will used"), quotechar == 39, Character.valueOf('\''), quoteGroup, quoteChangeListener);
        RadioButton doubleQuoteCharRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.quote.double.label", "Double quote"), this.i18n.getString("ColumnImportDialog.csv.quote.double.tooltip", "If selected, double quote character will used"), quotechar == 34, Character.valueOf('\"'), quoteGroup, quoteChangeListener);
        ToggleGroup escapeGroup = new ToggleGroup();
        escapeGroup.setUserData((Object)CSVOptionType.ESCAPE);
        final LimitedTextField escapeTextField = new LimitedTextField(1, String.valueOf(escape));
        escapeTextField.setPrefColumnCount(1);
        escapeTextField.setTooltip(new Tooltip(this.i18n.getString("ColumnImportDialog.csv.escape.user.field.tooltip", "User-defined escape character")));
        escapeTextField.setMaxWidth(Double.NEGATIVE_INFINITY);
        escapeTextField.setUserData((Object)CSVOptionType.ESCAPE);
        escapeTextField.textProperty().addListener((ChangeListener)new CSVUserDefinedOptionChangeListener(escapeTextField));
        CSVOptionChangeListener escapeChangeListener = new CSVOptionChangeListener(escapeGroup);
        RadioButton noneEscapeCharRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.escape.none.label", "Note"), this.i18n.getString("ColumnImportDialog.csv.escape.none.tooltip", "If selected, escape character is undefined"), escape == '\u0000', Character.valueOf('\u0000'), escapeGroup, escapeChangeListener);
        RadioButton userdefinedEscapeRadioButton = this.createRadioButton(this.i18n.getString("ColumnImportDialog.csv.escape.user.label", "User-defined"), this.i18n.getString("ColumnImportDialog.csv.escape.user.tooltip", "If selected, column separator is user-defined"), escapeTextField.getText().length() > 0 && escape == escapeTextField.getText().charAt(0), (Object)escapeTextField, escapeGroup, escapeChangeListener);
        HBox escapeBox = new HBox();
        escapeBox.setSpacing(3.0);
        escapeBox.setAlignment(Pos.CENTER_LEFT);
        escapeBox.getChildren().addAll((Object[])new Node[]{userdefinedEscapeRadioButton, escapeTextField});
        userdefinedEscapeRadioButton.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                escapeTextField.setDisable(newValue == false);
            }
        });
        int columnIndex = 0;
        int rowIndex = 0;
        gridPane.add((Node)new Label(this.i18n.getString("ColumnImportDialog.csv.separator.label", "Column separator:")), columnIndex++, rowIndex);
        gridPane.add((Node)commaSeparatorRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)semicolonSeparatorRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)blankSeparatorRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)tabulatorSeparatorRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)separatorBox, columnIndex++, rowIndex);
        columnIndex = 0;
        gridPane.add((Node)new Label(this.i18n.getString("ColumnImportDialog.csv.quote.label", "Quote character:")), columnIndex++, ++rowIndex);
        gridPane.add((Node)noneQuoteCharRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)singleQuoteCharRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)doubleQuoteCharRadioButton, columnIndex++, rowIndex);
        columnIndex = 0;
        gridPane.add((Node)new Label(this.i18n.getString("ColumnImportDialog.csv.escape.label", "Escape character:")), columnIndex++, ++rowIndex);
        gridPane.add((Node)noneEscapeCharRadioButton, columnIndex++, rowIndex);
        gridPane.add((Node)escapeBox, columnIndex++, rowIndex);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("ColumnImportDialog.csv.label", "CSV options"), this.i18n.getString("ColumnImportDialog.csv.tooltip", "Specify character-separated-values (CSV) import options"), (Node)gridPane);
        titledPane.setDisable(!this.importCSVFileCheckBox.isSelected());
        return titledPane;
    }

    private Node createVerticalDeflectionColumnPickerPane() {
        GridPane gridPane = this.createGridPane();
        int columnIndex = 0;
        int rowIndex = 0;
        String buttonLabel = this.i18n.getString("ColumnImportDialog.column.deflection.name.label", "Point-id \u25b6");
        String buttonTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.name.tooltip", "Add selected range for point-id");
        String textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.name.text.tooltip", "Range for point-id column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.POINT_ID, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.deflection.y0.label", "\u03b6y0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.y0.tooltip", "Add selected range for a-priori deflection of y-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.y0.text.tooltip", "Range for a-priori deflection of y-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.Y, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.deflection.x0.label", "\u03b6x0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.x0.tooltip", "Add selected range for a-priori deflection of x-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.x0.text.tooltip", "Range for a-priori udeflection of x-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.X, buttonLabel, buttonTooltip, textFieldTooltip);
        columnIndex = 2;
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.deflection.sigma.y0.label", "\u03c3y0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.sigma.y0.tooltip", "Add selected range for a-priori uncertainty of y-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.sigma.y0.text.tooltip", "Range for a-priori uncertainty of y-component column");
        columnIndex = this.addPickerElement(gridPane, ++rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_Y, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.deflection.sigma.x0.label", "\u03c3x0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.sigma.x0.tooltip", "Add selected range for a-priori uncertainty of x-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.deflection.sigma.x0.text.tooltip", "Range for a-priori uncertainty of x-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_X, buttonLabel, buttonTooltip, textFieldTooltip);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("ColumnImportDialog.column.deflection.label", "Column defintions for vertical deflection"), this.i18n.getString("ColumnImportDialog.column.deflection.tooltip", "Specify column range of file for vertical deflection import"), (Node)gridPane);
        return titledPane;
    }

    private Node createPointColumnPickerPane() {
        GridPane gridPane = this.createGridPane();
        int columnIndex = 0;
        int rowIndex = 0;
        String buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.name.label", "Point-id \u25b6");
        String buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.name.tooltip", "Add selected range for point-id");
        String textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.name.text.tooltip", "Range for point-id column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.POINT_ID, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.y0.label", "y0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.y0.tooltip", "Add selected range for a-priori y-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.y0.text.tooltip", "Range for a-priori y-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.Y, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.x0.label", "x0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.x0.tooltip", "Add selected range for a-priori x-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.x0.text.tooltip", "Range for a-priori x-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.X, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.z0.label", "z0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.z0.tooltip", "Add selected range for a-priori z-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.z0.text.tooltip", "Range for a-priori z-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.Z, buttonLabel, buttonTooltip, textFieldTooltip);
        columnIndex = 0;
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.code.label", "Code \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.code.tooltip", "Add selected range for code");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.code.text.tooltip", "Range for code column");
        columnIndex = this.addPickerElement(gridPane, ++rowIndex, columnIndex, CSVColumnType.POINT_CODE, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.sigma.y0.label", "\u03c3y0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.sigma.y0.tooltip", "Add selected range for a-priori uncertainty of y-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.sigma.y0.text.tooltip", "Range for a-priori uncertainty of y-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_Y, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.sigma.x0.label", "\u03c3x0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.sigma.x0.tooltip", "Add selected range for a-priori uncertainty of x-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.sigma.x0.text.tooltip", "Range for a-priori uncertainty of x-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_X, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.point.sigma.z0.label", "\u03c3z0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.point.sigma.z0.tooltip", "Add selected range for a-priori uncertainty of z-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.point.sigma.z0.text.tooltip", "Range for a-priori uncertainty of z-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_Z, buttonLabel, buttonTooltip, textFieldTooltip);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("ColumnImportDialog.column.point.label", "Column defintions for points"), this.i18n.getString("ColumnImportDialog.column.point.tooltip", "Specify column range of file for points import"), (Node)gridPane);
        return titledPane;
    }

    private Node createGNSSObservationColumnPickerPane() {
        GridPane gridPane = this.createGridPane();
        int columnIndex = 0;
        int rowIndex = 0;
        String buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.station.label", "Station \u25b6");
        String buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.station.tooltip", "Add selected range for station");
        String textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.station.text.tooltip", "Range for station column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.STATION, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.y0.label", "y0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.y0.tooltip", "Add selected range for a-priori y-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.y0.text.tooltip", "Range for a-priori y-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.Y, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.x0.label", "x0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.x0.tooltip", "Add selected range for a-priori x-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.x0.text.tooltip", "Range for a-priori x-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.X, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.z0.label", "z0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.z0.tooltip", "Add selected range for a-priori z-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.z0.text.tooltip", "Range for a-priori z-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.Z, buttonLabel, buttonTooltip, textFieldTooltip);
        columnIndex = 0;
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.target.label", "Target \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.target.tooltip", "Add selected range for target point");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.target.text.tooltip", "Range for target point column");
        columnIndex = this.addPickerElement(gridPane, ++rowIndex, columnIndex, CSVColumnType.TARGET, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.y0.label", "\u03c3y0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.y0.tooltip", "Add selected range for a-priori uncertainty of y-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.y0.text.tooltip", "Range for a-priori uncertainty of y-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_Y, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.x0.label", "\u03c3x0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.x0.tooltip", "Add selected range for a-priori uncertainty of x-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.x0.text.tooltip", "Range for a-priori uncertainty of x-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_X, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.z0.label", "\u03c3z0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.z0.tooltip", "Add selected range for a-priori uncertainty of z-component");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.gnss.sigma.z0.text.tooltip", "Range for a-priori uncertainty of z-component column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY_Z, buttonLabel, buttonTooltip, textFieldTooltip);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("ColumnImportDialog.column.gnss.label", "Column defintions for GNSS observations"), this.i18n.getString("ColumnImportDialog.column.gnss.tooltip", "Specify column range of file for GNSS observations import"), (Node)gridPane);
        return titledPane;
    }

    private Node createTerrestrialObservationColumnPickerPane() {
        GridPane gridPane = this.createGridPane();
        int columnIndex = 0;
        int rowIndex = 0;
        String buttonLabel = this.i18n.getString("ColumnImportDialog.column.terrestrial.station.label", "Station \u25b6");
        String buttonTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.station.tooltip", "Add selected range for station");
        String textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.station.text.tooltip", "Range for station column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.STATION, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.terrestrial.station.height.label", "ih \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.station.height.tooltip", "Add selected range for instrument height");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.station.height.text.tooltip", "Range for instrument height column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.INSTRUMENT_HEIGHT, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.terrestrial.value.label", "Value0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.value.tooltip", "Add selected range for a-priori observation value");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.value.text.tooltip", "Range for observation value column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.VALUE, buttonLabel, buttonTooltip, textFieldTooltip);
        columnIndex = 0;
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.terrestrial.target.label", "Target \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.target.tooltip", "Add selected range for target point");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.target.text.tooltip", "Range for target point column");
        columnIndex = this.addPickerElement(gridPane, ++rowIndex, columnIndex, CSVColumnType.TARGET, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.terrestrial.target.height.label", "th \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.target.height.tooltip", "Add selected range for target height");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.target.height.text.tooltip", "Range for target height column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.TARGET_HEIGHT, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.terrestrial.sigma0.label", "\u03c30 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.sigma0.tooltip", "Add selected range for a-priori uncertainty");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.sigma0.text.tooltip", "Range for uncertainty column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.UNCERTAINTY, buttonLabel, buttonTooltip, textFieldTooltip);
        buttonLabel = this.i18n.getString("ColumnImportDialog.column.terrestrial.distance.label", "d0 \u25b6");
        buttonTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.distance.tooltip", "Add selected range for length approximation for distance dependent uncertainty");
        textFieldTooltip = this.i18n.getString("ColumnImportDialog.column.terrestrial.distance.text.tooltip", "Range for length approximation for distance dependent uncertainty calculation column");
        columnIndex = this.addPickerElement(gridPane, rowIndex, columnIndex, CSVColumnType.DISTANCE_FOR_UNCERTAINTY, buttonLabel, buttonTooltip, textFieldTooltip);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("ColumnImportDialog.column.terrestrial.label", "Column defintions for terrestrial observations"), this.i18n.getString("ColumnImportDialog.column.terrestrial.tooltip", "Specify column range of file for terrestrial observations import"), (Node)gridPane);
        return titledPane;
    }

    private int addPickerElement(GridPane gridPane, int rowIndex, int columnIndex, CSVColumnType type, String buttonLabel, String buttonTooltip, String textFieldTooltip) {
        String promptText = this.i18n.getString("ColumnImportDialog.column.range.prompt", "from - to");
        final TextField textField = new TextField();
        textField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        textField.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        textField.setPrefWidth(Double.NEGATIVE_INFINITY);
        textField.setTooltip(new Tooltip(textFieldTooltip));
        textField.setPromptText(promptText);
        textField.setUserData((Object)type);
        UnaryOperator<TextFormatter.Change> textFilter = new UnaryOperator<TextFormatter.Change>(){

            @Override
            public TextFormatter.Change apply(TextFormatter.Change change) {
                String input = change.getControlNewText();
                Pattern pattern = ColumnImportDialog.this.importCSVFileCheckBox.isSelected() ? Pattern.compile("^(\\d+)$") : Pattern.compile("^(\\d+)(\\s*-\\s*(\\d*))?$");
                Matcher matcher = pattern.matcher(input.trim());
                if (!change.isContentChange() || input.trim().isEmpty()) {
                    return change;
                }
                if (!matcher.matches()) {
                    return null;
                }
                return change;
            }
        };
        textField.setTextFormatter(new TextFormatter((UnaryOperator)textFilter));
        Button button = new Button(buttonLabel);
        button.setTooltip(new Tooltip(buttonTooltip));
        button.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        button.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        button.setUserData((Object)textField);
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                int[] columns = ColumnImportDialog.this.getSelectedColumns();
                int min = columns[0];
                int max = columns[1];
                if (min >= 0 && max >= 0) {
                    if (ColumnImportDialog.this.importCSVFileCheckBox.isSelected()) {
                        textField.setText(String.valueOf(min));
                    } else {
                        textField.setText(String.valueOf(min) + " - " + String.valueOf(max));
                    }
                }
            }
        });
        gridPane.add((Node)button, columnIndex++, rowIndex);
        gridPane.add((Node)textField, columnIndex++, rowIndex);
        GridPane.setHgrow((Node)button, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
        this.textFieldList.add(textField);
        return columnIndex;
    }

    private Node initEditor() {
        ColumnSelectionEventHandler columnSelectionEventHandler = new ColumnSelectionEventHandler();
        this.editor = new HBox();
        this.editor.setOnMouseMoved((EventHandler)columnSelectionEventHandler);
        this.editor.setOnMouseReleased((EventHandler)columnSelectionEventHandler);
        this.editor.setOnMousePressed((EventHandler)columnSelectionEventHandler);
        this.editor.setOnMouseDragged((EventHandler)columnSelectionEventHandler);
        this.editor.setOnMouseClicked((EventHandler)columnSelectionEventHandler);
        this.editor.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.editor.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.editor.setPadding(new Insets(5.0));
        this.editor.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.editor.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.DARKGRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        VBox column = new VBox(0.0);
        column.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        column.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, CornerRadii.EMPTY, new BorderWidths(1.0), Insets.EMPTY)}));
        int j = 0;
        while (j < 10) {
            Text text = new Text(" ");
            text.setFont(Font.font((String)"MonoSpace", (FontWeight)FontWeight.NORMAL, (double)12.0));
            column.getChildren().add((Object)text);
            ++j;
        }
        this.editor.getChildren().add((Object)column);
        ScrollPane editorScrollPane = new ScrollPane((Node)this.editor);
        editorScrollPane.setFitToHeight(true);
        editorScrollPane.setFitToWidth(true);
        TitledPane titledPane = this.createTitledPane(this.i18n.getString("ColumnImportDialog.file.preview.label", "File preview"), this.i18n.getString("ColumnImportDialog.file.preview.tooltip", "Preview of selected file"), (Node)editorScrollPane);
        return titledPane;
    }

    private void addColumnHeader(int columns, int[] columnSize) {
        int j;
        StringBuffer headerLine = new StringBuffer();
        if (this.importCSVFileCheckBox != null && this.importCSVFileCheckBox.isSelected() && columnSize != null) {
            j = 0;
            int index = 1;
            int columnLength = 0;
            int halfInterval = 0;
            int i = 0;
            while (i < columns) {
                if (i == columnLength) {
                    headerLine.append("[");
                    columnLength += columnSize[j];
                    halfInterval = columnSize[j] / 2 + 1;
                    ++j;
                } else if (i == columnLength - 1) {
                    headerLine.append("]");
                } else if (i == columnLength - halfInterval) {
                    String str = String.valueOf(index++);
                    int endPos = i + 1;
                    int startPos = endPos - str.length();
                    headerLine.replace(startPos, endPos, str);
                } else {
                    headerLine.append("\u2219");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < columns) {
                if (i % 5 == 0) {
                    headerLine.append("+");
                } else {
                    headerLine.append("\u2219");
                }
                if (i % 10 == 0) {
                    String str = String.valueOf(i);
                    int endPos = i + 1;
                    int startPos = endPos - str.length();
                    headerLine.replace(startPos, endPos, str);
                }
                ++i;
            }
        }
        j = 0;
        while (j < columns) {
            Text text = new Text(String.valueOf(headerLine.charAt(j)));
            text.setFont(Font.font((String)"MonoSpace", (FontWeight)FontWeight.BOLD, (double)12.0));
            text.setFill((Paint)Color.DARKBLUE);
            text.setTextAlignment(TextAlignment.CENTER);
            this.columns.get(j).getChildren().add((Object)text);
            ++j;
        }
    }

    private void selectColumns(int startColumn, int endColumn) {
        int columnIndex = 0;
        while (columnIndex < this.columns.size()) {
            VBox column = this.columns.get(columnIndex);
            if (columnIndex >= startColumn && columnIndex <= endColumn) {
                column.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, CornerRadii.EMPTY, Insets.EMPTY)}));
                column.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, (Paint)(columnIndex == endColumn ? Color.BLACK : Color.TRANSPARENT), (Paint)Color.BLACK, (Paint)(columnIndex == startColumn ? Color.BLACK : Color.TRANSPARENT), BorderStrokeStyle.DOTTED, columnIndex == endColumn ? BorderStrokeStyle.DOTTED : BorderStrokeStyle.NONE, BorderStrokeStyle.DOTTED, columnIndex == startColumn ? BorderStrokeStyle.DOTTED : BorderStrokeStyle.NONE, CornerRadii.EMPTY, new BorderWidths(1.0), Insets.EMPTY)}));
            } else {
                column.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
                column.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, CornerRadii.EMPTY, new BorderWidths(1.0), Insets.EMPTY)}));
            }
            ++columnIndex;
        }
    }

    private void readPreview(File f) throws IOException, SQLException {
        PreviewFileReader reader = new PreviewFileReader(f, 10);
        reader.ignoreLinesWhichStartWith("#");
        reader.read();
        this.linesOfFile.clear();
        this.linesOfFile = reader.getLines();
        this.changeMode();
    }

    private int[] getSelectedColumns() {
        if (this.importCSVFileCheckBox.isSelected()) {
            int columnLength = 0;
            int i = 0;
            while (i < this.maxCharactersPerColumn.length) {
                if (this.startColumn <= columnLength && columnLength < this.endColumn) {
                    return new int[]{i + 1, i + 1};
                }
                columnLength += this.maxCharactersPerColumn[i];
                ++i;
            }
        }
        return new int[]{Math.min(this.endColumn, this.startColumn), Math.max(this.endColumn, this.startColumn)};
    }

    private void showContentPreview() {
        int contentColumns = 0;
        int contentRows = this.linesOfFile.size();
        this.columns.clear();
        this.editor.getChildren().clear();
        this.maxCharactersPerColumn = null;
        ArrayList<String> formattedLines = new ArrayList<String>(contentRows);
        if (this.importCSVFileCheckBox != null && this.importCSVFileCheckBox.isSelected()) {
            if (this.anyCharactersAreTheSame(this.separator, this.quotechar, this.escape)) {
                return;
            }
            int BUFFER_CHARS = 5;
            try {
                boolean strictQuotes = false;
                boolean ignoreLeadingWhiteSpace = true;
                boolean ignoreQuotations = false;
                CSVParser csvParser = new CSVParser(this.separator, this.quotechar, this.escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations);
                int columCounter = 0;
                ArrayList<String[]> fileData = new ArrayList<String[]>(20);
                ArrayList<String> row = new ArrayList<String>(20);
                int i = 0;
                while (i < this.linesOfFile.size()) {
                    String line = this.linesOfFile.get(i);
                    String[] parsedLine = csvParser.parseLineMulti(line);
                    if (parsedLine != null && parsedLine.length > 0) {
                        row.addAll(Arrays.asList(parsedLine));
                    }
                    if (!csvParser.isPending()) {
                        fileData.add(row.toArray(new String[row.size()]));
                        columCounter = Math.max(columCounter, row.size());
                        row.clear();
                    }
                    ++i;
                }
                this.maxCharactersPerColumn = new int[columCounter];
                for (String[] line : fileData) {
                    int i2 = 0;
                    while (i2 < line.length) {
                        line[i2] = line[i2].replace('\n', ' ').replaceAll("\t", "     ").trim();
                        this.maxCharactersPerColumn[i2] = Math.max(this.maxCharactersPerColumn[i2], line[i2].length() + 5);
                        ++i2;
                    }
                }
                for (String[] line : fileData) {
                    StringBuilder formattedLine = new StringBuilder();
                    int i3 = 0;
                    while (i3 < line.length) {
                        formattedLine.append(String.format(Locale.ENGLISH, "%" + this.maxCharactersPerColumn[i3] + "s", line[i3]));
                        ++i3;
                    }
                    formattedLines.add(formattedLine.toString().replaceAll("\\s+$", ""));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (String line : this.linesOfFile) {
                formattedLines.add(line.replaceAll("\t", "     "));
            }
        }
        for (String str : formattedLines) {
            contentColumns = Math.max(contentColumns, str.length());
        }
        int i = 0;
        while (i < contentColumns) {
            VBox column = new VBox(0.0);
            column.setUserData((Object)new ColumnIndex(i));
            column.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            column.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, (Paint)Color.TRANSPARENT, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, BorderStrokeStyle.NONE, CornerRadii.EMPTY, new BorderWidths(1.0), Insets.EMPTY)}));
            this.editor.getChildren().add((Object)column);
            this.columns.add(column);
            ++i;
        }
        this.addColumnHeader(contentColumns, this.maxCharactersPerColumn);
        i = 0;
        while (i < Math.min(formattedLines.size(), 10)) {
            String line = String.format(Locale.ENGLISH, "%-" + contentColumns + "s", formattedLines.get(i));
            int j = 0;
            while (j < contentColumns) {
                Text character = new Text(String.valueOf(line.charAt(j)));
                character.setFont(Font.font((String)"MonoSpace", (FontWeight)FontWeight.NORMAL, (double)12.0));
                character.setFill((Paint)Color.BLACK);
                character.setTextAlignment(TextAlignment.CENTER);
                this.columns.get(j).getChildren().add((Object)character);
                ++j;
            }
            ++i;
        }
        i = formattedLines.size();
        while (i < 10) {
            int j = 0;
            while (j < contentColumns) {
                Text character = new Text(" ");
                character.setFont(Font.font((String)"MonoSpace", (FontWeight)FontWeight.NORMAL, (double)12.0));
                character.setFill((Paint)Color.TRANSPARENT);
                character.setTextAlignment(TextAlignment.CENTER);
                this.columns.get(j).getChildren().add((Object)character);
                ++j;
            }
            ++i;
        }
    }

    private ComboBox<Enum<?>> createImportTypeComboBox() {
        Enum type;
        ComboBox typeComboBox = new ComboBox();
        ObservableList model = typeComboBox.getItems();
        Enum[] enumArray = PointType.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = enumArray[n2];
            model.add(type);
            ++n2;
        }
        enumArray = ObservationType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            type = enumArray[n2];
            model.add(type);
            ++n2;
        }
        enumArray = VerticalDeflectionType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            type = enumArray[n2];
            model.add(type);
            ++n2;
        }
        typeComboBox.setConverter(new StringConverter<Enum<?>>(){

            public Enum<?> fromString(String string) {
                PointType type = PointType.valueOf(string);
                return type != null ? type : ObservationType.valueOf(string);
            }

            public String toString(Enum<?> item) {
                if (item instanceof PointType) {
                    PointType type = (PointType)item;
                    switch (type) {
                        case DATUM_POINT: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.points.datum", "Datum points");
                        }
                        case NEW_POINT: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.points.new", "New points");
                        }
                        case REFERENCE_POINT: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.points.reference", "Reference points");
                        }
                        case STOCHASTIC_POINT: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.points.stochastic", "Stochastic points");
                        }
                    }
                } else if (item instanceof ObservationType) {
                    ObservationType type = (ObservationType)item;
                    switch (type) {
                        case LEVELING: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.observations.leveling", "Leveling data");
                        }
                        case DIRECTION: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.observations.direction", "Direction sets");
                        }
                        case HORIZONTAL_DISTANCE: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.observations.horizontal_distance", "Horizontal distances");
                        }
                        case SLOPE_DISTANCE: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.observations.slope_distance", "Slope distances");
                        }
                        case ZENITH_ANGLE: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.observations.zenith_angle", "Zenith angles");
                        }
                        case GNSS1D: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.gnss.1d", "GNSS baselines 1D");
                        }
                        case GNSS2D: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.gnss.2d", "GNSS baselines 2D");
                        }
                        case GNSS3D: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.gnss.3d", "GNSS baselines 3D");
                        }
                    }
                } else if (item instanceof VerticalDeflectionType) {
                    VerticalDeflectionType type = (VerticalDeflectionType)item;
                    switch (type) {
                        case UNKNOWN_VERTICAL_DEFLECTION: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.vertical_deflection.unknown", "Unknown deflection");
                        }
                        case STOCHASTIC_VERTICAL_DEFLECTION: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.vertical_deflection.stochastic", "Stochastic deflection");
                        }
                        case REFERENCE_VERTICAL_DEFLECTION: {
                            return ColumnImportDialog.this.i18n.getString("UITreeBuiler.directory.vertical_deflection.reference", "Reference deflection");
                        }
                    }
                }
                return null;
            }
        });
        typeComboBox.setTooltip(new Tooltip(this.i18n.getString("ColumnImportDialog.import.type.tooltip", "Select import type")));
        typeComboBox.setMinWidth(Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        typeComboBox.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<Enum<?>>(){

            public void changed(ObservableValue<? extends Enum<?>> observable, Enum<?> oldValue, Enum<?> newValue) {
                if (newValue instanceof PointType) {
                    ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setManaged(false);
                    ColumnImportDialog.this.gnssObservationColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.gnssObservationColumnPickerPane.setManaged(false);
                    ColumnImportDialog.this.deflectionColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.deflectionColumnPickerPane.setManaged(false);
                    ColumnImportDialog.this.pointColumnPickerPane.setVisible(true);
                    ColumnImportDialog.this.pointColumnPickerPane.setManaged(true);
                } else if (newValue instanceof ObservationType) {
                    if (ColumnImportDialog.this.isGNSS((ObservationType)newValue)) {
                        ColumnImportDialog.this.gnssObservationColumnPickerPane.setVisible(true);
                        ColumnImportDialog.this.gnssObservationColumnPickerPane.setManaged(true);
                        ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setVisible(false);
                        ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setManaged(false);
                    } else {
                        ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setVisible(true);
                        ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setManaged(true);
                        ColumnImportDialog.this.gnssObservationColumnPickerPane.setVisible(false);
                        ColumnImportDialog.this.gnssObservationColumnPickerPane.setManaged(false);
                    }
                    ColumnImportDialog.this.deflectionColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.deflectionColumnPickerPane.setManaged(false);
                    ColumnImportDialog.this.pointColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.pointColumnPickerPane.setManaged(false);
                } else if (newValue instanceof VerticalDeflectionType) {
                    ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.terrestrialObservationColumnPickerPane.setManaged(false);
                    ColumnImportDialog.this.gnssObservationColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.gnssObservationColumnPickerPane.setManaged(false);
                    ColumnImportDialog.this.deflectionColumnPickerPane.setVisible(true);
                    ColumnImportDialog.this.deflectionColumnPickerPane.setManaged(true);
                    ColumnImportDialog.this.pointColumnPickerPane.setVisible(false);
                    ColumnImportDialog.this.pointColumnPickerPane.setManaged(false);
                }
            }
        });
        typeComboBox.getSelectionModel().select((Object)PointType.REFERENCE_POINT);
        return typeComboBox;
    }

    private CheckBox createCSVCheckbox() {
        String title = this.i18n.getString("ColumnImportDialog.type.csv.label", "CSV file");
        String tooltip = this.i18n.getString("ColumnImportDialog.type.csv.tooltip", "If selected, file is parsed as character-separated-values (CSV) file");
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ColumnImportDialog.this.changeMode();
            }
        });
        this.changeMode();
        return checkBox;
    }

    private RadioButton createRadioButton(String title, String tooltip, boolean selected, Object userData, ToggleGroup group, ChangeListener<Boolean> listener) {
        Label label = new Label(title);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxWidth(Double.MAX_VALUE);
        radioButton.setUserData(userData);
        radioButton.setSelected(selected);
        radioButton.setToggleGroup(group);
        radioButton.selectedProperty().addListener(listener);
        return radioButton;
    }

    private TitledPane createTitledPane(String title, String tooltip, Node content) {
        Label label = new Label(title);
        label.setTooltip(new Tooltip(tooltip));
        TitledPane titledPane = new TitledPane();
        titledPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        titledPane.setGraphic((Node)label);
        titledPane.setCollapsible(false);
        titledPane.setAnimated(false);
        titledPane.setContent(content);
        titledPane.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        return titledPane;
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        gridPane.setAlignment(Pos.CENTER_LEFT);
        gridPane.setHgap(15.0);
        gridPane.setVgap(7.0);
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        return gridPane;
    }

    private void changeMode() {
        boolean isCSVMode;
        boolean bl = isCSVMode = this.importCSVFileCheckBox != null && this.importCSVFileCheckBox.isSelected();
        if (this.csvOptionPane != null) {
            this.csvOptionPane.setDisable(!isCSVMode);
        }
        String promptText = isCSVMode ? this.i18n.getString("ColumnImportDialog.column.index.prompt", "Index") : this.i18n.getString("ColumnImportDialog.column.range.prompt", "from - to");
        for (TextField textfield : this.textFieldList) {
            textfield.setPromptText(promptText);
            textfield.setText("");
        }
        this.showContentPreview();
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    private ColumnRange getColumnRange(TextField textField) {
        if (textField.getText() == null || textField.getText().trim().isEmpty() || textField.getUserData() == null || !(textField.getUserData() instanceof CSVColumnType)) {
            return null;
        }
        CSVColumnType type = (CSVColumnType)((Object)textField.getUserData());
        Pattern pattern = Pattern.compile("^(\\d+)(\\s*-\\s*(\\d*))?$");
        Matcher matcher = pattern.matcher(textField.getText().trim());
        if (matcher.matches()) {
            if (matcher.group(3) == null && this.importCSVFileCheckBox.isSelected()) {
                return new ColumnRange(type, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(1)));
            }
            return new ColumnRange(type, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(3)));
        }
        return null;
    }

    private SourceFileReader<TreeItem<TreeItemValue>> getSourceFileReader() {
        ArrayList<ColumnRange> columnRanges = new ArrayList<ColumnRange>(this.textFieldList.size());
        for (TextField textField : this.textFieldList) {
            ColumnRange columnRange = this.getColumnRange(textField);
            if (columnRange == null) continue;
            columnRanges.add(columnRange);
        }
        if (columnRanges.isEmpty()) {
            return null;
        }
        if (this.importCSVFileCheckBox.isSelected()) {
            boolean strictQuotes = false;
            boolean ignoreLeadingWhiteSpace = true;
            boolean ignoreQuotations = false;
            CSVParser csvParser = new CSVParser(this.separator, this.quotechar, this.escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations);
            if (this.importTypes.getValue() instanceof ObservationType) {
                ObservationType observationType = (ObservationType)((Object)this.importTypes.getValue());
                CSVObservationFileReader reader = new CSVObservationFileReader(observationType, csvParser);
                reader.setColumnRanges(columnRanges);
                reader.setFileLocale(this.fileLocale);
                return reader;
            }
            if (this.importTypes.getValue() instanceof PointType) {
                PointType pointType = (PointType)((Object)this.importTypes.getValue());
                CSVPointFileReader reader = new CSVPointFileReader(pointType, csvParser);
                reader.setColumnRanges(columnRanges);
                reader.setFileLocale(this.fileLocale);
                return reader;
            }
            if (this.importTypes.getValue() instanceof VerticalDeflectionType) {
                VerticalDeflectionType verticalDeflectionType = (VerticalDeflectionType)((Object)this.importTypes.getValue());
                CSVVerticalDeflectionFileReader reader = new CSVVerticalDeflectionFileReader(verticalDeflectionType, csvParser);
                reader.setColumnRanges(columnRanges);
                reader.setFileLocale(this.fileLocale);
                return reader;
            }
        } else {
            SourceFileReader reader;
            if (this.importTypes.getValue() instanceof ObservationType) {
                ObservationType observationType = (ObservationType)((Object)this.importTypes.getValue());
                reader = new ColumnDefinedObservationFileReader(observationType, "     ");
                ((ColumnDefinedObservationFileReader)reader).setColumnRanges(columnRanges);
                ((ColumnDefinedObservationFileReader)reader).setFileLocale(this.fileLocale);
                return reader;
            }
            if (this.importTypes.getValue() instanceof PointType) {
                PointType pointType = (PointType)((Object)this.importTypes.getValue());
                reader = new ColumnDefinedPointFileReader(pointType, "     ");
                ((ColumnDefinedPointFileReader)reader).setColumnRanges(columnRanges);
                ((ColumnDefinedPointFileReader)reader).setFileLocale(this.fileLocale);
                return reader;
            }
            if (this.importTypes.getValue() instanceof VerticalDeflectionType) {
                VerticalDeflectionType verticalDeflectionType = (VerticalDeflectionType)((Object)this.importTypes.getValue());
                reader = new ColumnDefinedVerticalDeflectionFileReader(verticalDeflectionType, "     ");
                ((ColumnDefinedVerticalDeflectionFileReader)reader).setColumnRanges(columnRanges);
                ((ColumnDefinedVerticalDeflectionFileReader)reader).setFileLocale(this.fileLocale);
                return reader;
            }
        }
        return null;
    }

    private boolean isGNSS(ObservationType type) {
        switch (type) {
            case GNSS1D: 
            case GNSS2D: 
            case GNSS3D: {
                return true;
            }
        }
        return false;
    }

    private class CSVOptionChangeListener
    implements ChangeListener<Boolean> {
        private final ToggleGroup group;
        private final CSVOptionType type;

        public CSVOptionChangeListener(ToggleGroup group) {
            this.group = group;
            if (this.group.getUserData() == null || !(this.group.getUserData() instanceof CSVOptionType)) {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " Error, no CSV option type defined!");
            }
            this.type = (CSVOptionType)((Object)this.group.getUserData());
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue() && this.group.getSelectedToggle().getUserData() != null) {
                TextField textField;
                char c = '\u0000';
                if (this.group.getSelectedToggle().getUserData() instanceof Character) {
                    c = ((Character)this.group.getSelectedToggle().getUserData()).charValue();
                } else if (this.group.getSelectedToggle().getUserData() instanceof TextField && (textField = (TextField)this.group.getSelectedToggle().getUserData()).getText() != null && !textField.getText().isEmpty()) {
                    c = textField.getText().charAt(0);
                }
                switch (this.type) {
                    case QUOTE: {
                        ColumnImportDialog.this.quotechar = c;
                        break;
                    }
                    case ESCAPE: {
                        ColumnImportDialog.this.escape = c;
                        break;
                    }
                    case SEPARATOR: {
                        ColumnImportDialog.this.separator = c;
                    }
                }
                ColumnImportDialog.this.changeMode();
            }
        }
    }

    private class CSVUserDefinedOptionChangeListener
    implements ChangeListener<String> {
        private final TextField textField;
        private final CSVOptionType type;

        public CSVUserDefinedOptionChangeListener(TextField textField) {
            this.textField = textField;
            if (this.textField.getUserData() == null || !(this.textField.getUserData() instanceof CSVOptionType)) {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " Error, no CSV option type defined!");
            }
            this.type = (CSVOptionType)((Object)this.textField.getUserData());
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            if (this.textField.getText() != null && !this.textField.getText().isEmpty()) {
                char c = this.textField.getText().charAt(0);
                switch (this.type) {
                    case QUOTE: {
                        ColumnImportDialog.this.quotechar = c;
                        break;
                    }
                    case ESCAPE: {
                        ColumnImportDialog.this.escape = c;
                        break;
                    }
                    case SEPARATOR: {
                        ColumnImportDialog.this.separator = c;
                    }
                }
                ColumnImportDialog.this.changeMode();
            }
        }
    }

    private class ColumnIndex {
        final int column;

        public ColumnIndex(int column) {
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private class ColumnSelectionEventHandler
    implements EventHandler<MouseEvent> {
        ColumnIndex columnIndex = null;

        private ColumnSelectionEventHandler() {
        }

        public void handle(MouseEvent event) {
            if (event.getSource() == ColumnImportDialog.this.editor && event.getPickResult() != null && event.getPickResult().getIntersectedNode() != null && event.getPickResult().getIntersectedNode() instanceof Text && event.getPickResult().getIntersectedNode().getParent() != null && event.getPickResult().getIntersectedNode().getParent() instanceof VBox && event.getPickResult().getIntersectedNode().getParent().getUserData() != null && event.getPickResult().getIntersectedNode().getParent().getUserData() instanceof ColumnIndex) {
                this.columnIndex = (ColumnIndex)event.getPickResult().getIntersectedNode().getParent().getUserData();
            }
            if (this.columnIndex != null) {
                boolean highlight = false;
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    if (ColumnImportDialog.this.importCSVFileCheckBox.isSelected() && ColumnImportDialog.this.maxCharactersPerColumn != null) {
                        int columnLength = 0;
                        int column = this.columnIndex.getColumn();
                        int i = 0;
                        while (i < ColumnImportDialog.this.maxCharactersPerColumn.length) {
                            int nextColumLength = columnLength + ColumnImportDialog.this.maxCharactersPerColumn[i];
                            if (column >= columnLength && column < nextColumLength) {
                                ColumnImportDialog.this.startColumn = columnLength;
                            }
                            if (column >= columnLength && column < nextColumLength) {
                                ColumnImportDialog.this.endColumn = nextColumLength - 1;
                            }
                            columnLength = nextColumLength;
                            ++i;
                        }
                    } else {
                        ColumnImportDialog.this.endColumn = ColumnImportDialog.this.startColumn = this.columnIndex.getColumn();
                    }
                    highlight = true;
                } else if (!ColumnImportDialog.this.importCSVFileCheckBox.isSelected() && ColumnImportDialog.this.startColumn >= 0 && ColumnImportDialog.this.endColumn >= 0 && event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                    ColumnImportDialog.this.endColumn = this.columnIndex.getColumn();
                    highlight = true;
                }
                if (highlight) {
                    ColumnImportDialog.this.selectColumns(Math.min(ColumnImportDialog.this.startColumn, ColumnImportDialog.this.endColumn), Math.max(ColumnImportDialog.this.startColumn, ColumnImportDialog.this.endColumn));
                }
            }
        }
    }

    private class LocaleOptionChangeListener
    implements ChangeListener<Boolean> {
        private final ToggleGroup group;

        public LocaleOptionChangeListener(ToggleGroup group) {
            this.group = group;
        }

        public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
            if (this.group.getSelectedToggle().getUserData() != null && this.group.getSelectedToggle().getUserData() instanceof Locale) {
                ColumnImportDialog.this.fileLocale = (Locale)this.group.getSelectedToggle().getUserData();
            }
        }
    }
}

