/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.applied_geodesy.adjustment.network.DefaultAverageThreshold;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.observation.Observation;
import org.applied_geodesy.adjustment.network.sql.IllegalProjectionPropertyException;
import org.applied_geodesy.adjustment.network.sql.SQLAdjustmentManager;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.UIAverageObservationTableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.AveragedObservationRow;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.version.jag3d.DatabaseVersionMismatchException;

public class AverageDialog {
    private I18N i18n = I18N.getInstance();
    private static AverageDialog averageDialog = new AverageDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private boolean ignoreChanges = false;
    private ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
    private boolean preventClosing = false;
    private AverageTask averageTask = null;
    private Button okButton;
    private Map<ObservationType, DoubleTextField> thresholdFieldMap = new HashMap<ObservationType, DoubleTextField>(10);
    private UIAverageObservationTableBuilder tableBuilder = UIAverageObservationTableBuilder.getInstance();
    private Node settingPane;
    private Node progressIndicatorPane;

    private AverageDialog() {
    }

    public static void setOwner(Window owner) {
        AverageDialog.averageDialog.window = owner;
    }

    public static Optional<Void> showAndWait() {
        averageDialog.init();
        averageDialog.load();
        averageDialog.reset();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    averageDialog.reset();
                    AverageDialog.averageDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)AverageDialog.averageDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return AverageDialog.averageDialog.dialog.showAndWait();
    }

    private void reset() {
        this.preventClosing = false;
        this.settingPane.setDisable(false);
        this.progressIndicatorPane.setVisible(false);
        this.okButton.setDisable(false);
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("AverageDialog.title", "Averaging"));
        this.dialog.setHeaderText(this.i18n.getString("AverageDialog.header", "Averaging repeated observations"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CLOSE});
        this.okButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK);
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().getScene().getWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (AverageDialog.this.preventClosing) {
                    event.consume();
                }
            }
        });
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                if (AverageDialog.this.preventClosing) {
                    event.consume();
                }
            }
        });
        this.settingPane = this.createSettingPane();
        this.progressIndicatorPane = this.createProgressIndicatorPane();
        this.progressIndicatorPane.setVisible(false);
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        stackPane.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        stackPane.getChildren().addAll((Object[])new Node[]{this.settingPane, this.progressIndicatorPane});
        this.okButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new AverageEvent());
        this.dialog.getDialogPane().setContent((Node)stackPane);
    }

    private Node createProgressIndicatorPane() {
        VBox box = new VBox();
        box.setAlignment(Pos.CENTER);
        box.getChildren().setAll((Object[])new Node[]{this.progressIndicator});
        return box;
    }

    private VBox createSettingPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(20.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setAlignment(Pos.TOP_CENTER);
        int row = 0;
        this.addRow(gridPane, row++, ObservationType.LEVELING);
        this.addRow(gridPane, row++, ObservationType.DIRECTION);
        this.addRow(gridPane, row++, ObservationType.HORIZONTAL_DISTANCE);
        this.addRow(gridPane, row++, ObservationType.SLOPE_DISTANCE);
        this.addRow(gridPane, row++, ObservationType.ZENITH_ANGLE);
        this.addRow(gridPane, row++, ObservationType.GNSS1D);
        this.addRow(gridPane, row++, ObservationType.GNSS2D);
        this.addRow(gridPane, row++, ObservationType.GNSS3D);
        Label warningLabel = new Label(this.i18n.getString("AverageDialog.warning.label", "Please note: Averaging repeated measurements will reduce\r\nthe number of observations and is an irreversible process"));
        warningLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        warningLabel.setWrapText(true);
        VBox box = new VBox();
        VBox.setVgrow((Node)gridPane, (Priority)Priority.ALWAYS);
        box.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        box.setSpacing(10.0);
        box.getChildren().addAll((Object[])new Node[]{warningLabel, this.createTitledPane(this.i18n.getString("AverageDialog.threshold.title", "Threshold w.r.t median"), (Node)gridPane)});
        return box;
    }

    private void addRow(GridPane parent, int row, ObservationType observationType) {
        CellValueType valueType = null;
        String labelText = null;
        double value = DefaultAverageThreshold.getThreshold(observationType);
        switch (observationType) {
            case LEVELING: {
                labelText = this.i18n.getString("AverageDialog.leveling.label", "Leveling:");
                valueType = CellValueType.LENGTH_RESIDUAL;
                break;
            }
            case DIRECTION: {
                labelText = this.i18n.getString("AverageDialog.direction.label", "Direction:");
                valueType = CellValueType.ANGLE_RESIDUAL;
                break;
            }
            case ZENITH_ANGLE: {
                labelText = this.i18n.getString("AverageDialog.zenith_angle.label", "Zenith angle:");
                valueType = CellValueType.ANGLE_RESIDUAL;
                break;
            }
            case HORIZONTAL_DISTANCE: {
                labelText = this.i18n.getString("AverageDialog.horizontal_distance.label", "Horizontal distance:");
                valueType = CellValueType.LENGTH_RESIDUAL;
                break;
            }
            case SLOPE_DISTANCE: {
                labelText = this.i18n.getString("AverageDialog.slope_distance.label", "Slope distance:");
                valueType = CellValueType.LENGTH_RESIDUAL;
                break;
            }
            case GNSS1D: {
                labelText = this.i18n.getString("AverageDialog.gnss.1d.label", "GNSS baseline 1D:");
                valueType = CellValueType.LENGTH_RESIDUAL;
                break;
            }
            case GNSS2D: {
                labelText = this.i18n.getString("AverageDialog.gnss.2d.label", "GNSS baseline 2D:");
                valueType = CellValueType.LENGTH_RESIDUAL;
                break;
            }
            case GNSS3D: {
                labelText = this.i18n.getString("AverageDialog.gnss.3d.label", "GNSS baseline 3D:");
                valueType = CellValueType.LENGTH_RESIDUAL;
            }
        }
        if (labelText != null && valueType != null && value > 0.0) {
            DoubleTextField thresholdField = new DoubleTextField(value, valueType, true, DoubleTextField.ValueSupport.EXCLUDING_INCLUDING_INTERVAL);
            thresholdField.setMinWidth(100.0);
            thresholdField.setMaxWidth(Double.MAX_VALUE);
            thresholdField.numberProperty().addListener((ChangeListener)new DoubleValueChangeListener(observationType));
            this.thresholdFieldMap.put(observationType, thresholdField);
            Label label = new Label(labelText);
            label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            GridPane.setHgrow((Node)label, (Priority)Priority.SOMETIMES);
            GridPane.setHgrow((Node)thresholdField, (Priority)Priority.ALWAYS);
            parent.add((Node)label, 0, row);
            parent.add((Node)thresholdField, 1, row);
        }
    }

    private TitledPane createTitledPane(String title, Node content) {
        TitledPane titledPane = new TitledPane();
        titledPane.setCollapsible(false);
        titledPane.setAnimated(false);
        titledPane.setContent(content);
        titledPane.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        titledPane.setText(title);
        return titledPane;
    }

    private void load() {
        try {
            try {
                this.okButton.setDisable(false);
                this.ignoreChanges = true;
                for (Map.Entry<ObservationType, DoubleTextField> item : this.thresholdFieldMap.entrySet()) {
                    ObservationType type = item.getKey();
                    DoubleTextField field = item.getValue();
                    double value = SQLManager.getInstance().getAverageThreshold(type);
                    value = value > 0.0 ? value : DefaultAverageThreshold.getThreshold(type);
                    field.setValue(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OptionDialog.showThrowableDialog(AverageDialog.this.i18n.getString("AverageDialog.message.error.load.exception.title", "Unexpected SQL-Error"), AverageDialog.this.i18n.getString("AverageDialog.message.error.load.exception.header", "Error, could not load averaging properties from database."), AverageDialog.this.i18n.getString("AverageDialog.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
                    }
                });
                this.ignoreChanges = false;
            }
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    private void save(ObservationType observationType, double value) {
        try {
            SQLManager.getInstance().save(observationType, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OptionDialog.showThrowableDialog(AverageDialog.this.i18n.getString("AverageDialog.message.error.save.exception.title", "Unexpected SQL-Error"), AverageDialog.this.i18n.getString("AverageDialog.message.error.save.exception.header", "Error, could not save averaging properties to database."), AverageDialog.this.i18n.getString("AverageDialog.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                }
            });
        }
    }

    private void process() {
        this.reset();
        this.averageTask = new AverageTask(SQLManager.getInstance().getAdjustmentManager());
        this.averageTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                AverageDialog.this.preventClosing = false;
                List observations = (List)AverageDialog.this.averageTask.getValue();
                if (observations != null && !observations.isEmpty()) {
                    ArrayList<AveragedObservationRow> averagedObservationRows = new ArrayList<AveragedObservationRow>(observations.size());
                    for (Observation observation : observations) {
                        averagedObservationRows.add(new AveragedObservationRow(observation));
                    }
                    final TableView table = AverageDialog.this.tableBuilder.getTable();
                    AverageDialog.this.tableBuilder.getTableModel(table).setAll(averagedObservationRows);
                    table.setPrefHeight(200.0);
                    table.setPrefWidth(250.0);
                    table.sort();
                    final String title = AverageDialog.this.i18n.getString("AverageDialog.message.error.threshold.title", "Exceeding thresholds");
                    final String header = AverageDialog.this.i18n.getString("AverageDialog.message.error.threshold.header", "Error, averaging could not be finished due to exceeded threshold values.\r\nPlease correct the listed observations or increase the threshold value");
                    final String message = AverageDialog.this.i18n.getString("AverageDialog.message.error.threshold.message", "List of exceeded observations");
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OptionDialog.showContentDialog(Alert.AlertType.ERROR, title, header, message, (Node)table);
                        }
                    });
                } else {
                    UITreeBuilder.getInstance().handleTreeSelections();
                    AverageDialog.this.dialog.hide();
                }
            }
        });
        this.averageTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                AverageDialog.this.preventClosing = false;
                AverageDialog.this.dialog.hide();
                final Throwable throwable = AverageDialog.this.averageTask.getException();
                if (throwable != null) {
                    if (throwable instanceof IllegalProjectionPropertyException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).AverageDialog.this.i18n.getString("AverageDialog.message.error.projection.exception.title", "Initialization error"), (this).AverageDialog.this.i18n.getString("AverageDialog.message.error.projection.exception.header", "Error, the project contains unsupported projection properties."), (this).AverageDialog.this.i18n.getString("AverageDialog.message.error.projection.exception.message", "An exception has occurred during estimation of approximation."), throwable);
                            }
                        });
                    } else if (throwable instanceof DatabaseVersionMismatchException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).AverageDialog.this.i18n.getString("AverageDialog.message.error.databaseversion.exception.title", "Version error"), (this).AverageDialog.this.i18n.getString("AverageDialog.message.error.databaseversion.exception.header", "Error, the database version is unsupported."), (this).AverageDialog.this.i18n.getString("AverageDialog.message.error.databaseversion.exception.message", "An exception has occurred during network adjustment."), throwable);
                            }
                        });
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).AverageDialog.this.i18n.getString("AverageDialog.message.error.averaging.exception.title", "Unexpected Error"), (this).AverageDialog.this.i18n.getString("AverageDialog.message.error.averaging.exception.header", "Error, averaging failed. An unexpected exception occurred."), (this).AverageDialog.this.i18n.getString("AverageDialog.message.error.averaging.exception.message", "An exception has occurred during averaging process."), throwable);
                            }
                        });
                    }
                    throwable.printStackTrace();
                }
                UITreeBuilder.getInstance().getTree().getSelectionModel().select(0);
            }
        });
        Thread th = new Thread((Runnable)((Object)this.averageTask));
        th.setDaemon(true);
        th.start();
    }

    private class AverageEvent
    implements EventHandler<ActionEvent> {
        private AverageEvent() {
        }

        public void handle(ActionEvent event) {
            AverageDialog.this.okButton.setDisable(true);
            AverageDialog.this.process();
            event.consume();
        }
    }

    private class AverageTask
    extends Task<List<Observation>> {
        private SQLAdjustmentManager dataBaseManager;

        private AverageTask(SQLAdjustmentManager dataBaseManager) {
            this.dataBaseManager = dataBaseManager;
        }

        protected List<Observation> call() throws Exception {
            List<Observation> observations = null;
            try {
                AverageDialog.this.preventClosing = true;
                AverageDialog.this.okButton.setDisable(true);
                AverageDialog.this.progressIndicatorPane.setVisible(true);
                AverageDialog.this.settingPane.setDisable(true);
                List<Observation> list = observations = this.dataBaseManager.averageDetermination(false);
                return list;
            }
            finally {
                AverageDialog.this.okButton.setDisable(false);
                AverageDialog.this.progressIndicatorPane.setVisible(false);
                AverageDialog.this.settingPane.setDisable(false);
                if (observations == null || observations.isEmpty()) {
                    AverageDialog.this.preventClosing = false;
                }
            }
        }
    }

    private class DoubleValueChangeListener
    implements ChangeListener<Double> {
        private ObservationType observationType;

        private DoubleValueChangeListener(ObservationType observationType) {
            this.observationType = observationType;
        }

        public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
            if (!AverageDialog.this.ignoreChanges && newValue != null && newValue > 0.0) {
                AverageDialog.this.save(this.observationType, newValue);
            }
        }
    }
}

