/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.network.approximation.sql.SQLApproximationManager;
import org.applied_geodesy.jag3d.sql.PointTypeMismatchException;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.sql.UnderDeterminedPointException;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;

public class ApproximationValuesDialog {
    private I18N i18n = I18N.getInstance();
    private static ApproximationValuesDialog approximationValuesDialog = new ApproximationValuesDialog();
    private Dialog<EstimationStateType> dialog = null;
    private Window window;
    private boolean preventClosing = false;
    private Button okButton;
    private ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
    private Node settingPane;
    private Node progressIndicatorPane;
    private RadioButton estimateDatumAndNewPointsRadioButton;
    private RadioButton estimateNewPointsRadioButton;
    private RadioButton transferDatumAndNewPointsResultsRadioButton;
    private RadioButton transferNewPointsResultsRadioButton;
    private ApproximationEstimationTask approximationEstimationTask = null;

    private ApproximationValuesDialog() {
    }

    public static void setOwner(Window owner) {
        ApproximationValuesDialog.approximationValuesDialog.window = owner;
    }

    public static Optional<EstimationStateType> showAndWait() {
        approximationValuesDialog.init();
        approximationValuesDialog.reset();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    approximationValuesDialog.reset();
                    ApproximationValuesDialog.approximationValuesDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)ApproximationValuesDialog.approximationValuesDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ApproximationValuesDialog.approximationValuesDialog.dialog.showAndWait();
    }

    private void reset() {
        this.preventClosing = false;
        this.settingPane.setDisable(false);
        this.progressIndicatorPane.setVisible(false);
        this.okButton.setDisable(false);
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.settingPane = this.createSettingPane();
        this.progressIndicatorPane = this.createProgressIndicatorPane();
        this.progressIndicatorPane.setVisible(false);
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        stackPane.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        stackPane.getChildren().addAll((Object[])new Node[]{this.settingPane, this.progressIndicatorPane});
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("ApproximationValuesDialog.title", "Approximation values"));
        this.dialog.setHeaderText(this.i18n.getString("ApproximationValuesDialog.header", "Estimate approximation values using terrestrial observations"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent((Node)stackPane);
        this.dialog.setResizable(true);
        this.okButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK);
        this.okButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new StartAdjustmentEvent());
        this.dialog.getDialogPane().getScene().getWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (ApproximationValuesDialog.this.preventClosing) {
                    event.consume();
                    if (ApproximationValuesDialog.this.approximationEstimationTask != null) {
                        ApproximationValuesDialog.this.approximationEstimationTask.cancelled();
                    }
                }
            }
        });
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                if (ApproximationValuesDialog.this.preventClosing) {
                    event.consume();
                    if (ApproximationValuesDialog.this.approximationEstimationTask != null) {
                        ApproximationValuesDialog.this.approximationEstimationTask.cancelled();
                    }
                }
            }
        });
    }

    private Node createProgressIndicatorPane() {
        VBox box = new VBox();
        box.setAlignment(Pos.CENTER);
        box.getChildren().setAll((Object[])new Node[]{this.progressIndicator});
        this.progressIndicator.setMinWidth(50.0);
        this.progressIndicator.setMinHeight(50.0);
        return box;
    }

    private Node createSettingPane() {
        String estimateDatumAndNewPointsRadioButtonLabel = this.i18n.getString("ApproximationValuesDialog.estimate.datum_and_new.label", "Derive approximations for datum and new points");
        String estimateDatumAndNewPointsRadioButtonTooltip = this.i18n.getString("ApproximationValuesDialog.estimate.datum_and_new.title", "If checked, datum and new points will be estimated");
        String estimateNewPointsRadioButtonLabel = this.i18n.getString("ApproximationValuesDialog.estimate.new.label", "Derive approximations for new points");
        String estimateNewPointsRadioButtonTooltip = this.i18n.getString("ApproximationValuesDialog.estimate.new.title", "If checked, new points will be estimated");
        String transferDatumAndNewPointsResultsLabel = this.i18n.getString("ApproximationValuesDialog.transfer.datum_and_new.label", "Transfer adjusted coordinates of datum and new points as well as additional parameters");
        String transferDatumAndNewPointsResultsTooltip = this.i18n.getString("ApproximationValuesDialog.transfer.datum_and_new.title", "If checked, adjusted coordinates of datum and new points as well as additional parameters will be transferred to apprixmation values");
        String transferNewPointsResultsLabel = this.i18n.getString("ApproximationValuesDialog.transfer.new.label", "Transfer adjusted coordinates of new points as well as additional parameters");
        String transferNewPointsResultsTooltip = this.i18n.getString("ApproximationValuesDialog.transfer.new.title", "If checked, adjusted coordinates of new points as well as additional parameters will be transferred to apprixmation values");
        this.estimateDatumAndNewPointsRadioButton = this.createRadioButton(estimateDatumAndNewPointsRadioButtonLabel, estimateDatumAndNewPointsRadioButtonTooltip);
        this.estimateNewPointsRadioButton = this.createRadioButton(estimateNewPointsRadioButtonLabel, estimateNewPointsRadioButtonTooltip);
        this.transferDatumAndNewPointsResultsRadioButton = this.createRadioButton(transferDatumAndNewPointsResultsLabel, transferDatumAndNewPointsResultsTooltip);
        this.transferNewPointsResultsRadioButton = this.createRadioButton(transferNewPointsResultsLabel, transferNewPointsResultsTooltip);
        ToggleGroup group = new ToggleGroup();
        group.getToggles().addAll((Object[])new Toggle[]{this.estimateDatumAndNewPointsRadioButton, this.estimateNewPointsRadioButton, this.transferDatumAndNewPointsResultsRadioButton, this.transferNewPointsResultsRadioButton});
        this.estimateDatumAndNewPointsRadioButton.setSelected(true);
        VBox box = new VBox(10.0);
        box.setMaxWidth(Double.MAX_VALUE);
        box.setAlignment(Pos.CENTER_LEFT);
        box.getChildren().addAll((Object[])new Node[]{this.estimateDatumAndNewPointsRadioButton, this.estimateNewPointsRadioButton, new Region(), this.transferDatumAndNewPointsResultsRadioButton, this.transferNewPointsResultsRadioButton});
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ApproximationValuesDialog.this.estimateDatumAndNewPointsRadioButton.requestFocus();
            }
        });
        return box;
    }

    private RadioButton createRadioButton(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxWidth(Double.MAX_VALUE);
        return radioButton;
    }

    private void process() {
        this.reset();
        final SQLApproximationManager approximationManager = SQLManager.getInstance().getApproximationManager();
        this.approximationEstimationTask = new ApproximationEstimationTask(approximationManager);
        this.approximationEstimationTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                ApproximationValuesDialog.this.preventClosing = false;
                if (approximationManager != null) {
                    EstimationStateType state1D = approximationManager.getEstimationStatus1D();
                    EstimationStateType state2D = approximationManager.getEstimationStatus2D();
                    if (state1D != EstimationStateType.INTERRUPT && state2D != EstimationStateType.INTERRUPT) {
                        int subCounter1d = approximationManager.getSubSystemsCounter1D();
                        int subCounter2d = approximationManager.getSubSystemsCounter2D();
                        HashSet<String> underdeterminedPointNames = new HashSet<String>(approximationManager.getUnderdeterminedPointNames1D());
                        underdeterminedPointNames.addAll(approximationManager.getUnderdeterminedPointNames2D());
                        HashSet<String> outliers = new HashSet<String>(approximationManager.getOutliers1D());
                        outliers.addAll(approximationManager.getOutliers2D());
                        if (subCounter1d > 1 || subCounter2d > 1) {
                            OptionDialog.showErrorDialog(ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.subsystem.title", "No consistent frame"), ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.subsystem.header", "Error, could not determine a consistent reference frame."), ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.subsystem.message", "Not enough pass points to transform detected subsystems to global frame."));
                        } else if (!underdeterminedPointNames.isEmpty()) {
                            TextArea textArea = new TextArea();
                            int len = underdeterminedPointNames.size();
                            int cnt = 1;
                            for (String name : underdeterminedPointNames) {
                                textArea.appendText(name);
                                if (cnt++ >= len) continue;
                                textArea.appendText(", ");
                            }
                            textArea.setEditable(false);
                            textArea.setWrapText(true);
                            OptionDialog.showContentDialog(Alert.AlertType.ERROR, ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.underdetermination.title", "Underdetermined points"), String.format(ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.underdetermination.header", "Error, detect %d underdetermined points."), underdeterminedPointNames.size()), ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.underdetermination.message", "List of underdetermined points."), (Node)textArea);
                        } else if (!outliers.isEmpty()) {
                            TextArea textArea = new TextArea();
                            int len = outliers.size();
                            int cnt = 1;
                            for (String name : outliers) {
                                textArea.appendText(name);
                                if (cnt++ >= len) continue;
                                textArea.appendText(", ");
                            }
                            textArea.setEditable(false);
                            textArea.setWrapText(true);
                            OptionDialog.showContentDialog(Alert.AlertType.WARNING, ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.subsystem.exception.title", "Badly conditioned points"), String.format(ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.subsystem.exception.header", "Error, detect %d badly conditioned points.\r\nPlease check related observations."), outliers.size()), ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.subsystem.exception.message", "List of badly conditioned points."), (Node)textArea);
                        }
                    }
                    approximationManager.clearAll();
                }
                UITreeBuilder.getInstance().handleTreeSelections();
                ApproximationValuesDialog.this.dialog.hide();
            }
        });
        this.approximationEstimationTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                ApproximationValuesDialog.this.preventClosing = false;
                ApproximationValuesDialog.this.dialog.hide();
                final Throwable throwable = ApproximationValuesDialog.this.approximationEstimationTask.getException();
                if (throwable != null) {
                    if (throwable instanceof SQLException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.approximation_value.exception.title", "Unexpected Error"), (this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.approximation_value.exception.header", "Error, estimation of approximation values failed."), (this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.approximation_value.exception.message", "An exception has occurred during estimation of approximation."), throwable);
                            }
                        });
                    } else if (throwable instanceof PointTypeMismatchException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.pointtypemismatch.exception.title", "Initialization error"), (this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.pointtypemismatch.exception.header", "Error, the project contains uncombinable point typs, i.e. datum points as well as reference or stochastic points."), (this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.pointtypemismatch.exception.message", "An exception has occurred during estimation of approximation."), throwable);
                            }
                        });
                    } else if (throwable instanceof UnderDeterminedPointException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UnderDeterminedPointException e = (UnderDeterminedPointException)throwable;
                                OptionDialog.showThrowableDialog((this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.underdeterminded.exception.title", "Initialization error"), String.format((this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.underdeterminded.exception.header", "Error, the point %s of dimension %d has only %d observations and is indeterminable."), e.getPointName(), e.getDimension(), e.getNumberOfObservations()), (this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.underdeterminded.exception.message", "An exception has occurred during estimation of approximation."), throwable);
                            }
                        });
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.approximation_value.exception.title", "Unexpected Error"), (this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.approximation_value.exception.header", "Error, estimation of approximation values failed."), (this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.message.error.approximation_value.exception.message", "An exception has occurred during estimation of approximation."), throwable);
                            }
                        });
                    }
                    throwable.printStackTrace();
                }
                UITreeBuilder.getInstance().getTree().getSelectionModel().select(0);
            }
        });
        Thread th = new Thread((Runnable)((Object)this.approximationEstimationTask));
        th.setDaemon(true);
        th.start();
    }

    private class ApproximationEstimationTask
    extends Task<Boolean>
    implements PropertyChangeListener {
        private SQLApproximationManager approximationManager;

        private ApproximationEstimationTask(SQLApproximationManager approximationManager) {
            this.approximationManager = approximationManager;
        }

        protected Boolean call() throws Exception {
            EstimationStateType status1d = EstimationStateType.ERROR_FREE_ESTIMATION;
            EstimationStateType status2d = EstimationStateType.ERROR_FREE_ESTIMATION;
            this.updateProgress(-1.0, -1.0);
            this.approximationManager.addPropertyChangeListener(this);
            try {
                ApproximationValuesDialog.this.preventClosing = true;
                ApproximationValuesDialog.this.okButton.setDisable(true);
                ApproximationValuesDialog.this.progressIndicatorPane.setVisible(true);
                ApproximationValuesDialog.this.settingPane.setDisable(true);
                SQLManager.getInstance().checkNumberOfObersvationsPerUnknownParameter();
                if (ApproximationValuesDialog.this.transferDatumAndNewPointsResultsRadioButton.isSelected() || ApproximationValuesDialog.this.transferNewPointsResultsRadioButton.isSelected()) {
                    this.approximationManager.transferAposteriori2AprioriValues(ApproximationValuesDialog.this.transferDatumAndNewPointsResultsRadioButton.isSelected());
                } else if (ApproximationValuesDialog.this.estimateDatumAndNewPointsRadioButton.isSelected() || ApproximationValuesDialog.this.estimateNewPointsRadioButton.isSelected()) {
                    this.approximationManager.setEstimateDatumsPoints(ApproximationValuesDialog.this.estimateDatumAndNewPointsRadioButton.isSelected());
                    this.approximationManager.adjustApproximationValues(25.0);
                }
                status2d = this.approximationManager.getEstimationStatus2D();
                status1d = this.approximationManager.getEstimationStatus1D();
                Boolean bl = status1d == EstimationStateType.ERROR_FREE_ESTIMATION && status2d == EstimationStateType.ERROR_FREE_ESTIMATION;
                return bl;
            }
            finally {
                this.approximationManager.removePropertyChangeListener(this);
                ApproximationValuesDialog.this.okButton.setDisable(false);
                ApproximationValuesDialog.this.progressIndicatorPane.setVisible(false);
                ApproximationValuesDialog.this.settingPane.setDisable(false);
                if (status1d == EstimationStateType.ERROR_FREE_ESTIMATION && status2d == EstimationStateType.ERROR_FREE_ESTIMATION) {
                    ApproximationValuesDialog.this.preventClosing = false;
                }
            }
        }

        protected void failed() {
            ApproximationValuesDialog.this.preventClosing = false;
            super.failed();
        }

        protected void cancelled() {
            super.cancelled();
            if (this.approximationManager != null) {
                this.approximationManager.interrupt();
            }
        }

        protected void updateProgress(final double workDone, double max) {
            super.updateProgress(workDone, max);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Node node;
                    ((ApproximationEstimationTask)ApproximationEstimationTask.this).ApproximationValuesDialog.this.progressIndicator.setProgress(workDone);
                    if (workDone >= 1.0 && (node = ((ApproximationEstimationTask)ApproximationEstimationTask.this).ApproximationValuesDialog.this.progressIndicator.lookup(".percentage")) != null && node instanceof Text) {
                        Text text = (Text)node;
                        text.setText(((ApproximationEstimationTask)ApproximationEstimationTask.this).ApproximationValuesDialog.this.i18n.getString("ApproximationValuesDialog.done.label", "Done"));
                        ((ApproximationEstimationTask)ApproximationEstimationTask.this).ApproximationValuesDialog.this.progressIndicator.setPrefWidth(text.getLayoutBounds().getWidth());
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private class StartAdjustmentEvent
    implements EventHandler<ActionEvent> {
        private StartAdjustmentEvent() {
        }

        public void handle(ActionEvent event) {
            ApproximationValuesDialog.this.okButton.setDisable(true);
            ApproximationValuesDialog.this.process();
            event.consume();
        }
    }
}

