/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.ui.dialog.chart.AnalysisChartType;
import org.applied_geodesy.jag3d.ui.dialog.chart.AnalysisChartTypeListCell;
import org.applied_geodesy.jag3d.ui.dialog.chart.UIInfluenceOnPositionAnalysisChart;
import org.applied_geodesy.jag3d.ui.dialog.chart.UIRedundancyAnalysisChart;
import org.applied_geodesy.jag3d.ui.dialog.chart.UIResidualAnalysisChart;
import org.applied_geodesy.jag3d.ui.dialog.chart.UISignAnalysisChart;
import org.applied_geodesy.jag3d.ui.i18n.I18N;

public class AnalysisChartsDialog {
    private static AnalysisChartsDialog analysisChartsDialog = new AnalysisChartsDialog();
    private I18N i18n = I18N.getInstance();
    private Dialog<Void> dialog = null;
    private Window window;
    private ListView<AnalysisChartType> analysisChartTypeList;
    private AnalysisChartType lastSelectedAnalysisChartType = AnalysisChartType.RESIDUALS;
    private BorderPane chartPane;

    private AnalysisChartsDialog() {
    }

    public static void setOwner(Window owner) {
        AnalysisChartsDialog.analysisChartsDialog.window = owner;
    }

    public static Optional<Void> showAndWait() {
        analysisChartsDialog.init();
        AnalysisChartsDialog.analysisChartsDialog.analysisChartTypeList.getSelectionModel().clearSelection();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AnalysisChartsDialog.analysisChartsDialog.analysisChartTypeList.getSelectionModel().select((Object)AnalysisChartsDialog.analysisChartsDialog.lastSelectedAnalysisChartType);
                    AnalysisChartsDialog.analysisChartsDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)AnalysisChartsDialog.analysisChartsDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return AnalysisChartsDialog.analysisChartsDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("AnalysisChartsDialog.title", "Analysis charts"));
        this.dialog.setHeaderText(this.i18n.getString("AnalysisChartsDialog.chart.header", "Analysis charts"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent((Node)this.createPane());
        this.dialog.setResizable(true);
    }

    private BorderPane createPane() {
        this.chartPane = new BorderPane();
        this.analysisChartTypeList = new ListView();
        this.analysisChartTypeList.getItems().addAll((Object[])AnalysisChartType.values());
        this.analysisChartTypeList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new AnalysisChartTypeChangeListener());
        this.analysisChartTypeList.setTooltip(new Tooltip(this.i18n.getString("AnalysisChartsDialog.chart.type.tooltip", "Select analysis chart type")));
        this.analysisChartTypeList.setCellFactory((Callback)new Callback<ListView<AnalysisChartType>, ListCell<AnalysisChartType>>(){

            public ListCell<AnalysisChartType> call(ListView<AnalysisChartType> analysisChartTypeList) {
                return new AnalysisChartTypeListCell();
            }
        });
        this.chartPane.setLeft(this.analysisChartTypeList);
        Region spacer = new Region();
        spacer.setPrefWidth(450.0);
        spacer.setPrefHeight(400.0);
        this.chartPane.setCenter((Node)spacer);
        return this.chartPane;
    }

    private void setChart(Node node) {
        if (node != null) {
            this.chartPane.setCenter(node);
        }
    }

    private void loadChart(AnalysisChartType analysisChartType) {
        switch (analysisChartType) {
            case RESIDUALS: {
                this.dialog.setHeaderText(this.i18n.getString("AnalysisChartsDialog.chart.type.residual.header", "Histogram of normalized residuals"));
                Node node = UIResidualAnalysisChart.getInstance().getNode();
                this.setChart(node);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UIResidualAnalysisChart.getInstance().load();
                    }
                });
                break;
            }
            case REDUNDANCY: {
                this.dialog.setHeaderText(this.i18n.getString("AnalysisChartsDialog.chart.type.redundancy.header", "Pie chart of redundancy"));
                Node node = UIRedundancyAnalysisChart.getInstance().getNode();
                this.setChart(node);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UIRedundancyAnalysisChart.getInstance().load();
                    }
                });
                break;
            }
            case INFLUENCE_ON_POSITION: {
                this.dialog.setHeaderText(this.i18n.getString("AnalysisChartsDialog.chart.type.influence_on_position.header", "Pie chart of influence on position distribution"));
                Node node = UIInfluenceOnPositionAnalysisChart.getInstance().getNode();
                this.setChart(node);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UIInfluenceOnPositionAnalysisChart.getInstance().load();
                    }
                });
                break;
            }
            case SIGN: {
                this.dialog.setHeaderText(this.i18n.getString("AnalysisChartsDialog.chart.type.sign.header", "Pie chart of sign distribution"));
                Node node = UISignAnalysisChart.getInstance().getNode();
                this.setChart(node);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UISignAnalysisChart.getInstance().load();
                    }
                });
            }
        }
        this.lastSelectedAnalysisChartType = analysisChartType;
    }

    private class AnalysisChartTypeChangeListener
    implements ChangeListener<AnalysisChartType> {
        private AnalysisChartTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends AnalysisChartType> observable, AnalysisChartType oldType, AnalysisChartType newType) {
            if (newType != null) {
                AnalysisChartsDialog.this.loadChart(newType);
            }
        }
    }
}

