/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.dialog;

import java.util.Optional;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.applied_geodesy.version.VersionType;
import org.applied_geodesy.version.juniform.Version;

public class AboutDialog {
    private static AboutDialog aboutDialog = new AboutDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private HostServices hostServices;

    private AboutDialog() {
    }

    public static void setOwner(Window owner) {
        AboutDialog.aboutDialog.window = owner;
    }

    public static void setHostServices(HostServices hostServices) {
        AboutDialog.aboutDialog.hostServices = hostServices;
    }

    public static Optional<Void> showAndWait() {
        aboutDialog.init();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AboutDialog.aboutDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)AboutDialog.aboutDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return AboutDialog.aboutDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle("JAG3D");
        this.dialog.setHeaderText("JAG3D \u2014 Java\u00b7Applied\u00b7Geodesy\u00b73D" + (org.applied_geodesy.version.jag3d.Version.isReleaseCandidate() ? " (RC)" : ""));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
    }

    private Node createPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(15.0);
        gridPane.setVgap(10.0);
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(7.0, 7.0, 7.0, 7.0));
        Text applicationText = new Text("Least-Squares Adjustment Software for Geodetic Sciences");
        applicationText.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)14.0));
        applicationText.setTextAlignment(TextAlignment.CENTER);
        Label authorLabel = this.createLabel("Author:");
        Label licenceLabel = this.createLabel("Licence:");
        Label uiVersionLabel = this.createLabel("UI version:");
        Label dbVersionLabel = this.createLabel("DB version:");
        Label coreVersionLabel = this.createLabel("AC version:");
        Label homePageLabel = this.createLabel("Homepage:");
        Label moduleLabel = this.createLabel("Module:");
        Label thirdPartyLabel = this.createLabel("3rd Party Libraries:");
        Label iconLabel = this.createLabel("Icon set:");
        Label author = this.createLabel("Michael L\u00f6sler\r\n\r\nFriedberger Str. 50D\r\nDE-61118 Bad Vilbel");
        Label licence = this.createLabel("GNU General Public License v3.0");
        Label uiVersion = this.createLabel("v" + String.valueOf(org.applied_geodesy.version.jag3d.Version.get(VersionType.USER_INTERFACE)));
        Label dbVersion = this.createLabel("v" + String.valueOf(org.applied_geodesy.version.jag3d.Version.get(VersionType.DATABASE)));
        Label coreVersion = this.createLabel("v" + String.valueOf(org.applied_geodesy.version.jag3d.Version.get(VersionType.ADJUSTMENT_CORE)));
        final Hyperlink homePageLink = new Hyperlink("software.applied-geodesy.org");
        homePageLink.setTooltip(new Tooltip("Go to software.applied-geodesy.org"));
        homePageLink.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        homePageLink.setPadding(new Insets(0.0));
        homePageLink.setVisited(false);
        homePageLink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (AboutDialog.this.hostServices != null) {
                    AboutDialog.this.hostServices.showDocument("https://software.applied-geodesy.org");
                }
                homePageLink.setVisited(false);
            }
        });
        Label module = this.createLabel("\u2219 CoordTrans: v" + String.valueOf(org.applied_geodesy.version.coordtrans.Version.get()) + "\r\n\u2219 JUniForm: v" + String.valueOf(Version.get()));
        Label thirdParty = this.createLabel("\u2219 MTJ: GNU Lesser General Public License v3.0\r\n\u2219 FreeMarker: Apache License v2.0\r\n\u2219 netlib-java: BSD License\r\n\u2219 JLAPACK: BSD License\r\n\u2219 HSQLDB: BSD License\r\n\u2219 JDistlib: GNU General Public License v2.0\r\n\u2219 MAT File Library: Apache License v2.0\r\n\u2219 OpenCSV: Apache License v2.0\r\n\u2219 Launch4J: BSD/MIT License");
        Label icon = this.createLabel("Subway Icon Set: CC BY 4.0");
        authorLabel.setLabelFor((Node)author);
        licenceLabel.setLabelFor((Node)licence);
        uiVersionLabel.setLabelFor((Node)uiVersion);
        dbVersionLabel.setLabelFor((Node)dbVersion);
        coreVersionLabel.setLabelFor((Node)coreVersion);
        homePageLabel.setLabelFor((Node)homePageLink);
        thirdPartyLabel.setLabelFor((Node)thirdParty);
        moduleLabel.setLabelFor((Node)module);
        iconLabel.setLabelFor((Node)icon);
        GridPane.setHalignment((Node)applicationText, (HPos)HPos.CENTER);
        int row = 0;
        gridPane.add((Node)applicationText, 0, row++, 2, 1);
        gridPane.add((Node)authorLabel, 0, row);
        gridPane.add((Node)author, 1, row++);
        gridPane.add((Node)licenceLabel, 0, row);
        gridPane.add((Node)licence, 1, row++);
        gridPane.add((Node)uiVersionLabel, 0, row);
        gridPane.add((Node)uiVersion, 1, row++);
        gridPane.add((Node)dbVersionLabel, 0, row);
        gridPane.add((Node)dbVersion, 1, row++);
        gridPane.add((Node)coreVersionLabel, 0, row);
        gridPane.add((Node)coreVersion, 1, row++);
        gridPane.add((Node)homePageLabel, 0, row);
        gridPane.add((Node)homePageLink, 1, row++);
        gridPane.add((Node)moduleLabel, 0, row);
        gridPane.add((Node)module, 1, row++);
        gridPane.add((Node)thirdPartyLabel, 0, row);
        gridPane.add((Node)thirdParty, 1, row++);
        gridPane.add((Node)iconLabel, 0, row);
        gridPane.add((Node)icon, 1, row++);
        ScrollPane scroller = new ScrollPane((Node)gridPane);
        scroller.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        scroller.setFitToHeight(true);
        scroller.setFitToWidth(true);
        return gridPane;
    }

    private Label createLabel(String text) {
        Label label = new Label(text);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxHeight(Double.MAX_VALUE);
        label.setAlignment(Pos.TOP_LEFT);
        return label;
    }
}

