/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui;

import java.awt.SplashScreen;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeView;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.applied_geodesy.jag3d.DefaultApplicationProperty;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateChangeListener;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateEvent;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.dialog.AboutDialog;
import org.applied_geodesy.jag3d.ui.dialog.AnalysisChartsDialog;
import org.applied_geodesy.jag3d.ui.dialog.ApproximationValuesDialog;
import org.applied_geodesy.jag3d.ui.dialog.AverageDialog;
import org.applied_geodesy.jag3d.ui.dialog.ColumnImportDialog;
import org.applied_geodesy.jag3d.ui.dialog.CongruentPointDialog;
import org.applied_geodesy.jag3d.ui.dialog.ExportOptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.FormatterOptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.ImportOptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.InstrumentAndReflectorHeightAdaptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.LeastSquaresSettingDialog;
import org.applied_geodesy.jag3d.ui.dialog.NetworkAdjustmentDialog;
import org.applied_geodesy.jag3d.ui.dialog.ProjectionAndReductionDialog;
import org.applied_geodesy.jag3d.ui.dialog.RankDefectDialog;
import org.applied_geodesy.jag3d.ui.dialog.SearchAndReplaceDialog;
import org.applied_geodesy.jag3d.ui.dialog.TableRowHighlightDialog;
import org.applied_geodesy.jag3d.ui.dialog.TestStatisticDialog;
import org.applied_geodesy.jag3d.ui.graphic.UIGraphicPaneBuilder;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.FeatureZoomDialog;
import org.applied_geodesy.jag3d.ui.graphic.layer.dialog.LayerManagerDialog;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.menu.UIMenuBuilder;
import org.applied_geodesy.jag3d.ui.tabpane.UITabPaneBuilder;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.util.ImageUtils;
import org.applied_geodesy.util.sql.HSQLDB;
import org.applied_geodesy.version.jag3d.Version;

public class JAG3D
extends Application {
    private static final String TITLE_TEMPLATE = "%s%sJAG3D%s \u00b7 Least-Squares Adjustment & Deformation Analysis \u00b7";
    private static Stage primaryStage;
    private Button adjustmentButton;

    public static void setTitle(String title) {
        if (primaryStage != null && title != null && !title.trim().isEmpty()) {
            primaryStage.setTitle(String.format(Locale.ENGLISH, TITLE_TEMPLATE, title, " \u2014 ", Version.isReleaseCandidate() ? " (RC)" : ""));
        } else if (primaryStage != null) {
            primaryStage.setTitle(String.format(Locale.ENGLISH, TITLE_TEMPLATE, "", "", Version.isReleaseCandidate() ? " (RC)" : ""));
        }
    }

    public static void close() {
        primaryStage.close();
    }

    public static Stage getStage() {
        return primaryStage;
    }

    private void setHostServices() {
        HostServices hostServices = this.getHostServices();
        AboutDialog.setHostServices(hostServices);
        SQLManager.setHostServices(hostServices);
        UIMenuBuilder.setHostServices(hostServices);
    }

    private void setStageToDialogs(Stage primaryStage) {
        OptionDialog.setOwner((Window)primaryStage);
        NetworkAdjustmentDialog.setOwner((Window)primaryStage);
        FormatterOptionDialog.setOwner((Window)primaryStage);
        TestStatisticDialog.setOwner((Window)primaryStage);
        ProjectionAndReductionDialog.setOwner((Window)primaryStage);
        RankDefectDialog.setOwner((Window)primaryStage);
        CongruentPointDialog.setOwner((Window)primaryStage);
        AverageDialog.setOwner((Window)primaryStage);
        ApproximationValuesDialog.setOwner((Window)primaryStage);
        LeastSquaresSettingDialog.setOwner((Window)primaryStage);
        LayerManagerDialog.setOwner((Window)primaryStage);
        SearchAndReplaceDialog.setOwner((Window)primaryStage);
        AboutDialog.setOwner((Window)primaryStage);
        ColumnImportDialog.setOwner((Window)primaryStage);
        TableRowHighlightDialog.setOwner((Window)primaryStage);
        ImportOptionDialog.setOwner((Window)primaryStage);
        ExportOptionDialog.setOwner((Window)primaryStage);
        AnalysisChartsDialog.setOwner((Window)primaryStage);
        InstrumentAndReflectorHeightAdaptionDialog.setOwner((Window)primaryStage);
        FeatureZoomDialog.setOwner((Window)primaryStage);
    }

    public void start(Stage primaryStage) throws Exception {
        JAG3D.primaryStage = primaryStage;
        try (SplashScreen splashScreen = null;){
            try {
                splashScreen = SplashScreen.getSplashScreen();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            I18N i18n = I18N.getInstance();
            UIMenuBuilder menuBuilder = UIMenuBuilder.getInstance();
            UITabPaneBuilder tabPaneBuilder = UITabPaneBuilder.getInstance();
            UITreeBuilder treeBuilder = UITreeBuilder.getInstance();
            final TabPane tabPane = tabPaneBuilder.getTabPane();
            TreeView<TreeItemValue> tree = treeBuilder.getTree();
            SplitPane splitPane = new SplitPane();
            splitPane.setOrientation(Orientation.HORIZONTAL);
            splitPane.getItems().addAll((Object[])new Node[]{tree, tabPane});
            splitPane.setDividerPositions(new double[]{0.3});
            SplitPane.setResizableWithParent(tree, (Boolean)false);
            BorderPane border = new BorderPane();
            border.setPrefSize(900.0, 650.0);
            border.setTop((Node)menuBuilder.getMenuBar());
            border.setCenter((Node)splitPane);
            UITreeBuilder.getInstance().getTree().getSelectionModel().clearSelection();
            UITreeBuilder.getInstance().getTree().getSelectionModel().selectFirst();
            this.adjustmentButton = new Button(i18n.getString("JavaGraticule3D.button.adjust.label", "Adjust network"));
            this.adjustmentButton.setTooltip(new Tooltip(i18n.getString("JavaGraticule3D.button.adjust.tooltip", "Start network adjustment process")));
            this.adjustmentButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NetworkAdjustmentDialog.show();
                }
            });
            this.adjustmentButton.setDisable(true);
            DropShadow ds = new DropShadow();
            ds.setOffsetY(0.5);
            ds.setColor(Color.gray((double)0.8));
            Text applicationName = new Text();
            applicationName.setEffect((Effect)ds);
            applicationName.setCache(true);
            applicationName.setFill((Paint)Color.GREY);
            applicationName.setText("Java\u00b7Applied\u00b7Geodesy\u00b73D");
            applicationName.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.NORMAL, (double)17.0));
            Region spacer = new Region();
            HBox hbox = new HBox(10.0);
            hbox.setPadding(new Insets(5.0, 10.0, 5.0, 15.0));
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            hbox.getChildren().addAll((Object[])new Node[]{applicationName, spacer, this.adjustmentButton});
            border.setBottom((Node)hbox);
            Scene scene = new Scene((Parent)border);
            scene.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
                final KeyCombination adjustKeyComb = new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]);
                final KeyCombination zoomInKeyComb = new KeyCodeCombination(KeyCode.PLUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination zoomOutKeyComb = new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabOneKeyComb = new KeyCodeCombination(KeyCode.DIGIT1, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabTwoKeyComb = new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabThreeKeyComb = new KeyCodeCombination(KeyCode.DIGIT3, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFourKeyComb = new KeyCodeCombination(KeyCode.DIGIT4, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFiveKeyComb = new KeyCodeCombination(KeyCode.DIGIT5, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSixKeyComb = new KeyCodeCombination(KeyCode.DIGIT6, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSevenKeyComb = new KeyCodeCombination(KeyCode.DIGIT7, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabEightKeyComb = new KeyCodeCombination(KeyCode.DIGIT8, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabNineKeyComb = new KeyCodeCombination(KeyCode.DIGIT9, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination zoomInKeyCombNum = new KeyCodeCombination(KeyCode.ADD, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination zoomOutKeyCombNum = new KeyCodeCombination(KeyCode.SUBTRACT, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabOneKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD1, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabTwoKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD2, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabThreeKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD3, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFourKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD4, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFiveKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD5, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSixKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD6, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSevenKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD7, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabEightKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD8, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabNineKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD9, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});

                public void handle(KeyEvent keyEvent) {
                    if (this.adjustKeyComb.match(keyEvent) && !JAG3D.this.adjustmentButton.isDisabled()) {
                        JAG3D.this.adjustmentButton.fire();
                        keyEvent.consume();
                    } else if (tabPane.getSelectionModel().getSelectedItem() != null) {
                        if ((this.zoomInKeyComb.match(keyEvent) || this.zoomInKeyCombNum.match(keyEvent)) && ((Tab)tabPane.getSelectionModel().getSelectedItem()).getContent() == UIGraphicPaneBuilder.getInstance().getPane()) {
                            UIGraphicPaneBuilder.getInstance().getLayerManager().zoomIn();
                            keyEvent.consume();
                        } else if ((this.zoomOutKeyComb.match(keyEvent) || this.zoomOutKeyCombNum.match(keyEvent)) && ((Tab)tabPane.getSelectionModel().getSelectedItem()).getContent() == UIGraphicPaneBuilder.getInstance().getPane()) {
                            UIGraphicPaneBuilder.getInstance().getLayerManager().zoomOut();
                            keyEvent.consume();
                        } else if (this.tabOneKeyComb.match(keyEvent) || this.tabTwoKeyComb.match(keyEvent) || this.tabThreeKeyComb.match(keyEvent) || this.tabFourKeyComb.match(keyEvent) || this.tabFiveKeyComb.match(keyEvent) || this.tabSixKeyComb.match(keyEvent) || this.tabSevenKeyComb.match(keyEvent) || this.tabEightKeyComb.match(keyEvent) || this.tabNineKeyComb.match(keyEvent) || this.tabOneKeyCombNum.match(keyEvent) || this.tabTwoKeyCombNum.match(keyEvent) || this.tabThreeKeyCombNum.match(keyEvent) || this.tabFourKeyCombNum.match(keyEvent) || this.tabFiveKeyCombNum.match(keyEvent) || this.tabSixKeyCombNum.match(keyEvent) || this.tabSevenKeyCombNum.match(keyEvent) || this.tabEightKeyCombNum.match(keyEvent) || this.tabNineKeyCombNum.match(keyEvent)) {
                            int size = tabPane.getTabs().size();
                            if ((this.tabOneKeyComb.match(keyEvent) || this.tabOneKeyCombNum.match(keyEvent)) && size > 0) {
                                tabPane.getSelectionModel().clearAndSelect(0);
                            } else if ((this.tabTwoKeyComb.match(keyEvent) || this.tabTwoKeyCombNum.match(keyEvent)) && size > 1) {
                                tabPane.getSelectionModel().clearAndSelect(1);
                            } else if ((this.tabThreeKeyComb.match(keyEvent) || this.tabThreeKeyCombNum.match(keyEvent)) && size > 2) {
                                tabPane.getSelectionModel().clearAndSelect(2);
                            } else if ((this.tabFourKeyComb.match(keyEvent) || this.tabFourKeyCombNum.match(keyEvent)) && size > 3) {
                                tabPane.getSelectionModel().clearAndSelect(3);
                            } else if ((this.tabFiveKeyComb.match(keyEvent) || this.tabFiveKeyCombNum.match(keyEvent)) && size > 4) {
                                tabPane.getSelectionModel().clearAndSelect(4);
                            } else if ((this.tabSixKeyComb.match(keyEvent) || this.tabSixKeyCombNum.match(keyEvent)) && size > 5) {
                                tabPane.getSelectionModel().clearAndSelect(5);
                            } else if ((this.tabSevenKeyComb.match(keyEvent) || this.tabSevenKeyCombNum.match(keyEvent)) && size > 6) {
                                tabPane.getSelectionModel().clearAndSelect(6);
                            } else if ((this.tabEightKeyComb.match(keyEvent) || this.tabEightKeyCombNum.match(keyEvent)) && size > 7) {
                                tabPane.getSelectionModel().clearAndSelect(7);
                            } else if ((this.tabNineKeyComb.match(keyEvent) || this.tabNineKeyCombNum.match(keyEvent)) && size > 8) {
                                tabPane.getSelectionModel().clearAndSelect(8);
                            }
                            keyEvent.consume();
                        }
                    }
                }
            });
            try {
                URL cssURL = null;
                cssURL = JAG3D.class.getClassLoader().getResource("css/");
                if (cssURL != null && Files.exists(Paths.get((cssURL = cssURL.toURI().resolve("jag3d.css").toURL()).toURI()), new LinkOption[0])) {
                    scene.getStylesheets().add((Object)cssURL.toExternalForm());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                primaryStage.getIcons().addAll((Object[])new Image[]{ImageUtils.getImage("JAG3D_16x16.png"), ImageUtils.getImage("JAG3D_32x32.png"), ImageUtils.getImage("JAG3D_64x64.png")});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            primaryStage.setScene(scene);
            JAG3D.setTitle(null);
            primaryStage.show();
            primaryStage.setMaximized(DefaultApplicationProperty.startApplicationInFullScreen());
            primaryStage.toFront();
            this.setStageToDialogs(primaryStage);
            this.setHostServices();
            SQLManager.getInstance().addProjectDatabaseStateChangeListener(new DatabaseStateChangeListener());
            try {
                Application.Parameters params = this.getParameters();
                Map parameterMap = params.getNamed();
                if (parameterMap.containsKey("database")) {
                    String project;
                    Path path = Paths.get((String)parameterMap.get("database"), new String[0]);
                    String regex = "(?i)(.+?)(\\.)(backup$|data$|properties$|script$)";
                    String string = project = Files.exists(path, LinkOption.NOFOLLOW_LINKS) ? path.toAbsolutePath().toString().replaceFirst(regex, "$1") : null;
                    if (project != null) {
                        SQLManager.openExistingProject(new HSQLDB(project));
                        JAG3D.setTitle(path.getFileName() == null ? null : path.getFileName().toString().replaceFirst(regex, "$1"));
                    }
                }
                if (parameterMap.containsKey("ut") && parameterMap.getOrDefault("ut", "FALSE").equalsIgnoreCase("TRUE")) {
                    LeastSquaresSettingDialog.setEnableUnscentedTransformation(true);
                    org.applied_geodesy.juniform.ui.dialog.LeastSquaresSettingDialog.setEnableUnscentedTransformation(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() throws Exception {
        SQLManager.getInstance().closeDataBase();
        super.stop();
    }

    public static void main(String[] args) {
        try {
            Logger[] loggers;
            Logger[] loggerArray = loggers = new Logger[]{Logger.getLogger("hsqldb.db"), Logger.getLogger("com.github.fommil.netlib.LAPACK"), Logger.getLogger("com.github.fommil.netlib.BLAS")};
            int n = loggers.length;
            int n2 = 0;
            while (n2 < n) {
                Logger logger = loggerArray[n2];
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.OFF);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Application.launch(JAG3D.class, (String[])args);
    }

    private class DatabaseStateChangeListener
    implements ProjectDatabaseStateChangeListener {
        private DatabaseStateChangeListener() {
        }

        @Override
        public void projectDatabaseStateChanged(ProjectDatabaseStateEvent evt) {
            if (JAG3D.this.adjustmentButton != null) {
                boolean disable = evt.getEventType() != ProjectDatabaseStateType.OPENED;
                JAG3D.this.adjustmentButton.setDisable(disable);
                if (evt.getEventType() == ProjectDatabaseStateType.CLOSING || evt.getEventType() == ProjectDatabaseStateType.CLOSED) {
                    JAG3D.setTitle(null);
                }
            }
        }
    }
}

