/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.UnscentedTransformationParameter;
import org.applied_geodesy.adjustment.network.DefaultAverageThreshold;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.PointType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionGroupUncertaintyType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.adjustment.network.observation.reduction.ProjectionType;
import org.applied_geodesy.adjustment.network.observation.reduction.ReductionTaskType;
import org.applied_geodesy.adjustment.statistic.DefaultTestStatisticValue;
import org.applied_geodesy.jag3d.ui.graphic.layer.LayerType;
import org.applied_geodesy.jag3d.ui.io.reader.ImportOption;
import org.applied_geodesy.jag3d.ui.io.writer.ExportOption;
import org.applied_geodesy.jag3d.ui.table.column.TableContentType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.DefaultTableRowHighlightValue;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

class SQLDatabase {
    static final String TABLE_STORAGE_TYPE = "CACHED";

    private SQLDatabase() {
    }

    static Map<Double, String> dataBase() {
        LinkedHashMap<Double, String> sqls = new LinkedHashMap<Double, String>();
        sqls.put(2.01801060101E7, "CREATE CACHED TABLE \"ObservationGroup\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"name\" VARCHAR(256) NOT NULL,\"type\" SMALLINT NOT NULL,\"enable\" BOOLEAN NOT NULL, \"reference_epoch\" BOOLEAN DEFAULT TRUE NOT NULL);\r\n");
        sqls.put(2.01801060102E7, "CREATE CACHED TABLE \"ObservationGroupUncertainty\"(\"group_id\" INTEGER NOT NULL,\"type\" SMALLINT NOT NULL,\"value\" DOUBLE NOT NULL, PRIMARY KEY(\"group_id\",\"type\"), CONSTRAINT \"ObservationGroupUncertaintyOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"ObservationGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060103E7, "CREATE CACHED TABLE \"ObservationApriori\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"group_id\" INTEGER NOT NULL,\"start_point_name\" VARCHAR(256) NOT NULL,\"end_point_name\" VARCHAR(256) NOT NULL,\"instrument_height\" DOUBLE DEFAULT 0 NOT NULL,\"reflector_height\" DOUBLE DEFAULT 0 NOT NULL,\"value_0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_0\" DOUBLE DEFAULT 0 NOT NULL,\"distance_0\" DOUBLE DEFAULT 0 NOT NULL,\"enable\" BOOLEAN DEFAULT TRUE NOT NULL, CONSTRAINT \"ObservationOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"ObservationGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060104E7, "CREATE CACHED TABLE \"ObservationAposteriori\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"value\" DOUBLE NOT NULL,\"sigma_0\" DOUBLE NOT NULL,\"sigma\" DOUBLE NOT NULL,\"redundancy\" DOUBLE NOT NULL,\"gross_error\" DOUBLE NOT NULL,\"minimal_detectable_bias\" DOUBLE NOT NULL,\"influence_on_position\" DOUBLE NOT NULL,\"influence_on_network_distortion\" DOUBLE NOT NULL,\"omega\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL, CONSTRAINT \"ObservationOnDelete\" FOREIGN KEY(\"id\") REFERENCES \"ObservationApriori\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060105E7, "CREATE CACHED TABLE \"GNSSObservationApriori\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"group_id\" INTEGER NOT NULL,\"start_point_name\" VARCHAR(256) NOT NULL,\"end_point_name\" VARCHAR(256) NOT NULL,\"y0\" DOUBLE DEFAULT 0 NOT NULL,\"x0\" DOUBLE DEFAULT 0 NOT NULL,\"z0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_y0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_x0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_z0\" DOUBLE DEFAULT 0 NOT NULL,\"enable\" BOOLEAN DEFAULT TRUE NOT NULL, CONSTRAINT \"GNSSObservationOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"ObservationGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060106E7, "CREATE CACHED TABLE \"GNSSObservationAposteriori\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"y\" DOUBLE NOT NULL,\"x\" DOUBLE NOT NULL,\"z\" DOUBLE NOT NULL,\"sigma_y0\" DOUBLE NOT NULL,\"sigma_x0\" DOUBLE NOT NULL,\"sigma_z0\" DOUBLE NOT NULL,\"sigma_y\" DOUBLE NOT NULL,\"sigma_x\" DOUBLE NOT NULL,\"sigma_z\" DOUBLE NOT NULL,\"redundancy_y\" DOUBLE NOT NULL,\"redundancy_x\" DOUBLE NOT NULL,\"redundancy_z\" DOUBLE NOT NULL,\"gross_error_y\" DOUBLE NOT NULL,\"gross_error_x\" DOUBLE NOT NULL,\"gross_error_z\" DOUBLE NOT NULL,\"minimal_detectable_bias_y\" DOUBLE NOT NULL,\"minimal_detectable_bias_x\" DOUBLE NOT NULL,\"minimal_detectable_bias_z\" DOUBLE NOT NULL,\"influence_on_position_y\" DOUBLE NOT NULL,\"influence_on_position_x\" DOUBLE NOT NULL,\"influence_on_position_z\" DOUBLE NOT NULL,\"influence_on_network_distortion\" DOUBLE NOT NULL,\"omega\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL, CONSTRAINT \"GNSSObservationOnDelete\" FOREIGN KEY(\"id\") REFERENCES \"GNSSObservationApriori\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060107E7, "CREATE CACHED TABLE \"AdditionalParameterApriori\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"group_id\" INTEGER NOT NULL,\"type\" SMALLINT NOT NULL,\"value_0\" DOUBLE DEFAULT 0 NOT NULL,\"enable\" BOOLEAN NOT NULL, CONSTRAINT \"AdditionalParameterOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"ObservationGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060108E7, "CREATE CACHED TABLE \"AdditionalParameterAposteriori\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"value\" DOUBLE NOT NULL,\"sigma\" DOUBLE NOT NULL,\"confidence\" DOUBLE NOT NULL,\"gross_error\" DOUBLE NOT NULL,\"minimal_detectable_bias\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL, CONSTRAINT \"AdditionalParameterOnDelete\" FOREIGN KEY(\"id\") REFERENCES \"AdditionalParameterApriori\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060201E7, "CREATE CACHED TABLE \"PointGroup\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"name\" VARCHAR(256) NOT NULL,\"type\" SMALLINT NOT NULL,\"dimension\" TINYINT NOT NULL,\"enable\" BOOLEAN NOT NULL, \"consider_deflection\" BOOLEAN DEFAULT FALSE NOT NULL);\r\n");
        sqls.put(2.01801060202E7, "CREATE CACHED TABLE \"PointGroupUncertainty\"(\"group_id\" INTEGER NOT NULL,\"type\" SMALLINT NOT NULL,\"value\" DOUBLE NOT NULL, PRIMARY KEY(\"group_id\",\"type\"), CONSTRAINT \"PointGroupUncertaintyOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"PointGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060204E7, "CREATE CACHED TABLE \"PointApriori\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"group_id\" INTEGER NOT NULL,\"name\" VARCHAR(256) NOT NULL,\"code\" VARCHAR(256) NOT NULL,\"y0\" DOUBLE DEFAULT 0 NOT NULL,\"x0\" DOUBLE DEFAULT 0 NOT NULL,\"z0\" DOUBLE DEFAULT 0 NOT NULL,\"dy0\" DOUBLE DEFAULT 0 NOT NULL,\"dx0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_y0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_x0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_z0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_dy0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_dx0\" DOUBLE DEFAULT 0 NOT NULL,\"enable\" BOOLEAN DEFAULT TRUE NOT NULL, CONSTRAINT \"PointOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"PointGroup\"(\"id\") ON DELETE CASCADE, CONSTRAINT \"UniquePointName\" UNIQUE (\"name\"));\r\n");
        sqls.put(2.01801060205E7, "CREATE CACHED TABLE \"PointAposteriori\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"y\" DOUBLE NOT NULL,\"x\" DOUBLE NOT NULL,\"z\" DOUBLE NOT NULL,\"sigma_y0\" DOUBLE NOT NULL,\"sigma_x0\" DOUBLE NOT NULL,\"sigma_z0\" DOUBLE NOT NULL,\"sigma_y\" DOUBLE NOT NULL,\"sigma_x\" DOUBLE NOT NULL,\"sigma_z\" DOUBLE NOT NULL,\"confidence_major_axis\" DOUBLE NOT NULL,\"confidence_middle_axis\" DOUBLE NOT NULL,\"confidence_minor_axis\" DOUBLE NOT NULL,\"confidence_alpha\" DOUBLE NOT NULL,\"confidence_beta\" DOUBLE NOT NULL,\"confidence_gamma\" DOUBLE NOT NULL,\"helmert_major_axis\" DOUBLE NOT NULL,\"helmert_minor_axis\" DOUBLE NOT NULL,\"helmert_alpha\" DOUBLE NOT NULL,\"redundancy_y\" DOUBLE NOT NULL,\"redundancy_x\" DOUBLE NOT NULL,\"redundancy_z\" DOUBLE NOT NULL,\"gross_error_y\" DOUBLE NOT NULL,\"gross_error_x\" DOUBLE NOT NULL,\"gross_error_z\" DOUBLE NOT NULL,\"minimal_detectable_bias_y\" DOUBLE NOT NULL,\"minimal_detectable_bias_x\" DOUBLE NOT NULL,\"minimal_detectable_bias_z\" DOUBLE NOT NULL,\"influence_on_position_y\" DOUBLE NOT NULL,\"influence_on_position_x\" DOUBLE NOT NULL,\"influence_on_position_z\" DOUBLE NOT NULL,\"influence_on_network_distortion\" DOUBLE NOT NULL,\"first_principal_component_y\" DOUBLE NOT NULL,\"first_principal_component_x\" DOUBLE NOT NULL,\"first_principal_component_z\" DOUBLE NOT NULL,\"omega\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL,\"covar_index\" INTEGER NOT NULL, CONSTRAINT \"PointOnDelete\" FOREIGN KEY(\"id\") REFERENCES \"PointApriori\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060206E7, "CREATE CACHED TABLE \"DeflectionAposteriori\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"dy\" DOUBLE NOT NULL,\"dx\" DOUBLE NOT NULL,\"sigma_dy0\" DOUBLE NOT NULL,\"sigma_dx0\" DOUBLE NOT NULL,\"sigma_dy\" DOUBLE NOT NULL,\"sigma_dx\" DOUBLE NOT NULL,\"confidence_major_axis\" DOUBLE NOT NULL,\"confidence_minor_axis\" DOUBLE NOT NULL,\"redundancy_dy\" DOUBLE NOT NULL,\"redundancy_dx\" DOUBLE NOT NULL,\"gross_error_dy\" DOUBLE NOT NULL,\"gross_error_dx\" DOUBLE NOT NULL,\"minimal_detectable_bias_dy\" DOUBLE NOT NULL,\"minimal_detectable_bias_dx\" DOUBLE NOT NULL,\"omega\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL,\"covar_index\" INTEGER NOT NULL, CONSTRAINT \"DeflectionOnDelete\" FOREIGN KEY(\"id\") REFERENCES \"PointApriori\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060301E7, "CREATE CACHED TABLE \"CongruenceAnalysisGroup\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"name\" VARCHAR(256) NOT NULL,\"dimension\" TINYINT NOT NULL,\"enable\" BOOLEAN NOT NULL);\r\n");
        sqls.put(2.01801060302E7, "CREATE CACHED TABLE \"CongruenceAnalysisPointPairApriori\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"group_id\" INTEGER NOT NULL,\"start_point_name\" VARCHAR(256) NOT NULL,\"end_point_name\" VARCHAR(256) NOT NULL,\"enable\" BOOLEAN NOT NULL, CONSTRAINT \"CongruenceAnalysisPointPairAprioriOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"CongruenceAnalysisGroup\"(\"id\") ON DELETE CASCADE, CONSTRAINT \"CongruenceAnalysisUniquePointNamesPerGroup\" UNIQUE (\"group_id\",\"start_point_name\",\"end_point_name\"));\r\n");
        sqls.put(2.01801060303E7, "CREATE CACHED TABLE \"CongruenceAnalysisPointPairAposteriori\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"y\" DOUBLE NOT NULL,\"x\" DOUBLE NOT NULL,\"z\" DOUBLE NOT NULL,\"sigma_y\" DOUBLE NOT NULL,\"sigma_x\" DOUBLE NOT NULL,\"sigma_z\" DOUBLE NOT NULL,\"confidence_major_axis\" DOUBLE NOT NULL,\"confidence_middle_axis\" DOUBLE NOT NULL,\"confidence_minor_axis\" DOUBLE NOT NULL,\"confidence_alpha\" DOUBLE NOT NULL,\"confidence_beta\" DOUBLE NOT NULL,\"confidence_gamma\" DOUBLE NOT NULL,\"confidence_major_axis_2d\" DOUBLE NOT NULL,\"confidence_minor_axis_2d\" DOUBLE NOT NULL,\"confidence_alpha_2d\" DOUBLE NOT NULL,\"gross_error_y\" DOUBLE NOT NULL,\"gross_error_x\" DOUBLE NOT NULL,\"gross_error_z\" DOUBLE NOT NULL,\"minimal_detectable_bias_y\" DOUBLE NOT NULL,\"minimal_detectable_bias_x\" DOUBLE NOT NULL,\"minimal_detectable_bias_z\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL, CONSTRAINT \"CongruenceAnalysisPointPairOnDelete\" FOREIGN KEY(\"id\") REFERENCES \"CongruenceAnalysisPointPairApriori\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060304E7, "CREATE CACHED TABLE \"CongruenceAnalysisStrainParameterRestriction\"(\"group_id\" INTEGER NOT NULL,\"type\" SMALLINT NOT NULL,\"enable\" BOOLEAN NOT NULL,PRIMARY KEY(\"group_id\",\"type\"), CONSTRAINT \"CongruenceAnalysisStrainParameterRestrictionOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"CongruenceAnalysisGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060305E7, "CREATE CACHED TABLE \"CongruenceAnalysisStrainParameterAposteriori\"(\"group_id\" INTEGER NOT NULL,\"type\" SMALLINT NOT NULL,\"value\" DOUBLE NOT NULL,\"sigma\" DOUBLE NOT NULL,\"confidence\" DOUBLE NOT NULL,\"gross_error\" DOUBLE NOT NULL,\"minimal_detectable_bias\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL,PRIMARY KEY(\"group_id\",\"type\"), CONSTRAINT \"CongruenceAnalysisStrainParameterAposterioriOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"CongruenceAnalysisGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01801060401E7, "CREATE CACHED TABLE \"VarianceComponent\"(\"type\" SMALLINT NOT NULL PRIMARY KEY,\"redundancy\" DOUBLE NOT NULL,\"omega\" DOUBLE NOT NULL,\"sigma2apost\" DOUBLE NOT NULL,\"number_of_observations\" INTEGER NOT NULL);\r\n");
        sqls.put(2.01801060402E7, "CREATE CACHED TABLE \"PrincipalComponent\"(\"index\" INTEGER NOT NULL PRIMARY KEY,\"value\" DOUBLE NOT NULL,\"ratio\" DOUBLE NOT NULL);\r\n");
        sqls.put(2.01801060403E7, "CREATE CACHED TABLE \"RankDefect\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"user_defined\" BOOLEAN DEFAULT FALSE NOT NULL,\"ty\" BOOLEAN DEFAULT FALSE NOT NULL,\"tx\" BOOLEAN DEFAULT FALSE NOT NULL,\"tz\" BOOLEAN DEFAULT FALSE NOT NULL,\"ry\" BOOLEAN DEFAULT FALSE NOT NULL,\"rx\" BOOLEAN DEFAULT FALSE NOT NULL,\"rz\" BOOLEAN DEFAULT FALSE NOT NULL,\"sy\" BOOLEAN DEFAULT FALSE NOT NULL,\"sx\" BOOLEAN DEFAULT FALSE NOT NULL,\"sz\" BOOLEAN DEFAULT FALSE NOT NULL,\"my\" BOOLEAN DEFAULT FALSE NOT NULL,\"mx\" BOOLEAN DEFAULT FALSE NOT NULL,\"mz\" BOOLEAN DEFAULT FALSE NOT NULL,\"mxy\" BOOLEAN DEFAULT FALSE NOT NULL,\"mxyz\" BOOLEAN DEFAULT FALSE NOT NULL);\r\n");
        sqls.put(2.01801060404E7, "INSERT INTO \"RankDefect\" (\"id\") VALUES (1);\r\n");
        sqls.put(2.01801060501E7, "CREATE CACHED TABLE \"TestStatistic\"(\"d1\" DOUBLE NOT NULL,\"d2\" DOUBLE NOT NULL,\"probability_value\" DOUBLE NOT NULL,\"power_of_test\" DOUBLE NOT NULL,\"quantile\" DOUBLE NOT NULL,\"non_centrality_parameter\" DOUBLE NOT NULL,\"p_value\" DOUBLE NOT NULL,PRIMARY KEY(\"d1\",\"d2\",\"probability_value\",\"power_of_test\"));\r\n");
        sqls.put(2.01801060502E7, "CREATE CACHED TABLE \"TestStatisticDefinition\"(\"id\" INTEGER NOT NULL PRIMARY KEY, \"type\" SMALLINT DEFAULT " + DefaultTestStatisticValue.getTestStatisticType().getId() + " NOT NULL, \"probability_value\" DOUBLE DEFAULT " + DefaultTestStatisticValue.getProbabilityValue() + " NOT NULL,\"power_of_test\" DOUBLE DEFAULT " + DefaultTestStatisticValue.getPowerOfTest() + " NOT NULL,\"familywise_error_rate\" BOOLEAN DEFAULT FALSE NOT NULL);\r\n");
        sqls.put(2.01801060503E7, "INSERT INTO \"TestStatisticDefinition\" (\"id\") VALUES (1);\r\n");
        sqls.put(2.01801060504E7, "CREATE CACHED TABLE \"ProjectionDefinition\"(\"id\" INTEGER NOT NULL PRIMARY KEY, \"type\" SMALLINT DEFAULT " + ProjectionType.LOCAL_CARTESIAN.getId() + " NOT NULL,\"reference_height\" DOUBLE DEFAULT 0 NOT NULL);\r\n");
        sqls.put(2.01801060505E7, "INSERT INTO \"ProjectionDefinition\" (\"id\") VALUES (1);\r\n");
        sqls.put(2.01801060506E7, "CREATE CACHED TABLE \"AdjustmentDefinition\"(\"id\" INTEGER NOT NULL PRIMARY KEY, \"type\" SMALLINT DEFAULT " + EstimationType.L2NORM.getId() + " NOT NULL, \"number_of_iterations\" INTEGER DEFAULT 50 NOT NULL, \"robust_estimation_limit\" DOUBLE DEFAULT " + DefaultValue.getRobustEstimationLimit() + " NOT NULL, \"number_of_principal_components\" INTEGER DEFAULT 1 NOT NULL, \"estimate_direction_set_orientation_approximation\" BOOLEAN DEFAULT TRUE NOT NULL, \"congruence_analysis\" BOOLEAN DEFAULT FALSE NOT NULL, \"export_covariance_matrix\" BOOLEAN DEFAULT FALSE NOT NULL);\r\n");
        sqls.put(2.01801060507E7, "INSERT INTO \"AdjustmentDefinition\" (\"id\") VALUES (1);\r\n");
        sqls.put(2.01801060508E7, "CREATE CACHED TABLE \"ProjectMetadata\"(\"id\" INTEGER NOT NULL PRIMARY KEY, \"name\" VARCHAR(256) DEFAULT '' NOT NULL, \"operator\" VARCHAR(256) DEFAULT '' NOT NULL, \"description\" VARCHAR(10000) DEFAULT '' NOT NULL, \"date\" TIMESTAMP(6) DEFAULT NOW() NOT NULL, \"customer_id\" VARCHAR(256) DEFAULT '' NOT NULL, \"project_id\" VARCHAR(256) DEFAULT '' NOT NULL);\r\n");
        sqls.put(2.01801060509E7, "INSERT INTO \"ProjectMetadata\" (\"id\", \"operator\") VALUES (1, '" + (System.getProperty("user.name") == null ? "" : System.getProperty("user.name").replaceAll("'", "")) + "');\r\n");
        sqls.put(2.0180106051E7, "CREATE CACHED TABLE \"AverageThreshold\"(\"type\" SMALLINT NOT NULL PRIMARY KEY,\"value\" DOUBLE);\r\n");
        sqls.put(2.01801060511E7, "INSERT INTO \"AverageThreshold\" (\"type\", \"value\") VALUES (" + ObservationType.LEVELING.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.LEVELING) + "'), (" + ObservationType.DIRECTION.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.DIRECTION) + "'), (" + ObservationType.HORIZONTAL_DISTANCE.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.HORIZONTAL_DISTANCE) + "'), (" + ObservationType.SLOPE_DISTANCE.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.SLOPE_DISTANCE) + "'), (" + ObservationType.ZENITH_ANGLE.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.ZENITH_ANGLE) + "'), (" + ObservationType.GNSS1D.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.GNSS1D) + "'), (" + ObservationType.GNSS2D.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.GNSS2D) + "'), (" + ObservationType.GNSS3D.getId() + ", '" + DefaultAverageThreshold.getThreshold(ObservationType.GNSS3D) + "');\r\n");
        sqls.put(2.01801061001E7, "CREATE CACHED TABLE \"FormatterOption\" (\"type\" SMALLINT NOT NULL PRIMARY KEY, \"unit\" SMALLINT NULL, \"digits\" TINYINT NOT NULL);\r\n");
        sqls.put(2.01801065001E7, "CREATE INDEX \"IndexPointAprioriGroupId\" ON \"PointApriori\"(\"group_id\");\r\n");
        sqls.put(2.01801065002E7, "CREATE INDEX \"IndexPointAprioriName\" ON \"PointApriori\"(\"name\");\r\n");
        sqls.put(2.01801065003E7, "CREATE INDEX \"IndexPointGroupUncertaintyGroupId\" ON \"PointGroupUncertainty\"(\"group_id\");\r\n");
        sqls.put(2.01801065011E7, "CREATE INDEX \"IndexObservationGroupUncertaintyGroupId\" ON \"ObservationGroupUncertainty\"(\"group_id\");\r\n");
        sqls.put(2.01801065012E7, "CREATE INDEX \"IndexObservationGroupId\" ON \"ObservationApriori\"(\"group_id\");\r\n");
        sqls.put(2.01801065013E7, "CREATE INDEX \"IndexGNSSObservationGroupId\" ON \"GNSSObservationApriori\"(\"group_id\");\r\n");
        sqls.put(2.01801065014E7, "CREATE INDEX \"IndexObservationAprioriStartPointName\" ON \"ObservationApriori\"(\"start_point_name\");\r\n");
        sqls.put(2.01801065015E7, "CREATE INDEX \"IndexObservationAprioriEndPointName\" ON \"ObservationApriori\"(\"end_point_name\");\r\n");
        sqls.put(2.01801065016E7, "CREATE INDEX \"IndexGNSSObservationAprioriStartPointName\" ON \"GNSSObservationApriori\"(\"start_point_name\");\r\n");
        sqls.put(2.01801065017E7, "CREATE INDEX \"IndexGNSSObservationAprioriEndPointName\" ON \"GNSSObservationApriori\"(\"end_point_name\");\r\n");
        sqls.put(2.01801065021E7, "CREATE INDEX \"IndexAdditionalParameterAprioriGroupId\" ON \"AdditionalParameterApriori\"(\"group_id\");\r\n");
        sqls.put(2.0180107E7, "CREATE INDEX \"IndexCongruenceAnalysisPointPairAprioriGroupId\" ON \"CongruenceAnalysisPointPairApriori\"(\"group_id\");\r\n");
        sqls.put(2.01802190601E7, "CREATE CACHED TABLE \"Layer\" (\"type\" SMALLINT NOT NULL PRIMARY KEY, \"red\" DOUBLE DEFAULT 0.5 NOT NULL, \"green\" DOUBLE DEFAULT 0.5 NOT NULL, \"blue\" DOUBLE DEFAULT 0.5 NOT NULL, \"symbol_size\" DOUBLE DEFAULT 12.0 NOT NULL, \"line_width\" DOUBLE DEFAULT 1.0 NOT NULL, \"order\" INTEGER DEFAULT 0 NOT NULL, \"visible\" BOOLEAN DEFAULT TRUE NOT NULL);\r\n");
        sqls.put(2.01802190602E7, "CREATE CACHED TABLE \"LayerExtent\" (\"id\" INTEGER NOT NULL PRIMARY KEY, \"min_x\" DOUBLE NOT NULL, \"min_y\" DOUBLE NOT NULL, \"max_x\" DOUBLE NOT NULL, \"max_y\" DOUBLE NOT NULL);\r\n");
        sqls.put(2.01802190603E7, "CREATE CACHED TABLE \"LayerEllipseScale\" (\"id\" INTEGER NOT NULL PRIMARY KEY, \"value\" DOUBLE NOT NULL);\r\n");
        sqls.put(2.01802190604E7, "CREATE CACHED TABLE \"LayerFont\" (\"layer\" SMALLINT NOT NULL PRIMARY KEY, \"family\" VARCHAR(256) DEFAULT 'SYSTEM' NOT NULL, \"size\" DOUBLE DEFAULT 12.0 NOT NULL, \"red\" DOUBLE DEFAULT 0 NOT NULL, \"green\" DOUBLE DEFAULT 0 NOT NULL, \"blue\" DOUBLE DEFAULT 0 NOT NULL, CONSTRAINT \"LayerFontOnLayerDelete\" FOREIGN KEY(\"layer\") REFERENCES \"Layer\"(\"type\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01802190605E7, "CREATE CACHED TABLE \"PointLayerProperty\" (\"layer\" SMALLINT NOT NULL PRIMARY KEY, \"type\" SMALLINT NOT NULL, \"point_1d_visible\" BOOLEAN DEFAULT FALSE NOT NULL, \"point_2d_visible\" BOOLEAN DEFAULT TRUE NOT NULL, \"point_3d_visible\" BOOLEAN DEFAULT TRUE NOT NULL, CONSTRAINT \"LayerSymbolOnLayerDelete\" FOREIGN KEY(\"layer\") REFERENCES \"Layer\"(\"type\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01802190606E7, "CREATE CACHED TABLE \"ObservationLayerProperty\" (\"layer\" SMALLINT NOT NULL, \"observation_type\" SMALLINT NOT NULL, \"red\" DOUBLE DEFAULT 0 NOT NULL, \"green\" DOUBLE DEFAULT 0 NOT NULL, \"blue\" DOUBLE DEFAULT 0 NOT NULL, \"visible\" BOOLEAN DEFAULT TRUE NOT NULL, PRIMARY KEY(\"layer\",\"observation_type\"), CONSTRAINT \"LayerObservationColorOnLayerDelete\" FOREIGN KEY(\"layer\") REFERENCES \"Layer\"(\"type\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01802190607E7, "CREATE CACHED TABLE \"ArrowLayerProperty\" (\"layer\" SMALLINT NOT NULL PRIMARY KEY, \"type\" SMALLINT NOT NULL, CONSTRAINT \"ArrowLayerPropertyOnLayerDelete\" FOREIGN KEY(\"layer\") REFERENCES \"Layer\"(\"type\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01802190608E7, "CREATE CACHED TABLE \"ConfidenceLayerProperty\" (\"layer\" SMALLINT NOT NULL PRIMARY KEY, \"red\" DOUBLE DEFAULT 0.5 NOT NULL, \"green\" DOUBLE DEFAULT 0.5 NOT NULL, \"blue\" DOUBLE DEFAULT 0.5 NOT NULL, CONSTRAINT \"ConfidenceLayerPropertyOnLayerDelete\" FOREIGN KEY(\"layer\") REFERENCES \"Layer\"(\"type\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01803110001E7, "CREATE CACHED TABLE \"HighlightLayerProperty\" (\"layer\" SMALLINT NOT NULL PRIMARY KEY, \"red\" DOUBLE DEFAULT 0.5 NOT NULL, \"green\" DOUBLE DEFAULT 0.5 NOT NULL, \"blue\" DOUBLE DEFAULT 0.5 NOT NULL, \"line_width\" DOUBLE DEFAULT 2.5 NOT NULL, CONSTRAINT \"HighlightLayerPropertyOnLayerDelete\" FOREIGN KEY(\"layer\") REFERENCES \"Layer\"(\"type\") ON DELETE CASCADE);\r\n");
        sqls.put(2.01804100001E7, "ALTER TABLE \"ObservationAposteriori\" ADD \"residual\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100011E7, "ALTER TABLE \"GNSSObservationAposteriori\" ADD \"residual_x\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100012E7, "ALTER TABLE \"GNSSObservationAposteriori\" ADD \"residual_y\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100013E7, "ALTER TABLE \"GNSSObservationAposteriori\" ADD \"residual_z\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100021E7, "ALTER TABLE \"PointAposteriori\" ADD \"residual_x\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100022E7, "ALTER TABLE \"PointAposteriori\" ADD \"residual_y\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100023E7, "ALTER TABLE \"PointAposteriori\" ADD \"residual_z\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100031E7, "ALTER TABLE \"DeflectionAposteriori\" ADD \"residual_dx\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804100032E7, "ALTER TABLE \"DeflectionAposteriori\" ADD \"residual_dy\" DOUBLE DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01804110001E7, "CREATE CACHED TABLE \"TableRowHighlightRange\" (\"type\" SMALLINT NOT NULL PRIMARY KEY, \"left_boundary\" DOUBLE NOT NULL, \"right_boundary\" DOUBLE NOT NULL);\r\n");
        sqls.put(2.01804110002E7, "INSERT INTO \"TableRowHighlightRange\" (\"type\", \"left_boundary\", \"right_boundary\") VALUES (" + TableRowHighlightType.REDUNDANCY.getId() + ", '" + DefaultTableRowHighlightValue.getRange(TableRowHighlightType.REDUNDANCY)[0] + "', '" + DefaultTableRowHighlightValue.getRange(TableRowHighlightType.REDUNDANCY)[1] + "'), (" + TableRowHighlightType.P_PRIO_VALUE.getId() + ", '" + DefaultTableRowHighlightValue.getRange(TableRowHighlightType.P_PRIO_VALUE)[0] + "', '" + DefaultTableRowHighlightValue.getRange(TableRowHighlightType.P_PRIO_VALUE)[1] + "'), (" + TableRowHighlightType.INFLUENCE_ON_POSITION.getId() + ", '" + DefaultTableRowHighlightValue.getRange(TableRowHighlightType.INFLUENCE_ON_POSITION)[0] + "', '" + DefaultTableRowHighlightValue.getRange(TableRowHighlightType.INFLUENCE_ON_POSITION)[1] + "');\r\n");
        sqls.put(2.01804110011E7, "CREATE CACHED TABLE \"TableRowHighlightProperty\" (\"type\" SMALLINT NOT NULL PRIMARY KEY, \"red\" DOUBLE DEFAULT 0.5 NOT NULL, \"green\" DOUBLE DEFAULT 0.5 NOT NULL, \"blue\" DOUBLE DEFAULT 0.5 NOT NULL);\r\n");
        sqls.put(2.01804110012E7, "INSERT INTO \"TableRowHighlightProperty\" (\"type\", \"red\", \"green\", \"blue\") VALUES (" + TableRowHighlightRangeType.EXCELLENT.getId() + ", '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.EXCELLENT).getRed() + "', '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.EXCELLENT).getGreen() + "', '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.EXCELLENT).getBlue() + "'), (" + TableRowHighlightRangeType.SATISFACTORY.getId() + ", '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.SATISFACTORY).getRed() + "', '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.SATISFACTORY).getGreen() + "', '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.SATISFACTORY).getBlue() + "'), (" + TableRowHighlightRangeType.INADEQUATE.getId() + ", '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.INADEQUATE).getRed() + "', '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.INADEQUATE).getGreen() + "', '" + DefaultTableRowHighlightValue.getColor(TableRowHighlightRangeType.INADEQUATE).getBlue() + "');\r\n");
        sqls.put(2.01804110021E7, "CREATE CACHED TABLE \"TableRowHighlightScheme\" (\"id\" INTEGER NOT NULL PRIMARY KEY, \"type\" SMALLINT DEFAULT " + TableRowHighlightType.NONE.getId() + " NOT NULL);\r\n");
        sqls.put(2.01804110022E7, "INSERT INTO \"TableRowHighlightScheme\" (\"id\") VALUES (1);\r\n");
        sqls.put(2.01804300001E7, "ALTER TABLE \"AdjustmentDefinition\" ADD \"apply_variance_of_unit_weight\" BOOLEAN DEFAULT TRUE NOT NULL\r\n");
        sqls.put(2.01902250001E7, "ALTER TABLE \"ObservationGroup\" ADD \"order\" INTEGER DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01902250002E7, "UPDATE \"ObservationGroup\" SET \"order\" = \"id\";\r\n");
        sqls.put(2.01902250011E7, "ALTER TABLE \"PointGroup\" ADD \"order\" INTEGER DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01902250012E7, "UPDATE \"PointGroup\" SET \"order\" = \"id\";\r\n");
        sqls.put(2.01902250021E7, "ALTER TABLE \"CongruenceAnalysisGroup\" ADD \"order\" INTEGER DEFAULT 0 NOT NULL\r\n");
        sqls.put(2.01902250022E7, "UPDATE \"CongruenceAnalysisGroup\" SET \"order\" = \"id\";\r\n");
        sqls.put(2.01903090001E7, "CREATE CACHED TABLE \"LegendLayerProperty\" (\"layer\" SMALLINT NOT NULL PRIMARY KEY, \"type\" SMALLINT NOT NULL, CONSTRAINT \"LegendLayerPropertyOnLayerDelete\" FOREIGN KEY(\"layer\") REFERENCES \"Layer\"(\"type\") ON DELETE CASCADE);\r\n");
        sqls.put(2.02001190001E7, "CREATE CACHED TABLE \"ReductionDefinition\"(\"id\" INTEGER NOT NULL PRIMARY KEY, \"projection_type\" SMALLINT DEFAULT " + ProjectionType.LOCAL_CARTESIAN.getId() + " NOT NULL, \"reference_height\" DOUBLE DEFAULT 0 NOT NULL, \"earth_radius\" DOUBLE DEFAULT 6371007.0 NOT NULL);\r\n");
        sqls.put(2.02001190002E7, "INSERT INTO \"ReductionDefinition\" (\"id\", \"projection_type\", \"reference_height\", \"earth_radius\") (SELECT \"id\", CASEWHEN(\"type\" IN (4, 24, 34, 234), " + ProjectionType.GAUSS_KRUEGER.getId() + ", CASEWHEN(\"type\" IN (5, 25, 35, 235), " + ProjectionType.UTM.getId() + ", " + ProjectionType.LOCAL_CARTESIAN.getId() + ")) AS \"projection_type\", \"reference_height\", 6371007.0 AS \"earth_radius\" FROM \"ProjectionDefinition\" WHERE \"id\" = 1 LIMIT 1);\r\n");
        sqls.put(2.02001190011E7, "CREATE CACHED TABLE \"ReductionTask\"(\"reduction_id\" INTEGER NOT NULL, \"type\" SMALLINT NOT NULL, PRIMARY KEY(\"reduction_id\", \"type\"), CONSTRAINT \"ReductionDefinitionOnGroupDelete\" FOREIGN KEY(\"reduction_id\") REFERENCES \"ReductionDefinition\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.02001190012E7, "INSERT INTO \"ReductionTask\" (\"reduction_id\", \"type\") SELECT \"id\", CASEWHEN(\"type\" IN (4, 24, 34, 234, 5, 25, 35, 235), " + ReductionTaskType.DISTANCE.getId() + ", -1) FROM \"ProjectionDefinition\" WHERE \"id\" = 1 LIMIT 1;\r\n");
        sqls.put(2.02001190013E7, "INSERT INTO \"ReductionTask\" (\"reduction_id\", \"type\") SELECT \"id\", CASEWHEN(\"type\" IN (23, 34, 234, 35, 235),           " + ReductionTaskType.HEIGHT.getId() + ", -2) FROM \"ProjectionDefinition\" WHERE \"id\" = 1 LIMIT 1;\r\n");
        sqls.put(2.02001190014E7, "INSERT INTO \"ReductionTask\" (\"reduction_id\", \"type\") SELECT \"id\", CASEWHEN(\"type\" IN (23, 24, 234, 25, 235),           " + ReductionTaskType.DIRECTION.getId() + ", -3) FROM \"ProjectionDefinition\" WHERE \"id\" = 1 LIMIT 1;\r\n");
        sqls.put(2.02001190015E7, "DELETE FROM \"ReductionTask\" WHERE \"type\" < 0;\r\n");
        sqls.put(2.0200119002E7, "DROP TABLE \"ProjectionDefinition\"\r\n");
        sqls.put(2.02001240001E7, "CREATE CACHED TABLE \"UnscentedTransformation\"(\"id\" INTEGER NOT NULL PRIMARY KEY, \"scaling\" DOUBLE DEFAULT " + UnscentedTransformationParameter.getAlpha() + " NOT NULL, \"damping\" DOUBLE DEFAULT " + UnscentedTransformationParameter.getBeta() + " NOT NULL, \"weight_zero\" DOUBLE DEFAULT " + UnscentedTransformationParameter.getWeightZero() + " NOT NULL);\r\n");
        sqls.put(2.02001240002E7, "INSERT INTO \"UnscentedTransformation\" (\"id\") VALUES (1);\r\n");
        sqls.put(2.02003270001E7, "CREATE CACHED TABLE \"ImportSeparation\" (\"id\" INTEGER NOT NULL PRIMARY KEY, \"separate\" BOOLEAN DEFAULT FALSE NOT NULL);\r\n");
        sqls.put(2.02003270002E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.LEVELING.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.LEVELING) + ");\r\n");
        sqls.put(2.02003270003E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.DIRECTION.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.DIRECTION) + ");\r\n");
        sqls.put(2.02003270004E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.HORIZONTAL_DISTANCE.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.HORIZONTAL_DISTANCE) + ");\r\n");
        sqls.put(2.02003270005E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.SLOPE_DISTANCE.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.SLOPE_DISTANCE) + ");\r\n");
        sqls.put(2.02003270006E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.ZENITH_ANGLE.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.ZENITH_ANGLE) + ");\r\n");
        sqls.put(2.02003270007E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.GNSS1D.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.GNSS1D) + ");\r\n");
        sqls.put(2.02003270008E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.GNSS2D.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.GNSS2D) + ");\r\n");
        sqls.put(2.02003270009E7, "INSERT INTO \"ImportSeparation\" (\"id\", \"separate\") VALUES (" + ObservationType.GNSS3D.getId() + ", " + ImportOption.getInstance().isGroupSeparation(ObservationType.GNSS3D) + ");\r\n");
        sqls.put(2.02012200001E7, "CREATE CACHED TABLE \"VerticalDeflectionGroup\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"name\" VARCHAR(256) NOT NULL,\"type\" SMALLINT NOT NULL,\"enable\" BOOLEAN NOT NULL,\"order\" INTEGER DEFAULT 0 NOT NULL);\r\n");
        sqls.put(2.02012200002E7, "CREATE CACHED TABLE \"VerticalDeflectionGroupUncertainty\"(\"group_id\" INTEGER NOT NULL,\"type\" SMALLINT NOT NULL,\"value\" DOUBLE NOT NULL, PRIMARY KEY(\"group_id\",\"type\"), CONSTRAINT \"VerticalDeflectionUncertaintyOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"VerticalDeflectionGroup\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.02012200003E7, "CREATE CACHED TABLE \"VerticalDeflectionApriori\"(\"id\" INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,\"group_id\" INTEGER NOT NULL,\"name\" VARCHAR(256) NOT NULL,\"y0\" DOUBLE DEFAULT 0 NOT NULL,\"x0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_y0\" DOUBLE DEFAULT 0 NOT NULL,\"sigma_x0\" DOUBLE DEFAULT 0 NOT NULL,\"enable\" BOOLEAN DEFAULT TRUE NOT NULL, CONSTRAINT \"VerticalDeflectionOnGroupDelete\" FOREIGN KEY(\"group_id\") REFERENCES \"VerticalDeflectionGroup\"(\"id\") ON DELETE CASCADE, CONSTRAINT \"UniqueVerticalDeflectionName\" UNIQUE (\"name\"));\r\n");
        sqls.put(2.02012200004E7, "CREATE CACHED TABLE \"VerticalDeflectionAposteriori\"(\"id\" INTEGER NOT NULL PRIMARY KEY,\"y\" DOUBLE NOT NULL,\"x\" DOUBLE NOT NULL,\"sigma_y0\" DOUBLE NOT NULL,\"sigma_x0\" DOUBLE NOT NULL,\"sigma_y\" DOUBLE NOT NULL,\"sigma_x\" DOUBLE NOT NULL,\"residual_y\" DOUBLE DEFAULT 0 NOT NULL,\"residual_x\" DOUBLE DEFAULT 0 NOT NULL,\"confidence_major_axis\" DOUBLE NOT NULL,\"confidence_minor_axis\" DOUBLE NOT NULL,\"redundancy_y\" DOUBLE NOT NULL,\"redundancy_x\" DOUBLE NOT NULL,\"gross_error_y\" DOUBLE NOT NULL,\"gross_error_x\" DOUBLE NOT NULL,\"minimal_detectable_bias_y\" DOUBLE NOT NULL,\"minimal_detectable_bias_x\" DOUBLE NOT NULL,\"omega\" DOUBLE NOT NULL,\"p_prio\" DOUBLE NOT NULL,\"p_post\" DOUBLE NOT NULL,\"t_prio\" DOUBLE NOT NULL,\"t_post\" DOUBLE NOT NULL,\"significant\" BOOLEAN NOT NULL,\"covar_index\" INTEGER NOT NULL, CONSTRAINT \"VerticalDeflectionOnDelete\" FOREIGN KEY(\"id\") REFERENCES \"VerticalDeflectionApriori\"(\"id\") ON DELETE CASCADE);\r\n");
        sqls.put(2.0201220001E7, "INSERT INTO \"VerticalDeflectionGroup\" (\"id\", \"name\", \"type\", \"enable\", \"order\") SELECT \"id\", \"name\", " + VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION.getId() + " AS \"type\", \"enable\", \"order\" FROM \"PointGroup\" WHERE \"type\" = " + PointType.REFERENCE_POINT.getId() + " and \"dimension\" = 3 and \"consider_deflection\" = TRUE\r\n");
        sqls.put(2.02012200011E7, "INSERT INTO \"VerticalDeflectionGroup\" (\"id\", \"name\", \"type\", \"enable\", \"order\") SELECT \"id\", \"name\", " + VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION.getId() + " AS \"type\", \"enable\", \"order\" FROM \"PointGroup\" WHERE \"type\" = " + PointType.STOCHASTIC_POINT.getId() + " and \"dimension\" = 3 and \"consider_deflection\" = TRUE\r\n");
        sqls.put(2.02012200012E7, "INSERT INTO \"VerticalDeflectionGroup\" (\"id\", \"name\", \"type\", \"enable\", \"order\") SELECT \"id\", \"name\", " + VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION.getId() + " AS \"type\", \"enable\", \"order\" FROM \"PointGroup\" WHERE \"type\" IN (" + PointType.NEW_POINT.getId() + "," + PointType.DATUM_POINT.getId() + ") and \"dimension\" = 3 and \"consider_deflection\" = TRUE\r\n");
        sqls.put(2.02012200013E7, "INSERT INTO \"VerticalDeflectionGroupUncertainty\" (\"group_id\", \"type\", \"value\") SELECT \"group_id\", " + VerticalDeflectionGroupUncertaintyType.DEFLECTION_X.getId() + " AS \"type\", \"value\" FROM \"PointGroupUncertainty\" JOIN \"PointGroup\" ON \"PointGroupUncertainty\".\"group_id\" = \"PointGroup\".\"id\" AND \"dimension\" = 3 AND \"consider_deflection\" = TRUE WHERE \"PointGroupUncertainty\".\"type\" = " + VerticalDeflectionGroupUncertaintyType.DEFLECTION_X.getId() + "\r\n");
        sqls.put(2.02012200014E7, "INSERT INTO \"VerticalDeflectionGroupUncertainty\" (\"group_id\", \"type\", \"value\") SELECT \"group_id\", " + VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y.getId() + " AS \"type\", \"value\" FROM \"PointGroupUncertainty\" JOIN \"PointGroup\" ON \"PointGroupUncertainty\".\"group_id\" = \"PointGroup\".\"id\" AND \"dimension\" = 3 AND \"consider_deflection\" = TRUE WHERE \"PointGroupUncertainty\".\"type\" = " + VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y.getId() + "\r\n");
        sqls.put(2.02012200015E7, "INSERT INTO \"VerticalDeflectionApriori\" (\"name\", \"group_id\", \"y0\", \"x0\", \"sigma_y0\", \"sigma_x0\", \"enable\")  SELECT \"name\", \"group_id\", \"dy0\", \"dx0\", \"sigma_dy0\", \"sigma_dx0\", \"enable\" FROM \"PointApriori\" JOIN \"PointGroup\" ON \"PointApriori\".\"group_id\" = \"PointGroup\".\"id\" WHERE \"dimension\" = 3 AND \"consider_deflection\" = TRUE\r\n");
        sqls.put(2.0201220002E7, "DELETE FROM \"PointGroupUncertainty\" WHERE \"type\" IN (" + VerticalDeflectionGroupUncertaintyType.DEFLECTION_X.getId() + ", " + VerticalDeflectionGroupUncertaintyType.DEFLECTION_Y.getId() + ")\r\n");
        sqls.put(2.02012200021E7, "DROP TABLE \"DeflectionAposteriori\"\r\n");
        sqls.put(2.02012200022E7, "ALTER TABLE \"PointApriori\" DROP COLUMN \"dy0\"\r\n");
        sqls.put(2.02012200023E7, "ALTER TABLE \"PointApriori\" DROP COLUMN \"dx0\"\r\n");
        sqls.put(2.02012200024E7, "ALTER TABLE \"PointApriori\" DROP COLUMN \"sigma_dy0\"\r\n");
        sqls.put(2.02012200025E7, "ALTER TABLE \"PointApriori\" DROP COLUMN \"sigma_dx0\"\r\n");
        sqls.put(2.02012200026E7, "ALTER TABLE \"PointGroup\" DROP COLUMN \"consider_deflection\"\r\n");
        sqls.put(2.02101120001E7, "CREATE CACHED TABLE \"TableColumnProperty\" (\"table_type\" SMALLINT NOT NULL, \"column_type\" SMALLINT NOT NULL, \"width\" DOUBLE DEFAULT 125 NOT NULL, \"sort_type\" TINYINT DEFAULT 1 NOT NULL, \"sort_order\" SMALLINT DEFAULT -1 NOT NULL, \"column_order\" SMALLINT DEFAULT 0 NOT NULL, PRIMARY KEY(\"table_type\",\"column_type\"));\r\n");
        sqls.put(2.02102150001E7, "UPDATE \"TestStatistic\" SET \"probability_value\" = \"probability_value\" / 100, \"power_of_test\" = \"power_of_test\" / 100 WHERE ((SELECT \"power_of_test\" FROM \"TestStatisticDefinition\") > 1);\r\n");
        sqls.put(2.02102150002E7, "UPDATE \"TableRowHighlightRange\" SET \"left_boundary\" = \"left_boundary\" / 100, \"right_boundary\" = \"right_boundary\" / 100 WHERE \"type\" = " + TableRowHighlightType.P_PRIO_VALUE.getId() + " AND ((SELECT \"power_of_test\" FROM \"TestStatisticDefinition\") > 1);\r\n");
        sqls.put(2.02102150003E7, "UPDATE \"TestStatisticDefinition\" SET \"probability_value\" = \"probability_value\" / 100, \"power_of_test\" = \"power_of_test\" / 100 WHERE \"power_of_test\" > 1;\r\n");
        sqls.put(2.02103120001E7, "DELETE FROM \"TableColumnProperty\";\r\n");
        sqls.put(2.02103150001E7, "DELETE FROM \"TableColumnProperty\" WHERE \"table_type\" IN (" + TableContentType.CONGRUENCE_ANALYSIS_1D.getId() + ", " + TableContentType.CONGRUENCE_ANALYSIS_2D.getId() + ", " + TableContentType.CONGRUENCE_ANALYSIS_3D.getId() + ");\r\n");
        sqls.put(2.02105080001E7, "ALTER TABLE \"ReductionDefinition\" ADD \"x0\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02105080002E7, "ALTER TABLE \"ReductionDefinition\" ADD \"y0\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02105080003E7, "ALTER TABLE \"ReductionDefinition\" ADD \"z0\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02105130001E7, "ALTER TABLE \"ReductionDefinition\" ADD \"reference_latitude\"  DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02105130002E7, "ALTER TABLE \"ReductionDefinition\" ADD \"reference_longitude\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02105130003E7, "ALTER TABLE \"ReductionDefinition\" ADD \"major_axis\" DOUBLE DEFAULT 6371007.0 NOT NULL;\r\n");
        sqls.put(2.02105130004E7, "ALTER TABLE \"ReductionDefinition\" ADD \"minor_axis\" DOUBLE DEFAULT 6371007.0 NOT NULL;\r\n");
        sqls.put(2.0210513001E7, "UPDATE \"ReductionDefinition\" SET \"major_axis\" = \"earth_radius\", \"minor_axis\" = \"earth_radius\" WHERE \"id\" = 1;\r\n");
        sqls.put(2.02105130011E7, "ALTER TABLE \"ReductionDefinition\" DROP COLUMN \"earth_radius\";\r\n");
        sqls.put(2.02106290001E7, "ALTER TABLE \"ObservationAposteriori\" ADD \"maximum_tolerable_bias\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290011E7, "ALTER TABLE \"GNSSObservationAposteriori\" ADD \"maximum_tolerable_bias_x\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290012E7, "ALTER TABLE \"GNSSObservationAposteriori\" ADD \"maximum_tolerable_bias_y\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290013E7, "ALTER TABLE \"GNSSObservationAposteriori\" ADD \"maximum_tolerable_bias_z\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290021E7, "ALTER TABLE \"PointAposteriori\" ADD \"maximum_tolerable_bias_x\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290022E7, "ALTER TABLE \"PointAposteriori\" ADD \"maximum_tolerable_bias_y\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290023E7, "ALTER TABLE \"PointAposteriori\" ADD \"maximum_tolerable_bias_z\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290031E7, "ALTER TABLE \"VerticalDeflectionAposteriori\" ADD \"maximum_tolerable_bias_x\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02106290032E7, "ALTER TABLE \"VerticalDeflectionAposteriori\" ADD \"maximum_tolerable_bias_y\" DOUBLE DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02109230001E7, "ALTER TABLE \"HighlightLayerProperty\" ADD \"type\" SMALLINT DEFAULT " + TableRowHighlightType.NONE.getId() + " NOT NULL;\r\n");
        sqls.put(2.02205120001E7, "ALTER TABLE \"VarianceComponent\" ADD \"number_of_effective_observations\" INTEGER DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02205120002E7, "ALTER TABLE \"VarianceComponent\" ADD \"number_of_negative_residuals\" INTEGER DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.0220512001E7, "CREATE CACHED TABLE \"BinomialTestStatistic\"(\"number_of_trials\" INTEGER NOT NULL PRIMARY KEY, \"success_probability\" DOUBLE NOT NULL, \"probability_value\" DOUBLE NOT NULL, \"lower_tail_quantile\" DOUBLE NOT NULL, \"upper_tail_quantile\" DOUBLE NOT NULL);\r\n");
        sqls.put(2.02212200001E7, "ALTER TABLE \"Layer\"                     ADD \"opacity\" DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200002E7, "ALTER TABLE \"ConfidenceLayerProperty\"   ADD \"opacity\" DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200003E7, "ALTER TABLE \"ObservationLayerProperty\"  ADD \"opacity\" DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200004E7, "ALTER TABLE \"HighlightLayerProperty\"    ADD \"opacity\" DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200005E7, "ALTER TABLE \"LayerFont\"                 ADD \"opacity\" DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200006E7, "ALTER TABLE \"TableRowHighlightProperty\" ADD \"opacity\" DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200011E7, "ALTER TABLE \"LayerFont\" ADD \"background_red\"     DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200012E7, "ALTER TABLE \"LayerFont\" ADD \"background_green\"   DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200013E7, "ALTER TABLE \"LayerFont\" ADD \"background_blue\"    DOUBLE DEFAULT 1.0 NOT NULL;\r\n");
        sqls.put(2.02212200014E7, "ALTER TABLE \"LayerFont\" ADD \"background_opacity\" DOUBLE DEFAULT 0.0 NOT NULL;\r\n");
        sqls.put(2.02212200015E7, "UPDATE \"LayerFont\" SET \"background_opacity\" = 0.9  WHERE \"layer\" = " + LayerType.LEGEND.getId() + ";\r\n");
        sqls.put(2.02212200016E7, "UPDATE \"LayerFont\" SET \"background_opacity\" = 0.25 WHERE \"layer\" IN (" + LayerType.REFERENCE_POINT_APRIORI.getId() + "," + LayerType.STOCHASTIC_POINT_APRIORI.getId() + "," + LayerType.DATUM_POINT_APRIORI.getId() + "," + LayerType.NEW_POINT_APRIORI.getId() + "," + LayerType.REFERENCE_POINT_APOSTERIORI.getId() + "," + LayerType.STOCHASTIC_POINT_APOSTERIORI.getId() + "," + LayerType.DATUM_POINT_APOSTERIORI.getId() + "," + LayerType.NEW_POINT_APOSTERIORI.getId() + ");\r\n");
        sqls.put(2.02301100001E7, "ALTER TABLE \"PointAposteriori\" ADD \"number_of_observations\" INTEGER DEFAULT 0 NOT NULL;\r\n");
        sqls.put(2.02301310001E7, "UPDATE \"ObservationAposteriori\" SET \"residual\" = -\"residual\";\r\n");
        sqls.put(2.02301310011E7, "UPDATE \"GNSSObservationAposteriori\" SET \"residual_x\" = -\"residual_x\";\r\n");
        sqls.put(2.02301310012E7, "UPDATE \"GNSSObservationAposteriori\" SET \"residual_y\" = -\"residual_y\";\r\n");
        sqls.put(2.02301310013E7, "UPDATE \"GNSSObservationAposteriori\" SET \"residual_z\" = -\"residual_z\";\r\n");
        sqls.put(2.02301310021E7, "UPDATE \"PointAposteriori\" SET \"residual_x\" = -\"residual_x\";\r\n");
        sqls.put(2.02301310022E7, "UPDATE \"PointAposteriori\" SET \"residual_y\" = -\"residual_y\";\r\n");
        sqls.put(2.02301310023E7, "UPDATE \"PointAposteriori\" SET \"residual_z\" = -\"residual_z\";\r\n");
        sqls.put(2.02301310031E7, "UPDATE \"VerticalDeflectionAposteriori\" SET \"residual_x\" = -\"residual_x\";\r\n");
        sqls.put(2.02301310032E7, "UPDATE \"VerticalDeflectionAposteriori\" SET \"residual_y\" = -\"residual_y\";\r\n");
        sqls.put(2.02307160001E7, "CREATE CACHED TABLE \"ExportResult\"(\"id\" INTEGER NOT NULL PRIMARY KEY, \"type\" INTEGER DEFAULT " + ExportOption.ExportResultType.NONE.getId() + " NOT NULL);\r\n");
        sqls.put(2.02307160002E7, "INSERT INTO \"ExportResult\" (\"id\", \"type\") SELECT \"id\", CASEWHEN(\"export_covariance_matrix\", " + ExportOption.ExportResultType.ASCII.getId() + ", " + ExportOption.ExportResultType.NONE.getId() + ") AS \"type\" FROM \"AdjustmentDefinition\" WHERE \"id\" = 1;\r\n");
        sqls.put(2.02307160003E7, "ALTER TABLE \"AdjustmentDefinition\" DROP COLUMN \"export_covariance_matrix\";\r\n");
        sqls.put(2.02507270001E7, "ALTER TABLE \"AdjustmentDefinition\" ADD \"confidence_level\" DOUBLE DEFAULT " + DefaultValue.getConfidenceLevel() + " NOT NULL;\r\n");
        sqls.put(2.02507270002E7, "ALTER TABLE \"PointAposteriori\" ALTER COLUMN \"helmert_major_axis\" RENAME TO \"confidence_ellipse_major_axis\";\r\n");
        sqls.put(2.02507270003E7, "ALTER TABLE \"PointAposteriori\" ALTER COLUMN \"helmert_minor_axis\" RENAME TO \"confidence_ellipse_minor_axis\";\r\n");
        sqls.put(2.02507270004E7, "ALTER TABLE \"PointAposteriori\" ALTER COLUMN \"helmert_alpha\"      RENAME TO \"confidence_ellipse_angle\";\r\n");
        sqls.put(2.02507270005E7, "ALTER TABLE \"CongruenceAnalysisPointPairAposteriori\" ALTER COLUMN \"confidence_major_axis_2d\" RENAME TO \"confidence_ellipse_major_axis\";\r\n");
        sqls.put(2.02507270006E7, "ALTER TABLE \"CongruenceAnalysisPointPairAposteriori\" ALTER COLUMN \"confidence_minor_axis_2d\" RENAME TO \"confidence_ellipse_minor_axis\";\r\n");
        sqls.put(2.02507270007E7, "ALTER TABLE \"CongruenceAnalysisPointPairAposteriori\" ALTER COLUMN \"confidence_alpha_2d\"      RENAME TO \"confidence_ellipse_angle\";\r\n");
        return sqls;
    }
}

