/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Properties;

public class DefaultApplicationProperty {
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/application.default";
        try {
            try {
                if (DefaultApplicationProperty.class.getClassLoader().getResourceAsStream("properties/application.default") != null) {
                    bis = new BufferedInputStream(DefaultApplicationProperty.class.getClassLoader().getResourceAsStream("properties/application.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultApplicationProperty() {
    }

    public static boolean startApplicationInFullScreen() {
        return PROPERTIES.getProperty("FULL_SCREEN", "FALSE").equalsIgnoreCase("TRUE");
    }

    public static boolean showConfirmDialogOnDelete() {
        return PROPERTIES.getProperty("SHOW_CONFIRM_DIALOG_ON_DELETE", "TRUE").equalsIgnoreCase("TRUE");
    }

    public static File getDefaultWorkspacePath() {
        String defaultWorkspace = PROPERTIES.getProperty("WORKSPACE", System.getProperty("user.home", null));
        if (defaultWorkspace != null && Files.exists(Paths.get(defaultWorkspace, new String[0]), new LinkOption[0]) && Files.isDirectory(Paths.get(defaultWorkspace, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            return new File(defaultWorkspace);
        }
        return new File(System.getProperty("user.home", null));
    }

    public static File getDefaultHistoryPath() {
        String defaultHistoryPath = PROPERTIES.getProperty("HISTORY", System.getProperty("user.home", null));
        if (defaultHistoryPath != null && Files.exists(Paths.get(defaultHistoryPath, new String[0]), new LinkOption[0]) && Files.isDirectory(Paths.get(defaultHistoryPath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            return new File(defaultHistoryPath + File.separator + ".jag3d_history");
        }
        return new File(System.getProperty("user.home") + File.separator + ".jag3d_history");
    }
}

