/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.tree;

import java.util.Arrays;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.tabpane.UITabPaneBuilder;
import org.applied_geodesy.coordtrans.ui.tree.AdjustmentTreeItemValue;
import org.applied_geodesy.coordtrans.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.coordtrans.ui.tree.TransformationParameterTreeItemValue;
import org.applied_geodesy.coordtrans.ui.tree.TransformationTreeItemValue;
import org.applied_geodesy.coordtrans.ui.tree.TreeItemType;
import org.applied_geodesy.coordtrans.ui.tree.TreeItemValue;

public class UITreeBuilder
implements TransformationChangeListener {
    private final I18N i18n = I18N.getInstance();
    private static UITreeBuilder treeBuilder = new UITreeBuilder();
    private UITabPaneBuilder tabPaneBuilder = UITabPaneBuilder.getInstance();
    private TreeView<TreeItemValue<?>> treeView;
    private TreeListSelectionChangeListener treeListSelectionChangeListener = new TreeListSelectionChangeListener();
    private TreeItem<TreeItemValue<?>> lastValidSelectedTreeItem = null;

    private UITreeBuilder() {
    }

    public static UITreeBuilder getInstance() {
        treeBuilder.init();
        return treeBuilder;
    }

    public TreeView<TreeItemValue<?>> getTree() {
        return this.treeView;
    }

    private void init() {
        if (this.treeView != null) {
            return;
        }
        this.treeView = new TreeView();
        this.treeView.setEditable(false);
        AdjustmentTreeItemValue adjustmentTreeItemValue = new AdjustmentTreeItemValue(this.i18n.getString("UITreeBuilder.root.label", "CoordTrans"));
        ObservationTreeItemValue observationTreeItemValue = new ObservationTreeItemValue(this.i18n.getString("UITreeBuilder.observation.label", "Homologous Points"));
        TransformationParameterTreeItemValue parameterTreeItemValue = new TransformationParameterTreeItemValue(this.i18n.getString("UITreeBuilder.parameter.label", "Parameters"));
        TransformationTreeItemValue transformationTreeItemValue = new TransformationTreeItemValue(this.i18n.getString("UITreeBuilder.transformation.label", "Transformation"));
        TreeItem<TreeItemValue<?>> rootItem = this.createItem(adjustmentTreeItemValue);
        TreeItem<TreeItemValue<?>> observationItem = this.createItem(observationTreeItemValue);
        TreeItem<TreeItemValue<?>> parameterItem = this.createItem(parameterTreeItemValue);
        TreeItem<TreeItemValue<?>> transformationItem = this.createItem(transformationTreeItemValue);
        rootItem.getChildren().addAll(Arrays.asList(observationItem, parameterItem, transformationItem));
        this.treeView.setRoot(rootItem);
        this.treeView.setShowRoot(true);
        this.treeView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)this.treeListSelectionChangeListener);
        this.treeView.getSelectionModel().select(0);
    }

    public void handleTreeSelections() {
        this.handleTreeSelections(this.lastValidSelectedTreeItem);
    }

    private TreeItem<TreeItemValue<?>> createItem(TreeItemValue<?> value) {
        TreeItem item = new TreeItem(value);
        item.setExpanded(true);
        return item;
    }

    private TreeItem<TreeItemValue<?>> searchTreeItem(TreeItem<TreeItemValue<?>> item, TreeItemType treeItemType) {
        if (item == null) {
            return null;
        }
        if (((TreeItemValue)item.getValue()).getTreeItemType() == treeItemType) {
            return item;
        }
        TreeItem<TreeItemValue<?>> result = null;
        for (TreeItem child : item.getChildren()) {
            result = this.searchTreeItem(child, treeItemType);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public TransformationAdjustment getTransformationAdjustment() {
        TreeItem rootItem = this.treeView.getRoot();
        if (rootItem != null) {
            return (TransformationAdjustment)((AdjustmentTreeItemValue)rootItem.getValue()).getObject();
        }
        return null;
    }

    private void setTransformation(Transformation transformation) {
        TreeItem<TreeItemValue<?>> observationItem;
        this.treeView.getSelectionModel().select(0);
        if (transformation != null && (observationItem = this.searchTreeItem(this.treeView.getRoot(), TreeItemType.OBSERVED_POSITIONS)) != null) {
            this.treeView.getSelectionModel().select(observationItem);
        }
    }

    private void handleTreeSelections(TreeItem<TreeItemValue<?>> currentTreeItem) {
        this.lastValidSelectedTreeItem = currentTreeItem;
        if (currentTreeItem == null) {
            return;
        }
        this.tabPaneBuilder.setTreeItemValue((TreeItemValue)currentTreeItem.getValue());
    }

    @Override
    public void transformationChanged(TransformationEvent evt) {
        if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED) {
            this.setTransformation(evt.getSource());
        } else if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED) {
            this.setTransformation(null);
        }
    }

    private class TreeListSelectionChangeListener
    implements ListChangeListener<TreeItem<TreeItemValue<?>>> {
        private TreeListSelectionChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends TreeItem<TreeItemValue<?>>> change) {
            if (change != null && change.next() && UITreeBuilder.this.treeView != null && UITreeBuilder.this.treeView.getSelectionModel() != null && UITreeBuilder.this.treeView.getSelectionModel().getSelectedItems().size() > 0) {
                TreeItem treeItem = null;
                boolean hasValidTreeItem = false;
                try {
                    if ((change.wasAdded() || change.wasReplaced()) && change.getAddedSubList() != null && !change.getAddedSubList().isEmpty()) {
                        treeItem = (TreeItem)change.getAddedSubList().get(0);
                        hasValidTreeItem = true;
                    }
                }
                catch (Exception e) {
                    hasValidTreeItem = false;
                    e.printStackTrace();
                }
                if (!hasValidTreeItem) {
                    treeItem = (TreeItem)UITreeBuilder.this.treeView.getSelectionModel().getSelectedItem();
                    int treeItemIndex = UITreeBuilder.this.treeView.getSelectionModel().getSelectedIndex();
                    if (treeItemIndex < 0 || treeItem == null || !UITreeBuilder.this.treeView.getSelectionModel().isSelected(treeItemIndex)) {
                        treeItem = (TreeItem)UITreeBuilder.this.treeView.getSelectionModel().getSelectedItems().get(0);
                    }
                }
                UITreeBuilder.this.handleTreeSelections(treeItem);
            }
        }
    }
}

