/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.tabpane;

import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.pane.UIInterpolationPaneBuilder;
import org.applied_geodesy.coordtrans.ui.pane.UIRestrictionPaneBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIHomologousFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIParameterTableBuilder;
import org.applied_geodesy.coordtrans.ui.tabpane.TabType;
import org.applied_geodesy.coordtrans.ui.tree.TreeItemType;
import org.applied_geodesy.coordtrans.ui.tree.TreeItemValue;
import org.applied_geodesy.ui.table.ColumnType;

public class UITabPaneBuilder {
    private TabPane tabPane = null;
    private static UITabPaneBuilder tabPaneBuilder = new UITabPaneBuilder();
    private I18N i18n = I18N.getInstance();
    private TabSelectionChangeListener tabSelectionChangeListener = new TabSelectionChangeListener();
    private UIRestrictionPaneBuilder restrictionPaneBuilder = UIRestrictionPaneBuilder.getInstance();
    private UIInterpolationPaneBuilder interpolationPaneBuilder = UIInterpolationPaneBuilder.getInstance();
    private UIHomologousFramePositionPairTableBuilder homologousFramePositionPairTableBuilder = UIHomologousFramePositionPairTableBuilder.getInstance();
    private UIParameterTableBuilder parameterTableBuilder = UIParameterTableBuilder.getInstance();
    private UIFramePositionPairTableBuilder framePositionPairTableBuilder = UIFramePositionPairTableBuilder.getInstance();
    private ObservableMap<TabType, Tab> tapMap = FXCollections.observableHashMap();
    private TreeItemValue<?> lastTreeItemValue = null;
    private Tab lastSelectedTab = null;

    public static UITabPaneBuilder getInstance() {
        return tabPaneBuilder;
    }

    public TabPane getTabPane() {
        if (this.tabPane == null) {
            this.init();
        }
        return this.tabPane;
    }

    private void init() {
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.restriction.label", "Restriction"), this.i18n.getString("UITabPaneBuilder.tab.restriction.title", "Parameter restrictions of transformation"), TabType.RESTRICTIONS, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.interpolation.label", "Interpolation"), this.i18n.getString("UITabPaneBuilder.tab.interpolation.title", "Interpolation approaches for residual gaps"), TabType.INTERPOLATION, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.homologous_pair.apriori.label", "Position pairs"), this.i18n.getString("UITabPaneBuilder.tab.homologous_pair.apriori.title", "Table of observed homologous position pairs"), TabType.APRIORI_HOMOLOGOUS_PAIRS, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.position.source.apriori.label", "Source system"), this.i18n.getString("UITabPaneBuilder.tab.position.source.apriori.title", "Table of source system positions"), TabType.APRIORI_SOURCE_SYSTEM_POINTS, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.position.source.aposteriori.label", "Source system"), this.i18n.getString("UITabPaneBuilder.tab.position.source.aposteriori.title", "Table of estimated source system positions"), TabType.APOSTERIORI_SOURCE_SYSTEM_POINTS, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.position.target.aposteriori.label", "Target system"), this.i18n.getString("UITabPaneBuilder.tab.position.target.aposteriori.title", "Table of estimated target system positions"), TabType.APOSTERIORI_TARGET_SYSTEM_POINTS, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.position.outlier.label", "Outliers"), this.i18n.getString("UITabPaneBuilder.tab.position.outlier.title", "Table of estimated stochastic parameters"), TabType.APOSTERIORI_OUTLIERS, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.parameter.aposteriori.label", "Parameters"), this.i18n.getString("UITabPaneBuilder.tab.parameter.aposteriori.title", "Table of estimated transformation parameters"), TabType.APOSTERIORI_PARAMETERS, null);
        this.tabPane = new TabPane();
        this.tabPane.setSide(Side.BOTTOM);
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)this.tabSelectionChangeListener);
    }

    private Tab createTab(String name, String tooltip, TabType type, Node node) {
        Tab tab = new Tab(name, node);
        tab.setClosable(false);
        tab.setTooltip(new Tooltip(tooltip));
        tab.setUserData((Object)type);
        this.tapMap.put((Object)type, (Object)tab);
        return tab;
    }

    private Node getNode(TabType tabType) {
        if (this.lastTreeItemValue == null || tabType == null) {
            return null;
        }
        Object node = null;
        TreeItemType treeItemType = this.lastTreeItemValue.getTreeItemType();
        switch (treeItemType) {
            case ADJUSTMENT: {
                TableView<HomologousFramePositionPair> propertyPane;
                node = propertyPane = tabType == TabType.INTERPOLATION ? this.interpolationPaneBuilder.getNode() : this.restrictionPaneBuilder.getNode();
                break;
            }
            case OBSERVED_POSITIONS: {
                TableView<HomologousFramePositionPair> homologousFramePositionPairTableView = this.homologousFramePositionPairTableBuilder.getTable();
                this.setTableColumnView(tabType, homologousFramePositionPairTableView);
                node = homologousFramePositionPairTableView;
                break;
            }
            case TRANSFORMATION_PARAMETERS: {
                TableView<UnknownParameter> parameterTableView = this.parameterTableBuilder.getTable();
                this.setTableColumnView(tabType, parameterTableView);
                node = parameterTableView;
                break;
            }
            case TRANSFORMED_POSITIONS: {
                TableView<FramePositionPair> framePositionPairTableBuilder = this.framePositionPairTableBuilder.getTable();
                this.setTableColumnView(tabType, framePositionPairTableBuilder);
                node = framePositionPairTableBuilder;
                break;
            }
            case UNSPECIFIC: {
                break;
            }
        }
        return node;
    }

    private void setTableColumnView(TabType tabType, TableView<?> tableView) {
        int columnCount = tableView.getColumns().size();
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            TableColumn column = (TableColumn)tableView.getColumns().get(columnIndex);
            if (column.getUserData() instanceof ColumnType) {
                ColumnType columnType = (ColumnType)((Object)column.getUserData());
                switch (columnType) {
                    case VISIBLE: {
                        column.setVisible(true);
                        break;
                    }
                    case HIDDEN: {
                        column.setVisible(false);
                        break;
                    }
                    case APRIORI_POINT: {
                        column.setVisible(tabType == TabType.APRIORI_SOURCE_SYSTEM_POINTS || tabType == TabType.APRIORI_HOMOLOGOUS_PAIRS);
                        break;
                    }
                    case APOSTERIORI_SOURCE_SYSTEM: {
                        column.setVisible(tabType == TabType.APOSTERIORI_SOURCE_SYSTEM_POINTS);
                        break;
                    }
                    case APOSTERIORI_TARGET_SYSTEM: {
                        column.setVisible(tabType == TabType.APOSTERIORI_TARGET_SYSTEM_POINTS);
                        break;
                    }
                    case APOSTERIORI_POINT: {
                        column.setVisible(tabType == TabType.APOSTERIORI_OUTLIERS);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Error, unsupported column type " + String.valueOf((Object)columnType) + "!");
                    }
                }
            }
            ++columnIndex;
        }
    }

    public void setTreeItemValue(TreeItemValue<?> treeItemValue) {
        if (this.tabPane == null) {
            this.init();
        }
        SingleSelectionModel selectionModel = this.tabPane.getSelectionModel();
        this.lastSelectedTab = this.lastSelectedTab != null ? this.lastSelectedTab : (Tab)selectionModel.getSelectedItem();
        selectionModel.clearSelection();
        this.lastTreeItemValue = treeItemValue;
        if (this.tabPane != null && treeItemValue != null) {
            TabType[] newTabTypes = treeItemValue.getTabTypes();
            if (newTabTypes != null && newTabTypes.length > 0) {
                boolean equalTabOrderAndTypes;
                Tab selectedTab = null;
                ObservableList oldTabList = this.tabPane.getTabs();
                boolean bl = equalTabOrderAndTypes = oldTabList.size() == newTabTypes.length;
                if (equalTabOrderAndTypes) {
                    int idx = 0;
                    while (idx < newTabTypes.length) {
                        Tab tab = (Tab)oldTabList.get(idx);
                        if (tab.getUserData() == null || tab.getUserData() != newTabTypes[idx]) {
                            equalTabOrderAndTypes = false;
                            break;
                        }
                        ++idx;
                    }
                }
                if (!equalTabOrderAndTypes) {
                    ObservableList newTabList = FXCollections.observableArrayList();
                    this.tabPane.getTabs().clear();
                    TabType[] tabTypeArray = newTabTypes;
                    int n = newTabTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TabType tabType = tabTypeArray[n2];
                        if (this.tapMap.containsKey((Object)tabType)) {
                            newTabList.add((Object)((Tab)this.tapMap.get((Object)tabType)));
                            if (this.lastSelectedTab != null && this.lastSelectedTab.getUserData() == tabType) {
                                selectedTab = (Tab)this.tapMap.get((Object)tabType);
                            }
                        }
                        ++n2;
                    }
                    this.tabPane.getTabs().setAll((Collection)newTabList);
                } else {
                    boolean validLastSelectedTabType = false;
                    TabType[] tabTypeArray = newTabTypes;
                    int n = newTabTypes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TabType newType = tabTypeArray[n3];
                        if (this.lastSelectedTab.getUserData() == newType) {
                            validLastSelectedTabType = true;
                            break;
                        }
                        ++n3;
                    }
                    Tab tab = selectedTab = validLastSelectedTabType ? this.lastSelectedTab : null;
                }
                if (selectedTab == null && this.tabPane.getTabs().size() > 0) {
                    selectedTab = (Tab)this.tabPane.getTabs().get(0);
                }
                selectionModel.select((Object)selectedTab);
            } else {
                this.tabPane.getTabs().clear();
                System.out.println(this.getClass().getSimpleName() + " : No known tab types " + String.valueOf(newTabTypes) + " for " + String.valueOf(treeItemValue));
            }
        }
    }

    private class TabSelectionChangeListener
    implements ChangeListener<Tab> {
        private TabSelectionChangeListener() {
        }

        public void changed(ObservableValue<? extends Tab> observable, Tab oldTab, Tab newTab) {
            Tab tab = UITabPaneBuilder.this.lastSelectedTab = newTab == null ? UITabPaneBuilder.this.lastSelectedTab : newTab;
            if (oldTab != null) {
                oldTab.setContent(null);
            }
            if (newTab != null && newTab.getUserData() instanceof TabType) {
                TabType tabType = (TabType)((Object)newTab.getUserData());
                newTab.setContent(UITabPaneBuilder.this.getNode(tabType));
            }
        }
    }
}

