/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.table;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.VarianceComponentType;
import org.applied_geodesy.coordtrans.ui.table.UITableBuilder;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.util.CellValueType;

public class UIVarianceComponentTableBuilder
extends UITableBuilder<VarianceComponent> {
    private static UIVarianceComponentTableBuilder tableBuilder = new UIVarianceComponentTableBuilder();
    private boolean isInitialize = false;

    private UIVarianceComponentTableBuilder() {
    }

    public static UIVarianceComponentTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableColumn<VarianceComponent, VarianceComponentType> varianceComponentTypeColumn = null;
        TableColumn<VarianceComponent, Boolean> booleanColumn = null;
        TableColumn<VarianceComponent, Double> doubleColumn = null;
        TableColumn<VarianceComponent, Integer> integerColumn = null;
        TableView table = this.createTable();
        double columWidth = 85.0;
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.type.label", "Component");
        String tooltipText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.type.tooltip", "Type of estimated variance component");
        CellValueType cellValueType = CellValueType.STRING;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        varianceComponentTypeColumn = this.getColumn(header, VarianceComponent::varianceComponentTypeProperty, UIVarianceComponentTableBuilder.getVarianceComponentTypeCallback(), ColumnType.VISIBLE, columnIndex, false);
        varianceComponentTypeColumn.setMinWidth(150.0);
        varianceComponentTypeColumn.setSortable(false);
        table.getColumns().add(varianceComponentTypeColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.number_of_observations.label", "n");
        tooltipText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.number_of_observations.tooltip", "Number of equations");
        cellValueType = CellValueType.INTEGER;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        integerColumn = this.getColumn(header, VarianceComponent::numberOfObservationsProperty, UIVarianceComponentTableBuilder.getIntegerCallback(), ColumnType.VISIBLE, columnIndex, false);
        integerColumn.setPrefWidth(columWidth);
        integerColumn.setSortable(false);
        table.getColumns().add(integerColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.redundancy.label", "r");
        tooltipText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.redundancy.tooltip", "Redundancy");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, VarianceComponent::redundancyProperty, UIVarianceComponentTableBuilder.getDoubleCallback(cellValueType), ColumnType.VISIBLE, columnIndex, false);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.omega.label", "\u03a9");
        tooltipText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.omega.tooltip", "Squared weigthed residuals");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, VarianceComponent::unitOmegaProperty, UIVarianceComponentTableBuilder.getDoubleCallback(cellValueType), ColumnType.VISIBLE, columnIndex, false);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.variance.label", "1 : \u03c3\u00b2");
        tooltipText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.variance.tooltip", "A-posteriori variance factor w.r.t. a-priori variance");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, VarianceComponent::unitVarianceProperty, UIVarianceComponentTableBuilder.getDoubleCallback(cellValueType), ColumnType.VISIBLE, columnIndex, false);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        final int columnIndexOutlier = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.significant.label", "Significant");
        tooltipText = i18n.getString("UIVarianceComponentTableBuilder.tableheader.significant.tooltip", "Checked, if a-posteriori variance is significant w.r.t. a-priori variance");
        cellValueType = CellValueType.BOOLEAN;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(header, VarianceComponent::significantProperty, UIVarianceComponentTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, false);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<VarianceComponent, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<VarianceComponent, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener(UIVarianceComponentTableBuilder.this, columnIndexOutlier, (VarianceComponent)param.getValue());
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((VarianceComponent)param.getValue()).isSignificant());
                booleanProp.addListener(significantChangeListener);
                return booleanProp;
            }
        });
        booleanColumn.setSortable(false);
        table.getColumns().add(booleanColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    private static Callback<TableColumn<VarianceComponent, VarianceComponentType>, TableCell<VarianceComponent, VarianceComponentType>> getVarianceComponentTypeCallback() {
        return new Callback<TableColumn<VarianceComponent, VarianceComponentType>, TableCell<VarianceComponent, VarianceComponentType>>(){

            public TableCell<VarianceComponent, VarianceComponentType> call(TableColumn<VarianceComponent, VarianceComponentType> cell) {
                TextFieldTableCell tableCell = new TextFieldTableCell((StringConverter)new StringConverter<VarianceComponentType>(){

                    public String toString(VarianceComponentType type) {
                        if (type == null) {
                            return null;
                        }
                        return UIVarianceComponentTableBuilder.getVarianceComponentTypeLabel(type);
                    }

                    public VarianceComponentType fromString(String string) {
                        return VarianceComponentType.valueOf(string);
                    }
                });
                tableCell.setAlignment(Pos.CENTER_LEFT);
                return tableCell;
            }
        };
    }

    public static final String getVarianceComponentTypeLabel(VarianceComponentType type) {
        switch (type) {
            case GLOBAL: {
                return i18n.getString("UIVarianceComponentTableBuilder.type.global.label", "Global adjustment");
            }
            case SOURCE: {
                return i18n.getString("UIVarianceComponentTableBuilder.type.source.label", "Source system");
            }
            case TARGET: {
                return i18n.getString("UIVarianceComponentTableBuilder.type.target.label", "Target system");
            }
        }
        return null;
    }

    @Override
    void setValue(VarianceComponent row, int columnIndex, Object oldValue, Object newValue) {
    }
}

