/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.table;

import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.coordtrans.ui.table.UITableBuilder;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.util.CellValueType;

public class UIQuantileTableBuilder
extends UITableBuilder<TestStatisticParameterSet> {
    private static UIQuantileTableBuilder tableBuilder = new UIQuantileTableBuilder();
    private boolean isInitialize = false;

    private UIQuantileTableBuilder() {
    }

    public static UIQuantileTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        CellValueType cellValueTypeStatistic = CellValueType.STATISTIC;
        CellValueType cellValueTypePercent = CellValueType.PERCENTAGE;
        TableColumn<TestStatisticParameterSet, Double> doubleColumn = null;
        TableView table = this.createTable();
        double columWidth = 85.0;
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIQuantileTableBuilder.tableheader.degree_of_freedom_numerator.label", "d1");
        String tooltipText = i18n.getString("UIQuantileTableBuilder.tableheader.degree_of_freedom_numerator.tooltip", "Numerator degrees of freedom of F distribution");
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticParameterSet::numeratorDofProperty, UIQuantileTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, true);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIQuantileTableBuilder.tableheader.degree_of_freedom_denominator.label", "d2");
        tooltipText = i18n.getString("UIQuantileTableBuilder.tableheader.degree_of_freedom_denominator.tooltip", "Denominator degrees of freedom of F distribution");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticParameterSet::denominatorDofProperty, UIQuantileTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, true);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIQuantileTableBuilder.tableheader.probability_value.label", "\u03b1");
        tooltipText = i18n.getString("UIQuantileTableBuilder.tableheader.probability_value.tooltip", "Probability value (type I-error)");
        header = new ColumnTooltipHeader(cellValueTypePercent, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueTypePercent).getUnit());
        doubleColumn = this.getColumn(header, TestStatisticParameterSet::probabilityValueProperty, UIQuantileTableBuilder.getDoubleCallback(cellValueTypePercent), ColumnType.VISIBLE, columnIndex, true);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIQuantileTableBuilder.tableheader.power_of_test.label", "1 - \u03b2");
        tooltipText = i18n.getString("UIQuantileTableBuilder.tableheader.power_of_test.tooltip", "Power of test (type II-error)");
        header = new ColumnTooltipHeader(cellValueTypePercent, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueTypePercent).getUnit());
        doubleColumn = this.getColumn(header, TestStatisticParameterSet::powerOfTestProperty, UIQuantileTableBuilder.getDoubleCallback(cellValueTypePercent), ColumnType.VISIBLE, columnIndex, true);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIQuantileTableBuilder.tableheader.noncentrality_parameter.label", "\u03bb(\u03b1, \u03b2)");
        tooltipText = i18n.getString("UIQuantileTableBuilder.tableheader.noncentrality_parameter.tooltip", "Noncentrality Parameter");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticParameterSet::noncentralityParameterProperty, UIQuantileTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIQuantileTableBuilder.tableheader.p_value.label", "log(p)");
        tooltipText = i18n.getString("UIQuantileTableBuilder.tableheader.p_value.tooltip", "p-value (logarithmic representation)");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticParameterSet::logarithmicProbabilityValueProperty, UIQuantileTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIQuantileTableBuilder.tableheader.quantile.label", "q");
        tooltipText = i18n.getString("UIQuantileTableBuilder.tableheader.quantile.tooltip", "Quantile of F-distribution");
        header = new ColumnTooltipHeader(cellValueTypeStatistic, labelText, tooltipText);
        doubleColumn = this.getColumn(header, TestStatisticParameterSet::quantileProperty, UIQuantileTableBuilder.getDoubleCallback(cellValueTypeStatistic), ColumnType.VISIBLE, columnIndex, false);
        doubleColumn.setPrefWidth(columWidth);
        doubleColumn.setSortable(false);
        table.getColumns().add(doubleColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    @Override
    void setValue(TestStatisticParameterSet row, int columnIndex, Object oldValue, Object newValue) {
    }
}

