/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.table;

import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.adjustment.transformation.parameter.Parameter;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.coordtrans.ui.table.ParameterDoubleCell;
import org.applied_geodesy.coordtrans.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UITableBuilder;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.DisplayCellFormatType;
import org.applied_geodesy.ui.table.NaturalOrderComparator;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.ObservableUniqueList;

public class UIParameterTableBuilder
extends UIEditableTableBuilder<UnknownParameter>
implements TransformationChangeListener {
    private static UIParameterTableBuilder tableBuilder = new UIParameterTableBuilder();
    private boolean isInitialize = false;
    private ObservableUniqueList<UnknownParameter> unknownTransformationParameters;
    private Predicate<UnknownParameter> visiblePredicate = new Predicate<UnknownParameter>(){

        @Override
        public boolean test(UnknownParameter unknownParameter) {
            return unknownParameter.isVisible();
        }
    };

    private UIParameterTableBuilder() {
    }

    public static UIParameterTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    @Override
    public TableView<UnknownParameter> getTable() {
        return this.getTable(null);
    }

    public TableView<UnknownParameter> getTable(Transformation transformation) {
        if (transformation == null) {
            if (this.unknownTransformationParameters != null) {
                FilteredList filteredFeatureParameters = new FilteredList(this.unknownTransformationParameters, this.visiblePredicate);
                this.table.setItems((ObservableList)filteredFeatureParameters);
            }
        } else {
            this.table.setItems(FXCollections.observableArrayList(transformation.getUnknownParameters()));
        }
        return this.table;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableColumn<UnknownParameter, ParameterType> parameterTypeColumn = null;
        TableColumn<UnknownParameter, Double> doubleColumn = null;
        TableColumn<UnknownParameter, Boolean> booleanColumn = null;
        TableView table = this.createTable();
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIParameterTableBuilder.tableheader.type.label", "Type");
        String tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.type.tooltip", "Type of the model parameter");
        ColumnTooltipHeader header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        parameterTypeColumn = this.getColumn(header, Parameter::parameterTypeProperty, UIParameterTableBuilder.getParameterTypeCallback(), ColumnType.VISIBLE, columnIndex, false);
        parameterTypeColumn.setComparator(new NaturalOrderComparator());
        table.getColumns().add(parameterTypeColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIParameterTableBuilder.tableheader.value.aposteriori.label", "Estimated value");
        tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.value.aposteriori.tooltip", "Estimated value of model parameter");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        doubleColumn = this.getColumn(header, UnknownParameter::valueProperty, UIParameterTableBuilder.getDoubleValueWithUnitCallback(DisplayCellFormatType.NORMAL), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIParameterTableBuilder.tableheader.uncertainty.label", "Uncertainty");
        tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.uncertainty.tooltip", "A-posteriori uncertainty of parameter");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        doubleColumn = this.getColumn(header, UnknownParameter::uncertaintyProperty, UIParameterTableBuilder.getDoubleValueWithUnitCallback(DisplayCellFormatType.UNCERTAINTY), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        final int columnIndexSignificant = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIParameterTableBuilder.tableheader.testdecision.label", "Significant");
        tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.testdecision.tooltip", "Checked, if null-hypothesis is rejected");
        header = new ColumnTooltipHeader(CellValueType.BOOLEAN, labelText, tooltipText);
        booleanColumn = this.getColumn(header, UnknownParameter::significantProperty, UIParameterTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, false);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<UnknownParameter, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<UnknownParameter, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener(UIParameterTableBuilder.this, columnIndexSignificant, (UnknownParameter)param.getValue());
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((UnknownParameter)param.getValue()).isSignificant());
                booleanProp.addListener(significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    private static Callback<TableColumn<UnknownParameter, ParameterType>, TableCell<UnknownParameter, ParameterType>> getParameterTypeCallback() {
        return new Callback<TableColumn<UnknownParameter, ParameterType>, TableCell<UnknownParameter, ParameterType>>(){

            public TableCell<UnknownParameter, ParameterType> call(TableColumn<UnknownParameter, ParameterType> cell) {
                TextFieldTableCell tableCell = new TextFieldTableCell((StringConverter)new StringConverter<ParameterType>(){

                    public String toString(ParameterType parameterType) {
                        return UIParameterTableBuilder.getParameterTypeLabel(parameterType);
                    }

                    public ParameterType fromString(String string) {
                        return ParameterType.valueOf(string);
                    }
                });
                tableCell.setAlignment(Pos.CENTER_LEFT);
                return tableCell;
            }
        };
    }

    private static Callback<TableColumn<UnknownParameter, Double>, TableCell<UnknownParameter, Double>> getDoubleValueWithUnitCallback(final DisplayCellFormatType displayFormatType) {
        return new Callback<TableColumn<UnknownParameter, Double>, TableCell<UnknownParameter, Double>>(){

            public TableCell<UnknownParameter, Double> call(TableColumn<UnknownParameter, Double> cell) {
                return new ParameterDoubleCell(displayFormatType);
            }
        };
    }

    private void setTransformation(Transformation transformation) {
        this.unknownTransformationParameters = transformation == null ? new ObservableUniqueList(0) : transformation.getUnknownParameters();
    }

    @Override
    void setValue(final UnknownParameter unknownParameter, int columnIndex, Object oldValue, Object newValue) {
        boolean valid = !(oldValue != null && !oldValue.toString().trim().isEmpty() || newValue != null && !newValue.toString().trim().isEmpty());
        switch (columnIndex) {
            case 0: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    unknownParameter.setName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                unknownParameter.setName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 4: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    unknownParameter.setDescription(newValue.toString().trim());
                    valid = true;
                    break;
                }
                unknownParameter.setDescription(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
                valid = false;
            }
        }
        if (!valid) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIParameterTableBuilder.this.table.refresh();
                    UIParameterTableBuilder.this.table.requestFocus();
                    UIParameterTableBuilder.this.table.getSelectionModel().clearSelection();
                    UIParameterTableBuilder.this.table.getSelectionModel().select((Object)unknownParameter);
                }
            });
        }
    }

    public static String getParameterTypeLabel(ParameterType parameterType) {
        if (parameterType == null) {
            return null;
        }
        switch (parameterType) {
            case SHIFT_X: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.shift.x", "Shift tx");
            }
            case SHIFT_Y: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.shift.y", "Shift ty");
            }
            case SHIFT_Z: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.shift.z", "Shift tz");
            }
            case QUATERNION_Q0: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.quaternion.q0", "Quaternion q0");
            }
            case QUATERNION_Q1: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.quaternion.q1", "Quaternion q1");
            }
            case QUATERNION_Q2: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.quaternion.q2", "Quaternion q2");
            }
            case QUATERNION_Q3: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.quaternion.q3", "Quaternion q3");
            }
            case VECTOR_LENGTH: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.vector.norm", "Norm of vector \u2016n\u2016");
            }
            case SCALE_X: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.scale.x", "Scale mx");
            }
            case SCALE_Y: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.scale.y", "Scale my");
            }
            case SCALE_Z: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.scale.z", "Scale mz");
            }
            case SHEAR_X: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.shear.x", "Shear sx");
            }
            case SHEAR_Y: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.shear.y", "Shear sy");
            }
            case SHEAR_Z: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.shear.z", "Shear sz");
            }
            case EULER_ANGLE_X: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.angle.x", "Euler angle rx");
            }
            case EULER_ANGLE_Y: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.angle.y", "Euler angle ry");
            }
            case EULER_ANGLE_Z: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.angle.z", "Euler angle rz");
            }
            case AUXILIARY_ELEMENT_11: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.auxiliary.element11", "Auxiliary quantity e11");
            }
            case AUXILIARY_ELEMENT_12: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.auxiliary.element12", "Auxiliary quantity e12");
            }
            case AUXILIARY_ELEMENT_13: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.auxiliary.element13", "Auxiliary quantity e13");
            }
            case AUXILIARY_ELEMENT_21: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.auxiliary.element21", "Auxiliary quantity e21");
            }
            case AUXILIARY_ELEMENT_22: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.auxiliary.element22", "Auxiliary quantity e22");
            }
            case AUXILIARY_ELEMENT_23: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.auxiliary.element23", "Auxiliary quantity e23");
            }
            case AUXILIARY_ELEMENT_33: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.auxiliary.element33", "Auxiliary quantity e33");
            }
            case CONSTANT: {
                return i18n.getString("UIParameterTableBuilder.parameter.type.constant", "Constant");
            }
        }
        return null;
    }

    @Override
    public void transformationChanged(TransformationEvent evt) {
        if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED) {
            this.setTransformation(evt.getSource());
        } else if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED) {
            this.setTransformation(null);
        }
    }
}

