/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.table;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePositionPair;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.coordtrans.ui.dialog.MatrixDialog;
import org.applied_geodesy.coordtrans.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UITableBuilder;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.ui.table.AbsoluteValueComparator;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderComparator;
import org.applied_geodesy.util.CellValueType;

public class UIHomologousFramePositionPairTableBuilder
extends UIEditableTableBuilder<HomologousFramePositionPair>
implements TransformationChangeListener {
    private TransformationType transformationType = TransformationType.SPATIAL;
    private Map<TransformationType, TableView<HomologousFramePositionPair>> tables = new HashMap<TransformationType, TableView<HomologousFramePositionPair>>(2);
    private static UIHomologousFramePositionPairTableBuilder tableBuilder = new UIHomologousFramePositionPairTableBuilder();

    private UIHomologousFramePositionPairTableBuilder() {
    }

    public static UIHomologousFramePositionPairTableBuilder getInstance() {
        return tableBuilder;
    }

    public void setTransformationType(TransformationType transformationType) {
        if (this.transformationType != transformationType) {
            this.getTableModel(this.table).clear();
            this.table.refresh();
            this.transformationType = transformationType;
        }
    }

    @Override
    public TableView<HomologousFramePositionPair> getTable() {
        this.init();
        return this.table;
    }

    private void init() {
        int columnIndex;
        if (this.tables.containsKey((Object)this.transformationType)) {
            this.table = this.tables.get((Object)this.transformationType);
            return;
        }
        TableColumn<HomologousFramePositionPair, Boolean> booleanColumn = null;
        TableColumn<HomologousFramePositionPair, String> stringColumn = null;
        TableColumn<HomologousFramePositionPair, Double> doubleColumn = null;
        TableColumn<HomologousFramePositionPair, Boolean> matrixColumn = null;
        TableView table = this.createTable();
        final int columnIndexEnable = columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.enable.label", "Enable");
        String tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.enable.tooltip", "State of the point");
        CellValueType cellValueType = CellValueType.BOOLEAN;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(header, PositionPair::enableProperty, UIHomologousFramePositionPairTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<HomologousFramePositionPair, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<HomologousFramePositionPair, Boolean> param) {
                UITableBuilder.TableCellChangeListener enableChangeListener = new UITableBuilder.TableCellChangeListener(UIHomologousFramePositionPairTableBuilder.this, columnIndexEnable, (HomologousFramePositionPair)param.getValue());
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((HomologousFramePositionPair)param.getValue()).isEnable());
                booleanProp.addListener(enableChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.station.name.label", "Point-Id");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.station.name.tooltip", "Id of the point");
        cellValueType = CellValueType.STRING;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(header, PositionPair::nameProperty, UIHomologousFramePositionPairTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true);
        stringColumn.setComparator(new NaturalOrderComparator());
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.x0.label", "x0");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.x0.tooltip", "A-priori x-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceX0Property, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.y0.label", "y0");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.y0.tooltip", "A-priori y-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceY0Property, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.z0.label", "z0");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.z0.tooltip", "A-priori z-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceZ0Property, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.x0.label", "X0");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.x0.tooltip", "A-priori x-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetX0Property, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.y0.label", "Y0");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.y0.tooltip", "A-priori y-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetY0Property, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.z0.label", "Z0");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.z0.tooltip", "A-priori z-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetZ0Property, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.covariance.label", "Uncertainties");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.covariance.tooltip", "A-priori variance-covariance matrix");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        matrixColumn = this.getColumn(header, DispersionablePositionPair::containsDispersionablePositionProperty, UIHomologousFramePositionPairTableBuilder.getMatrixCallback(), ColumnType.APRIORI_POINT, columnIndex, true);
        table.getColumns().add(matrixColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.x.label", "x");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.x.tooltip", "A-posteriori x-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::sourceXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.y.label", "y");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.y.tooltip", "A-posteriori y-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::sourceYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.z.label", "z");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.source.z.tooltip", "A-posteriori z-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::sourceZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.x.label", "\u03c3x");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.x.tooltip", "A-posteriori uncertainty of x-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceUncertaintyXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.y.label", "\u03c3y");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.y.tooltip", "A-posteriori uncertainty of y-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceUncertaintyYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.z.label", "\u03c3z");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.z.tooltip", "A-posteriori uncertainty of z-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceUncertaintyZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.x.label", "rx");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.x.tooltip", "Redundancy of x-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceRedundancyXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.y.label", "ry");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.y.tooltip", "Redundancy of y-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceRedundancyYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.z.label", "rz");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.z.tooltip", "Redundancy of z-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceRedundancyZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.x.label", "\u03b5x");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.x.tooltip", "Residual of x-component, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceResidualXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.y.label", "\u03b5y");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.y.tooltip", "Residual of y-component, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceResidualYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.z.label", "\u03b5z");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.z.tooltip", "Residual of z-component, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::sourceResidualZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_SOURCE_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.x.label", "X");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.x.tooltip", "A-posteriori x-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::targetXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.y.label", "Y");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.y.tooltip", "A-posteriori y-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::targetYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.z.label", "Z");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.target.z.tooltip", "A-posteriori z-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::targetZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.x.label", "\u03c3x");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.x.tooltip", "A-posteriori uncertainty of x-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetUncertaintyXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.y.label", "\u03c3y");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.y.tooltip", "A-posteriori uncertainty of y-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetUncertaintyYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.z.label", "\u03c3z");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.uncertainty.z.tooltip", "A-posteriori uncertainty of z-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetUncertaintyZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.x.label", "rx");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.x.tooltip", "Redundancy of x-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetRedundancyXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.y.label", "ry");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.y.tooltip", "Redundancy of y-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetRedundancyYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.z.label", "rz");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.redundancy.z.tooltip", "Redundancy of z-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetRedundancyZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.x.label", "\u03b5x");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.x.tooltip", "Residual of x-component");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetResidualXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.y.label", "\u03b5y");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.y.tooltip", "Residual of y-component");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetResidualYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.z.label", "\u03b5z");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.residual.z.tooltip", "Residual of z-component");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::targetResidualZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.grosserror.x.label", "\u2207x");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.grosserror.x.tooltip", "Gross-error in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::grossErrorXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.grosserror.y.label", "\u2207y");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.grosserror.y.tooltip", "Gross-error in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::grossErrorYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.grosserror.z.label", "\u2207z");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.grosserror.z.tooltip", "Gross-error in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::grossErrorZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.maximumtolerablebias.x.label", "\u2207x(1)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.maximumtolerablebias.x.tooltip", "Maximum tolerable bias in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::maximumTolerableBiasXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.maximumtolerablebias.y.label", "\u2207y(1)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.maximumtolerablebias.y.tooltip", "Maximum tolerable bias in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::maximumTolerableBiasYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.maximumtolerablebias.z.label", "\u2207z(1)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.maximumtolerablebias.z.tooltip", "Maximum tolerable bias in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::maximumTolerableBiasZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.minimaldetectablebias.x.label", "\u2207x(\u03bb)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.minimaldetectablebias.x.tooltip", "Minimal detectable bias in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::minimalDetectableBiasXProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.minimaldetectablebias.y.label", "\u2207y(\u03bb)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.minimaldetectablebias.y.tooltip", "Minimal detectable bias in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::minimalDetectableBiasYProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.minimaldetectablebias.z.label", "\u2207z(\u03bb)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.minimaldetectablebias.z.tooltip", "Minimal detectable bias in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::minimalDetectableBiasZProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.pvalue.apriori.label", "log(Pprio)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.pvalue.apriori.tooltip", "A-priori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::pValueAprioriProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.pvalue.aposteriori.label", "log(Ppost)");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.pvalue.aposteriori.tooltip", "A-posteriori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::pValueAposterioriProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.teststatistic.apriori.label", "Tprio");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.teststatistic.apriori.tooltip", "A-priori test statistic");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::testStatisticAprioriProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.teststatistic.aposteriori.label", "Tpost");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.teststatistic.aposteriori.tooltip", "A-posteriori test statistic");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, HomologousFramePositionPair::testStatisticAposterioriProperty, UIHomologousFramePositionPairTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        final int columnIndexSignificant = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.testdecision.label", "Significant");
        tooltipText = i18n.getString("UIHomologousFramePositionPairTableBuilder.tableheader.testdecision.tooltip", "Checked, if null-hypothesis is rejected");
        cellValueType = CellValueType.BOOLEAN;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(header, HomologousFramePositionPair::significantProperty, UIHomologousFramePositionPairTableBuilder.getBooleanCallback(), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<HomologousFramePositionPair, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<HomologousFramePositionPair, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener(UIHomologousFramePositionPairTableBuilder.this, columnIndexSignificant, (HomologousFramePositionPair)param.getValue());
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((HomologousFramePositionPair)param.getValue()).isSignificant());
                booleanProp.addListener(significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        this.tables.put(this.transformationType, table);
        this.table = table;
    }

    @Override
    void setValue(final HomologousFramePositionPair framePositionPair, int columnIndex, Object oldValue, Object newValue) {
        switch (columnIndex) {
            case 0: {
                framePositionPair.setEnable(newValue != null && newValue instanceof Boolean && (Boolean)newValue != false);
                break;
            }
            case 1: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    framePositionPair.setName(newValue.toString().trim());
                    break;
                }
                framePositionPair.setName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 2: {
                if (newValue != null && newValue instanceof Double) {
                    ((HomologousFramePosition)framePositionPair.getSourceSystemPosition()).setX0((Double)newValue);
                    break;
                }
                ((HomologousFramePosition)framePositionPair.getSourceSystemPosition()).setX0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 3: {
                if (newValue != null && newValue instanceof Double) {
                    ((HomologousFramePosition)framePositionPair.getSourceSystemPosition()).setY0((Double)newValue);
                    break;
                }
                ((HomologousFramePosition)framePositionPair.getSourceSystemPosition()).setY0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 4: {
                if (newValue != null && newValue instanceof Double) {
                    ((HomologousFramePosition)framePositionPair.getSourceSystemPosition()).setZ0((Double)newValue);
                    break;
                }
                ((HomologousFramePosition)framePositionPair.getSourceSystemPosition()).setZ0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 5: {
                if (newValue != null && newValue instanceof Double) {
                    ((HomologousFramePosition)framePositionPair.getTargetSystemPosition()).setX0((Double)newValue);
                    break;
                }
                ((HomologousFramePosition)framePositionPair.getTargetSystemPosition()).setX0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 6: {
                if (newValue != null && newValue instanceof Double) {
                    ((HomologousFramePosition)framePositionPair.getTargetSystemPosition()).setY0((Double)newValue);
                    break;
                }
                ((HomologousFramePosition)framePositionPair.getTargetSystemPosition()).setY0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 7: {
                if (newValue != null && newValue instanceof Double) {
                    ((HomologousFramePosition)framePositionPair.getTargetSystemPosition()).setZ0((Double)newValue);
                    break;
                }
                ((HomologousFramePosition)framePositionPair.getTargetSystemPosition()).setZ0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UIHomologousFramePositionPairTableBuilder.this.table.refresh();
                UIHomologousFramePositionPairTableBuilder.this.table.requestFocus();
                UIHomologousFramePositionPairTableBuilder.this.table.getSelectionModel().clearSelection();
                UIHomologousFramePositionPairTableBuilder.this.table.getSelectionModel().select((Object)framePositionPair);
                UIHomologousFramePositionPairTableBuilder.this.table.sort();
            }
        });
    }

    private void setPositionsToTransformation(Transformation transformation) {
        for (HomologousFramePositionPair positionPair : this.table.getItems()) {
            positionPair.reset();
        }
        if (transformation != null) {
            transformation.getTransformationEquations().getHomologousFramePositionPairs().setAll((Collection)this.table.getItems());
        }
    }

    @Override
    public void transformationChanged(TransformationEvent evt) {
        if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED) {
            this.setPositionsToTransformation(evt.getSource());
        } else if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED) {
            this.setPositionsToTransformation(null);
        }
    }

    private static Callback<TableColumn<HomologousFramePositionPair, Boolean>, TableCell<HomologousFramePositionPair, Boolean>> getMatrixCallback() {
        return new Callback<TableColumn<HomologousFramePositionPair, Boolean>, TableCell<HomologousFramePositionPair, Boolean>>(){

            public TableCell<HomologousFramePositionPair, Boolean> call(TableColumn<HomologousFramePositionPair, Boolean> cell) {
                TableCell<HomologousFramePositionPair, Boolean> tableCell = new TableCell<HomologousFramePositionPair, Boolean>(){
                    final Button button = UIHomologousFramePositionPairTableBuilder.getDispersionButton();

                    public void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.button.getTooltip().setText(String.format(Locale.ENGLISH, i18n.getString("UIHomologousFramePositionPairTableBuilder.dispersion.button.tooltip", "Show dispersion of point %s"), this.getTableRow().getItem() == null || ((HomologousFramePositionPair)this.getTableRow().getItem()).getName() == null ? "" : ((HomologousFramePositionPair)this.getTableRow().getItem()).getName()));
                            this.button.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    this.getTableView().getSelectionModel().clearAndSelect(this.getTableRow().getIndex());
                                }
                            });
                            this.button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    TableView.TableViewSelectionModel tableSelectionModel = this.getTableView().getSelectionModel();
                                    tableSelectionModel.clearAndSelect(this.getTableRow().getIndex());
                                    MatrixDialog.showAndWait(tableSelectionModel);
                                }
                            });
                            this.setGraphic((Node)this.button);
                            this.setText(null);
                        }
                    }
                };
                tableCell.setAlignment(Pos.CENTER);
                return tableCell;
            }
        };
    }

    private static Button getDispersionButton() {
        Button button = UiUtil.createButton(i18n.getString("UIHomologousFramePositionPairTableBuilder.dispersion.button.label", "Dispersion"), "");
        button.setMaxWidth(Double.NEGATIVE_INFINITY);
        return button;
    }
}

