/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.table;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.adjustment.transformation.point.DispersionablePositionPair;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.ObservedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.PositionPair;
import org.applied_geodesy.coordtrans.ui.dialog.MatrixDialog;
import org.applied_geodesy.coordtrans.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UITableBuilder;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.ui.table.AbsoluteValueComparator;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderComparator;
import org.applied_geodesy.util.CellValueType;

public class UIFramePositionPairTableBuilder
extends UIEditableTableBuilder<FramePositionPair>
implements TransformationChangeListener {
    private TransformationType transformationType = TransformationType.SPATIAL;
    private Map<TransformationType, TableView<FramePositionPair>> tables = new HashMap<TransformationType, TableView<FramePositionPair>>(2);
    private static UIFramePositionPairTableBuilder tableBuilder = new UIFramePositionPairTableBuilder();

    private UIFramePositionPairTableBuilder() {
    }

    public static UIFramePositionPairTableBuilder getInstance() {
        return tableBuilder;
    }

    public void setTransformationType(TransformationType transformationType) {
        if (this.transformationType != transformationType) {
            this.getTableModel(this.table).clear();
            this.table.refresh();
            this.transformationType = transformationType;
        }
    }

    @Override
    public TableView<FramePositionPair> getTable() {
        this.init();
        return this.table;
    }

    private void init() {
        int columnIndex;
        if (this.tables.containsKey((Object)this.transformationType)) {
            this.table = this.tables.get((Object)this.transformationType);
            return;
        }
        TableColumn<FramePositionPair, Boolean> booleanColumn = null;
        TableColumn<FramePositionPair, String> stringColumn = null;
        TableColumn<FramePositionPair, Double> doubleColumn = null;
        TableColumn<FramePositionPair, Boolean> matrixColumn = null;
        TableView table = this.createTable();
        final int columnIndexEnable = columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.enable.label", "Enable");
        String tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.enable.tooltip", "State of the point");
        CellValueType cellValueType = CellValueType.BOOLEAN;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(header, PositionPair::enableProperty, UIFramePositionPairTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FramePositionPair, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<FramePositionPair, Boolean> param) {
                UITableBuilder.TableCellChangeListener enableChangeListener = new UITableBuilder.TableCellChangeListener(UIFramePositionPairTableBuilder.this, columnIndexEnable, (FramePositionPair)param.getValue());
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((FramePositionPair)param.getValue()).isEnable());
                booleanProp.addListener(enableChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.station.name.label", "Point-Id");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.station.name.tooltip", "Id of the point");
        cellValueType = CellValueType.STRING;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(header, PositionPair::nameProperty, UIFramePositionPairTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true);
        stringColumn.setComparator(new NaturalOrderComparator());
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.source.x0.label", "x0");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.source.x0.tooltip", "A-priori x-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::sourceXProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.source.y0.label", "y0");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.source.y0.tooltip", "A-priori y-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::sourceYProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.source.z0.label", "z0");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.source.z0.tooltip", "A-priori z-component of the point in source system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::sourceZProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.covariance.label", "Uncertainties");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.covariance.tooltip", "A-priori variance-covariance matrix");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        matrixColumn = this.getColumn(header, DispersionablePositionPair::containsDispersionablePositionProperty, UIFramePositionPairTableBuilder.getMatrixCallback(), ColumnType.APRIORI_POINT, columnIndex, true);
        table.getColumns().add(matrixColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.target.x.label", "X");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.target.x.tooltip", "A-posteriori x-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::targetXProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.target.y.label", "Y");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.target.y.tooltip", "A-posteriori y-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::targetYProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.target.z.label", "Z");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.target.z.tooltip", "A-posteriori z-component of the point in target system");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, PositionPair::targetZProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.uncertainty.x.label", "\u03c3x");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.uncertainty.x.tooltip", "A-posteriori uncertainty of x-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FramePositionPair::targetUncertaintyXProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.uncertainty.y.label", "\u03c3y");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.uncertainty.y.tooltip", "A-posteriori uncertainty of y-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FramePositionPair::targetUncertaintyYProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.uncertainty.z.label", "\u03c3z");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.uncertainty.z.tooltip", "A-posteriori uncertainty of z-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FramePositionPair::targetUncertaintyZProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.residualgap.x.label", "\u03b4x");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.residualgap.x.tooltip", "Residual gap of x-component applied by selected interpolation approach");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FramePositionPair::targetResidualXProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.residualgap.y.label", "\u03b4y");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.residualgap.y.tooltip", "Residual gap of y-component applied by selected interpolation approach");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FramePositionPair::targetResidualYProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.HEIGHT ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.residualgap.z.label", "\u03b4z");
        tooltipText = i18n.getString("UIFramePositionPairTableBuilder.tableheader.residualgap.z.tooltip", "Residual gap of z-component applied by selected interpolation approach");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FramePositionPair::targetResidualZProperty, UIFramePositionPairTableBuilder.getDoubleCallback(cellValueType), this.transformationType != TransformationType.PLANAR ? ColumnType.APOSTERIORI_TARGET_SYSTEM : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        this.tables.put(this.transformationType, table);
        this.table = table;
    }

    @Override
    void setValue(final FramePositionPair framePositionPair, int columnIndex, Object oldValue, Object newValue) {
        boolean valid = !(oldValue != null && !oldValue.toString().trim().isEmpty() || newValue != null && !newValue.toString().trim().isEmpty());
        switch (columnIndex) {
            case 0: {
                framePositionPair.setEnable(newValue != null && newValue instanceof Boolean && (Boolean)newValue != false);
                valid = true;
                break;
            }
            case 1: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    framePositionPair.setName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                framePositionPair.setName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 2: {
                if (newValue != null && newValue instanceof Double) {
                    ((ObservedFramePosition)framePositionPair.getSourceSystemPosition()).setX((Double)newValue);
                    valid = true;
                    break;
                }
                ((ObservedFramePosition)framePositionPair.getSourceSystemPosition()).setX(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 3: {
                if (newValue != null && newValue instanceof Double) {
                    ((ObservedFramePosition)framePositionPair.getSourceSystemPosition()).setY((Double)newValue);
                    valid = true;
                    break;
                }
                ((ObservedFramePosition)framePositionPair.getSourceSystemPosition()).setY(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 4: {
                if (newValue != null && newValue instanceof Double) {
                    ((ObservedFramePosition)framePositionPair.getSourceSystemPosition()).setZ((Double)newValue);
                    valid = true;
                    break;
                }
                ((ObservedFramePosition)framePositionPair.getSourceSystemPosition()).setZ(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
                valid = false;
            }
        }
        if (!valid) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIFramePositionPairTableBuilder.this.table.refresh();
                    UIFramePositionPairTableBuilder.this.table.requestFocus();
                    UIFramePositionPairTableBuilder.this.table.getSelectionModel().clearSelection();
                    UIFramePositionPairTableBuilder.this.table.getSelectionModel().select((Object)framePositionPair);
                }
            });
        }
    }

    private void setPositionsToTransformation(Transformation transformation) {
        for (FramePositionPair positionPair : this.table.getItems()) {
            positionPair.reset();
        }
        if (transformation != null) {
            transformation.getFramePositionPairs().setAll((Collection)this.table.getItems());
        }
    }

    @Override
    public void transformationChanged(TransformationEvent evt) {
        if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED) {
            this.setPositionsToTransformation(evt.getSource());
        } else if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED) {
            this.setPositionsToTransformation(null);
        }
    }

    private static Callback<TableColumn<FramePositionPair, Boolean>, TableCell<FramePositionPair, Boolean>> getMatrixCallback() {
        return new Callback<TableColumn<FramePositionPair, Boolean>, TableCell<FramePositionPair, Boolean>>(){

            public TableCell<FramePositionPair, Boolean> call(TableColumn<FramePositionPair, Boolean> cell) {
                TableCell<FramePositionPair, Boolean> tableCell = new TableCell<FramePositionPair, Boolean>(){
                    final Button button = UIFramePositionPairTableBuilder.getDispersionButton();

                    public void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.button.getTooltip().setText(String.format(Locale.ENGLISH, i18n.getString("UIFramePositionPairTableBuilder.dispersion.button.tooltip", "Show dispersion of point %s"), this.getTableRow().getItem() == null || ((FramePositionPair)this.getTableRow().getItem()).getName() == null ? "" : ((FramePositionPair)this.getTableRow().getItem()).getName()));
                            this.button.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    this.getTableView().getSelectionModel().clearAndSelect(this.getTableRow().getIndex());
                                }
                            });
                            this.button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    TableView.TableViewSelectionModel tableSelectionModel = this.getTableView().getSelectionModel();
                                    tableSelectionModel.clearAndSelect(this.getTableRow().getIndex());
                                    MatrixDialog.showAndWait(tableSelectionModel);
                                }
                            });
                            this.setGraphic((Node)this.button);
                            this.setText(null);
                        }
                    }
                };
                tableCell.setAlignment(Pos.CENTER);
                return tableCell;
            }
        };
    }

    private static Button getDispersionButton() {
        Button button = UiUtil.createButton(i18n.getString("UIFramePositionPairTableBuilder.dispersion.button.label", "Dispersion"), "");
        button.setMaxWidth(Double.NEGATIVE_INFINITY);
        return button;
    }
}

