/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.table;

import javafx.geometry.Pos;
import javafx.scene.control.TableRow;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.ui.table.DisplayCellFormatType;
import org.applied_geodesy.ui.table.EditableCell;
import org.applied_geodesy.ui.table.EditableDoubleCellConverter;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

class ParameterDoubleCell
extends EditableCell<UnknownParameter, Double>
implements FormatterChangedListener {
    private DisplayCellFormatType displayFormatType;
    private EditableDoubleCellConverter editableDoubleCellConverter;
    private FormatterOptions options = FormatterOptions.getInstance();

    ParameterDoubleCell(DisplayCellFormatType displayFormatType) {
        super(new EditableDoubleCellConverter(CellValueType.LENGTH, true));
        this.editableDoubleCellConverter = (EditableDoubleCellConverter)this.getEditableCellConverter();
        this.displayFormatType = displayFormatType;
        this.setAlignment(Pos.CENTER_RIGHT);
        this.options.addFormatterChangedListener(this);
    }

    protected void updateItem(Double value, boolean empty) {
        int currentIndex = this.indexProperty().getValue();
        if (!empty && currentIndex >= 0 && currentIndex < this.getTableView().getItems().size()) {
            UnknownParameter paramRow = (UnknownParameter)this.getTableView().getItems().get(currentIndex);
            this.setCellValueTypeOfUnknownParameter(paramRow);
        }
        super.updateItem((Object)value, empty);
    }

    private void setCellValueTypeOfUnknownParameter(UnknownParameter paramRow) {
        if (paramRow != null && paramRow.getParameterType() != null) {
            switch (paramRow.getParameterType()) {
                case SHIFT_X: 
                case SHIFT_Y: 
                case SHIFT_Z: {
                    if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.LENGTH);
                        break;
                    }
                    if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.LENGTH_UNCERTAINTY);
                        break;
                    }
                    if (this.displayFormatType != DisplayCellFormatType.RESIDUAL) break;
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.LENGTH_RESIDUAL);
                    break;
                }
                case QUATERNION_Q0: 
                case QUATERNION_Q1: 
                case QUATERNION_Q2: 
                case QUATERNION_Q3: 
                case VECTOR_LENGTH: {
                    if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.VECTOR);
                        break;
                    }
                    if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.VECTOR_UNCERTAINTY);
                        break;
                    }
                    if (this.displayFormatType != DisplayCellFormatType.RESIDUAL) break;
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.VECTOR_RESIDUAL);
                    break;
                }
                case SHEAR_X: 
                case SHEAR_Y: 
                case SHEAR_Z: 
                case EULER_ANGLE_X: 
                case EULER_ANGLE_Y: 
                case EULER_ANGLE_Z: {
                    if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.ANGLE);
                        break;
                    }
                    if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.ANGLE_UNCERTAINTY);
                        break;
                    }
                    if (this.displayFormatType != DisplayCellFormatType.RESIDUAL) break;
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.ANGLE_RESIDUAL);
                    break;
                }
                case SCALE_X: 
                case SCALE_Y: 
                case SCALE_Z: {
                    if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.SCALE);
                        break;
                    }
                    if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.SCALE_UNCERTAINTY);
                        break;
                    }
                    if (this.displayFormatType != DisplayCellFormatType.RESIDUAL) break;
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.SCALE_RESIDUAL);
                    break;
                }
                case AUXILIARY_ELEMENT_11: 
                case AUXILIARY_ELEMENT_12: 
                case AUXILIARY_ELEMENT_13: 
                case AUXILIARY_ELEMENT_21: 
                case AUXILIARY_ELEMENT_22: 
                case AUXILIARY_ELEMENT_23: 
                case AUXILIARY_ELEMENT_33: 
                case CONSTANT: {
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.DOUBLE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error, unknown type of parameter " + String.valueOf((Object)paramRow.getParameterType()));
                }
            }
        }
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        TableRow tableRow = this.getTableRow();
        if (tableRow == null || tableRow.isEmpty() || this.getTableRow().getItem() == null) {
            return;
        }
        UnknownParameter paramRow = (UnknownParameter)this.getTableRow().getItem();
        this.setCellValueTypeOfUnknownParameter(paramRow);
    }
}

