/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.pane;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.applied_geodesy.adjustment.transformation.ParameterRestrictionType;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;

public class UIRestrictionPaneBuilder
implements TransformationChangeListener {
    private static UIRestrictionPaneBuilder restrictionPaneBuilder = new UIRestrictionPaneBuilder();
    private Transformation transformation = null;
    private I18N i18n = I18N.getInstance();
    private Node restrictionNode = null;
    private Map<ParameterRestrictionType, CheckBox> parameterRestrictionCheckboxes = new HashMap<ParameterRestrictionType, CheckBox>();
    private TransformationType lastTransformationType = null;
    private MenuBar transformationMenuBar = new MenuBar();

    private UIRestrictionPaneBuilder() {
        this.init();
    }

    public static UIRestrictionPaneBuilder getInstance() {
        return restrictionPaneBuilder;
    }

    private void init() {
        if (this.restrictionNode != null) {
            return;
        }
        this.restrictionNode = this.createPane();
        this.setDisable();
    }

    public Node getNode() {
        return this.restrictionNode;
    }

    private Node createPane() {
        Node parameterTitledPane = this.createParameterRestrictionPane();
        Node identScalePane = this.createIdentScalePane();
        GridPane gridPane = UiUtil.createGridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(20.0);
        gridPane.setPadding(new Insets(20.0, 15.0, 20.0, 15.0));
        gridPane.setAlignment(Pos.BASELINE_CENTER);
        Region leftSpacer = new Region();
        leftSpacer.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        leftSpacer.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Region rightSpacer = new Region();
        rightSpacer.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        rightSpacer.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        GridPane.setHgrow((Node)leftSpacer, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)rightSpacer, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)parameterTitledPane, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)identScalePane, (Priority)Priority.SOMETIMES);
        int row = 0;
        int col = 0;
        gridPane.add((Node)leftSpacer, col++, row, 1, 1);
        gridPane.add(parameterTitledPane, col++, row, 1, 1);
        gridPane.add((Node)rightSpacer, col++, row++, 1, 1);
        col = 1;
        gridPane.add(identScalePane, col++, row++, 1, 1);
        ScrollPane scrollPane = new ScrollPane((Node)gridPane);
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        return scrollPane;
    }

    private Node createParameterRestrictionPane() {
        TransformationPropertyMenuEventHandler transformationPropertyEventHandler = new TransformationPropertyMenuEventHandler();
        CheckBox shiftXCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.x.label", "Shift tx"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.x.tooltip", "Checked, if x-shift is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SHIFT_X, this.parameterRestrictionCheckboxes);
        CheckBox shiftYCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.y.label", "Shift ty"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.y.tooltip", "Checked, if y-shift is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SHIFT_Y, this.parameterRestrictionCheckboxes);
        CheckBox shiftZCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.z.label", "Shift tz"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.z.tooltip", "Checked, if z-shift is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SHIFT_Z, this.parameterRestrictionCheckboxes);
        CheckBox scaleXCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.x.label", "Scale mx"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.x.tooltip", "Checked, if x-scale is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SCALE_X, this.parameterRestrictionCheckboxes);
        CheckBox scaleYCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.y.label", "Scale my"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.y.tooltip", "Checked, if y-scale is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SCALE_Y, this.parameterRestrictionCheckboxes);
        CheckBox scaleZCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.z.label", "Scale mz"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.z.tooltip", "Checked, if z-scale is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SCALE_Z, this.parameterRestrictionCheckboxes);
        CheckBox shearXCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.x.label", "Shear sx"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.x.tooltip", "Checked, if x-shear is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SHEAR_X, this.parameterRestrictionCheckboxes);
        CheckBox shearYCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.y.label", "Shear sy"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.y.tooltip", "Checked, if y-shear is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SHEAR_Y, this.parameterRestrictionCheckboxes);
        CheckBox shearZCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.z.label", "Shear sz"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.z.tooltip", "Checked, if z-shear is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_SHEAR_Z, this.parameterRestrictionCheckboxes);
        CheckBox rotationXCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.x.label", "Rotation rx"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.x.tooltip", "Checked, if x-rotation is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_ROTATION_X, this.parameterRestrictionCheckboxes);
        CheckBox rotationYCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.y.label", "Rotation ry"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.y.tooltip", "Checked, if y-rotation is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_ROTATION_Y, this.parameterRestrictionCheckboxes);
        CheckBox rotationZCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.z.label", "Rotation rz"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.z.tooltip", "Checked, if z-rotation is an unknown parameter to be estimated"), ParameterRestrictionType.FIXED_ROTATION_Z, this.parameterRestrictionCheckboxes);
        Region spacer = new Region();
        spacer.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        spacer.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox shiftNode = new HBox(50.0);
        shiftNode.getChildren().setAll((Object[])new Node[]{shiftXCheckBox, shiftYCheckBox, shiftZCheckBox});
        TitledPane shiftPane = UiUtil.createTitledPane(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.title", "Shift parameters"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shift.tooltip", "Select shift parameters to be estimated"), (Node)shiftNode);
        shiftPane.setCollapsible(false);
        HBox scaleNode = new HBox(50.0);
        scaleNode.getChildren().setAll((Object[])new Node[]{scaleXCheckBox, scaleYCheckBox, scaleZCheckBox});
        TitledPane scalePane = UiUtil.createTitledPane(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.title", "Scale parameters"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.tooltip", "Select scale parameters to be estimated"), (Node)scaleNode);
        scalePane.setCollapsible(false);
        HBox shearNode = new HBox(50.0);
        shearNode.getChildren().setAll((Object[])new Node[]{shearXCheckBox, shearYCheckBox, shearZCheckBox});
        TitledPane shearPane = UiUtil.createTitledPane(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.title", "Shear parameters"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.shear.tooltip", "Select shear parameters to be estimated"), (Node)shearNode);
        shearPane.setCollapsible(false);
        HBox rotationNode = new HBox(50.0);
        rotationNode.getChildren().setAll((Object[])new Node[]{rotationXCheckBox, rotationYCheckBox, rotationZCheckBox});
        TitledPane rotationPane = UiUtil.createTitledPane(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.title", "Rotation parameters"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.rotation.tooltip", "Select rotation parameters to be estimated"), (Node)rotationNode);
        rotationPane.setCollapsible(false);
        GridPane parameterGridPane = UiUtil.createGridPane();
        parameterGridPane.setHgap(50.0);
        parameterGridPane.setVgap(15.0);
        parameterGridPane.setAlignment(Pos.BASELINE_CENTER);
        int row = 0;
        int col = 0;
        parameterGridPane.add((Node)shiftXCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)scaleXCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)rotationXCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)shearXCheckBox, col++, row++, 1, 1);
        col = 0;
        parameterGridPane.add((Node)shiftYCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)scaleYCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)rotationYCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)shearYCheckBox, col++, row++, 1, 1);
        col = 0;
        parameterGridPane.add((Node)shiftZCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)scaleZCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)rotationZCheckBox, col++, row, 1, 1);
        parameterGridPane.add((Node)shearZCheckBox, col++, row++, 1, 1);
        TitledPane titledPane = UiUtil.createTitledPane(this.i18n.getString("UIRestrictionPaneBuilder.restriction.parameter.title", "Transformation parameters"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.parameter.tooltip", "Select transformation parameters to be estimated"), (Node)parameterGridPane);
        titledPane.setCollapsible(false);
        Menu menu = new Menu();
        Label label = new Label(this.i18n.getString("UIRestrictionPaneBuilder.transformation.property.label", "\u25bc"));
        label.setTooltip(new Tooltip(this.i18n.getString("UIRestrictionPaneBuilder.transformation.property.tooltip", "Select transformation properties")));
        menu.setGraphic((Node)label);
        menu.getItems().addAll((Object[])new MenuItem[]{this.getMenuItem(this.i18n.getString("UIRestrictionPaneBuilder.transformation.property.congruent.label", "Congruent"), transformationPropertyEventHandler, TransformationPropertyType.CONGRUENT), this.getMenuItem(this.i18n.getString("UIRestrictionPaneBuilder.transformation.property.similar.label", "Similar"), transformationPropertyEventHandler, TransformationPropertyType.SIMILAR), this.getMenuItem(this.i18n.getString("UIRestrictionPaneBuilder.transformation.property.affine.label", "Affine"), transformationPropertyEventHandler, TransformationPropertyType.AFFINE)});
        this.transformationMenuBar.setBackground(null);
        this.transformationMenuBar.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.transformationMenuBar.getMenus().add((Object)menu);
        this.transformationMenuBar.setDisable(true);
        HBox header = new HBox();
        header.setPadding(new Insets(0.0));
        header.setAlignment(Pos.CENTER_LEFT);
        header.setSpacing(0.0);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        header.setSpacing(0.0);
        header.getChildren().setAll((Object[])new Node[]{titledPane.getGraphic(), spacer, this.transformationMenuBar});
        titledPane.setGraphic((Node)header);
        return titledPane;
    }

    private Node createIdentScalePane() {
        CheckBox scaleXYCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.xy.label", "Scales mx = my"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.xy.tooltip", "Checked, if x-scale is identical with y-scale"), ParameterRestrictionType.IDENTICAL_SCALE_XY, this.parameterRestrictionCheckboxes);
        CheckBox scaleXZCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.xz.label", "Scales mx = mz"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.xz.tooltip", "Checked, if x-scale is identical with z-scale"), ParameterRestrictionType.IDENTICAL_SCALE_XZ, this.parameterRestrictionCheckboxes);
        CheckBox scaleYZCheckBox = this.createRestrictionCheckBox(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.yz.label", "Scales my = mz"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scale.yz.tooltip", "Checked, if y-scale is identical with z-scale"), ParameterRestrictionType.IDENTICAL_SCALE_YZ, this.parameterRestrictionCheckboxes);
        HBox identScaleNode = new HBox(50.0);
        identScaleNode.getChildren().setAll((Object[])new Node[]{scaleXYCheckBox, scaleXZCheckBox, scaleYZCheckBox});
        TitledPane titledPane = UiUtil.createTitledPane(this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scales.title", "Scale conditions"), this.i18n.getString("UIRestrictionPaneBuilder.restriction.type.scales.tooltip", "Select scale conditions"), (Node)identScaleNode);
        titledPane.setCollapsible(false);
        return titledPane;
    }

    private void setDisable() {
        Set supportedRestrictionTypes = this.transformation == null ? Collections.emptySet() : this.transformation.getSupportedParameterRestrictions().keySet();
        for (CheckBox checkBox : this.parameterRestrictionCheckboxes.values()) {
            checkBox.setDisable(!supportedRestrictionTypes.contains(checkBox.getUserData()));
        }
    }

    private CheckBox createRestrictionCheckBox(String label, String tooltip, ParameterRestrictionType restrictionType, Map<ParameterRestrictionType, CheckBox> checkBoxMap) {
        CheckBox checkBox = UiUtil.createCheckBox(label, tooltip);
        checkBox.setUserData((Object)restrictionType);
        checkBox.setSelected(true);
        checkBox.selectedProperty().addListener((ChangeListener)new RestrictionChangeListener(checkBox));
        checkBoxMap.put(restrictionType, checkBox);
        return checkBox;
    }

    private MenuItem getMenuItem(String name, TransformationPropertyMenuEventHandler eventHandler, TransformationPropertyType propertyType) {
        MenuItem item = new MenuItem(name);
        item.setOnAction((EventHandler)eventHandler);
        item.setUserData((Object)propertyType);
        return item;
    }

    @Override
    public void transformationChanged(TransformationEvent evt) {
        if (this.transformation != null) {
            this.lastTransformationType = this.transformation.getTransformationEquations().getTransformationType();
        }
        if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED) {
            this.transformation = null;
        } else if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED) {
            this.transformation = evt.getSource();
        }
        this.transformationMenuBar.setDisable(evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED);
        this.setDisable();
        if (this.lastTransformationType == null || this.transformation == null || this.lastTransformationType != this.transformation.getTransformationEquations().getTransformationType()) {
            this.setSimilarProperty();
        }
        if (this.transformation != null) {
            for (CheckBox checkBox : this.parameterRestrictionCheckboxes.values()) {
                this.handleSelection((ParameterRestrictionType)((Object)checkBox.getUserData()), checkBox.isSelected());
            }
        }
    }

    private void setAffineProperty() {
        CheckBox checkBox;
        Set<ParameterRestrictionType> shearRestrictionTypes = Set.of(ParameterRestrictionType.FIXED_SHEAR_X, ParameterRestrictionType.FIXED_SHEAR_Y, ParameterRestrictionType.FIXED_SHEAR_Z);
        Set<ParameterRestrictionType> scaleRestrictionTypes = Set.of(ParameterRestrictionType.IDENTICAL_SCALE_XY, ParameterRestrictionType.IDENTICAL_SCALE_XZ, ParameterRestrictionType.IDENTICAL_SCALE_YZ);
        this.setSimilarProperty();
        for (ParameterRestrictionType restrictionType : shearRestrictionTypes) {
            checkBox = this.parameterRestrictionCheckboxes.get((Object)restrictionType);
            if (checkBox.isDisable() || !(checkBox.getUserData() instanceof ParameterRestrictionType)) continue;
            checkBox.setSelected(true);
        }
        for (ParameterRestrictionType restrictionType : scaleRestrictionTypes) {
            checkBox = this.parameterRestrictionCheckboxes.get((Object)restrictionType);
            if (checkBox.isDisable() || !(checkBox.getUserData() instanceof ParameterRestrictionType)) continue;
            checkBox.setSelected(false);
        }
    }

    private void setSimilarProperty() {
        Set<ParameterRestrictionType> scaleRestrictionTypes = Set.of(ParameterRestrictionType.FIXED_SCALE_X, ParameterRestrictionType.FIXED_SCALE_Y, ParameterRestrictionType.FIXED_SCALE_Z, ParameterRestrictionType.IDENTICAL_SCALE_XY, ParameterRestrictionType.IDENTICAL_SCALE_XZ, ParameterRestrictionType.IDENTICAL_SCALE_YZ);
        this.setCongruentProperty();
        for (ParameterRestrictionType restrictionType : scaleRestrictionTypes) {
            CheckBox checkBox = this.parameterRestrictionCheckboxes.get((Object)restrictionType);
            if (checkBox.isDisable() || !(checkBox.getUserData() instanceof ParameterRestrictionType)) continue;
            checkBox.setSelected(true);
        }
    }

    private void setCongruentProperty() {
        for (CheckBox checkBox : this.parameterRestrictionCheckboxes.values()) {
            if (checkBox.isDisable() || !(checkBox.getUserData() instanceof ParameterRestrictionType)) continue;
            ParameterRestrictionType restrictionType = (ParameterRestrictionType)((Object)checkBox.getUserData());
            switch (restrictionType) {
                case FIXED_SCALE_X: 
                case FIXED_SCALE_Y: 
                case FIXED_SCALE_Z: 
                case FIXED_SHEAR_X: 
                case FIXED_SHEAR_Y: 
                case FIXED_SHEAR_Z: 
                case IDENTICAL_SCALE_XY: 
                case IDENTICAL_SCALE_XZ: 
                case IDENTICAL_SCALE_YZ: {
                    checkBox.setSelected(false);
                    break;
                }
                default: {
                    checkBox.setSelected(true);
                }
            }
        }
    }

    private void handleSelection(ParameterRestrictionType parameterRestrictionType, boolean selected) {
        if (this.transformation == null) {
            return;
        }
        this.transformation.removeRestriction(parameterRestrictionType);
        switch (parameterRestrictionType) {
            case IDENTICAL_SCALE_XY: {
                if (!selected) break;
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.FIXED_SCALE_X).setSelected(true);
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.FIXED_SCALE_Y).setSelected(true);
                break;
            }
            case IDENTICAL_SCALE_XZ: {
                if (!selected) break;
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.FIXED_SCALE_X).setSelected(true);
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.FIXED_SCALE_Z).setSelected(true);
                break;
            }
            case IDENTICAL_SCALE_YZ: {
                if (!selected) break;
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.FIXED_SCALE_Y).setSelected(true);
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.FIXED_SCALE_Z).setSelected(true);
                break;
            }
            case FIXED_SCALE_X: {
                if (selected) break;
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XY).setSelected(false);
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XZ).setSelected(false);
                this.transformation.addRestriction(parameterRestrictionType);
                break;
            }
            case FIXED_SCALE_Y: {
                if (selected) break;
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XY).setSelected(false);
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_YZ).setSelected(false);
                this.transformation.addRestriction(parameterRestrictionType);
                break;
            }
            case FIXED_SCALE_Z: {
                if (selected) break;
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XZ).setSelected(false);
                this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_YZ).setSelected(false);
                this.transformation.addRestriction(parameterRestrictionType);
                break;
            }
            default: {
                if (selected) break;
                this.transformation.addRestriction(parameterRestrictionType);
            }
        }
        if (parameterRestrictionType == ParameterRestrictionType.IDENTICAL_SCALE_XY || parameterRestrictionType == ParameterRestrictionType.IDENTICAL_SCALE_XZ || parameterRestrictionType == ParameterRestrictionType.IDENTICAL_SCALE_YZ) {
            CheckBox identScaleXYCheckBox = this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XY);
            CheckBox identScaleXZCheckBox = this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_XZ);
            CheckBox identScaleYZCheckBox = this.parameterRestrictionCheckboxes.get((Object)ParameterRestrictionType.IDENTICAL_SCALE_YZ);
            if (identScaleXYCheckBox.isSelected() && identScaleXZCheckBox.isSelected() && identScaleYZCheckBox.isSelected()) {
                this.transformation.removeRestriction(ParameterRestrictionType.IDENTICAL_SCALE_XY);
                this.transformation.removeRestriction(ParameterRestrictionType.IDENTICAL_SCALE_XZ);
                this.transformation.removeRestriction(ParameterRestrictionType.IDENTICAL_SCALE_YZ);
                this.transformation.addRestriction(ParameterRestrictionType.IDENTICAL_SCALE_XY);
                this.transformation.addRestriction(ParameterRestrictionType.IDENTICAL_SCALE_XZ);
            } else if (selected) {
                this.transformation.addRestriction(parameterRestrictionType);
            }
        }
    }

    private class RestrictionChangeListener
    implements ChangeListener<Boolean> {
        private final CheckBox checkBox;

        private RestrictionChangeListener(CheckBox checkBox) {
            this.checkBox = checkBox;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (this.checkBox.getUserData() instanceof ParameterRestrictionType) {
                UIRestrictionPaneBuilder.this.handleSelection((ParameterRestrictionType)((Object)this.checkBox.getUserData()), this.checkBox.isSelected());
            }
        }
    }

    private class TransformationPropertyMenuEventHandler
    implements EventHandler<ActionEvent> {
        private TransformationPropertyMenuEventHandler() {
        }

        public void handle(ActionEvent event) {
            MenuItem menuItem;
            if (event.getSource() instanceof MenuItem && (menuItem = (MenuItem)event.getSource()).getUserData() instanceof TransformationPropertyType) {
                TransformationPropertyType transformationPropertyType = (TransformationPropertyType)((Object)menuItem.getUserData());
                switch (transformationPropertyType) {
                    case CONGRUENT: {
                        UIRestrictionPaneBuilder.this.setCongruentProperty();
                        break;
                    }
                    case SIMILAR: {
                        UIRestrictionPaneBuilder.this.setSimilarProperty();
                        break;
                    }
                    case AFFINE: {
                        UIRestrictionPaneBuilder.this.setAffineProperty();
                    }
                }
            }
        }
    }

    private static enum TransformationPropertyType {
        CONGRUENT,
        SIMILAR,
        AFFINE;

    }
}

