/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.pane;

import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.adjustment.transformation.interpolation.Interpolation;
import org.applied_geodesy.adjustment.transformation.interpolation.InterpolationType;
import org.applied_geodesy.adjustment.transformation.interpolation.InverseDistanceWeighting;
import org.applied_geodesy.adjustment.transformation.interpolation.MultiQuadraticInterpolation;
import org.applied_geodesy.adjustment.transformation.interpolation.SectorInterpolation;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.utils.UiUtil;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class UIInterpolationPaneBuilder
implements TransformationChangeListener {
    private static UIInterpolationPaneBuilder interpolationPaneBuilder = new UIInterpolationPaneBuilder();
    private Transformation transformation = null;
    private InterpolationType lastSelectedInterpolationType = InterpolationType.NONE;
    private I18N i18n = I18N.getInstance();
    private ScrollPane restrictionNode = null;
    private Map<InterpolationType, Interpolation> interpolationApproaches = Map.of(InterpolationType.INVERSE_DISTANCE_WEIGHTING, new InverseDistanceWeighting(), InterpolationType.MULTI_QUADRATIC, new MultiQuadraticInterpolation(), InterpolationType.SECTOR, new SectorInterpolation());

    private UIInterpolationPaneBuilder() {
        this.init();
    }

    public static UIInterpolationPaneBuilder getInstance() {
        return interpolationPaneBuilder;
    }

    private void init() {
        if (this.restrictionNode != null) {
            return;
        }
        this.restrictionNode = this.createPane();
        this.restrictionNode.getContent().setDisable(true);
    }

    public Node getNode() {
        return this.restrictionNode;
    }

    private ScrollPane createPane() {
        Node interPolationPane = this.createInterpolationPane();
        GridPane gridPane = UiUtil.createGridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(20.0);
        gridPane.setPadding(new Insets(20.0, 15.0, 20.0, 15.0));
        gridPane.setAlignment(Pos.BASELINE_CENTER);
        Region leftSpacer = new Region();
        leftSpacer.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        leftSpacer.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Region rightSpacer = new Region();
        rightSpacer.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        rightSpacer.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        GridPane.setHgrow((Node)leftSpacer, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)rightSpacer, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)interPolationPane, (Priority)Priority.SOMETIMES);
        int row = 0;
        int col = 0;
        gridPane.add((Node)leftSpacer, col++, row, 1, 1);
        gridPane.add(interPolationPane, col++, row, 1, 1);
        gridPane.add((Node)rightSpacer, col++, row++, 1, 1);
        ScrollPane scrollPane = new ScrollPane((Node)gridPane);
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        return scrollPane;
    }

    private Node createInterpolationPane() {
        ToggleGroup interpolationGroup = new ToggleGroup();
        Insets radioInsets = new Insets(10.0, 0.0, 0.0, 0.0);
        Insets labelInsets = new Insets(0.0, 0.0, 0.0, 40.0);
        RadioButton nonRadioButton = this.createInterpolationRadioButton(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.none.label", "No interpolation of residual gaps"), this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.none.tooltip", "Selected, if no interpolation approach is prescribed."), InterpolationType.NONE, interpolationGroup);
        RadioButton idwRadioButton = this.createInterpolationRadioButton(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.inverse_distance_weighting.label", "Inverse distance weighting"), this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.inverse_distance_weighting.tooltip", "Selected, if inverse distance weighting is to be applied."), InterpolationType.INVERSE_DISTANCE_WEIGHTING, interpolationGroup);
        RadioButton msiRadioButton = this.createInterpolationRadioButton(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.multiquadratic.label", "Multiquadratic interpolation"), this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.multiquadratic.tooltip", "Selected, if multiquadratic interpolation is to be applied."), InterpolationType.MULTI_QUADRATIC, interpolationGroup);
        RadioButton secRadioButton = this.createInterpolationRadioButton(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.sector.label", "Sector interpolation"), this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.sector.tooltip", "Selected, if sector interpolation is to be applied."), InterpolationType.SECTOR, interpolationGroup);
        nonRadioButton.setPadding(radioInsets);
        idwRadioButton.setPadding(radioInsets);
        msiRadioButton.setPadding(radioInsets);
        secRadioButton.setPadding(radioInsets);
        Label idxExponentLabel = new Label(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.inverse_distance_weighting.parameter.exponent.label", "Exponent: "));
        Label idxSmoothingLabel = new Label(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.inverse_distance_weighting.parameter.smoothing.label", "Smoothing value: "));
        Label msiExponentLabel = new Label(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.multiquadratic.parameter.exponent.label", "Exponent: "));
        Label msiSmoothingLabel = new Label(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.multiquadratic.parameter.smoothing.label", "Smoothing value: "));
        Label secNumeratorExponentLabel = new Label(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.sector.parameter.exponent.numerator.label", "Exponent of numerator: "));
        Label secDenominatorExponentLabel = new Label(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.sector.parameter.exponent.denominator.label", "Exponent of denominator: "));
        idxExponentLabel.setPadding(labelInsets);
        idxSmoothingLabel.setPadding(labelInsets);
        msiExponentLabel.setPadding(labelInsets);
        msiSmoothingLabel.setPadding(labelInsets);
        secNumeratorExponentLabel.setPadding(labelInsets);
        secDenominatorExponentLabel.setPadding(labelInsets);
        DoubleTextField idxExponentField = this.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.inverse_distance_weighting.parameter.exponent.tooltip", "Exponent of inverse distance weighting"), InterpolationType.INVERSE_DISTANCE_WEIGHTING);
        DoubleTextField idxSmoothingField = this.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.inverse_distance_weighting.parameter.smoothing.tooltip", "Smoothing value in inverse distance weighting"), InterpolationType.INVERSE_DISTANCE_WEIGHTING);
        DoubleTextField msiExponentField = this.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.multiquadratic.parameter.exponent.tooltip", "Exponent of multiquadratic interpolation"), InterpolationType.MULTI_QUADRATIC);
        DoubleTextField msiSmoothingField = this.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.multiquadratic.parameter.smoothing.tooltip", "Smoothing value of multiquadratic interpolation"), InterpolationType.MULTI_QUADRATIC);
        DoubleTextField secNumeratorExponentField = this.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.sector.parameter.exponent.numerator.tooltip", "Numerator exponent of sector interpolation"), InterpolationType.SECTOR);
        DoubleTextField secDenominatorExponentField = this.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("UIInterpolationPaneBuilder.interpolation.type.sector.parameter.exponent.denominator.tooltip", "Denominator exponent of sector interpolation"), InterpolationType.SECTOR);
        idxExponentField.numberProperty().bindBidirectional(((InverseDistanceWeighting)this.interpolationApproaches.get((Object)InterpolationType.INVERSE_DISTANCE_WEIGHTING)).exponentProperty());
        idxSmoothingField.numberProperty().bindBidirectional(((InverseDistanceWeighting)this.interpolationApproaches.get((Object)InterpolationType.INVERSE_DISTANCE_WEIGHTING)).smoothingProperty());
        msiExponentField.numberProperty().bindBidirectional(((MultiQuadraticInterpolation)this.interpolationApproaches.get((Object)InterpolationType.MULTI_QUADRATIC)).exponentProperty());
        msiSmoothingField.numberProperty().bindBidirectional(((MultiQuadraticInterpolation)this.interpolationApproaches.get((Object)InterpolationType.MULTI_QUADRATIC)).smoothingProperty());
        secNumeratorExponentField.numberProperty().bindBidirectional(((SectorInterpolation)this.interpolationApproaches.get((Object)InterpolationType.SECTOR)).numeratorExponentProperty());
        secDenominatorExponentField.numberProperty().bindBidirectional(((SectorInterpolation)this.interpolationApproaches.get((Object)InterpolationType.SECTOR)).denominatorExponentProperty());
        idxExponentLabel.setLabelFor((Node)idxExponentField);
        idxSmoothingLabel.setLabelFor((Node)idxSmoothingField);
        msiExponentLabel.setLabelFor((Node)msiExponentField);
        msiSmoothingLabel.setLabelFor((Node)msiSmoothingField);
        secNumeratorExponentLabel.setLabelFor((Node)secNumeratorExponentField);
        secDenominatorExponentLabel.setLabelFor((Node)secDenominatorExponentField);
        nonRadioButton.setSelected(true);
        interpolationGroup.selectedToggleProperty().addListener((ChangeListener)new InterpolationTypeChangeListener());
        GridPane.setHgrow((Node)idxExponentField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)idxSmoothingField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)msiExponentField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)msiSmoothingField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)secNumeratorExponentField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)secDenominatorExponentField, (Priority)Priority.ALWAYS);
        GridPane interpolationApproachGridPane = UiUtil.createGridPane();
        interpolationApproachGridPane.setHgap(50.0);
        interpolationApproachGridPane.setVgap(10.0);
        interpolationApproachGridPane.setAlignment(Pos.BASELINE_LEFT);
        int row = 0;
        interpolationApproachGridPane.add((Node)nonRadioButton, 0, row++, 2, 1);
        interpolationApproachGridPane.add((Node)idwRadioButton, 0, row++, 2, 1);
        interpolationApproachGridPane.add((Node)idxExponentLabel, 0, row, 1, 1);
        interpolationApproachGridPane.add((Node)idxExponentField, 1, row++, 1, 1);
        interpolationApproachGridPane.add((Node)idxSmoothingLabel, 0, row, 1, 1);
        interpolationApproachGridPane.add((Node)idxSmoothingField, 1, row++, 1, 1);
        interpolationApproachGridPane.add((Node)msiRadioButton, 0, row++, 2, 1);
        interpolationApproachGridPane.add((Node)msiExponentLabel, 0, row, 1, 1);
        interpolationApproachGridPane.add((Node)msiExponentField, 1, row++, 1, 1);
        interpolationApproachGridPane.add((Node)msiSmoothingLabel, 0, row, 1, 1);
        interpolationApproachGridPane.add((Node)msiSmoothingField, 1, row++, 1, 1);
        interpolationApproachGridPane.add((Node)secRadioButton, 0, row++, 2, 1);
        interpolationApproachGridPane.add((Node)secNumeratorExponentLabel, 0, row, 1, 1);
        interpolationApproachGridPane.add((Node)secNumeratorExponentField, 1, row++, 1, 1);
        interpolationApproachGridPane.add((Node)secDenominatorExponentLabel, 0, row, 1, 1);
        interpolationApproachGridPane.add((Node)secDenominatorExponentField, 1, row++, 1, 1);
        TitledPane titledPane = UiUtil.createTitledPane(this.i18n.getString("UIInterpolationPaneBuilder.interpolation.title", "Interpolation of residual gaps"), this.i18n.getString("UIInterpolationPaneBuilder.interpolation.tooltip", "Select interpolation approach"), (Node)interpolationApproachGridPane);
        titledPane.setCollapsible(false);
        return titledPane;
    }

    private RadioButton createInterpolationRadioButton(String label, String tooltip, InterpolationType interpolationType, ToggleGroup group) {
        RadioButton radioButton = UiUtil.createRadioButton(label, tooltip, group);
        radioButton.setUserData((Object)interpolationType);
        radioButton.setSelected(false);
        return radioButton;
    }

    private DoubleTextField createDoubleTextField(CellValueType type, double value, String tooltipText, InterpolationType interpolationType) {
        DoubleTextField field = UiUtil.createDoubleTextField(type, value, tooltipText);
        field.setUserData((Object)interpolationType);
        return field;
    }

    private void setInterpolation(InterpolationType interpolationType) {
        if (interpolationType != null) {
            this.lastSelectedInterpolationType = interpolationType;
        }
        if (this.transformation == null) {
            return;
        }
        if (interpolationType == null) {
            this.transformation.setInterpolation(null);
        } else {
            Interpolation interpolation = this.interpolationApproaches.get((Object)interpolationType);
            this.transformation.setInterpolation(interpolation);
        }
    }

    @Override
    public void transformationChanged(TransformationEvent evt) {
        this.restrictionNode.getContent().setDisable(evt.getEventType() != TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED);
        if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED) {
            this.transformation = evt.getSource();
            this.setInterpolation(this.lastSelectedInterpolationType);
        } else if (evt.getEventType() == TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_REMOVED) {
            if (this.transformation != null) {
                this.setInterpolation(null);
            }
            this.transformation = null;
        }
    }

    private class InterpolationTypeChangeListener
    implements ChangeListener<Toggle> {
        private InterpolationTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> arg0, Toggle oldValue, Toggle newValue) {
            if (newValue.getUserData() instanceof InterpolationType) {
                InterpolationType interpolationType = (InterpolationType)((Object)newValue.getUserData());
                UIInterpolationPaneBuilder.this.setInterpolation(interpolationType);
            }
        }
    }
}

