/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.menu;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.applied_geodesy.adjustment.transformation.HeightTransformation;
import org.applied_geodesy.adjustment.transformation.PlanarAffineTransformation;
import org.applied_geodesy.adjustment.transformation.SpatialAffineTransformation;
import org.applied_geodesy.adjustment.transformation.Transformation;
import org.applied_geodesy.adjustment.transformation.TransformationChangeListener;
import org.applied_geodesy.adjustment.transformation.TransformationEvent;
import org.applied_geodesy.adjustment.transformation.TransformationType;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.ObservedFramePosition;
import org.applied_geodesy.coordtrans.ui.CoordTrans;
import org.applied_geodesy.coordtrans.ui.dialog.FilePathsSelectionDialog;
import org.applied_geodesy.coordtrans.ui.dialog.ReadFileProgressDialog;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.io.reader.PositionFileReader;
import org.applied_geodesy.coordtrans.ui.io.writer.FTLReport;
import org.applied_geodesy.coordtrans.ui.io.writer.MatlabTransformationAdjustmentResultWriter;
import org.applied_geodesy.coordtrans.ui.menu.MenuEventHandler;
import org.applied_geodesy.coordtrans.ui.menu.MenuItemType;
import org.applied_geodesy.coordtrans.ui.menu.PathMenuItem;
import org.applied_geodesy.coordtrans.ui.table.UIFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.table.UIHomologousFramePositionPairTableBuilder;
import org.applied_geodesy.coordtrans.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.io.DefaultFileChooser;
import org.applied_geodesy.util.ObservableUniqueList;

public class UIMenuBuilder
implements TransformationChangeListener {
    private static UIMenuBuilder menuBuilder = new UIMenuBuilder();
    private I18N i18n = I18N.getInstance();
    private MenuEventHandler menuEventHandler = new MenuEventHandler(this);
    private MenuBar menuBar;
    private Menu reportMenu;

    private UIMenuBuilder() {
    }

    public static UIMenuBuilder getInstance() {
        return menuBuilder;
    }

    public MenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.init();
        }
        return this.menuBar;
    }

    private void init() {
        this.menuBar = new MenuBar();
        Menu fileMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.file.label", "_File"), true);
        Menu adjustmentMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.adjustment.label", "Ad_justment"), true);
        Menu analysisMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.analysis.label", "Anal_ysis"), true);
        this.reportMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.report.label", "Repor_t"), true);
        Menu helpMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.help.label", "_?"), true);
        this.createFileMenu(fileMenu);
        this.createAnalysisMenu(analysisMenu);
        this.createAdjustmentMenu(adjustmentMenu);
        this.createReportMenu(this.reportMenu);
        this.createHelpMenu(helpMenu);
        this.menuBar.getMenus().addAll((Object[])new Menu[]{fileMenu, adjustmentMenu, analysisMenu, this.reportMenu, helpMenu});
    }

    private void createFileMenu(Menu parentMenu) {
        MenuItem importPositionsItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.file.import.positions.label", "Imp_ort data"), true, MenuItemType.IMPORT_POSITIONS, new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        MenuItem exitItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.file.exit.label", "_Exit"), true, MenuItemType.EXIT, new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{importPositionsItem, new SeparatorMenuItem(), exitItem});
    }

    private void createAdjustmentMenu(Menu parentMenu) {
        MenuItem leastSquaresItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.adjustment.leastsquares.label", "_Least-squares"), true, MenuItemType.LEAST_SQUARES, new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem teststatisticItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.adjustment.teststatistic.label", "Test st_atistic"), true, MenuItemType.TEST_STATISTIC, new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem preferencesItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.adjustment.preferences.label", "Preferen_ces"), true, MenuItemType.PREFERENCES, new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), this.menuEventHandler, false);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{leastSquaresItem, teststatisticItem, new SeparatorMenuItem(), preferencesItem});
    }

    private void createAnalysisMenu(Menu parentMenu) {
        MenuItem quantileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.analysis.quantile.label", "_Quantiles"), true, MenuItemType.QUANTILES, new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem varianceComponentItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.analysis.variance_component.label", "_Variance components"), true, MenuItemType.VARIANCE_COMPONENT_ESTIMATION, new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{varianceComponentItem, quantileItem});
    }

    private void createReportMenu(Menu parentMenu) {
        MenuItem matlabItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.report.matlab.label", "_Matlab file"), true, MenuItemType.EXPORT_MATLAB, new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().add((Object)matlabItem);
        List<Path> templates = FTLReport.getTemplates();
        if (templates != null && !templates.isEmpty()) {
            for (Path templatePath : templates) {
                MenuItem templateFileItem = UIMenuBuilder.createMenuItem(templatePath.getFileName().toString(), false, MenuItemType.REPORT, templatePath, null, this.menuEventHandler, true);
                parentMenu.getItems().add((Object)templateFileItem);
            }
        }
    }

    private void createHelpMenu(Menu parentMenu) {
        MenuItem aboutItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.help.about.label", "A_bout CoordTrans"), true, MenuItemType.ABOUT, new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{aboutItem});
    }

    private static Menu createMenu(String label, boolean mnemonicParsing) {
        Menu menu = new Menu(label);
        menu.setMnemonicParsing(mnemonicParsing);
        return menu;
    }

    private static MenuItem createMenuItem(String label, boolean mnemonicParsing, MenuItemType menuItemType, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        MenuItem menuItem = UIMenuBuilder.createMenuItem(new MenuItem(label), mnemonicParsing, (Object)menuItemType, keyCodeCombination, menuEventHandler, disable);
        return menuItem;
    }

    private static MenuItem createMenuItem(MenuItem menuItem, boolean mnemonicParsing, Object userDate, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        menuItem.setMnemonicParsing(mnemonicParsing);
        if (keyCodeCombination != null) {
            menuItem.setAccelerator((KeyCombination)keyCodeCombination);
        }
        menuItem.setOnAction((EventHandler)menuEventHandler);
        menuItem.setDisable(disable);
        menuItem.setUserData(userDate);
        return menuItem;
    }

    private static MenuItem createMenuItem(String label, boolean mnemonicParsing, MenuItemType menuItemType, Path path, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        PathMenuItem menuItem = (PathMenuItem)UIMenuBuilder.createMenuItem(new PathMenuItem(label), mnemonicParsing, (Object)menuItemType, keyCodeCombination, menuEventHandler, disable);
        menuItem.setPath(path);
        return menuItem;
    }

    void importPositions() {
        FilePathsSelectionDialog.FilePathPair filePathPair = null;
        Optional<FilePathsSelectionDialog.FilePathPair> optional = FilePathsSelectionDialog.showAndWait();
        if (optional.isPresent()) {
            filePathPair = optional.get();
        }
        if (filePathPair != null) {
            this.importPositions(filePathPair);
        }
    }

    private void importPositions(FilePathsSelectionDialog.FilePathPair filePathPair) {
        TransformationType transformationType = filePathPair.getTransformationType();
        PositionFileReader fileReader = new PositionFileReader(transformationType);
        ReadFileProgressDialog<Map<String, ObservedFramePosition>> dialog = new ReadFileProgressDialog<Map<String, ObservedFramePosition>>();
        Optional<List<Map<String, ObservedFramePosition>>> optional = dialog.showAndWait(fileReader, List.of(filePathPair.getSourceFilePath().toFile(), filePathPair.getTargetFilePath().toFile()), Boolean.TRUE);
        List<Map<String, ObservedFramePosition>> positions = null;
        if (optional.isPresent()) {
            positions = optional.get();
        }
        if (positions == null || positions.size() < 2) {
            return;
        }
        Map<String, ObservedFramePosition> sourceSystemPositions = positions.get(0);
        Map<String, ObservedFramePosition> targetSystemPositions = positions.get(1);
        if (sourceSystemPositions == null || sourceSystemPositions.isEmpty() || targetSystemPositions == null || targetSystemPositions.isEmpty()) {
            return;
        }
        ObservableUniqueList homologousFramePositionPairs = new ObservableUniqueList(Math.min(sourceSystemPositions.size(), targetSystemPositions.size()));
        ObservableUniqueList framePositionPairs = new ObservableUniqueList(sourceSystemPositions.size());
        for (Map.Entry<String, ObservedFramePosition> point : sourceSystemPositions.entrySet()) {
            String name = point.getKey();
            ObservedFramePosition sourcePosition = point.getValue();
            framePositionPairs.add(new FramePositionPair(name, sourcePosition));
            if (!targetSystemPositions.containsKey(name)) continue;
            ObservedFramePosition targetPosition = targetSystemPositions.get(name);
            switch (transformationType) {
                case HEIGHT: {
                    homologousFramePositionPairs.add(new HomologousFramePositionPair(name, sourcePosition.getZ(), sourcePosition.getDispersionApriori(), targetPosition.getZ(), targetPosition.getDispersionApriori()));
                    break;
                }
                case PLANAR: {
                    homologousFramePositionPairs.add(new HomologousFramePositionPair(name, sourcePosition.getX(), sourcePosition.getY(), sourcePosition.getDispersionApriori(), targetPosition.getX(), targetPosition.getY(), targetPosition.getDispersionApriori()));
                    break;
                }
                case SPATIAL: {
                    homologousFramePositionPairs.add(new HomologousFramePositionPair(name, sourcePosition.getX(), sourcePosition.getY(), sourcePosition.getZ(), sourcePosition.getDispersionApriori(), targetPosition.getX(), targetPosition.getY(), targetPosition.getZ(), targetPosition.getDispersionApriori()));
                }
            }
        }
        UIHomologousFramePositionPairTableBuilder homologousFramePositionPairTableBuilder = UIHomologousFramePositionPairTableBuilder.getInstance();
        homologousFramePositionPairTableBuilder.setTransformationType(transformationType);
        TableView<HomologousFramePositionPair> homologousPositionPairTable = homologousFramePositionPairTableBuilder.getTable();
        ObservableList<HomologousFramePositionPair> homologousPositionPairTableModel = homologousFramePositionPairTableBuilder.getTableModel(homologousPositionPairTable);
        homologousPositionPairTableModel.setAll(homologousFramePositionPairs);
        UIFramePositionPairTableBuilder framePositionPairTableBuilder = UIFramePositionPairTableBuilder.getInstance();
        framePositionPairTableBuilder.setTransformationType(transformationType);
        TableView<FramePositionPair> positionPairTable = framePositionPairTableBuilder.getTable();
        ObservableList<FramePositionPair> positionPairTableModel = framePositionPairTableBuilder.getTableModel(positionPairTable);
        positionPairTableModel.setAll(framePositionPairs);
        Transformation transformation = null;
        switch (transformationType) {
            case HEIGHT: {
                transformation = new HeightTransformation();
                break;
            }
            case PLANAR: {
                transformation = new PlanarAffineTransformation();
                break;
            }
            case SPATIAL: {
                transformation = new SpatialAffineTransformation();
                break;
            }
        }
        if (transformation == null) {
            CoordTrans.setTitle(null);
        } else {
            CoordTrans.setTitle(transformationType.getDimension());
        }
        this.fireTransformationChanged(transformation);
    }

    void createMatlabFile() {
        try {
            if (UITreeBuilder.getInstance().getTransformationAdjustment().getTransformation() == null) {
                return;
            }
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(this.i18n.getString("UIMenuBuilder.report.extension.mat", "Binary Matlab file"), new String[]{"*.mat", "*.MAT"});
            String fileNameSuggestion = "transformation.mat";
            MatlabTransformationAdjustmentResultWriter matWriter = new MatlabTransformationAdjustmentResultWriter();
            File binFile = DefaultFileChooser.showSaveDialog((Window)CoordTrans.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.export.matlab.title", "Save Matlab file"), fileNameSuggestion, extensionFilter);
            if (binFile != null && matWriter != null) {
                matWriter.toFile(binFile, UITreeBuilder.getInstance().getTransformationAdjustment());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.export.matlab.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.export.matlab.exception.header", "Error, could not binary Matlab file."), this.i18n.getString("UIMenuBuilder.message.error.export.matlab.exception.message", "An exception has occurred during file creation."), e);
        }
    }

    void createReport(Path template) {
        try {
            if (UITreeBuilder.getInstance().getTransformationAdjustment().getTransformation() == null) {
                return;
            }
            Pattern pattern = Pattern.compile(".*?\\.(\\.)?(\\w+)\\.ftlh$", 2);
            Matcher matcher = pattern.matcher(template.getFileName().toString().toLowerCase());
            String extension = "html";
            boolean openFileInSystemApplication = true;
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(this.i18n.getString("UIMenuBuilder.report.extension.html", "Hypertext Markup Language"), new String[]{"*.html", "*.htm", "*.HTML", "*.HTM"});
            if (matcher.find() && matcher.groupCount() == 2) {
                openFileInSystemApplication = matcher.group(1) == null;
                extension = matcher.group(2);
                extensionFilter = new FileChooser.ExtensionFilter(String.format(Locale.ENGLISH, this.i18n.getString("UIMenuBuilder.report.extension.template", "%s-File"), extension), new String[]{"*." + extension});
            }
            String fileNameSuggestion = "report." + extension;
            FTLReport ftl = new FTLReport(UITreeBuilder.getInstance().getTransformationAdjustment());
            File reportFile = DefaultFileChooser.showSaveDialog((Window)CoordTrans.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.export.report.title", "Save adjustment report"), fileNameSuggestion, extensionFilter);
            if (reportFile != null && ftl != null) {
                ftl.setTemplate(template.getFileName().toString());
                ftl.toFilePath(reportFile.toPath(), openFileInSystemApplication);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.export.report.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.export.report.exception.header", "Error, could not create adjustment report."), this.i18n.getString("UIMenuBuilder.message.error.export.report.exception.message", "An exception has occurred during report creation."), e);
        }
    }

    public void setReportMenuDisable(boolean disable) {
        for (MenuItem item : this.reportMenu.getItems()) {
            item.setDisable(disable);
        }
    }

    private void fireTransformationChanged(Transformation transformation) {
        UITreeBuilder treeBuilder = UITreeBuilder.getInstance();
        treeBuilder.getTransformationAdjustment().setTransformation(transformation);
        treeBuilder.handleTreeSelections();
    }

    void disableMenu(boolean disable) {
        ObservableList menus = this.menuBar.getMenus();
        for (Menu menu : menus) {
            this.disableMenu(menu, disable);
        }
    }

    private void disableMenu(Menu menu, boolean disable) {
        ObservableList items = menu.getItems();
        for (MenuItem item : items) {
            if (item instanceof Menu) {
                this.disableMenu((Menu)item, disable);
                continue;
            }
            if (item.getUserData() == null || !(item.getUserData() instanceof MenuItemType)) continue;
            MenuItemType itemType = (MenuItemType)((Object)item.getUserData());
            switch (itemType) {
                case QUANTILES: 
                case VARIANCE_COMPONENT_ESTIMATION: 
                case TEST_STATISTIC: 
                case LEAST_SQUARES: {
                    item.setDisable(disable);
                    break;
                }
                case EXPORT_MATLAB: 
                case REPORT: {
                    this.setReportMenuDisable(true);
                    break;
                }
            }
        }
    }

    @Override
    public void transformationChanged(TransformationEvent evt) {
        this.disableMenu(evt.getEventType() != TransformationEvent.TransformationEventType.TRANSFORMATION_MODEL_ADDED);
    }
}

