/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.menu;

import java.nio.file.Path;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.VarianceComponentType;
import org.applied_geodesy.coordtrans.ui.CoordTrans;
import org.applied_geodesy.coordtrans.ui.dialog.AboutDialog;
import org.applied_geodesy.coordtrans.ui.dialog.FormatterOptionDialog;
import org.applied_geodesy.coordtrans.ui.dialog.LeastSquaresSettingDialog;
import org.applied_geodesy.coordtrans.ui.dialog.QuantilesDialog;
import org.applied_geodesy.coordtrans.ui.dialog.TestStatisticDialog;
import org.applied_geodesy.coordtrans.ui.dialog.VarianceComponentsDialog;
import org.applied_geodesy.coordtrans.ui.menu.MenuItemType;
import org.applied_geodesy.coordtrans.ui.menu.UIMenuBuilder;
import org.applied_geodesy.coordtrans.ui.tree.UITreeBuilder;
import org.applied_geodesy.jag3d.ui.menu.PathMenuItem;

class MenuEventHandler
implements EventHandler<ActionEvent> {
    private UIMenuBuilder menuBuilder;
    private UITreeBuilder treeBuilder = UITreeBuilder.getInstance();

    MenuEventHandler(UIMenuBuilder menuBuilder) {
        this.menuBuilder = menuBuilder;
    }

    public void handle(ActionEvent event) {
        if (event.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)event.getSource();
            this.handleAction(menuItem);
        }
    }

    void handleAction(MenuItem menuItem) {
        MenuItemType menuItemType = null;
        Path path = null;
        if (menuItem.getUserData() instanceof MenuItemType) {
            menuItemType = (MenuItemType)((Object)menuItem.getUserData());
            Path path2 = path = menuItem instanceof PathMenuItem ? ((PathMenuItem)menuItem).getPath() : null;
        }
        if (menuItemType == null) {
            return;
        }
        switch (menuItemType) {
            case IMPORT_POSITIONS: {
                this.menuBuilder.importPositions();
                break;
            }
            case TEST_STATISTIC: {
                TestStatisticDialog.showAndWait(this.treeBuilder.getTransformationAdjustment().getTestStatisticDefinition());
                break;
            }
            case LEAST_SQUARES: {
                LeastSquaresSettingDialog.showAndWait(this.treeBuilder.getTransformationAdjustment());
                break;
            }
            case QUANTILES: {
                QuantilesDialog.showAndWait(this.treeBuilder.getTransformationAdjustment() == null ? null : this.treeBuilder.getTransformationAdjustment().getTestStatisticParameters());
                break;
            }
            case VARIANCE_COMPONENT_ESTIMATION: {
                VarianceComponent[] varianceComponentArray;
                if (this.treeBuilder.getTransformationAdjustment() == null) {
                    varianceComponentArray = null;
                } else {
                    VarianceComponent[] varianceComponentArray2 = new VarianceComponent[3];
                    varianceComponentArray2[0] = this.treeBuilder.getTransformationAdjustment().getVarianceComponent(VarianceComponentType.GLOBAL);
                    varianceComponentArray2[1] = this.treeBuilder.getTransformationAdjustment().getVarianceComponent(VarianceComponentType.SOURCE);
                    varianceComponentArray = varianceComponentArray2;
                    varianceComponentArray2[2] = this.treeBuilder.getTransformationAdjustment().getVarianceComponent(VarianceComponentType.TARGET);
                }
                VarianceComponentsDialog.showAndWait(varianceComponentArray);
                break;
            }
            case PREFERENCES: {
                FormatterOptionDialog.showAndWait();
                break;
            }
            case EXIT: {
                CoordTrans.close();
                break;
            }
            case EXPORT_MATLAB: {
                this.menuBuilder.createMatlabFile();
                break;
            }
            case REPORT: {
                this.menuBuilder.createReport(path);
                break;
            }
            case ABOUT: {
                AboutDialog.showAndWait();
            }
        }
    }
}

