/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.io.writer;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.VarianceComponentType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.util.ObservableUniqueList;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Struct;

public class MatlabTransformationAdjustmentResultWriter {
    public void toFile(File binFile, TransformationAdjustment adjustment) throws NullPointerException, IllegalArgumentException, IOException {
        if (adjustment == null || adjustment.getTransformation() == null) {
            throw new NullPointerException("Error, feature object cannot be null!");
        }
        if (binFile == null) {
            throw new NullPointerException("Error, export path cannot be null!");
        }
        ObservableUniqueList<UnknownParameter> unknownParameters = adjustment.getTransformation().getUnknownParameters();
        Struct parameters = Mat5.newStruct((int)1, (int)unknownParameters.size());
        int structIndex = 0;
        int numberOfUnknownParameters = 0;
        Iterator iterator = unknownParameters.iterator();
        while (iterator.hasNext()) {
            UnknownParameter unknownParameter = (UnknownParameter)iterator.next();
            int column = unknownParameter.getColumn();
            parameters.set("name", structIndex, (Array)Mat5.newString((String)unknownParameter.getName()));
            parameters.set("parameter_type", structIndex, (Array)Mat5.newString((String)unknownParameter.getParameterType().name()));
            parameters.set("processing_type", structIndex, (Array)Mat5.newString((String)unknownParameter.getProcessingType().name()));
            parameters.set("value", structIndex, (Array)MatlabTransformationAdjustmentResultWriter.newDouble(unknownParameter.getValue()));
            parameters.set("sigma", structIndex, (Array)MatlabTransformationAdjustmentResultWriter.newDouble(unknownParameter.getUncertainty()));
            if (column >= 0) {
                ++numberOfUnknownParameters;
                parameters.set("column", structIndex, (Array)MatlabTransformationAdjustmentResultWriter.newInteger(column + 1));
            } else {
                parameters.set("column", structIndex, (Array)MatlabTransformationAdjustmentResultWriter.newInteger(-1));
            }
            ++structIndex;
        }
        UpperSymmPackMatrix correlationMatrix = adjustment.getCorrelationMatrix();
        int cols = correlationMatrix.numColumns();
        int rows = correlationMatrix.numRows();
        Matrix correlations = Mat5.newMatrix((int)rows, (int)cols, (MatlabType)MatlabType.Double);
        int rowIdx = 0;
        while (rowIdx < rows) {
            double corr = correlationMatrix.get(rowIdx, rowIdx);
            correlations.setDouble(rowIdx, rowIdx, corr);
            int columnIdx = rowIdx + 1;
            while (columnIdx < cols) {
                corr = correlationMatrix.get(rowIdx, columnIdx);
                correlations.setDouble(rowIdx, columnIdx, corr);
                correlations.setDouble(columnIdx, rowIdx, corr);
                ++columnIdx;
            }
            ++rowIdx;
        }
        VarianceComponent varianceComponentOfUnitWeight = adjustment.getVarianceComponent(VarianceComponentType.GLOBAL);
        int degreeOfFreedom = (int)Math.rint(varianceComponentOfUnitWeight.getRedundancy());
        int numberOfPoints = adjustment.getTransformation().getHomologousFramePositionPairs().size();
        int dimension = adjustment.getTransformation().getTransformationEquations().getTransformationType().getDimension();
        double sigma2aprio = varianceComponentOfUnitWeight.getVariance0();
        double sigma2apost = varianceComponentOfUnitWeight.getVariance();
        Mat5File matFile = Mat5.newMatFile();
        matFile.addArray("variance_of_unit_weight_prio", (Array)MatlabTransformationAdjustmentResultWriter.newDouble(sigma2aprio));
        matFile.addArray("variance_of_unit_weight_post", (Array)MatlabTransformationAdjustmentResultWriter.newDouble(sigma2apost));
        matFile.addArray("degree_of_freedom", (Array)MatlabTransformationAdjustmentResultWriter.newInteger(degreeOfFreedom));
        matFile.addArray("number_of_observations", (Array)MatlabTransformationAdjustmentResultWriter.newInteger(dimension * numberOfPoints));
        matFile.addArray("number_of_unknowns", (Array)MatlabTransformationAdjustmentResultWriter.newInteger(numberOfUnknownParameters));
        matFile.addArray("parameters", (Array)parameters);
        matFile.addArray("correlations", (Array)correlations);
        Mat5.writeToFile((MatFile)matFile, (File)binFile);
    }

    private static Matrix newInteger(int value) {
        Matrix matrix = Mat5.newMatrix((int)1, (int)1, (MatlabType)MatlabType.Int32);
        matrix.setInt(0, 0, value);
        return matrix;
    }

    private static Matrix newDouble(double value) {
        Matrix matrix = Mat5.newMatrix((int)1, (int)1, (MatlabType)MatlabType.Double);
        matrix.setDouble(0, 0, value);
        return matrix;
    }
}

