/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.io.writer;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNotFoundException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.application.HostServices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.statistic.TestStatisticDefinition;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.adjustment.transformation.TransformationAdjustment;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.adjustment.transformation.VarianceComponentType;
import org.applied_geodesy.adjustment.transformation.interpolation.Interpolation;
import org.applied_geodesy.adjustment.transformation.interpolation.InterpolationType;
import org.applied_geodesy.adjustment.transformation.interpolation.InverseDistanceWeighting;
import org.applied_geodesy.adjustment.transformation.interpolation.MultiQuadraticInterpolation;
import org.applied_geodesy.adjustment.transformation.interpolation.SectorInterpolation;
import org.applied_geodesy.adjustment.transformation.parameter.ParameterType;
import org.applied_geodesy.adjustment.transformation.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.transformation.point.EstimatedFramePosition;
import org.applied_geodesy.adjustment.transformation.point.FramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePosition;
import org.applied_geodesy.adjustment.transformation.point.HomologousFramePositionPair;
import org.applied_geodesy.adjustment.transformation.point.ObservedFramePosition;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.ObservableUniqueList;
import org.applied_geodesy.util.unit.UnitType;
import org.applied_geodesy.version.juniform.Version;

public class FTLReport {
    private static final freemarker.template.Version VERSION = Configuration.VERSION_2_3_33;
    private FormatterOptions options = FormatterOptions.getInstance();
    private Template template = null;
    private static HostServices hostServices;
    private Map<String, Object> data = new HashMap<String, Object>();
    public static final String TEMPLATE_PATH = "ftl/ct/";
    private final Configuration cfg = new Configuration(VERSION);
    private TransformationAdjustment adjustment;

    public FTLReport(TransformationAdjustment adjustment) {
        this.adjustment = adjustment;
        this.init();
    }

    private void init() {
        try {
            Path path = Paths.get(FTLReport.class.getClassLoader().getResource(TEMPLATE_PATH).toURI());
            this.cfg.setDirectoryForTemplateLoading(path.toFile());
            this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.cfg.setLogTemplateExceptions(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setHostServices(HostServices hostServices) {
        FTLReport.hostServices = hostServices;
    }

    private void setParam(String key, Object value) {
        this.data.put(key, value);
    }

    public void setTemplate(String template) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        this.template = this.cfg.getTemplate(template);
    }

    private void createReport() throws ClassNotFoundException, TemplateModelException {
        this.data.clear();
        BeansWrapper wrapper = new BeansWrapperBuilder(VERSION).build();
        TemplateHashModel staticModels = wrapper.getStaticModels();
        TemplateHashModel mathStatics = (TemplateHashModel)staticModels.get("java.lang.Math");
        this.data.put("Math", mathStatics);
        this.initFormatterOptions();
        this.addMetaData();
        this.addTeststatistics();
        this.addVarianceEstimation();
        this.addHomologousFramePositionPairs();
        this.addFramePositionPairs();
        this.addUnknownParameters();
        this.addCorrelationMatrix();
        this.addHomogeneousCoordinateTransformationMatrix();
        this.addEulerAngles();
    }

    public void toFilePath(Path report, boolean openFile) throws ClassNotFoundException, TemplateException, IOException {
        if (report == null) {
            return;
        }
        this.createReport();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(report, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.template.process(this.data, (Writer)writer);
            ((Writer)writer).flush();
            if (hostServices != null && openFile) {
                hostServices.showDocument(report.toAbsolutePath().normalize().toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void initFormatterOptions() {
        Map<CellValueType, FormatterOptions.FormatterOption> options = FormatterOptions.getInstance().getFormatterOptions();
        block17: for (FormatterOptions.FormatterOption option : options.values()) {
            String keyDigits = null;
            String keyUnit = null;
            String keySexagesimal = null;
            CellValueType cellValueType = option.getType();
            switch (cellValueType) {
                case ANGLE: {
                    keyDigits = "digits_angle";
                    keyUnit = "unit_abbr_angle";
                    keySexagesimal = option.getUnit().getType() == UnitType.DEGREE_SEXAGESIMAL ? "sexagesimal_angle" : null;
                    break;
                }
                case ANGLE_RESIDUAL: {
                    keyDigits = "digits_angle_residual";
                    keyUnit = "unit_abbr_angle_residual";
                    keySexagesimal = option.getUnit().getType() == UnitType.DEGREE_SEXAGESIMAL ? "sexagesimal_angle_residual" : null;
                    break;
                }
                case ANGLE_UNCERTAINTY: {
                    keyDigits = "digits_angle_uncertainty";
                    keyUnit = "unit_abbr_angle_uncertainty";
                    keySexagesimal = option.getUnit().getType() == UnitType.DEGREE_SEXAGESIMAL ? "sexagesimal_angle_uncertainty" : null;
                    break;
                }
                case LENGTH: {
                    keyDigits = "digits_length";
                    keyUnit = "unit_abbr_length";
                    break;
                }
                case LENGTH_RESIDUAL: {
                    keyDigits = "digits_length_residual";
                    keyUnit = "unit_abbr_length_residual";
                    break;
                }
                case LENGTH_UNCERTAINTY: {
                    keyDigits = "digits_length_uncertainty";
                    keyUnit = "unit_abbr_length_uncertainty";
                    break;
                }
                case SCALE: {
                    keyDigits = "digits_scale";
                    keyUnit = "unit_abbr_scale";
                    break;
                }
                case SCALE_RESIDUAL: {
                    keyDigits = "digits_scale_residual";
                    keyUnit = "unit_abbr_scale_residual";
                    break;
                }
                case SCALE_UNCERTAINTY: {
                    keyDigits = "digits_scale_uncertainty";
                    keyUnit = "unit_abbr_scale_uncertainty";
                    break;
                }
                case VECTOR: {
                    keyDigits = "digits_vector";
                    keyUnit = "unit_abbr_vector";
                    break;
                }
                case VECTOR_RESIDUAL: {
                    keyDigits = "digits_vector_residual";
                    keyUnit = "unit_abbr_vector_residual";
                    break;
                }
                case VECTOR_UNCERTAINTY: {
                    keyDigits = "digits_vector_uncertainty";
                    keyUnit = "unit_abbr_vector_uncertainty";
                    break;
                }
                case PERCENTAGE: {
                    keyDigits = "digits_percentage";
                    keyUnit = "unit_abbr_percentage";
                    break;
                }
                case STATISTIC: {
                    keyDigits = "digits_statistic";
                    break;
                }
                case DOUBLE: {
                    keyDigits = "digits_double";
                    break;
                }
                default: {
                    continue block17;
                }
            }
            if (keyDigits != null) {
                this.setParam(keyDigits, option.getFormatter().format(0.0));
            }
            if (keyUnit != null) {
                this.setParam(keyUnit, option.getUnit().getAbbreviation());
            }
            if (keySexagesimal == null) continue;
            this.setParam(keySexagesimal, Boolean.TRUE);
        }
    }

    private void addMetaData() {
        this.setParam("report_creation_date", new Date(System.currentTimeMillis()));
        this.setParam("version", Version.get());
        this.setParam("estimation_type", (Object)this.adjustment.getEstimationType());
        if (this.adjustment.getTransformation().getInterpolation() == null || this.adjustment.getTransformation().getInterpolation().getInterpolationType() == InterpolationType.NONE) {
            this.setParam("interpolation_type", InterpolationType.NONE.name());
        } else {
            Interpolation interpolation = this.adjustment.getTransformation().getInterpolation();
            this.setParam("interpolation_type", interpolation.getInterpolationType().name());
            switch (interpolation.getInterpolationType()) {
                case INVERSE_DISTANCE_WEIGHTING: {
                    this.setParam("interpolation_idw_exponent", ((InverseDistanceWeighting)interpolation).getExponent());
                    this.setParam("interpolation_idw_smoothing", ((InverseDistanceWeighting)interpolation).getSmoothing());
                    break;
                }
                case MULTI_QUADRATIC: {
                    this.setParam("interpolation_mq_exponent", ((MultiQuadraticInterpolation)interpolation).getExponent());
                    this.setParam("interpolation_mq_smoothing", ((MultiQuadraticInterpolation)interpolation).getSmoothing());
                    break;
                }
                case SECTOR: {
                    this.setParam("interpolation_sect_numerator_exponent", ((SectorInterpolation)interpolation).getNumeratorExponent());
                    this.setParam("interpolation_sect_denominator_exponent", ((SectorInterpolation)interpolation).getDenominatorExponent());
                    break;
                }
            }
        }
    }

    private void addTeststatistics() {
        TestStatisticParameterSet[] testStatisticParameterSets;
        TestStatisticDefinition testStatisticDefinition = this.adjustment.getTestStatisticDefinition();
        if (this.adjustment.getTestStatisticDefinition() == null || this.adjustment.getTestStatisticParameters() == null) {
            return;
        }
        TestStatisticType type = testStatisticDefinition.getTestStatisticType();
        double powerOfTest = testStatisticDefinition.getPowerOfTest();
        double probabilityValue = testStatisticDefinition.getProbabilityValue();
        this.setParam("test_statistic_method", type.name());
        this.setParam("test_statistic_probability_value", this.options.convertPercentToView(probabilityValue));
        this.setParam("test_statistic_power_of_test", this.options.convertPercentToView(powerOfTest));
        ArrayList testStatistics = new ArrayList();
        TestStatisticParameterSet[] testStatisticParameterSetArray = testStatisticParameterSets = this.adjustment.getTestStatisticParameters().getTestStatisticParameterSets();
        int n = testStatisticParameterSets.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatisticParameterSet testStatisticParameterSet = testStatisticParameterSetArray[n2];
            if (testStatisticParameterSet.getNumeratorDof() >= 0.0 && testStatisticParameterSet.getDenominatorDof() > 0.0) {
                HashMap<String, Double> h = new HashMap<String, Double>();
                h.put("d1", testStatisticParameterSet.getNumeratorDof());
                h.put("d2", testStatisticParameterSet.getDenominatorDof());
                h.put("probability_value", this.options.convertPercentToView(testStatisticParameterSet.getProbabilityValue()));
                h.put("power_of_test", this.options.convertPercentToView(testStatisticParameterSet.getPowerOfTest()));
                h.put("quantile", testStatisticParameterSet.getQuantile());
                h.put("p_value", testStatisticParameterSet.getLogarithmicProbabilityValue());
                h.put("non_centrality_parameter", testStatisticParameterSet.getNoncentralityParameter());
                testStatistics.add(h);
            }
            ++n2;
        }
        if (!testStatistics.isEmpty()) {
            this.setParam("test_statistic_params", testStatistics);
        }
    }

    private void addUnknownParameters() {
        this.setParam("unknown_transformation_parameters", this.getUnknownParameters());
    }

    private void addHomogeneousCoordinateTransformationMatrix() {
        Matrix transformationMatrix = this.adjustment.getTransformation().getTransformationEquations().getHomogeneousCoordinateTransformationMatrix();
        if (transformationMatrix == null) {
            return;
        }
        ArrayList matrix = new ArrayList();
        int cols = transformationMatrix.numColumns();
        int rows = transformationMatrix.numRows();
        int dimension = this.adjustment.getTransformation().getTransformationEquations().getTransformationType().getDimension();
        int r = 0;
        while (r < rows) {
            HashMap<String, Serializable> row = new HashMap<String, Serializable>(2);
            ArrayList<Double> rowVec = new ArrayList<Double>(rows);
            int c = 0;
            while (c < cols) {
                rowVec.add(transformationMatrix.get(r, c));
                ++c;
            }
            if (dimension != 1 && r < 2) {
                row.put("parameter", Character.valueOf(r == 0 ? (char)'x' : 'y'));
            }
            if (dimension != 2 && r == dimension - 1) {
                row.put("parameter", Character.valueOf('z'));
            }
            if (r == dimension) {
                row.put("parameter", Character.valueOf('h'));
            }
            row.put("data", rowVec);
            matrix.add(row);
            ++r;
        }
        this.setParam("homogeneous_coordinate_transformation_matrix", matrix);
    }

    private void addEulerAngles() {
        if (this.adjustment.getTransformation().getTransformationEquations().getTransformationType().getDimension() != 3) {
            return;
        }
        Matrix R = this.adjustment.getTransformation().getTransformationEquations().getRotationMatrix();
        MathExtension.EulerAngleConventionType[] eulerAngleConventions = MathExtension.EulerAngleConventionType.values();
        ArrayList conventions = new ArrayList();
        MathExtension.EulerAngleConventionType[] eulerAngleConventionTypeArray = eulerAngleConventions;
        int n = eulerAngleConventions.length;
        int n2 = 0;
        while (n2 < n) {
            MathExtension.EulerAngleConventionType eulerAngleConvention = eulerAngleConventionTypeArray[n2];
            double[] eulerAngles = MathExtension.rotationMatrix3D2EulerAngles(R, eulerAngleConvention);
            HashMap<String, Object> angles = new HashMap<String, Object>();
            angles.put("convention", eulerAngleConvention.name());
            angles.put("phi", this.options.convertAngleToView(eulerAngles[0]));
            angles.put("theta", this.options.convertAngleToView(eulerAngles[1]));
            angles.put("psi", this.options.convertAngleToView(eulerAngles[2]));
            conventions.add(angles);
            ++n2;
        }
        this.setParam("euler_angles_conventions", conventions);
    }

    private void addCorrelationMatrix() {
        UpperSymmPackMatrix correlationMatrix = this.adjustment.getCorrelationMatrix();
        if (correlationMatrix == null) {
            return;
        }
        ArrayList matrix = new ArrayList();
        ObservableUniqueList<UnknownParameter> unknownParameters = this.adjustment.getTransformation().getUnknownParameters();
        int cols = correlationMatrix.numColumns();
        int rows = correlationMatrix.numRows();
        int r = 0;
        while (r < rows) {
            HashMap<String, Cloneable> row = new HashMap<String, Cloneable>(2);
            ArrayList<Double> rowVec = new ArrayList<Double>(rows);
            int c = 0;
            while (c < cols) {
                rowVec.add(correlationMatrix.get(r, c));
                ++c;
            }
            row.put("parameter", this.getUnknownParameter((UnknownParameter)unknownParameters.get(r)));
            row.put("data", rowVec);
            matrix.add(row);
            ++r;
        }
        this.setParam("correlation_matrix", matrix);
    }

    private List<HashMap<String, Object>> getUnknownParameters() {
        ArrayList<HashMap<String, Object>> parameters = new ArrayList<HashMap<String, Object>>();
        ObservableUniqueList<UnknownParameter> unknownParameters = this.adjustment.getTransformation().getUnknownParameters();
        Iterator iterator = unknownParameters.iterator();
        while (iterator.hasNext()) {
            UnknownParameter unknownParameter = (UnknownParameter)iterator.next();
            parameters.add(this.getUnknownParameter(unknownParameter));
        }
        return parameters;
    }

    private HashMap<String, Object> getUnknownParameter(UnknownParameter unknownParameter) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        ParameterType type = unknownParameter.getParameterType();
        parameter.put("name", unknownParameter.getName());
        parameter.put("description", unknownParameter.getDescription());
        parameter.put("processing_type", unknownParameter.getProcessingType().name());
        parameter.put("parameter_type", type.name());
        parameter.put("visible", unknownParameter.isVisible());
        parameter.put("indispensable", unknownParameter.isIndispensable());
        parameter.put("column", unknownParameter.getColumn());
        double value = unknownParameter.getValue();
        double sigma = unknownParameter.getUncertainty();
        switch (type) {
            case SHIFT_X: 
            case SHIFT_Y: 
            case SHIFT_Z: {
                parameter.put("value", this.options.convertLengthToView(value));
                parameter.put("sigma", this.options.convertLengthUncertaintyToView(sigma));
                parameter.put("unit_type", "LENGTH");
                break;
            }
            case QUATERNION_Q0: 
            case QUATERNION_Q1: 
            case QUATERNION_Q2: 
            case QUATERNION_Q3: 
            case VECTOR_LENGTH: {
                parameter.put("value", this.options.convertVectorToView(value));
                parameter.put("sigma", this.options.convertVectorUncertaintyToView(sigma));
                parameter.put("unit_type", "VECTOR");
                break;
            }
            case SHEAR_X: 
            case SHEAR_Y: 
            case SHEAR_Z: 
            case EULER_ANGLE_X: 
            case EULER_ANGLE_Y: 
            case EULER_ANGLE_Z: {
                parameter.put("value", this.options.convertAngleToView(value));
                parameter.put("sigma", this.options.convertAngleUncertaintyToView(sigma));
                parameter.put("unit_type", "ANGLE");
                break;
            }
            case SCALE_X: 
            case SCALE_Y: 
            case SCALE_Z: {
                parameter.put("value", this.options.convertScaleToView(value));
                parameter.put("sigma", this.options.convertScaleUncertaintyToView(sigma));
                parameter.put("unit_type", "SCALE");
                break;
            }
            default: {
                parameter.put("value", value);
                parameter.put("sigma", sigma);
                parameter.put("unit_type", "DOUBLE");
            }
        }
        return parameter;
    }

    private void addFramePositionPairs() {
        HashMap<String, Serializable> positions = new HashMap<String, Serializable>();
        ArrayList positionList = new ArrayList();
        ObservableUniqueList<FramePositionPair> framePositionPairs = this.adjustment.getTransformation().getFramePositionPairs();
        int dimension = this.adjustment.getTransformation().getTransformationEquations().getTransformationType().getDimension();
        Iterator iterator = framePositionPairs.iterator();
        while (iterator.hasNext()) {
            FramePositionPair positionPair = (FramePositionPair)iterator.next();
            if (!positionPair.isEnable()) continue;
            HashMap<String, Object> h = new HashMap<String, Object>();
            ObservedFramePosition sourcePosition = (ObservedFramePosition)positionPair.getSourceSystemPosition();
            EstimatedFramePosition targetPosition = (EstimatedFramePosition)positionPair.getTargetSystemPosition();
            h.put("name", positionPair.getName());
            if (dimension != 1) {
                h.put("x", this.options.convertLengthToView(sourcePosition.getX()));
                h.put("y", this.options.convertLengthToView(sourcePosition.getY()));
                h.put("X", this.options.convertLengthToView(targetPosition.getX()));
                h.put("Y", this.options.convertLengthToView(targetPosition.getY()));
                h.put("sigma_X", this.options.convertLengthUncertaintyToView(targetPosition.getUncertaintyX()));
                h.put("sigma_Y", this.options.convertLengthUncertaintyToView(targetPosition.getUncertaintyY()));
                h.put("residual_X", this.options.convertLengthResidualToView(targetPosition.getResidualX()));
                h.put("residual_Y", this.options.convertLengthResidualToView(targetPosition.getResidualY()));
            }
            if (dimension != 2) {
                h.put("z", this.options.convertLengthToView(sourcePosition.getZ()));
                h.put("Z", this.options.convertLengthToView(targetPosition.getZ()));
                h.put("sigma_Z", this.options.convertLengthUncertaintyToView(targetPosition.getUncertaintyZ()));
                h.put("residual_Z", this.options.convertLengthResidualToView(targetPosition.getResidualZ()));
            }
            positionList.add(h);
        }
        if (positionList != null && !positionList.isEmpty()) {
            positions.put("positions", positionList);
            positions.put("dimension", Integer.valueOf(dimension));
            this.setParam("transformed_position_pairs", positions);
        }
    }

    private void addHomologousFramePositionPairs() {
        HashMap<String, Serializable> positions = new HashMap<String, Serializable>();
        ArrayList positionList = new ArrayList();
        List<HomologousFramePositionPair> homologousFramePositionPairs = this.adjustment.getTransformation().getHomologousFramePositionPairs();
        int dimension = this.adjustment.getTransformation().getTransformationEquations().getTransformationType().getDimension();
        double redundancySourcePositionsX = 0.0;
        double redundancySourcePositionsY = 0.0;
        double redundancySourcePositionsZ = 0.0;
        double redundancyTargetPositionsX = 0.0;
        double redundancyTargetPositionsY = 0.0;
        double redundancyTargetPositionsZ = 0.0;
        double maxResidualSourcePositionsX = 0.0;
        double maxResidualSourcePositionsY = 0.0;
        double maxResidualSourcePositionsZ = 0.0;
        double maxResidualTargetPositionsX = 0.0;
        double maxResidualTargetPositionsY = 0.0;
        double maxResidualTargetPositionsZ = 0.0;
        double maxGrossErrorGroupX = 0.0;
        double maxGrossErrorGroupY = 0.0;
        double maxGrossErrorGroupZ = 0.0;
        boolean significantGroup = false;
        for (HomologousFramePositionPair positionPair : homologousFramePositionPairs) {
            if (!positionPair.isEnable()) continue;
            HashMap<String, Object> h = new HashMap<String, Object>();
            HomologousFramePosition sourcePosition = (HomologousFramePosition)positionPair.getSourceSystemPosition();
            HomologousFramePosition targetPosition = (HomologousFramePosition)positionPair.getTargetSystemPosition();
            boolean significant = positionPair.isSignificant();
            if (!significantGroup && significant) {
                significantGroup = true;
            }
            h.put("name", positionPair.getName());
            h.put("t_prio", positionPair.getTestStatistic().getTestStatisticApriori());
            h.put("t_post", positionPair.getTestStatistic().getTestStatisticAposteriori());
            h.put("p_prio", positionPair.getTestStatistic().getPValueApriori());
            h.put("p_post", positionPair.getTestStatistic().getPValueAposteriori());
            h.put("significant", significant);
            h.put("dimension", dimension);
            if (dimension != 1) {
                h.put("x0", this.options.convertLengthToView(sourcePosition.getX0()));
                h.put("y0", this.options.convertLengthToView(sourcePosition.getY0()));
                h.put("x", this.options.convertLengthToView(sourcePosition.getX()));
                h.put("y", this.options.convertLengthToView(sourcePosition.getY()));
                h.put("sigma_x", this.options.convertLengthUncertaintyToView(sourcePosition.getUncertaintyX()));
                h.put("sigma_y", this.options.convertLengthUncertaintyToView(sourcePosition.getUncertaintyY()));
                h.put("X0", this.options.convertLengthToView(targetPosition.getX0()));
                h.put("Y0", this.options.convertLengthToView(targetPosition.getY0()));
                h.put("X", this.options.convertLengthToView(targetPosition.getX()));
                h.put("Y", this.options.convertLengthToView(targetPosition.getY()));
                h.put("sigma_X", this.options.convertLengthUncertaintyToView(targetPosition.getUncertaintyX()));
                h.put("sigma_Y", this.options.convertLengthUncertaintyToView(targetPosition.getUncertaintyY()));
                h.put("minimal_detectable_bias_x", this.options.convertLengthResidualToView(positionPair.getMinimalDetectableBiasX()));
                h.put("minimal_detectable_bias_y", this.options.convertLengthResidualToView(positionPair.getMinimalDetectableBiasY()));
                h.put("maximum_tolerable_bias_x", this.options.convertLengthResidualToView(positionPair.getMaximumTolerableBiasX()));
                h.put("maximum_tolerable_bias_y", this.options.convertLengthResidualToView(positionPair.getMaximumTolerableBiasY()));
                double grossErrorX = this.options.convertLengthResidualToView(positionPair.getGrossErrorX());
                double grossErrorY = this.options.convertLengthResidualToView(positionPair.getGrossErrorY());
                double sourceResidualX = this.options.convertLengthResidualToView(sourcePosition.getResidualX());
                double sourceResidualY = this.options.convertLengthResidualToView(sourcePosition.getResidualY());
                double targetResidualX = this.options.convertLengthResidualToView(targetPosition.getResidualX());
                double targetResidualY = this.options.convertLengthResidualToView(targetPosition.getResidualY());
                double sourceRedundancyX = sourcePosition.getRedundancyX();
                double sourceRedundancyY = sourcePosition.getRedundancyY();
                double targetRedundancyX = targetPosition.getRedundancyX();
                double targetRedundancyY = targetPosition.getRedundancyY();
                h.put("gross_error_x", grossErrorX);
                h.put("gross_error_y", grossErrorY);
                h.put("residual_x", sourceResidualX);
                h.put("residual_y", sourceResidualY);
                h.put("residual_X", targetResidualX);
                h.put("residual_Y", targetResidualY);
                h.put("redundancy_x", this.options.convertPercentToView(sourceRedundancyX));
                h.put("redundancy_y", this.options.convertPercentToView(sourceRedundancyY));
                h.put("redundancy_X", this.options.convertPercentToView(targetRedundancyX));
                h.put("redundancy_Y", this.options.convertPercentToView(targetRedundancyY));
                maxResidualSourcePositionsX = Math.abs(sourceResidualX) > Math.abs(maxResidualSourcePositionsX) ? sourceResidualX : maxResidualSourcePositionsX;
                maxResidualSourcePositionsY = Math.abs(sourceResidualY) > Math.abs(maxResidualSourcePositionsY) ? sourceResidualY : maxResidualSourcePositionsY;
                maxResidualTargetPositionsX = Math.abs(targetResidualX) > Math.abs(maxResidualTargetPositionsX) ? targetResidualX : maxResidualTargetPositionsX;
                maxResidualTargetPositionsY = Math.abs(targetResidualY) > Math.abs(maxResidualTargetPositionsY) ? targetResidualY : maxResidualTargetPositionsY;
                redundancySourcePositionsX += sourceRedundancyX;
                redundancySourcePositionsY += sourceRedundancyY;
                redundancyTargetPositionsX += targetRedundancyX;
                redundancyTargetPositionsY += targetRedundancyY;
                maxGrossErrorGroupX = Math.abs(grossErrorX) > Math.abs(maxGrossErrorGroupX) ? grossErrorX : maxGrossErrorGroupX;
                double d = maxGrossErrorGroupY = Math.abs(grossErrorY) > Math.abs(maxGrossErrorGroupY) ? grossErrorY : maxGrossErrorGroupY;
            }
            if (dimension != 2) {
                h.put("z0", this.options.convertLengthToView(sourcePosition.getZ0()));
                h.put("z", this.options.convertLengthToView(sourcePosition.getZ()));
                h.put("sigma_z", this.options.convertLengthUncertaintyToView(sourcePosition.getUncertaintyZ()));
                h.put("Z0", this.options.convertLengthToView(targetPosition.getZ0()));
                h.put("Z", this.options.convertLengthToView(targetPosition.getZ()));
                h.put("sigma_Z", this.options.convertLengthUncertaintyToView(targetPosition.getUncertaintyZ()));
                h.put("minimal_detectable_bias_z", this.options.convertLengthResidualToView(positionPair.getMinimalDetectableBiasZ()));
                h.put("maximum_tolerable_bias_z", this.options.convertLengthResidualToView(positionPair.getMaximumTolerableBiasZ()));
                double grossErrorZ = this.options.convertLengthResidualToView(positionPair.getGrossErrorZ());
                double sourceResidualZ = this.options.convertLengthResidualToView(sourcePosition.getResidualZ());
                double targetResidualZ = this.options.convertLengthResidualToView(targetPosition.getResidualZ());
                double sourceRedundancyZ = sourcePosition.getRedundancyZ();
                double targetRedundancyZ = targetPosition.getRedundancyZ();
                h.put("gross_error_z", grossErrorZ);
                h.put("residual_z", sourceResidualZ);
                h.put("residual_Z", targetResidualZ);
                h.put("redundancy_z", this.options.convertPercentToView(sourceRedundancyZ));
                h.put("redundancy_Z", this.options.convertPercentToView(targetRedundancyZ));
                redundancySourcePositionsZ += sourceRedundancyZ;
                redundancyTargetPositionsZ += targetRedundancyZ;
                maxResidualSourcePositionsZ = Math.abs(sourceResidualZ) > Math.abs(maxResidualSourcePositionsZ) ? sourceResidualZ : maxResidualSourcePositionsZ;
                maxResidualTargetPositionsZ = Math.abs(targetResidualZ) > Math.abs(maxResidualTargetPositionsZ) ? targetResidualZ : maxResidualTargetPositionsZ;
                maxGrossErrorGroupZ = Math.abs(grossErrorZ) > Math.abs(maxGrossErrorGroupZ) ? grossErrorZ : maxGrossErrorGroupZ;
            }
            positionList.add(h);
        }
        if (positionList != null && !positionList.isEmpty()) {
            positions.put("positions", positionList);
            positions.put("significant", Boolean.valueOf(significantGroup));
            positions.put("dimension", Integer.valueOf(dimension));
            positions.put("redundancy_x", Double.valueOf(redundancySourcePositionsX));
            positions.put("redundancy_y", Double.valueOf(redundancySourcePositionsY));
            positions.put("redundancy_z", Double.valueOf(redundancySourcePositionsZ));
            positions.put("redundancy_xyz", Double.valueOf(redundancySourcePositionsX + redundancySourcePositionsY + redundancySourcePositionsZ));
            positions.put("redundancy_X", Double.valueOf(redundancyTargetPositionsX));
            positions.put("redundancy_Y", Double.valueOf(redundancyTargetPositionsY));
            positions.put("redundancy_Z", Double.valueOf(redundancyTargetPositionsZ));
            positions.put("redundancy_XYZ", Double.valueOf(redundancyTargetPositionsX + redundancyTargetPositionsY + redundancyTargetPositionsZ));
            positions.put("max_residual_x", Double.valueOf(maxResidualSourcePositionsX));
            positions.put("max_residual_y", Double.valueOf(maxResidualSourcePositionsY));
            positions.put("max_residual_z", Double.valueOf(maxResidualSourcePositionsZ));
            positions.put("max_residual_X", Double.valueOf(maxResidualTargetPositionsX));
            positions.put("max_residual_Y", Double.valueOf(maxResidualTargetPositionsY));
            positions.put("max_residual_Z", Double.valueOf(maxResidualTargetPositionsZ));
            positions.put("max_gross_error_x", Double.valueOf(maxGrossErrorGroupX));
            positions.put("max_gross_error_y", Double.valueOf(maxGrossErrorGroupY));
            positions.put("max_gross_error_z", Double.valueOf(maxGrossErrorGroupZ));
            this.setParam("homologous_position_pairs", positions);
        }
    }

    private void addVarianceEstimation() {
        if (this.adjustment.getTestStatisticParameters() == null) {
            return;
        }
        ArrayList vces = new ArrayList();
        VarianceComponentType[] varianceComponentTypeArray = VarianceComponentType.values();
        int n = varianceComponentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarianceComponentType varianceComponentType = varianceComponentTypeArray[n2];
            HashMap<String, Object> vce = new HashMap<String, Object>(6);
            VarianceComponent varianceComponentOfUnitWeight = this.adjustment.getVarianceComponent(varianceComponentType);
            double dof = varianceComponentOfUnitWeight.getRedundancy();
            int numberOfPoints = this.adjustment.getTransformation().getHomologousFramePositionPairs().size();
            int dimension = this.adjustment.getTransformation().getTransformationEquations().getTransformationType().getDimension();
            double sigma2apost = varianceComponentOfUnitWeight.getVariance() / varianceComponentOfUnitWeight.getVariance0();
            double omega = varianceComponentOfUnitWeight.getOmega() / varianceComponentOfUnitWeight.getVariance0();
            boolean significant = varianceComponentOfUnitWeight.isSignificant();
            double quantile = this.adjustment.getTestStatisticParameters().getTestStatisticParameter(dof > 1.0E-6 ? dof : 0.0, Double.POSITIVE_INFINITY).getQuantile();
            vce.put("type", varianceComponentType.name());
            vce.put("omega", omega);
            vce.put("number_of_observations", dimension * numberOfPoints);
            vce.put("redundancy", dof);
            vce.put("sigma2apost", sigma2apost);
            vce.put("quantile", quantile);
            vce.put("significant", significant);
            vces.add(vce);
            ++n2;
        }
        if (vces.size() > 0) {
            this.setParam("vce", vces);
        }
    }

    public static List<Path> getTemplates() {
        URL url;
        ArrayList<Path> templates;
        block13: {
            templates = new ArrayList<Path>();
            url = FTLReport.class.getClassLoader().getResource(TEMPLATE_PATH);
            if (url != null) break block13;
            System.err.println("Template path not found");
            return null;
        }
        try {
            DirectoryStream.Filter<Path> ftlhFilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    String name = entry.getFileName().toString();
                    return name.toLowerCase().endsWith(".ftlh");
                }
            };
            Path root = Paths.get(url.toURI());
            Throwable throwable = null;
            Object var5_7 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, (DirectoryStream.Filter<? super Path>)ftlhFilter);){
                for (Path p : stream) {
                    if (!Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)) continue;
                    templates.add(p);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return templates;
    }
}

