/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.coordtrans.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.transformation.VarianceComponent;
import org.applied_geodesy.coordtrans.ui.i18n.I18N;
import org.applied_geodesy.coordtrans.ui.table.UIVarianceComponentTableBuilder;

public class VarianceComponentsDialog {
    private static I18N i18N = I18N.getInstance();
    private static VarianceComponentsDialog varianceComponentsDialog = new VarianceComponentsDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private ObservableList<VarianceComponent> tableModel;
    private VBox contentPane;

    private VarianceComponentsDialog() {
    }

    public static void setOwner(Window owner) {
        VarianceComponentsDialog.varianceComponentsDialog.window = owner;
    }

    public static Optional<Void> showAndWait(VarianceComponent ... varianceComponents) {
        varianceComponentsDialog.init();
        varianceComponentsDialog.setVarianceComponents(varianceComponents);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    VarianceComponentsDialog.varianceComponentsDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)VarianceComponentsDialog.varianceComponentsDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return VarianceComponentsDialog.varianceComponentsDialog.dialog.showAndWait();
    }

    private void setVarianceComponents(VarianceComponent ... varianceComponents) {
        if (varianceComponents != null && varianceComponents.length > 0) {
            this.tableModel.setAll((Object[])varianceComponents);
            this.contentPane.setPrefHeight(this.contentPane.getMinHeight() + (double)(varianceComponents.length * 30));
        } else {
            this.tableModel.clear();
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.contentPane = this.createPane();
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("VarianceComponentsDialog.title", "Variance component estimation"));
        this.dialog.setHeaderText(i18N.getString("VarianceComponentsDialog.header", "Estimated variance components"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent((Node)this.contentPane);
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                return null;
            }
        });
    }

    private VBox createPane() {
        TableView varianceComponentTableView = UIVarianceComponentTableBuilder.getInstance().getTable();
        this.tableModel = UIVarianceComponentTableBuilder.getInstance().getTableModel(varianceComponentTableView);
        VBox contentPane = new VBox();
        contentPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        contentPane.getChildren().setAll((Object[])new Node[]{varianceComponentTableView});
        contentPane.setMinHeight(75.0);
        return contentPane;
    }
}

